/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr.facet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.alfresco.repo.search.impl.solr.facet.Exceptions;
import org.alfresco.repo.search.impl.solr.facet.SolrFacetConfigException;
import org.alfresco.repo.search.impl.solr.facet.SolrFacetProperties;
import org.alfresco.repo.search.impl.solr.facet.SolrFacetService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.collections.CollectionUtils;
import org.alfresco.util.collections.Function;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.alfresco.util.test.junitrules.RunAsFullyAuthenticatedRule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class SolrFacetServiceImplTest {
    private static final Log logger = LogFactory.getLog(SolrFacetServiceImplTest.class);
    @ClassRule
    public static ApplicationContextInit APP_CONTEXT_INIT = new ApplicationContextInit();
    @Rule
    public RunAsFullyAuthenticatedRule runAsRule = new RunAsFullyAuthenticatedRule(AuthenticationUtil.getAdminUserName());
    private static final List<String> FILTERS = new ArrayList<String>();
    private static SolrFacetService SOLR_FACET_SERVICE;
    private static RetryingTransactionHelper TRANSACTION_HELPER;

    @BeforeClass
    public static void initStaticData() throws Exception {
        SOLR_FACET_SERVICE = (SolrFacetService)APP_CONTEXT_INIT.getApplicationContext().getBean("solrFacetService", SolrFacetService.class);
        TRANSACTION_HELPER = (RetryingTransactionHelper)APP_CONTEXT_INIT.getApplicationContext().getBean("retryingTransactionHelper", RetryingTransactionHelper.class);
    }

    @AfterClass
    public static void cleanup() {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                for (String filter : FILTERS) {
                    try {
                        SOLR_FACET_SERVICE.deleteFacet(filter);
                    }
                    catch (SolrFacetConfigException sfe) {
                        logger.info((Object)("Cannot delete filter [" + filter + "]. " + (Object)((Object)sfe)));
                    }
                }
                return null;
            }
        });
    }

    @Test
    public void getFacetsAndReorderThem() throws Exception {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                List facetIds = SolrFacetServiceImplTest.this.getExistingFacetIds();
                ArrayList reorderedFacetIds = new ArrayList(facetIds);
                Collections.reverse(reorderedFacetIds);
                SOLR_FACET_SERVICE.reorderFacets(reorderedFacetIds);
                List newfacetIds = SolrFacetServiceImplTest.this.getExistingFacetIds();
                Assert.assertEquals(reorderedFacetIds, (Object)newfacetIds);
                return null;
            }
        });
    }

    @Test(expected=NullPointerException.class)
    public void reorderNullFacetIdsShouldFail() throws Exception {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                SOLR_FACET_SERVICE.reorderFacets(null);
                return null;
            }
        });
    }

    @Test(expected=Exceptions.MissingFacetId.class)
    public void reorderEmptyFacetIdsShouldFail() throws Exception {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                SOLR_FACET_SERVICE.reorderFacets(Collections.emptyList());
                return null;
            }
        });
    }

    @Test(expected=Exceptions.DuplicateFacetId.class)
    public void reorderDuplicateFacetIdsShouldFail() throws Exception {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                List facetIds = SolrFacetServiceImplTest.this.getExistingFacetIds();
                facetIds.add((String)facetIds.get(0));
                SOLR_FACET_SERVICE.reorderFacets(facetIds);
                return null;
            }
        });
    }

    @Test
    public void reorderUnrecognisedFacetIdsShouldFail() throws Exception {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                List existingFacetIds = SolrFacetServiceImplTest.this.getExistingFacetIds();
                ArrayList<String> facetIds = new ArrayList<String>(existingFacetIds);
                facetIds.add("unrecognisedID");
                SOLR_FACET_SERVICE.reorderFacets(facetIds);
                List newfacetIds = SolrFacetServiceImplTest.this.getExistingFacetIds();
                Assert.assertEquals((Object)existingFacetIds, (Object)newfacetIds);
                return null;
            }
        });
    }

    @Test
    public void updateFacet() {
        final String filterName = this.getFilterName();
        final SolrFacetProperties facetProps = new SolrFacetProperties.Builder().filterID(filterName).facetQName(QName.createQName((String)"{http://www.alfresco.org/model/content/1.0}test")).displayName("faceted-search.facet-menu.facet.test").displayControl("alfresco/search/FacetFilters").maxFilters(5).hitThreshold(1).minFilterValueLength(4).sortBy("ALPHABETICALLY").isEnabled(Boolean.valueOf(false)).scope("ALL").build();
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                try {
                    SOLR_FACET_SERVICE.updateFacet(facetProps);
                    Assert.fail((String)"Shouldn't be able to update a facet that does not exist");
                }
                catch (SolrFacetConfigException solrFacetConfigException) {}
                return null;
            }
        });
        this.createFacet(facetProps);
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                SolrFacetProperties updatedFacetProps = new SolrFacetProperties.Builder(facetProps).maxFilters(10).build();
                SOLR_FACET_SERVICE.updateFacet(updatedFacetProps);
                updatedFacetProps = SOLR_FACET_SERVICE.getFacet(filterName);
                Assert.assertEquals((long)10L, (long)updatedFacetProps.getMaxFilters());
                Assert.assertEquals((Object)filterName, (Object)updatedFacetProps.getFilterID());
                Assert.assertEquals((Object)"{http://www.alfresco.org/model/content/1.0}test", (Object)updatedFacetProps.getFacetQName().toString());
                Assert.assertEquals((Object)"faceted-search.facet-menu.facet.test", (Object)updatedFacetProps.getDisplayName());
                Assert.assertEquals((Object)"alfresco/search/FacetFilters", (Object)updatedFacetProps.getDisplayControl());
                Assert.assertEquals((long)4L, (long)updatedFacetProps.getMinFilterValueLength());
                Assert.assertEquals((long)1L, (long)updatedFacetProps.getHitThreshold());
                Assert.assertEquals((Object)"ALPHABETICALLY", (Object)updatedFacetProps.getSortBy());
                Assert.assertEquals((Object)"ALL", (Object)updatedFacetProps.getScope());
                Assert.assertFalse((boolean)updatedFacetProps.isDefault());
                Assert.assertFalse((boolean)updatedFacetProps.isEnabled());
                return null;
            }
        });
    }

    @Test(expected=SolrFacetConfigException.class)
    public void deleteFacet_DoesNotExist() {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                SOLR_FACET_SERVICE.deleteFacet(GUID.generate());
                return null;
            }
        });
    }

    @Test
    public void deleteDefaultFacet() {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                List defaultFacet = SolrFacetServiceImplTest.this.getDefaultFilters();
                Assert.assertTrue((defaultFacet.size() > 0 ? 1 : 0) != 0);
                try {
                    SOLR_FACET_SERVICE.deleteFacet(((SolrFacetProperties)defaultFacet.get(0)).getFilterID());
                    Assert.fail((String)"Shouldn't be able to delete a default facet.");
                }
                catch (SolrFacetConfigException solrFacetConfigException) {}
                return null;
            }
        });
        final String defaultFilterName = (String)TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

            public String execute() throws Throwable {
                List defaultFacet = SolrFacetServiceImplTest.this.getDefaultFilters();
                Assert.assertTrue((defaultFacet.size() > 0 ? 1 : 0) != 0);
                SolrFacetProperties facetProperties = (SolrFacetProperties)defaultFacet.get(0);
                Assert.assertNotNull((Object)facetProperties);
                String filterName = facetProperties.getFilterID();
                int maxFilters = facetProperties.getMaxFilters();
                facetProperties = new SolrFacetProperties.Builder().filterID(filterName).maxFilters(maxFilters + 1).build();
                SOLR_FACET_SERVICE.updateFacet(facetProperties);
                facetProperties = SOLR_FACET_SERVICE.getFacet(filterName);
                Assert.assertEquals((long)(maxFilters + 1), (long)facetProperties.getMaxFilters());
                return filterName;
            }
        });
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                try {
                    SOLR_FACET_SERVICE.deleteFacet(defaultFilterName);
                    Assert.fail((String)"Shouldn't be able to delete a default facet.");
                }
                catch (SolrFacetConfigException solrFacetConfigException) {}
                return null;
            }
        });
    }

    @Test
    public void deleteFacet() {
        final String filterName = this.getFilterName();
        SolrFacetProperties facetProps = new SolrFacetProperties.Builder().filterID(filterName).facetQName(QName.createQName((String)"{http://www.alfresco.org/model/content/1.0}test2")).displayName("faceted-search.facet-menu.facet.test2").displayControl("alfresco/search/FacetFilters").maxFilters(5).hitThreshold(1).minFilterValueLength(2).sortBy("ALPHABETICALLY").isEnabled(Boolean.valueOf(true)).scope("ALL").build();
        this.createFacet(facetProps);
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                SOLR_FACET_SERVICE.deleteFacet(filterName);
                SolrFacetProperties solrFacetProperties = SOLR_FACET_SERVICE.getFacet(filterName);
                Assert.assertNull((Object)solrFacetProperties);
                return null;
            }
        });
    }

    @Test
    public void createFacet() {
        String filterName = this.getFilterName();
        SolrFacetProperties facetProps = new SolrFacetProperties.Builder().filterID(filterName).facetQName(QName.createQName((String)"{http://www.alfresco.org/model/content/1.0}test3")).displayName("faceted-search.facet-menu.facet.test3").displayControl("alfresco/search/FacetFilters").maxFilters(5).hitThreshold(1).minFilterValueLength(2).sortBy("ALPHABETICALLY").isEnabled(Boolean.valueOf(false)).scope("ALL").build();
        this.createFacet(facetProps);
        SolrFacetProperties facetProperties = SOLR_FACET_SERVICE.getFacet(filterName);
        Assert.assertEquals((Object)filterName, (Object)facetProperties.getFilterID());
        try {
            facetProperties = new SolrFacetProperties.Builder().filterID(filterName).build();
            this.createFacet(facetProperties);
            Assert.fail((String)"Shouldn't be able to create a duplicate facet.");
        }
        catch (SolrFacetConfigException solrFacetConfigException) {}
    }

    private List<String> getExistingFacetIds() {
        List facetProps = SOLR_FACET_SERVICE.getFacets();
        List facetIds = CollectionUtils.transform((Collection)facetProps, (Function)new Function<SolrFacetProperties, String>(){

            public String apply(SolrFacetProperties value) {
                return value.getFilterID();
            }
        });
        return facetIds;
    }

    private NodeRef createFacet(final SolrFacetProperties facetProps) {
        return (NodeRef)TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                NodeRef nodeRef = SOLR_FACET_SERVICE.createFacetNode(facetProps);
                return nodeRef;
            }
        });
    }

    private String getFilterName() {
        String name = "test_filter" + System.currentTimeMillis();
        FILTERS.add(name);
        return name;
    }

    private List<SolrFacetProperties> getDefaultFilters() {
        ArrayList<SolrFacetProperties> defaultFilters = new ArrayList<SolrFacetProperties>();
        List filters = SOLR_FACET_SERVICE.getFacets();
        for (SolrFacetProperties fp : filters) {
            if (!fp.isDefault()) continue;
            defaultFilters.add(fp);
        }
        return defaultFilters;
    }
}

