/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.RepositoryState;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.repo.forms.processor.node.MockClassAttributeDefinition;
import org.alfresco.repo.search.impl.solr.SolrQueryHTTPClient;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.FieldHighlightParameters;
import org.alfresco.service.cmr.search.GeneralHighlightParameters;
import org.alfresco.service.cmr.search.Interval;
import org.alfresco.service.cmr.search.IntervalParameters;
import org.alfresco.service.cmr.search.IntervalSet;
import org.alfresco.service.cmr.search.RangeParameters;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.StatsParameters;
import org.alfresco.service.cmr.search.StatsRequestParameters;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.testing.category.LuceneTests;
import org.apache.commons.codec.net.URLCodec;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@Category(value={LuceneTests.class})
public class SolrQueryHTTPClientTest {
    static SolrQueryHTTPClient client = new SolrQueryHTTPClient();
    static URLCodec encoder = new URLCodec();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        HashMap<String, String> languageMappings = new HashMap<String, String>();
        languageMappings.put("index-alfresco", "alfresco");
        languageMappings.put("index-fts-alfresco", "afts");
        languageMappings.put("index-cmis", "cmis");
        languageMappings.put("solr-alfresco", "alfresco");
        languageMappings.put("solr-fts-alfresco", "afts");
        languageMappings.put("solr-cmis", "cmis");
        NamespaceDAO namespaceDAO = (NamespaceDAO)Mockito.mock(NamespaceDAO.class);
        DictionaryService dictionaryService = (DictionaryService)Mockito.mock(DictionaryService.class);
        Mockito.when((Object)namespaceDAO.getPrefixes()).thenReturn(Arrays.asList("cm", "exif"));
        Mockito.when((Object)namespaceDAO.getNamespaceURI(ArgumentMatchers.anyString())).thenReturn((Object)"http://www.alfresco.org/model/content/1.0");
        Mockito.when((Object)dictionaryService.getProperty((QName)ArgumentMatchers.notNull())).thenAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            QName qName = (QName)args[0];
            if (qName.getLocalName().contains("created")) {
                return MockClassAttributeDefinition.mockPropertyDefinition(qName, DataTypeDefinition.DATE);
            }
            return MockClassAttributeDefinition.mockPropertyDefinition(qName, DataTypeDefinition.ANY);
        });
        client.setLanguageMappings(languageMappings);
        client.setDictionaryService(dictionaryService);
        client.setNamespaceDAO(namespaceDAO);
        client.setNodeService((NodeService)Mockito.mock(NodeService.class));
        client.setTenantService((TenantService)Mockito.mock(TenantService.class));
        client.setPermissionService((PermissionService)Mockito.mock(PermissionService.class));
        client.setStoreMappings(Collections.emptyList());
        client.setRepositoryState((RepositoryState)Mockito.mock(RepositoryState.class));
        client.init();
    }

    @Test
    public void testBuildStatsUrl() throws UnsupportedEncodingException {
        StatsParameters params = this.getParameters();
        String url = client.buildStatsUrl(params, "http://localhost:8080/solr/alfresco/select", Locale.CANADA_FRENCH, null);
        Assert.assertNotNull((Object)url);
        Assert.assertTrue((boolean)url.contains("locale=fr_CA"));
        Assert.assertTrue((boolean)url.contains("sort=contentsize"));
        Assert.assertTrue((boolean)url.contains("fq=ANCESTOR"));
    }

    @Test
    public void testBuildStatsBody() throws JSONException {
        StatsParameters params = this.getParameters();
        JSONObject body = client.buildStatsBody(params, "myTenant", Locale.US);
        Assert.assertNotNull((Object)body);
        JSONArray tenant = body.getJSONArray("tenants");
        TestCase.assertEquals((String)"myTenant", (String)tenant.get(0).toString());
        JSONArray locale = body.getJSONArray("locales");
        TestCase.assertEquals((String)"en_US", (String)locale.get(0).toString());
        String query = body.getString("query");
        Assert.assertTrue((boolean)query.contains("TYPE:"));
        Assert.assertTrue((boolean)query.contains("{http://www.alfresco.org/model/content/1.0}content"));
    }

    private StatsParameters getParameters() {
        StringBuilder luceneQuery = new StringBuilder();
        luceneQuery.append(" +TYPE:\"" + ContentModel.TYPE_CONTENT + "\"");
        String filterQuery = "ANCESTOR:\"workspace://SpacesStore/a1c1a0a1-9d68-4912-b853-b3b277f31288\"";
        StatsParameters params = new StatsParameters("index-fts-alfresco", luceneQuery.toString(), filterQuery, false);
        params.addSort(new SearchParameters.SortDefinition(SearchParameters.SortDefinition.SortType.FIELD, "contentsize", false));
        params.addStatsParameter("field", "contentsize");
        params.addStatsParameter("facet", "@" + ContentModel.PROP_CREATED.toString());
        params.addStatsParameter("Test1", "@author. .u");
        params.addStatsParameter("Test2", "@creator. .u");
        return params;
    }

    @Test
    public void testBuildTimezone() throws UnsupportedEncodingException {
        SearchParameters params = new SearchParameters();
        params.setTimezone("");
        StringBuilder urlBuilder = new StringBuilder();
        client.buildUrlParameters(params, false, encoder, urlBuilder);
        String url = urlBuilder.toString();
        Assert.assertFalse((boolean)url.contains("&TZ"));
        params.setTimezone("bob");
        urlBuilder = new StringBuilder();
        client.buildUrlParameters(params, false, encoder, urlBuilder);
        url = urlBuilder.toString();
        Assert.assertTrue((boolean)url.contains("&TZ=bob"));
    }

    @Test
    public void testBuildHighlightQuery() throws UnsupportedEncodingException {
        SearchParameters params = new SearchParameters();
        params.setSearchTerm("bob");
        StringBuilder urlBuilder = new StringBuilder();
        client.buildUrlParameters(params, false, encoder, urlBuilder);
        String url = urlBuilder.toString();
        Assert.assertNotNull((Object)url);
        Assert.assertFalse((boolean)url.contains("&hl"));
        urlBuilder = new StringBuilder();
        GeneralHighlightParameters highlightParameters = new GeneralHighlightParameters(null, null, null, null, null, null, null, null);
        params.setHighlight(highlightParameters);
        client.buildUrlParameters(params, true, encoder, urlBuilder);
        url = urlBuilder.toString();
        Assert.assertTrue((boolean)url.contains("&hl=true"));
        Assert.assertTrue((boolean)url.contains("&hl.q=bob"));
        urlBuilder = new StringBuilder();
        highlightParameters = new GeneralHighlightParameters(Integer.valueOf(5), Integer.valueOf(10), Boolean.valueOf(false), "{", "}", Integer.valueOf(20), Boolean.valueOf(true), null);
        params.setHighlight(highlightParameters);
        client.buildUrlParameters(params, false, encoder, urlBuilder);
        url = urlBuilder.toString();
        Assert.assertTrue((boolean)url.contains("&hl=true"));
        Assert.assertTrue((boolean)url.contains("&hl.q=bob"));
        Assert.assertTrue((boolean)url.contains("&hl.snippets=5"));
        Assert.assertTrue((boolean)url.contains("&hl.fragsize=10"));
        Assert.assertTrue((boolean)url.contains("&hl.maxAnalyzedChars=20"));
        Assert.assertTrue((boolean)url.contains("&hl.mergeContiguous=false"));
        Assert.assertTrue((boolean)url.contains("&hl.usePhraseHighlighter=true"));
        Assert.assertTrue((boolean)url.contains("&hl.simple.pre=" + encoder.encode("{", "UTF-8")));
        Assert.assertTrue((boolean)url.contains("&hl.simple.post=" + encoder.encode("}", "UTF-8")));
        List<FieldHighlightParameters> fields = Arrays.asList(new FieldHighlightParameters(null, null, null, null, null, null));
        urlBuilder = new StringBuilder();
        highlightParameters = new GeneralHighlightParameters(Integer.valueOf(5), Integer.valueOf(10), Boolean.valueOf(false), "{", "}", Integer.valueOf(20), Boolean.valueOf(true), fields);
        params.setHighlight(highlightParameters);
        try {
            client.buildUrlParameters(params, false, encoder, urlBuilder);
            Assert.fail();
        }
        catch (IllegalArgumentException iae) {
            Assert.assertNotNull((String)"no fieldname specfied so invalid", (Object)iae);
        }
        fields = Arrays.asList(new FieldHighlightParameters("desc", Integer.valueOf(50), Integer.valueOf(100), Boolean.valueOf(false), "@", "#"), new FieldHighlightParameters("title", Integer.valueOf(55), Integer.valueOf(105), Boolean.valueOf(true), "*", "\u00bf"));
        urlBuilder = new StringBuilder();
        highlightParameters = new GeneralHighlightParameters(Integer.valueOf(5), Integer.valueOf(10), Boolean.valueOf(false), "{", "}", Integer.valueOf(20), Boolean.valueOf(true), fields);
        params.setHighlight(highlightParameters);
        client.buildUrlParameters(params, false, encoder, urlBuilder);
        url = urlBuilder.toString();
        Assert.assertTrue((boolean)url.contains("&hl=true"));
        Assert.assertTrue((boolean)url.contains("&hl.fl=" + encoder.encode("desc,title", "UTF-8")));
        Assert.assertTrue((boolean)url.contains("&f.desc.hl.snippets=50"));
        Assert.assertTrue((boolean)url.contains("&f.title.hl.snippets=55"));
        Assert.assertTrue((boolean)url.contains("&f.desc.hl.fragsize=100"));
        Assert.assertTrue((boolean)url.contains("&f.title.hl.fragsize=105"));
        Assert.assertTrue((boolean)url.contains("&f.desc.hl.mergeContiguous=false"));
        Assert.assertTrue((boolean)url.contains("&f.title.hl.mergeContiguous=true"));
        Assert.assertTrue((boolean)url.contains("&f.desc.hl.simple.pre=" + encoder.encode("@", "UTF-8")));
        Assert.assertTrue((boolean)url.contains("&f.desc.hl.simple.post=" + encoder.encode("#", "UTF-8")));
        Assert.assertTrue((boolean)url.contains("&f.title.hl.simple.pre=" + encoder.encode("*", "UTF-8")));
        Assert.assertTrue((boolean)url.contains("&f.title.hl.simple.post=" + encoder.encode("\u00bf", "UTF-8")));
    }

    @Test
    public void testBuildFacetIntervalQuery() throws UnsupportedEncodingException {
        TimeZone defaultTimeZone = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        SearchParameters params = new SearchParameters();
        params.setSearchTerm("bob");
        IntervalSet intervalSet = new IntervalSet("8", "12", null, null, null);
        params.setInterval(new IntervalParameters(new HashSet<IntervalSet>(Arrays.asList(intervalSet)), null));
        StringBuilder urlBuilder = new StringBuilder();
        client.buildFacetIntervalParameters(params, encoder, urlBuilder);
        String url = urlBuilder.toString();
        Assert.assertNotNull((Object)url);
        Assert.assertTrue((boolean)url.contains("&facet=true"));
        Assert.assertTrue((boolean)url.contains(encoder.encode("{!afts}[8,12]", "UTF-8")));
        intervalSet = new IntervalSet("1", "10", "numbers", Boolean.valueOf(false), Boolean.valueOf(true));
        params.setInterval(new IntervalParameters(new HashSet<IntervalSet>(Arrays.asList(intervalSet)), null));
        urlBuilder = new StringBuilder();
        client.buildFacetIntervalParameters(params, encoder, urlBuilder);
        url = urlBuilder.toString();
        Assert.assertNotNull((Object)url);
        Assert.assertTrue((boolean)url.contains("&facet=true"));
        Assert.assertTrue((boolean)url.contains(encoder.encode("{!afts key=numbers}(1,10]", "UTF-8")));
        List<Interval> intervalList = Arrays.asList(new Interval("cm:price", "Price", null), new Interval("cm:created", "Created", new HashSet<IntervalSet>(Arrays.asList(new IntervalSet("2015", "2016-12", "special", Boolean.valueOf(false), Boolean.valueOf(true))))));
        params.setInterval(new IntervalParameters(new HashSet<IntervalSet>(Arrays.asList(intervalSet)), intervalList));
        urlBuilder = new StringBuilder();
        client.buildFacetIntervalParameters(params, encoder, urlBuilder);
        url = urlBuilder.toString();
        Assert.assertNotNull((Object)url);
        Assert.assertTrue((boolean)url.contains("&facet=true"));
        Assert.assertTrue((boolean)url.contains(encoder.encode("{!afts key=numbers}(1,10]", "UTF-8")));
        Assert.assertTrue((boolean)url.contains(encoder.encode("{!key=Price}cm:price", "UTF-8")));
        Assert.assertTrue((boolean)url.contains(encoder.encode("{!key=Created}cm:created", "UTF-8")));
        Assert.assertTrue((boolean)url.contains(encoder.encode("f.cm:created.facet.interval.set", "UTF-8")));
        Assert.assertTrue((boolean)url.contains(encoder.encode("{!afts key=numbers}", "UTF-8")));
        Assert.assertTrue((boolean)url.contains(encoder.encode("(2015-12-31T23:59:59.999Z", "UTF-8")));
        Assert.assertTrue((boolean)url.contains(encoder.encode("2016-12-31T23:59:59.999Z]", "UTF-8")));
        TimeZone.setDefault(defaultTimeZone);
    }

    @Test
    public void testBuildFieldFacets() throws UnsupportedEncodingException {
        SearchParameters params = new SearchParameters();
        params.setSearchTerm("bob");
        SearchParameters.FieldFacet prefixff = new SearchParameters.FieldFacet("{!afts something=right}modifier");
        SearchParameters.FieldFacet ff = new SearchParameters.FieldFacet("creator");
        params.addFieldFacet(prefixff);
        params.addFieldFacet(ff);
        StringBuilder urlBuilder = new StringBuilder();
        client.buildFacetParameters(params, false, encoder, urlBuilder);
        String url = urlBuilder.toString();
        Assert.assertNotNull((Object)url);
        Assert.assertTrue((boolean)url.contains("&facet=true"));
        Assert.assertTrue((boolean)url.contains("facet.field=creator"));
        Assert.assertTrue((boolean)url.contains("f.creator.facet.limit=100"));
        Assert.assertTrue((boolean)url.contains("facet.field=" + encoder.encode("{!afts something=right}modifier", "UTF-8")));
        Assert.assertTrue((boolean)url.contains("f.modifier.facet.limit=100"));
        prefixff.setLabel("myLabel");
        ff.setLabel("yourLabel");
        urlBuilder = new StringBuilder();
        client.buildFacetParameters(params, false, encoder, urlBuilder);
        url = urlBuilder.toString();
        Assert.assertNotNull((Object)url);
        Assert.assertTrue((boolean)url.contains("&facet=true"));
        Assert.assertTrue((boolean)url.contains("facet.field=" + encoder.encode("{!afts key=yourLabel}creator", "UTF-8")));
        Assert.assertTrue((boolean)url.contains("f.creator.facet.limit=100"));
        Assert.assertTrue((boolean)url.contains("facet.field=" + encoder.encode("{!afts key=myLabel something=right}modifier", "UTF-8")));
        Assert.assertTrue((boolean)url.contains("f.modifier.facet.limit=100"));
        prefixff.setExcludeFilters(Arrays.asList("x", "y"));
        ff.setExcludeFilters(Arrays.asList("B"));
        urlBuilder = new StringBuilder();
        client.buildFacetParameters(params, false, encoder, urlBuilder);
        url = urlBuilder.toString();
        Assert.assertNotNull((Object)url);
        Assert.assertTrue((boolean)url.contains("&facet=true"));
        Assert.assertTrue((boolean)url.contains("facet.field=" + encoder.encode("{!afts ex=B key=yourLabel}creator", "UTF-8")));
        Assert.assertTrue((boolean)url.contains("f.creator.facet.limit=100"));
        Assert.assertTrue((boolean)url.contains("facet.field=" + encoder.encode("{!afts ex=x,y key=myLabel something=right}modifier", "UTF-8")));
        Assert.assertTrue((boolean)url.contains("f.modifier.facet.limit=100"));
        prefixff.setField("bill");
        prefixff.setExcludeFilters(Collections.emptyList());
        ff.setField("{!afts}ben");
        ff.setLabel(null);
        urlBuilder = new StringBuilder();
        client.buildFacetParameters(params, false, encoder, urlBuilder);
        url = urlBuilder.toString();
        Assert.assertNotNull((Object)url);
        Assert.assertTrue((boolean)url.contains("&facet=true"));
        Assert.assertTrue((boolean)url.contains("facet.field=" + encoder.encode("{!afts ex=B}ben", "UTF-8")));
        Assert.assertTrue((boolean)url.contains("f.ben.facet.limit=100"));
        Assert.assertTrue((boolean)url.contains("facet.field=" + encoder.encode("{!afts key=myLabel}bill", "UTF-8")));
        Assert.assertTrue((boolean)url.contains("f.bill.facet.limit=100"));
    }

    @Test
    public void testBuildStats() throws UnsupportedEncodingException {
        SearchParameters params = new SearchParameters();
        params.setSearchTerm("bob");
        params.setStats(Arrays.asList(new StatsRequestParameters("created", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null), new StatsRequestParameters("cm:name", "statLabel", Arrays.asList(Float.valueOf(2.4f), Float.valueOf(99.9f)), null, null, Boolean.valueOf(false), null, Boolean.valueOf(false), null, Boolean.valueOf(false), null, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Float.valueOf(0.5f), Arrays.asList("excludeme"))));
        StringBuilder urlBuilder = new StringBuilder();
        client.buildStatsParameters(params, encoder, urlBuilder);
        String url = urlBuilder.toString();
        Assert.assertNotNull((Object)url);
        Assert.assertTrue((boolean)url.contains("&stats=true"));
        Assert.assertTrue((boolean)url.contains("stats.field=" + encoder.encode("{! countDistinct=false distinctValues=false min=true max=true sum=true count=true missing=true sumOfSquares=true mean=true stddev=true}created", "UTF-8")));
        Assert.assertTrue((boolean)url.contains("stats.field=" + encoder.encode("{! ex=excludeme tag=statLabel key=statLabel percentiles='2.4,99.9' cardinality=0.5 countDistinct=true distinctValues=true min=true max=true sum=false count=true missing=false sumOfSquares=true mean=false stddev=true}cm:name", "UTF-8")));
    }

    @Test
    public void testBuildPivots() throws UnsupportedEncodingException {
        SearchParameters params = new SearchParameters();
        params.setSearchTerm("bob");
        params.addPivots(Arrays.asList("creator"));
        params.setStats(Arrays.asList(new StatsRequestParameters("created", "piv1", null, null, null, null, null, null, null, null, null, null, null, null, null, null)));
        ArrayList<RangeParameters> ranges = new ArrayList<RangeParameters>();
        ranges.add(new RangeParameters("content.size", "0", "1000000", "10000", true, Collections.emptyList(), Collections.emptyList(), "csize", null));
        params.setRanges(ranges);
        StringBuilder urlBuilder = new StringBuilder();
        client.buildPivotParameters(params, encoder, urlBuilder);
        String url = urlBuilder.toString();
        Assert.assertNotNull((Object)url);
        Assert.assertTrue((boolean)url.contains("&facet=true"));
        Assert.assertTrue((boolean)url.contains("facet.pivot=creator"));
        params.addPivots(Arrays.asList("cm:name", "piv1", "csize"));
        urlBuilder = new StringBuilder();
        client.buildPivotParameters(params, encoder, urlBuilder);
        url = urlBuilder.toString();
        Assert.assertNotNull((Object)url);
        Assert.assertTrue((boolean)url.contains("&facet=true"));
        Assert.assertTrue((boolean)url.contains("facet.pivot=" + encoder.encode("creator", "UTF-8")));
        Assert.assertTrue((boolean)url.contains("facet.pivot=" + encoder.encode("{! stats=piv1 range=csize}cm:name", "UTF-8")));
    }

    @Test
    public void testBuildRange() throws UnsupportedEncodingException {
        SearchParameters params = new SearchParameters();
        params.setSearchTerm("A*");
        ArrayList<RangeParameters> ranges = new ArrayList<RangeParameters>();
        ArrayList<String> includes = new ArrayList<String>();
        includes.add("upper");
        includes.add("outer");
        ArrayList<String> other = new ArrayList<String>();
        other.add("before");
        other.add("between");
        ranges.add(new RangeParameters("content.size", "0", "1000000", "10000", true, other, includes, null, null));
        params.setRanges(ranges);
        StringBuilder urlBuilder = new StringBuilder();
        client.buildRangeParameters(params, encoder, urlBuilder);
        String url = urlBuilder.toString();
        Assert.assertNotNull((Object)url);
        Assert.assertTrue((boolean)url.contains("&facet=true"));
        Assert.assertTrue((boolean)url.contains("&facet.range=content.size"));
        Assert.assertTrue((boolean)url.contains("&f.content.size.facet.range.start=0"));
        Assert.assertTrue((boolean)url.contains("&f.content.size.facet.range.end=1000000"));
        Assert.assertTrue((boolean)url.contains("&f.content.size.facet.range.gap=10000"));
        Assert.assertTrue((boolean)url.contains("&f.content.size.facet.range.include=upper"));
        Assert.assertTrue((boolean)url.contains("&f.content.size.facet.range.include=outer"));
        Assert.assertTrue((boolean)url.contains("&f.content.size.facet.range.other=before"));
        Assert.assertTrue((boolean)url.contains("&f.content.size.facet.range.other=between"));
        Assert.assertTrue((boolean)url.contains("&f.content.size.facet.range.hardend=true"));
        ArrayList<String> filters = new ArrayList<String>();
        filters.add("ex1");
        ranges.clear();
        ranges.add(new RangeParameters("content.size", "0", "1000000", "10000", true, Collections.emptyList(), Collections.emptyList(), "doc", filters));
        params.setRanges(ranges);
        urlBuilder = new StringBuilder();
        client.buildRangeParameters(params, encoder, urlBuilder);
        String url2 = urlBuilder.toString();
        Assert.assertTrue((boolean)url2.contains("&facet=true"));
        Assert.assertTrue((boolean)url2.contains("&facet.range=" + encoder.encode("{!tag=doc }", "UTF-8") + "content.size"));
        Assert.assertTrue((boolean)url2.contains("&f.content.size.facet.range.start=0"));
        Assert.assertTrue((boolean)url2.contains("&f.content.size.facet.range.end=1000000"));
        Assert.assertTrue((boolean)url2.contains("&f.content.size.facet.range.gap=10000"));
        Assert.assertFalse((boolean)url2.contains("&f.content.size.facet.range.include=upper"));
        Assert.assertFalse((boolean)url2.contains("&f.content.size.facet.range.include=outer"));
        Assert.assertFalse((boolean)url2.contains("&f.content.size.facet.range.other=before"));
        Assert.assertTrue((boolean)url2.contains("&f.content.size.facet.range.hardend=true"));
        Assert.assertTrue((boolean)url2.contains("&facet.range={!ex=ex1}content.size"));
    }

    @Test
    public void testBuildMulitRange() throws UnsupportedEncodingException {
        SearchParameters params = new SearchParameters();
        params.setSearchTerm("A*");
        ArrayList<RangeParameters> ranges = new ArrayList<RangeParameters>();
        ArrayList<String> includes = new ArrayList<String>();
        includes.add("upper");
        includes.add("outer");
        ArrayList<String> includes2 = new ArrayList<String>();
        includes2.add("lower");
        ArrayList<String> other = new ArrayList<String>();
        other.add("before");
        ranges.add(new RangeParameters("content.size", "0", "1000000", "10000", true, other, includes, null, null));
        ranges.add(new RangeParameters("created", "2015-09-29T10:45:15.729Z", "2016-09-29T10:45:15.729Z", "+100DAY", true, other, includes2, null, null));
        params.setRanges(ranges);
        StringBuilder urlBuilder = new StringBuilder();
        client.buildRangeParameters(params, encoder, urlBuilder);
        String url = urlBuilder.toString();
        Assert.assertNotNull((Object)url);
        Assert.assertTrue((boolean)url.contains("&facet=true"));
        Assert.assertTrue((boolean)url.contains("&facet.range=content.size"));
        Assert.assertTrue((boolean)url.contains("&f.content.size.facet.range.start=0"));
        Assert.assertTrue((boolean)url.contains("&f.content.size.facet.range.end=1000000"));
        Assert.assertTrue((boolean)url.contains("&f.content.size.facet.range.gap=10000"));
        Assert.assertTrue((boolean)url.contains("&f.content.size.facet.range.include=upper"));
        Assert.assertTrue((boolean)url.contains("&f.content.size.facet.range.include=outer"));
        Assert.assertTrue((boolean)url.contains("&f.content.size.facet.range.hardend=true"));
        Assert.assertTrue((boolean)url.contains("&facet.range=created"));
        Assert.assertTrue((boolean)url.contains("&f.created.facet.range.start=2015-09-29T10%3A45%3A15.729Z"));
        Assert.assertTrue((boolean)url.contains("&f.created.facet.range.end=2016-09-29T10%3A45%3A15.729Z"));
        Assert.assertTrue((boolean)url.contains("&f.created.facet.range.gap=%2B100DAY"));
        Assert.assertTrue((boolean)url.contains("&f.created.facet.range.other=before"));
        Assert.assertTrue((boolean)url.contains("&f.created.facet.range.include=lower"));
        Assert.assertTrue((boolean)url.contains("&f.created.facet.range.hardend=true"));
    }

    @Test
    public void testBuildRangeDate() throws UnsupportedEncodingException {
        TimeZone defaultTimeZone = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        SearchParameters params = new SearchParameters();
        params.setSearchTerm("A*");
        ArrayList<RangeParameters> ranges = new ArrayList<RangeParameters>();
        ranges.add(new RangeParameters("created", "2015", "2016", "+1MONTH", true, Collections.emptyList(), Collections.emptyList(), null, null));
        params.setRanges(ranges);
        StringBuilder urlBuilder = new StringBuilder();
        client.buildRangeParameters(params, encoder, urlBuilder);
        String url = urlBuilder.toString();
        Assert.assertNotNull((Object)url);
        Assert.assertTrue((boolean)url.contains("&facet=true"));
        Assert.assertTrue((boolean)url.contains("&facet.range=created"));
        Assert.assertTrue((boolean)url.contains("&f.created.facet.range.start=2015-01-01T00%3A00%3A00.000Z"));
        Assert.assertTrue((boolean)url.contains("&f.created.facet.range.end=2016-12-31T23%3A59%3A59.999Z"));
        Assert.assertTrue((boolean)url.contains("&f.created.facet.range.gap=%2B1MONTH"));
        TimeZone.setDefault(defaultTimeZone);
    }
}

