/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.util.HashMap;
import org.alfresco.repo.management.subsystems.SwitchableApplicationContextFactory;
import org.alfresco.repo.search.impl.solr.SolrAdminHTTPClient;
import org.alfresco.repo.search.impl.solr.SolrChildApplicationContextFactory;
import org.alfresco.util.BaseSpringTest;
import org.json.JSONObject;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.springframework.context.ApplicationContext;

public class SolrChildApplicationContextFactoryTest
extends BaseSpringTest {
    private static JSONObject json = new JSONObject("{\n   \"responseHeader\":{\n      \"status\":0,\n      \"QTime\":1221\n   },\n   \"Summary\":{\n      \"alfresco\":{\n         \"Total Searcher Cache (GB)\":0,\n         \"On disk (GB)\":\"0.006584\",\n         \"Active\":false,\n         \"TX Lag\":\"0 s\",\n         \"TX Duration\":\"P0Y\",\n         \"Approx transactions remaining\":0,\n         \"Approx transaction indexing time remaining\":\"0 Seconds\",\n         \"Id for last TX in index\":16\n      },\n      \"archive\":{\n         \"Total Searcher Cache (GB)\":1,\n         \"On disk (GB)\":\"0.001554\",\n         \"Active\":true,\n         \"TX Lag\":\"1 s\",\n         \"TX Duration\":\"P1Y\",\n         \"Approx transactions remaining\":1,\n         \"Approx transaction indexing time remaining\":\"30 Seconds\",\n         \"Id for last TX in index\":15\n      }\n   }\n}");
    private SolrChildApplicationContextFactory solrChildApplicationContextFactory;
    @Mock
    private SolrAdminHTTPClient adminClient;

    @Before
    public void before() {
        SwitchableApplicationContextFactory subsystemManager = (SwitchableApplicationContextFactory)this.applicationContext.getBean("Search");
        ApplicationContext solrContext = subsystemManager.getApplicationContext();
        this.solrChildApplicationContextFactory = (SolrChildApplicationContextFactory)solrContext.getBean("solr6");
        this.adminClient = (SolrAdminHTTPClient)Mockito.mock(SolrAdminHTTPClient.class);
        Mockito.when((Object)this.adminClient.execute((HashMap)ArgumentMatchers.any())).thenReturn((Object)json);
        this.solrChildApplicationContextFactory.setAdminClient(this.adminClient);
    }

    @Test
    public void test() {
        SolrChildApplicationContextFactoryTest.assertEquals((String)this.solrChildApplicationContextFactory.getProperty("tracker.alfresco.active"), (String)"false");
        SolrChildApplicationContextFactoryTest.assertEquals((String)this.solrChildApplicationContextFactory.getProperty("tracker.alfresco.lag"), (String)"0 s");
        SolrChildApplicationContextFactoryTest.assertEquals((String)this.solrChildApplicationContextFactory.getProperty("tracker.alfresco.lag.duration"), (String)"P0Y");
        SolrChildApplicationContextFactoryTest.assertEquals((String)this.solrChildApplicationContextFactory.getProperty("tracker.alfresco.last.indexed.txn"), (String)"16");
        SolrChildApplicationContextFactoryTest.assertEquals((String)this.solrChildApplicationContextFactory.getProperty("tracker.alfresco.approx.txns.remaining"), (String)"0");
        SolrChildApplicationContextFactoryTest.assertEquals((String)this.solrChildApplicationContextFactory.getProperty("tracker.alfresco.approx.indexing.time.remaining"), (String)"0 Seconds");
        SolrChildApplicationContextFactoryTest.assertEquals((String)this.solrChildApplicationContextFactory.getProperty("tracker.alfresco.disk"), (String)"0.006584");
        SolrChildApplicationContextFactoryTest.assertEquals((String)this.solrChildApplicationContextFactory.getProperty("tracker.alfresco.memory"), (String)"0");
        SolrChildApplicationContextFactoryTest.assertEquals((String)this.solrChildApplicationContextFactory.getProperty("tracker.archive.active"), (String)"true");
        SolrChildApplicationContextFactoryTest.assertEquals((String)this.solrChildApplicationContextFactory.getProperty("tracker.archive.lag"), (String)"1 s");
        SolrChildApplicationContextFactoryTest.assertEquals((String)this.solrChildApplicationContextFactory.getProperty("tracker.archive.lag.duration"), (String)"P1Y");
        SolrChildApplicationContextFactoryTest.assertEquals((String)this.solrChildApplicationContextFactory.getProperty("tracker.archive.last.indexed.txn"), (String)"15");
        SolrChildApplicationContextFactoryTest.assertEquals((String)this.solrChildApplicationContextFactory.getProperty("tracker.archive.approx.txns.remaining"), (String)"1");
        SolrChildApplicationContextFactoryTest.assertEquals((String)this.solrChildApplicationContextFactory.getProperty("tracker.archive.approx.indexing.time.remaining"), (String)"30 Seconds");
        SolrChildApplicationContextFactoryTest.assertEquals((String)this.solrChildApplicationContextFactory.getProperty("tracker.archive.disk"), (String)"0.001554");
        SolrChildApplicationContextFactoryTest.assertEquals((String)this.solrChildApplicationContextFactory.getProperty("tracker.archive.memory"), (String)"1");
    }
}

