/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.dictionary.CustomModelDefinition;
import org.alfresco.service.cmr.dictionary.CustomModelService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.testing.category.LuceneTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={LuceneTests.class})
public class CustomModelRepoRestartTest {
    private CustomModelService customModelService;
    private RetryingTransactionHelper transactionHelper;
    private String modelName;

    @Before
    public void setUp() throws Exception {
        this.getCtxAndSetBeans();
        this.modelName = String.valueOf(System.currentTimeMillis()) + "testCustomModel";
    }

    @After
    public void tearDown() throws Exception {
        this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Exception {
                try {
                    CustomModelRepoRestartTest.this.customModelService.deactivateCustomModel(CustomModelRepoRestartTest.this.modelName);
                }
                catch (Exception exception) {}
                return null;
            }
        });
        this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Exception {
                try {
                    CustomModelRepoRestartTest.this.customModelService.deleteCustomModel(CustomModelRepoRestartTest.this.modelName);
                }
                catch (Exception exception) {}
                return null;
            }
        });
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    private void getCtxAndSetBeans() {
        ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
        this.customModelService = (CustomModelService)ctx.getBean("customModelService", CustomModelService.class);
        this.transactionHelper = (RetryingTransactionHelper)ctx.getBean("retryingTransactionHelper", RetryingTransactionHelper.class);
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
    }

    @Test
    public void testActivateModelAndRestartRepo() throws Exception {
        long timeMillis = System.currentTimeMillis();
        String uri = "http://www.alfresco.org/model/testcmmrestartnamespace" + timeMillis;
        String prefix = "testcmmrestart" + timeMillis;
        final M2Model model = M2Model.createModel((String)(String.valueOf(prefix) + ':' + this.modelName));
        model.createNamespace(uri, prefix);
        CustomModelDefinition modelDefinition = (CustomModelDefinition)this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<CustomModelDefinition>(){

            public CustomModelDefinition execute() throws Exception {
                return CustomModelRepoRestartTest.this.customModelService.createCustomModel(model, false);
            }
        });
        Assert.assertNotNull((Object)modelDefinition);
        Assert.assertEquals((Object)this.modelName, (Object)modelDefinition.getName().getLocalName());
        Assert.assertFalse((boolean)modelDefinition.isActive());
        this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Exception {
                CustomModelRepoRestartTest.this.customModelService.activateCustomModel(CustomModelRepoRestartTest.this.modelName);
                return null;
            }
        });
        modelDefinition = this.getModel(this.modelName);
        Assert.assertNotNull((Object)modelDefinition);
        Assert.assertEquals((Object)this.modelName, (Object)modelDefinition.getName().getLocalName());
        Assert.assertTrue((boolean)modelDefinition.isActive());
        ApplicationContextHelper.closeApplicationContext();
        this.getCtxAndSetBeans();
        modelDefinition = this.getModel(this.modelName);
        Assert.assertNotNull((Object)modelDefinition);
        Assert.assertEquals((Object)this.modelName, (Object)modelDefinition.getName().getLocalName());
        Assert.assertTrue((boolean)modelDefinition.isActive());
    }

    private CustomModelDefinition getModel(final String modelName) {
        return (CustomModelDefinition)this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<CustomModelDefinition>(){

            public CustomModelDefinition execute() throws Exception {
                return CustomModelRepoRestartTest.this.customModelService.getCustomModel(modelName);
            }
        });
    }
}

