/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.traitextender;

import java.util.Collections;
import java.util.List;
import org.alfresco.traitextender.Extender;
import org.alfresco.traitextender.InvalidExtension;
import org.alfresco.traitextender.RegistryExtensionBundle;
import org.alfresco.traitextender.SpringBeanExtension;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class SpringExtensionBundle
implements InitializingBean {
    private static Log logger = LogFactory.getLog(SpringExtensionBundle.class);
    private List<SpringBeanExtension<?, ?>> extensions = Collections.emptyList();
    private String id;
    private boolean enabled = true;
    private RegistryExtensionBundle extensionBundle;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setExtensions(List<SpringBeanExtension<?, ?>> extensions) {
        this.extensions = extensions;
    }

    public void setId(String id) {
        this.id = id;
    }

    public synchronized void start() {
        if (this.extensionBundle == null) {
            logger.info((Object)("Registering extension bundle " + this.id));
            this.extensionBundle = new RegistryExtensionBundle(this.id);
            for (SpringBeanExtension<?, ?> springExtension : this.extensions) {
                try {
                    springExtension.register(this.extensionBundle);
                }
                catch (Exception error) {
                    throw new InvalidExtension("Could not register extension " + springExtension + " with " + this.extensionBundle, error);
                }
            }
        }
        logger.info((Object)("Starting extension bundle " + this.id));
        Extender.getInstance().start(this.extensionBundle);
    }

    public synchronized void stop() {
        if (this.extensionBundle == null) {
            logger.info((Object)("Stop request for unregistered extension bundle " + this.id));
        }
        logger.info((Object)("Stopping extension bundle " + this.id));
        Extender.getInstance().stop(this.extensionBundle);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.enabled) {
            logger.info((Object)("The extension bundle " + this.id + " is spring-enabled. Starting ... "));
            this.start();
        } else {
            logger.info((Object)("Extension bundle " + this.id + " is spring-disabled."));
        }
    }
}

