/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.alfresco.repo.virtual.ref.ClasspathResource;
import org.alfresco.repo.virtual.ref.Encodings;
import org.alfresco.repo.virtual.ref.Parameter;
import org.alfresco.repo.virtual.ref.Protocol;
import org.alfresco.repo.virtual.ref.Protocols;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.ReferenceParameter;
import org.alfresco.repo.virtual.ref.ReferenceParseException;
import org.alfresco.repo.virtual.ref.ReferenceParser;
import org.alfresco.repo.virtual.ref.RepositoryNodeRef;
import org.alfresco.repo.virtual.ref.RepositoryPath;
import org.alfresco.repo.virtual.ref.RepositoryResource;
import org.alfresco.repo.virtual.ref.Resource;
import org.alfresco.repo.virtual.ref.ResourceParameter;
import org.alfresco.repo.virtual.ref.StringParameter;
import org.alfresco.repo.virtual.ref.ZeroEncoding;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;

public class ZeroReferenceParser
implements ReferenceParser,
ZeroEncoding {
    private static final long serialVersionUID = 795566334039858555L;

    @Override
    public Reference parse(String referenceString) throws ReferenceParseException {
        String[] referenceTokens = referenceString.split(":");
        ReferenceParser.Cursor cursor = new ReferenceParser.Cursor(referenceTokens, 0);
        if (referenceTokens.length < 2) {
            throw new ReferenceParseException("Invalid reference " + referenceString);
        }
        return this.parseReference(cursor);
    }

    private Reference parseReference(ReferenceParser.Cursor cursor) throws ReferenceParseException {
        try {
            Protocol protocol = null;
            int protocolResourceEncoding = Integer.parseInt(cursor.tokens[cursor.i]);
            if (protocolResourceEncoding < 3) {
                protocol = Protocols.fromName("vanilla");
            } else if (protocolResourceEncoding < 6) {
                protocol = Protocols.fromName("virtual");
                protocolResourceEncoding -= 3;
            } else if (protocolResourceEncoding - 6 < 3) {
                protocol = Protocols.fromName("node");
                protocolResourceEncoding -= 6;
            }
            if (protocol == null) {
                throw new ReferenceParseException("Unknown protocol " + protocol);
            }
            ++cursor.i;
            Resource resource = this.parseResource(protocolResourceEncoding, cursor);
            List<Parameter> parameters = this.parseParameters(cursor);
            Reference reference = new Reference(Encodings.ZERO.encoding, protocol, resource, parameters);
            return reference;
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            throw new ReferenceParseException("Invalid reference", e);
        }
    }

    private Resource parseResource(int resourceEncoding, ReferenceParser.Cursor cursor) throws ReferenceParseException {
        Resource resource = null;
        if (resourceEncoding == 0) {
            resource = new RepositoryResource(this.parseRepositoryPath(cursor));
        } else if (resourceEncoding == 1) {
            resource = new RepositoryResource(this.parseRepositoryNode(cursor));
        } else if (resourceEncoding == 2) {
            resource = this.parseClasspathResource(cursor);
        }
        if (resource == null) {
            throw new ReferenceParseException("Unknown resource encoding " + resourceEncoding);
        }
        return resource;
    }

    private Resource parseResource(ReferenceParser.Cursor cursor) throws ReferenceParseException {
        return this.parseResource(Byte.parseByte(cursor.tokens[cursor.i - 1]), cursor);
    }

    private List<Parameter> parseParameters(ReferenceParser.Cursor cursor) throws ReferenceParseException {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        while (cursor.i < cursor.tokens.length) {
            if (Arrays.asList(ZeroEncoding.RESOURCE_PARAMETER).contains(cursor.tokens[cursor.i])) {
                ++cursor.i;
                parameters.add(this.parseResourceParameter(cursor));
                continue;
            }
            if ("s".equals(cursor.tokens[cursor.i])) {
                ++cursor.i;
                parameters.add(this.parseStringParameter(cursor));
                continue;
            }
            if ("r".equals(cursor.tokens[cursor.i])) {
                ++cursor.i;
                parameters.add(this.parseReferenceParameter(cursor));
                continue;
            }
            if ("*".equals(cursor.tokens[cursor.i])) {
                ++cursor.i;
                break;
            }
            throw new ReferenceParseException("Invalid parameter " + cursor.tokens[cursor.i]);
        }
        return parameters;
    }

    private Parameter parseStringParameter(ReferenceParser.Cursor cursor) {
        StringParameter paramenter = new StringParameter(cursor.tokens[cursor.i]);
        ++cursor.i;
        return paramenter;
    }

    private Parameter parseResourceParameter(ReferenceParser.Cursor cursor) throws ReferenceParseException {
        Resource resource = this.parseResource(cursor);
        return new ResourceParameter(resource);
    }

    private RepositoryPath parseRepositoryPath(ReferenceParser.Cursor cursor) {
        String path = cursor.tokens[cursor.i];
        ++cursor.i;
        return new RepositoryPath(path);
    }

    private RepositoryNodeRef parseRepositoryNode(ReferenceParser.Cursor cursor) {
        String id = cursor.tokens[cursor.i];
        ++cursor.i;
        return new RepositoryNodeRef(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, id));
    }

    private ClasspathResource parseClasspathResource(ReferenceParser.Cursor cursor) {
        String classpath = cursor.tokens[cursor.i];
        ++cursor.i;
        return new ClasspathResource(classpath);
    }

    private ReferenceParameter parseReferenceParameter(ReferenceParser.Cursor cursor) throws ReferenceParseException {
        Reference reference = this.parseReference(cursor);
        ReferenceParameter parameter = new ReferenceParameter(reference);
        return parameter;
    }
}

