/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.forms.Item;
import org.alfresco.repo.forms.processor.FormProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FormProcessorRegistry {
    private static Log logger = LogFactory.getLog(FormProcessorRegistry.class);
    protected List<FormProcessor> processors = new ArrayList<FormProcessor>(4);

    public void addProcessor(FormProcessor processor) {
        if (processor.isActive()) {
            this.processors.add(processor);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Registered processor: " + processor));
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)("Ignored registration of processor " + processor + "as it was marked as inactive"));
        }
    }

    public FormProcessor getApplicableFormProcessor(Item item) {
        FormProcessor selectedProcessor = null;
        for (FormProcessor processor : this.processors) {
            if (!processor.isActive() || !processor.isApplicable(item)) continue;
            selectedProcessor = processor;
            break;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning applicable processor: " + selectedProcessor));
        }
        return selectedProcessor;
    }
}

