/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.audit;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.CRC32;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.domain.audit.AuditApplicationEntity;
import org.alfresco.repo.domain.audit.AuditDAO;
import org.alfresco.repo.domain.audit.AuditEntryEntity;
import org.alfresco.repo.domain.audit.AuditModelEntity;
import org.alfresco.repo.domain.audit.AuditQueryParameters;
import org.alfresco.repo.domain.audit.AuditQueryResult;
import org.alfresco.repo.domain.contentdata.ContentDataDAO;
import org.alfresco.repo.domain.propval.PropertyIdSearchRow;
import org.alfresco.repo.domain.propval.PropertyValueDAO;
import org.alfresco.service.cmr.audit.AuditService;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataIntegrityViolationException;

public abstract class AbstractAuditDAOImpl
implements AuditDAO {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ContentService contentService;
    private ContentDataDAO contentDataDAO;
    protected PropertyValueDAO propertyValueDAO;

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setContentDataDAO(ContentDataDAO contentDataDAO) {
        this.contentDataDAO = contentDataDAO;
    }

    public void setPropertyValueDAO(PropertyValueDAO propertyValueDAO) {
        this.propertyValueDAO = propertyValueDAO;
    }

    protected PropertyValueDAO getPropertyValueDAO() {
        return this.propertyValueDAO;
    }

    /*
     * Loose catch block
     */
    @Override
    public Pair<Long, ContentData> getOrCreateAuditModel(URL url) {
        Pair pair;
        InputStream is;
        block17: {
            long crc;
            block15: {
                Pair pair2;
                block16: {
                    is = null;
                    is = url.openStream();
                    CRC32 crcCalc = new CRC32();
                    byte[] buffer = new byte[1024];
                    int read = -1;
                    while ((read = is.read(buffer)) >= 0) {
                        crcCalc.update(buffer, 0, read);
                    }
                    crc = crcCalc.getValue();
                    AuditModelEntity existingEntity = this.getAuditModelByCrc(crc);
                    if (existingEntity == null) break block15;
                    Long existingEntityId = existingEntity.getId();
                    ContentData existingContentData = (ContentData)this.contentDataDAO.getContentData(existingEntity.getContentDataId()).getSecond();
                    Pair result = new Pair((Object)existingEntityId, (Object)existingContentData);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Found existing model with same CRC: \n   URL:    " + url + "\n" + "   CRC:    " + crc + "\n" + "   Result: " + result));
                    }
                    pair2 = result;
                    if (is == null) break block16;
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {}
                }
                return pair2;
            }
            is.close();
            is = url.openStream();
            ContentWriter writer = this.contentService.getWriter(null, null, false);
            writer.setEncoding("UTF-8");
            writer.setMimetype("text/xml");
            writer.putContent(is);
            ContentData newContentData = writer.getContentData();
            Long newContentDataId = (Long)this.contentDataDAO.createContentData(newContentData).getFirst();
            AuditModelEntity newEntity = this.createAuditModel(newContentDataId, crc);
            Pair result = new Pair((Object)newEntity.getId(), (Object)newContentData);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Created new audit model: \n   URL:    " + url + "\n" + "   CRC:    " + crc + "\n" + "   Result: " + result));
            }
            pair = result;
            if (is == null) break block17;
            try {
                is.close();
            }
            catch (Throwable throwable) {}
        }
        return pair;
        catch (IOException iOException) {
            try {
                throw new AlfrescoRuntimeException("Failed to read Audit model: " + url);
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {}
                }
                throw throwable;
            }
        }
    }

    protected abstract AuditModelEntity getAuditModelByCrc(long var1);

    protected abstract AuditModelEntity createAuditModel(Long var1, long var2);

    @Override
    public AuditDAO.AuditApplicationInfo getAuditApplication(String application) {
        AuditApplicationEntity entity = this.getAuditApplicationByName(application);
        if (entity == null) {
            return null;
        }
        AuditDAO.AuditApplicationInfo appInfo = new AuditDAO.AuditApplicationInfo();
        appInfo.setId(entity.getId());
        appInfo.setname(application);
        appInfo.setModelId(entity.getAuditModelId());
        appInfo.setDisabledPathsId(entity.getDisabledPathsId());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Found existing audit application: \n  " + appInfo));
        }
        return appInfo;
    }

    @Override
    public AuditDAO.AuditApplicationInfo createAuditApplication(String application, Long modelId) {
        Long appNameId = (Long)this.propertyValueDAO.getOrCreatePropertyValue((Serializable)((Object)application)).getFirst();
        HashSet disabledPaths = new HashSet();
        Long disabledPathsId = this.propertyValueDAO.createProperty(disabledPaths);
        AuditApplicationEntity entity = this.createAuditApplication(appNameId, modelId, disabledPathsId);
        AuditDAO.AuditApplicationInfo appInfo = new AuditDAO.AuditApplicationInfo();
        appInfo.setId(entity.getId());
        appInfo.setname(application);
        appInfo.setModelId(modelId);
        appInfo.setDisabledPathsId(disabledPathsId);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Created new audit application: \n   Model:  " + modelId + "\n" + "   App:    " + application + "\n" + "   Result: " + entity));
        }
        return appInfo;
    }

    @Override
    public void updateAuditApplicationModel(Long id, Long modelId) {
        AuditApplicationEntity entity = this.getAuditApplicationById(id);
        if (entity == null) {
            throw new DataIntegrityViolationException("No audit application exists for ID " + id);
        }
        if (entity.getAuditModelId().equals(modelId)) {
            return;
        }
        entity.setAuditModelId(modelId);
        this.updateAuditApplication(entity);
    }

    @Override
    public void updateAuditApplicationDisabledPaths(Long id, Set<String> disabledPaths) {
        AuditApplicationEntity entity = this.getAuditApplicationById(id);
        if (entity == null) {
            throw new DataIntegrityViolationException("No audit application exists for ID " + id);
        }
        Long disabledPathsId = entity.getDisabledPathsId();
        Set oldDisabledPaths = (Set)((Object)this.propertyValueDAO.getPropertyById(disabledPathsId));
        if (oldDisabledPaths.equals(disabledPaths)) {
            return;
        }
        this.propertyValueDAO.updateProperty(disabledPathsId, (Serializable)((Object)disabledPaths));
        this.updateAuditApplication(entity);
    }

    protected abstract AuditApplicationEntity getAuditApplicationById(Long var1);

    protected abstract AuditApplicationEntity getAuditApplicationByName(String var1);

    protected abstract AuditApplicationEntity createAuditApplication(Long var1, Long var2, Long var3);

    protected abstract AuditApplicationEntity updateAuditApplication(AuditApplicationEntity var1);

    @Override
    public Long createAuditEntry(Long applicationId, long time, String username, Map<String, Serializable> values) {
        Long usernameId = username != null ? (Long)this.propertyValueDAO.getOrCreatePropertyValue((Serializable)((Object)username)).getFirst() : null;
        Long valuesId = null;
        if (values != null && values.size() > 0) {
            valuesId = this.propertyValueDAO.createProperty((Serializable)((Object)values));
        }
        AuditEntryEntity entity = this.createAuditEntry(applicationId, time, usernameId, valuesId);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Created new audit entry: \n   Application: " + applicationId + "\n" + "   Time:        " + new Date(time) + "\n" + "   User:        " + username + "\n" + "   Result:      " + entity));
        }
        return entity.getId();
    }

    @Override
    public int deleteAuditEntries(List<Long> auditEntryIds) {
        TreeSet<Long> ids = new TreeSet<Long>(auditEntryIds);
        int shouldDelete = ids.size();
        int deleted = 0;
        ArrayList<Long> batch = new ArrayList<Long>(shouldDelete > 512 ? 512 : shouldDelete);
        for (Long id : ids) {
            batch.add(id);
            if (batch.size() < 512) continue;
            deleted += this.deleteAuditEntriesImpl(batch);
            batch.clear();
        }
        if (batch.size() > 0) {
            deleted += this.deleteAuditEntriesImpl(batch);
        }
        if (deleted != shouldDelete) {
            throw new ConcurrencyFailureException("Deleted " + deleted + " audit entries out of a set of " + shouldDelete + " unique IDs.");
        }
        return deleted;
    }

    protected abstract AuditEntryEntity createAuditEntry(Long var1, long var2, Long var4, Long var5);

    protected abstract int deleteAuditEntriesImpl(List<Long> var1);

    @Override
    public void findAuditEntries(AuditService.AuditQueryCallback callback, org.alfresco.service.cmr.audit.AuditQueryParameters parameters, int maxResults) {
        AuditQueryRowHandler rowHandler = new AuditQueryRowHandler(callback);
        this.findAuditEntries(rowHandler, maxResults, parameters);
    }

    protected abstract void findAuditEntries(AuditQueryRowHandler var1, int var2, org.alfresco.service.cmr.audit.AuditQueryParameters var3);

    protected AuditQueryParameters convertFromRestAuditQueryParameters(org.alfresco.service.cmr.audit.AuditQueryParameters restParameters) {
        String user;
        AuditQueryParameters dbParameters = new AuditQueryParameters();
        String appName = restParameters.getApplicationName();
        if (appName != null) {
            Pair<Long, Serializable> appNamePair = this.propertyValueDAO.getPropertyValue((Serializable)((Object)appName));
            if (appNamePair == null) {
                return null;
            }
            dbParameters.setAuditAppNameId((Long)appNamePair.getFirst());
        }
        if ((user = restParameters.getUser()) != null) {
            Pair<Long, Serializable> userPair = this.propertyValueDAO.getPropertyValue((Serializable)((Object)user));
            if (userPair == null) {
                return null;
            }
            dbParameters.setAuditUserId((Long)userPair.getFirst());
        }
        dbParameters.setAuditFromId(restParameters.getFromId());
        dbParameters.setAuditToId(restParameters.getToId());
        dbParameters.setAuditFromTime(restParameters.getFromTime());
        dbParameters.setAuditToTime(restParameters.getToTime());
        String searchKey = null;
        Serializable searchValue = null;
        if (restParameters.getSearchKeyValues().size() > 0) {
            Pair<String, Serializable> searchKeyValue = restParameters.getSearchKeyValues().get(0);
            searchKey = (String)searchKeyValue.getFirst();
            searchValue = (Serializable)searchKeyValue.getSecond();
        }
        if (searchKey != null) {
            Pair<Long, Serializable> searchKeyPair = this.propertyValueDAO.getPropertyValue((Serializable)((Object)searchKey));
            if (searchKeyPair == null) {
                return null;
            }
            dbParameters.setSearchKeyId((Long)searchKeyPair.getFirst());
        }
        if (searchValue != null) {
            Pair<Long, Serializable> searchValuePair = this.propertyValueDAO.getPropertyValue(searchValue);
            if (searchValuePair == null) {
                return null;
            }
            dbParameters.setSearchValueId((Long)searchValuePair.getFirst());
        }
        dbParameters.setForward(restParameters.isForward());
        return dbParameters;
    }

    protected class AuditQueryRowHandler {
        private final AuditService.AuditQueryCallback callback;
        private boolean more;

        private AuditQueryRowHandler(AuditService.AuditQueryCallback callback) {
            this.callback = callback;
            this.more = true;
        }

        public boolean valuesRequired() {
            return this.callback.valuesRequired();
        }

        public void processResult(AuditQueryResult row) {
            if (!this.more) {
                return;
            }
            Map auditValues = null;
            if (this.valuesRequired() && (auditValues = row.getAuditValue()) == null) {
                List<PropertyIdSearchRow> propMapRows = row.getAuditValueRows();
                if (propMapRows == null) {
                    Long auditValuesId = row.getAuditValuesId();
                    Pair<Long, Serializable> auditValuesPair = AbstractAuditDAOImpl.this.propertyValueDAO.getPropertyValueById(auditValuesId);
                    if (auditValuesPair == null) {
                        this.more = this.callback.handleAuditEntryError(row.getAuditEntryId(), "Audit entry not joined to audit properties: " + row, null);
                        return;
                    }
                    auditValues = (Map)auditValuesPair.getSecond();
                } else {
                    try {
                        auditValues = (Map)((Object)AbstractAuditDAOImpl.this.propertyValueDAO.convertPropertyIdSearchRows(propMapRows));
                    }
                    catch (ClassCastException e) {
                        this.more = this.callback.handleAuditEntryError(row.getAuditEntryId(), "Audit entry not linked to a Map<String, Serializable> value: " + row, e);
                        return;
                    }
                    catch (Throwable e) {
                        this.more = this.callback.handleAuditEntryError(row.getAuditEntryId(), "Audit entry unable to extract audited values: " + row, e);
                        return;
                    }
                    if (auditValues == null) {
                        this.more = this.callback.handleAuditEntryError(row.getAuditEntryId(), "Audit entry incompletely joined to audit properties: " + row, null);
                        return;
                    }
                }
            }
            String auditAppName = (String)AbstractAuditDAOImpl.this.propertyValueDAO.getPropertyValueById(row.getAuditAppNameId()).getSecond();
            Long auditUserId = row.getAuditUserId();
            String auditUser = auditUserId == null ? null : (String)AbstractAuditDAOImpl.this.propertyValueDAO.getPropertyValueById(auditUserId).getSecond();
            this.more = this.callback.handleAuditEntry(row.getAuditEntryId(), auditAppName, auditUser, row.getAuditTime(), auditValues);
        }
    }
}

