/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.AbstractLocalTransform;
import org.alfresco.repo.content.transform.LocalTransform;
import org.alfresco.repo.content.transform.LocalTransformServiceRegistry;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.repo.content.transform.UnsupportedTransformationException;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.transform.config.TransformOption;
import org.alfresco.util.TempFileProvider;

public class LocalFailoverTransform
extends AbstractLocalTransform {
    private final List<LocalTransform> transformers = new ArrayList<LocalTransform>();

    public LocalFailoverTransform(String name, TransformerDebug transformerDebug, MimetypeService mimetypeService, boolean strictMimeTypeCheck, Map<String, Set<String>> strictMimetypeExceptions, boolean retryTransformOnDifferentMimeType, Set<TransformOption> transformsTransformOptions, LocalTransformServiceRegistry localTransformServiceRegistry) {
        super(name, transformerDebug, mimetypeService, strictMimeTypeCheck, strictMimetypeExceptions, retryTransformOnDifferentMimeType, transformsTransformOptions, localTransformServiceRegistry);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    public void addStepTransformer(LocalTransform stepTransformer) {
        this.transformers.add(stepTransformer);
    }

    @Override
    protected void transformImpl(ContentReader reader, ContentWriter writer, Map<String, String> transformOptions, String sourceMimetype, String targetMimetype, String sourceExtension, String targetExtension, String renditionName, NodeRef sourceNodeRef) {
        String targetExt = this.mimetypeService.getExtension(targetMimetype);
        Object transformationException = null;
        int i = 0;
        while (i < this.transformers.size()) {
            block9: {
                LocalTransform stepTransformer = this.transformers.get(i);
                FileContentWriter currentWriter = null;
                File tempFile = null;
                try {
                    if (AbstractLocalTransform.log.isDebugEnabled()) {
                        AbstractLocalTransform.log.debug((Object)("Transformation attempt " + (i + 1) + " of " + this.transformers.size() + ": " + stepTransformer));
                    }
                    tempFile = TempFileProvider.createTempFile((String)("LocalFailoverTransformer_intermediate_" + stepTransformer.getClass().getSimpleName() + "_"), (String)("." + targetExt));
                    currentWriter = new FileContentWriter(tempFile);
                    currentWriter.setMimetype(targetMimetype);
                    currentWriter.setEncoding(writer.getEncoding());
                    stepTransformer.transform(reader, currentWriter, transformOptions, renditionName, sourceNodeRef);
                }
                catch (UnsupportedTransformationException | ContentIOException are) {
                    if (transformationException == null) {
                        transformationException = are;
                    } else {
                        AbstractLocalTransform.log.debug((Object)"The below exception is provided for information purposes only.", (Throwable)are);
                    }
                    reader = reader.getReader();
                    break block9;
                }
                if (transformationException == null) {
                    AbstractLocalTransform.log.debug((Object)"The following exception (from the first transformer) is provided for information purposes only as a later transformer succeeded.", (Throwable)transformationException);
                }
                if (tempFile != null) {
                    writer.putContent(tempFile);
                }
                AbstractLocalTransform.log.info((Object)"Transformation was successful");
                return;
            }
            ++i;
        }
        if (transformationException != null) {
            this.transformerDebug.debug("          No more transformations to failover to");
            AbstractLocalTransform.log.debug((Object)"All transformations were unsuccessful. Throwing first exception.", transformationException);
            throw transformationException;
        }
    }
}

