/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.audit.access;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.repo.audit.access.NodeInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO9075;

public class NodeInfoFactory {
    private final NodeService nodeService;
    private final NamespaceService namespaceService;

    public NodeInfoFactory(NodeService nodeService, NamespaceService namespaceService) {
        this.nodeService = nodeService;
        this.namespaceService = namespaceService;
    }

    public NodeInfo newNodeInfo(NodeRef nodeRef) {
        String path = this.getPath(nodeRef);
        String type = this.getType(nodeRef);
        return new NodeInfo(nodeRef, path, type);
    }

    public NodeInfo newNodeInfo(ChildAssociationRef childAssocRef) {
        String path = String.valueOf(this.getPath(childAssocRef.getParentRef())) + '/' + this.getName(childAssocRef.getQName());
        String type = this.getType(childAssocRef.getChildRef());
        return new NodeInfo(childAssocRef.getChildRef(), path, type);
    }

    private String getPath(NodeRef nodeRef) {
        String path = null;
        try {
            path = this.nodeService.getPath(nodeRef).toPrefixString((NamespacePrefixResolver)this.namespaceService);
        }
        catch (NamespaceException namespaceException) {
            path = this.nodeService.getPath(nodeRef).toString();
        }
        catch (InvalidNodeRefException invalidNodeRefException) {}
        path = ISO9075.decode(path);
        return path;
    }

    private String getName(QName qName) {
        String name = null;
        try {
            name = qName.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        }
        catch (NamespaceException namespaceException) {
            name = qName.toPrefixString();
        }
        name = ISO9075.decode((String)name);
        return name;
    }

    private String getType(NodeRef nodeRef) {
        String type = null;
        try {
            type = this.nodeService.getType(nodeRef).toPrefixString((NamespacePrefixResolver)this.namespaceService);
        }
        catch (NamespaceException namespaceException) {
            type = this.nodeService.getType(nodeRef).toPrefixString();
        }
        catch (InvalidNodeRefException invalidNodeRefException) {}
        return type;
    }

    public Map<QName, Serializable> getProperties(NodeRef nodeRef) {
        return this.nodeService.getProperties(nodeRef);
    }
}

