/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.ibatis;

import org.alfresco.error.AlfrescoRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RetryingCallbackHelper {
    private static final Log logger = LogFactory.getLog(RetryingCallbackHelper.class);
    private int maxRetries = 5;
    private int retryWaitMs = 10;

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setRetryWaitMs(int retryWaitMs) {
        this.retryWaitMs = retryWaitMs;
    }

    public <R> R doWithRetry(RetryingCallback<R> callback) {
        Throwable lastException = null;
        int count = 0;
        while (count == 0 || count < this.maxRetries) {
            try {
                R result = callback.execute();
                if (logger.isDebugEnabled() && count != 0) {
                    logger.debug((Object)("\nRetrying work succeeded: \n   Thread: " + Thread.currentThread().getName() + "\n" + "   Iteration: " + count));
                }
                return result;
            }
            catch (Throwable e) {
                Throwable throwable = lastException = e instanceof RuntimeException ? (RuntimeException)e : new AlfrescoRuntimeException("Exception in Transaction.", e);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\nRetrying work failed: \n   Thread: " + Thread.currentThread().getName() + "\n" + "   Iteration: " + count + "\n" + "   Exception follows:"), e);
                } else if (logger.isInfoEnabled()) {
                    String msg = String.format("Retrying %s: count %2d; wait: %3dms; msg: \"%s\"; exception: (%s)", Thread.currentThread().getName(), count, this.retryWaitMs, e.getMessage(), e.getClass().getName());
                    logger.info((Object)msg);
                }
                try {
                    Thread.sleep(this.retryWaitMs);
                }
                catch (InterruptedException interruptedException) {}
                ++count;
            }
        }
        throw lastException;
    }

    public static interface RetryingCallback<Result> {
        public Result execute() throws Throwable;
    }
}

