/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.heartbeat.jobs;

import org.alfresco.heartbeat.HBBaseDataCollector;
import org.alfresco.heartbeat.datasender.HBDataSenderService;
import org.alfresco.heartbeat.jobs.HeartBeatJobScheduler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public abstract class QuartzJobScheduler
implements HeartBeatJobScheduler {
    private static final Log logger = LogFactory.getLog(QuartzJobScheduler.class);
    protected boolean testMode = false;
    protected final String testCronExpression = "0 0/1 * * * ?";
    protected HBDataSenderService hbDataSenderService;
    protected Scheduler scheduler;

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setHbDataSenderService(HBDataSenderService hbDataSenderService) {
        this.hbDataSenderService = hbDataSenderService;
    }

    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }

    public String getJobName(String collectorId) {
        return "heartbeat-" + collectorId;
    }

    public String getTriggerName(String collectorId) {
        return String.valueOf(this.getJobName(collectorId)) + "-Trigger";
    }

    protected abstract JobDataMap getJobDetailMap(HBBaseDataCollector var1);

    protected abstract Class<? extends Job> getHeartBeatJobClass();

    @Override
    public void scheduleJob(HBBaseDataCollector collector) {
        JobDetail jobDetail = JobBuilder.newJob().withIdentity(this.getJobName(collector.getCollectorId())).usingJobData(this.getJobDetailMap(collector)).ofType(this.getHeartBeatJobClass()).build();
        String cronExpression = this.testMode ? "0 0/1 * * * ?" : collector.getCronExpression();
        CronTrigger cronTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(this.getTriggerName(collector.getCollectorId())).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).build();
        try {
            this.scheduler.unscheduleJob(cronTrigger.getKey());
            this.scheduler.scheduleJob(jobDetail, (Trigger)cronTrigger);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("HeartBeat job scheduled for collector: " + collector.getCollectorId()));
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException("Heartbeat failed to schedule job for collector: " + collector.getCollectorId(), e);
        }
    }

    @Override
    public void unscheduleJob(HBBaseDataCollector collector) {
        try {
            this.scheduler.unscheduleJob(new TriggerKey(this.getTriggerName(collector.getCollectorId())));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("HeartBeat unscheduled job for collector: " + collector.getCollectorId()));
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException("Heartbeat failed to unschedule job for collector: " + collector.getCollectorId(), e);
        }
    }
}

