/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.repo.virtual.ref.ClasspathResource;
import org.alfresco.repo.virtual.ref.Encodings;
import org.alfresco.repo.virtual.ref.NodeProtocol;
import org.alfresco.repo.virtual.ref.Protocol;
import org.alfresco.repo.virtual.ref.ProtocolMethod;
import org.alfresco.repo.virtual.ref.ProtocolMethodException;
import org.alfresco.repo.virtual.ref.Protocols;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.RepositoryLocation;
import org.alfresco.repo.virtual.ref.RepositoryNodeRef;
import org.alfresco.repo.virtual.ref.RepositoryPath;
import org.alfresco.repo.virtual.ref.RepositoryResource;
import org.alfresco.repo.virtual.ref.Resource;
import org.alfresco.repo.virtual.ref.ResourceParameter;
import org.alfresco.repo.virtual.ref.StringParameter;
import org.alfresco.repo.virtual.ref.ValueParameter;
import org.alfresco.repo.virtual.ref.VanillaProtocol;
import org.alfresco.repo.virtual.ref.VirtualProtocol;
import org.alfresco.service.cmr.repository.NodeRef;
import org.junit.Test;

public class VirtualProtocolTest
extends TestCase {
    private static final String TEST_ACTUAL_NODE_REF_1 = "workspace://SpacesStore/0001-0002-0003-0004";
    private static final String TEST_TEAMPLATE_CP_1 = "/org/alfresco/repo/test.js";
    private ClasspathResource template1;
    private RepositoryResource actual1;
    private StringParameter templatePath1;
    private List<ValueParameter<? extends Object>> parameters1;
    private Reference r1;
    private VirtualProtocol virtualProtocol;

    protected void setUp() throws Exception {
        this.templatePath1 = new StringParameter("/root/child");
        this.template1 = new ClasspathResource(TEST_TEAMPLATE_CP_1);
        this.actual1 = new RepositoryResource((RepositoryLocation)new RepositoryNodeRef(new NodeRef(TEST_ACTUAL_NODE_REF_1)));
        this.parameters1 = Arrays.asList(this.templatePath1, new ResourceParameter((Resource)this.actual1));
        this.r1 = new Reference(Encodings.PLAIN.encoding, Protocols.VIRTUAL.protocol, (Resource)this.template1, this.parameters1);
        this.virtualProtocol = new VirtualProtocol();
    }

    @Test
    public void testGetTemplatePath() throws Exception {
        String tp = this.virtualProtocol.getTemplatePath(this.r1);
        VirtualProtocolTest.assertEquals((String)((String)this.templatePath1.getValue()), (String)tp);
    }

    @Test
    public void testGetActualNodeLocation() throws Exception {
        RepositoryLocation al = this.virtualProtocol.getActualNodeLocation(this.r1);
        VirtualProtocolTest.assertEquals((Object)this.actual1.getLocation(), (Object)al);
    }

    @Test
    public void testReplaceTemplatePath() throws Exception {
        Reference r = this.virtualProtocol.replaceTemplatePath(this.r1, "/root/child/anotherChild");
        String templatePath = this.virtualProtocol.getTemplatePath(r);
        VirtualProtocolTest.assertEquals((String)"/root/child/anotherChild", (String)templatePath);
    }

    @Test
    public void testNewReference() throws Exception {
        Reference nr1 = this.virtualProtocol.newReference(VirtualProtocol.NODE_TEMPLATE_PATH_TOKEN + "/a/repo/path", "/root/child", new NodeRef(TEST_ACTUAL_NODE_REF_1));
        RepositoryResource repoResource = new RepositoryResource((RepositoryLocation)new RepositoryPath("/a/repo/path"));
        VirtualProtocolTest.assertEquals((Object)repoResource, (Object)nr1.getResource());
        Reference nr2 = this.virtualProtocol.newReference(VirtualProtocol.CLASS_TEMPLATE_PATH_TOKEN + "/a/class/path", "/root/child", new NodeRef(TEST_ACTUAL_NODE_REF_1));
        ClasspathResource classpathResource = new ClasspathResource("/a/class/path");
        VirtualProtocolTest.assertEquals((Object)classpathResource, (Object)nr2.getResource());
    }

    @Test
    public void testDispatch() throws Exception {
        boolean sccess = (Boolean)this.virtualProtocol.dispatch((ProtocolMethod)new ProtocolMethod<Boolean>(){

            public Boolean execute(VanillaProtocol vanillaProtocol, Reference reference) throws ProtocolMethodException {
                VirtualProtocolTest.fail((String)"Invalid dispatch");
                return false;
            }

            public Boolean execute(VirtualProtocol virtualProtocol, Reference reference) throws ProtocolMethodException {
                return true;
            }

            public Boolean execute(NodeProtocol protocol, Reference reference) throws ProtocolMethodException {
                VirtualProtocolTest.fail((String)"Invalid dispatch");
                return false;
            }

            public Boolean execute(Protocol protocol, Reference reference) throws ProtocolMethodException {
                VirtualProtocolTest.fail((String)"Invalid dispatch");
                return false;
            }
        }, this.r1);
        VirtualProtocolTest.assertTrue((boolean)sccess);
    }
}

