/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.site;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.alfresco.model.ContentModel;
import org.alfresco.query.AbstractCannedQuery;
import org.alfresco.query.CannedQueryParameters;
import org.alfresco.query.CannedQuerySortDetails;
import org.alfresco.repo.site.SiteMembersCannedQueryParams;
import org.alfresco.repo.site.SiteMembership;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.util.Pair;

public class SiteMembersCannedQuery
extends AbstractCannedQuery<SiteMembership> {
    private NodeService nodeService;
    private PersonService personService;
    private SiteService siteService;

    protected SiteMembersCannedQuery(SiteService siteService, PersonService personService, NodeService nodeService, CannedQueryParameters parameters) {
        super(parameters);
        this.personService = personService;
        this.nodeService = nodeService;
        this.siteService = siteService;
    }

    protected List<SiteMembership> queryAndFilter(CannedQueryParameters parameters) {
        SiteMembersCannedQueryParams paramBean = (SiteMembersCannedQueryParams)parameters.getParameterBean();
        String siteShortName = paramBean.getShortName();
        CannedQuerySortDetails sortDetails = parameters.getSortDetails();
        List sortPairs = sortDetails.getSortPairs();
        CQSiteMembersCallback callback = new CQSiteMembersCallback(siteShortName, sortPairs);
        this.siteService.listMembers(siteShortName, null, null, true, false, paramBean.isExpandGroups(), callback);
        callback.done();
        return callback.getSiteMembers();
    }

    protected boolean isApplyPostQuerySorting() {
        return false;
    }

    private class CQSiteMembersCallback
    implements SiteService.SiteMembersCallback {
        private SiteInfo siteInfo;
        private Set<SiteMembership> siteMembers;

        CQSiteMembersCallback(String siteShortName, List<Pair<? extends Object, CannedQuerySortDetails.SortOrder>> sortPairs) {
            this.siteInfo = SiteMembersCannedQuery.this.siteService.getSite(siteShortName);
            this.siteMembers = sortPairs != null && sortPairs.size() > 0 ? new TreeSet<SiteMembership>(SiteMembership.getComparator(sortPairs)) : new HashSet<SiteMembership>();
        }

        @Override
        public void siteMember(String authority, String permission) {
        }

        @Override
        public void siteMember(String authority, String permission, boolean isMemberOfGroup) {
            String firstName = null;
            String lastName = null;
            if (SiteMembersCannedQuery.this.personService.personExists(authority)) {
                NodeRef nodeRef = SiteMembersCannedQuery.this.personService.getPerson(authority);
                firstName = (String)((Object)SiteMembersCannedQuery.this.nodeService.getProperty(nodeRef, ContentModel.PROP_FIRSTNAME));
                lastName = (String)((Object)SiteMembersCannedQuery.this.nodeService.getProperty(nodeRef, ContentModel.PROP_LASTNAME));
            }
            this.siteMembers.add(new SiteMembership(this.siteInfo, authority, firstName, lastName, permission, isMemberOfGroup));
        }

        @Override
        public boolean isDone() {
            return false;
        }

        List<SiteMembership> getSiteMembers() {
            return new ArrayList<SiteMembership>(this.siteMembers);
        }

        void done() {
        }
    }
}

