/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authority;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authority.AuthorityDAO;
import org.alfresco.repo.security.authority.AuthorityException;
import org.alfresco.repo.security.authority.AuthorityInfo;
import org.alfresco.repo.security.authority.AuthorityServicePolicies;
import org.alfresco.repo.security.permissions.PermissionServiceSPI;
import org.alfresco.repo.security.person.UserNameMatcher;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.extensions.surf.util.ParameterCheck;

public class AuthorityServiceImpl
implements AuthorityService,
InitializingBean {
    public static final String GROUP_ALFRESCO_SYSTEM_ADMINISTRATORS_AUTHORITY = "GROUP_ALFRESCO_SYSTEM_ADMINISTRATORS";
    private static Set<String> DEFAULT_ZONES = new HashSet<String>();
    private PersonService personService;
    private TenantService tenantService;
    private AuthorityDAO authorityDAO;
    private UserNameMatcher userNameMatcher;
    private AuthenticationService authenticationService;
    private PermissionServiceSPI permissionServiceSPI;
    private Set<String> adminSet = Collections.singleton("ROLE_ADMINISTRATOR");
    private Set<String> guestSet = Collections.singleton("ROLE_GUEST");
    private Set<String> allSet = Collections.singleton("GROUP_EVERYONE");
    private Set<String> adminGroups = Collections.emptySet();
    private Set<String> guestGroups = Collections.emptySet();
    private ClassPolicyDelegate<AuthorityServicePolicies.OnAuthorityAddedToGroup> onAuthorityAddedToGroups;
    private ClassPolicyDelegate<AuthorityServicePolicies.OnAuthorityRemovedFromGroup> onAuthorityRemovedFromGroup;
    private ClassPolicyDelegate<AuthorityServicePolicies.OnGroupDeleted> onGroupDeletedDelegate;
    private PolicyComponent policyComponent;

    static {
        DEFAULT_ZONES.add("APP.DEFAULT");
        DEFAULT_ZONES.add("AUTH.ALF");
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setAuthorityDAO(AuthorityDAO authorityDAO) {
        this.authorityDAO = authorityDAO;
    }

    public void setUserNameMatcher(UserNameMatcher userNameMatcher) {
        this.userNameMatcher = userNameMatcher;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setPermissionServiceSPI(PermissionServiceSPI permissionServiceSPI) {
        this.permissionServiceSPI = permissionServiceSPI;
    }

    public void setAdminGroups(Set<String> adminGroups) {
        this.adminGroups = adminGroups;
    }

    public void setGuestGroups(Set<String> guestGroups) {
        this.guestGroups = guestGroups;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void init() {
        this.onAuthorityAddedToGroups = this.policyComponent.registerClassPolicy(AuthorityServicePolicies.OnAuthorityAddedToGroup.class);
        this.onAuthorityRemovedFromGroup = this.policyComponent.registerClassPolicy(AuthorityServicePolicies.OnAuthorityRemovedFromGroup.class);
        this.onGroupDeletedDelegate = this.policyComponent.registerClassPolicy(AuthorityServicePolicies.OnGroupDeleted.class);
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.adminGroups.isEmpty()) {
            HashSet<String> adminGroups = new HashSet<String>(this.adminGroups.size());
            for (String group : this.adminGroups) {
                adminGroups.add(this.getName(AuthorityType.GROUP, group));
            }
            this.adminGroups = adminGroups;
        }
        if (!this.guestGroups.isEmpty()) {
            HashSet<String> guestGroups = new HashSet<String>(this.guestGroups.size());
            for (String group : this.guestGroups) {
                guestGroups.add(this.getName(AuthorityType.GROUP, group));
            }
            this.guestGroups = guestGroups;
        }
    }

    @Override
    public boolean hasAdminAuthority() {
        String currentUserName = AuthenticationUtil.getRunAsUser();
        return currentUserName != null && this.getAuthoritiesForUser(currentUserName).contains("ROLE_ADMINISTRATOR");
    }

    @Override
    public boolean isAdminAuthority(String authorityName) {
        String canonicalName = this.personService.getUserIdentifier(authorityName);
        if (canonicalName == null) {
            canonicalName = authorityName;
        }
        return this.getAuthoritiesForUser(canonicalName).contains("ROLE_ADMINISTRATOR");
    }

    @Override
    public boolean hasGuestAuthority() {
        String currentUserName = AuthenticationUtil.getRunAsUser();
        return currentUserName != null && this.getAuthoritiesForUser(currentUserName).contains("ROLE_GUEST");
    }

    @Override
    public boolean isGuestAuthority(String authorityName) {
        String canonicalName = this.personService.getUserIdentifier(authorityName);
        if (canonicalName == null) {
            canonicalName = authorityName;
        }
        return this.getAuthoritiesForUser(canonicalName).contains("ROLE_GUEST");
    }

    private boolean hasAuthority(String authority, String parentAuthority, Set<String> positiveHits, Set<String> negativeHits) {
        if (AuthorityType.getAuthorityType((String)parentAuthority) == AuthorityType.USER) {
            return false;
        }
        if (parentAuthority.equals(authority)) {
            return true;
        }
        return this.authorityDAO.isAuthorityContained(parentAuthority, authority, positiveHits, negativeHits);
    }

    @Override
    public long countUsers() {
        long usersCount = this.authorityDAO.getPersonCount();
        return usersCount > 0L ? usersCount : 0L;
    }

    @Override
    public long countGroups() {
        long groupsCount = this.authorityDAO.getGroupCount();
        return groupsCount;
    }

    @Override
    public Set<String> getAuthorities() {
        String currentUserName = AuthenticationUtil.getRunAsUser();
        return this.getAuthoritiesForUser(currentUserName);
    }

    @Override
    public Set<String> getAuthoritiesForUser(String currentUserName) {
        return new UserAuthoritySet(currentUserName);
    }

    private Set<String> getRoleAuthorities(String currentUserName, Set<String> positiveHits, Set<String> negativeHits) {
        TreeSet<String> authorities = new TreeSet<String>();
        Set<String> adminUsers = this.authenticationService.getDefaultAdministratorUserNames();
        Set<String> guestUsers = this.authenticationService.getDefaultGuestUserNames();
        String defaultGuestName = AuthenticationUtil.getGuestUserName();
        if (defaultGuestName != null && defaultGuestName.length() > 0) {
            guestUsers.add(defaultGuestName);
        }
        boolean isAdminUser = this.containsMatch(adminUsers, currentUserName);
        boolean isGuestUser = this.containsMatch(guestUsers, currentUserName);
        if (!isAdminUser) {
            for (String authority : this.adminGroups) {
                if (!this.hasAuthority(currentUserName, authority, positiveHits, negativeHits) && !this.hasAuthority(currentUserName, this.tenantService.getBaseNameUser(authority), positiveHits, negativeHits)) continue;
                isAdminUser = true;
                break;
            }
        }
        if (!isAdminUser && !isGuestUser && this.tenantService.getBaseNameUser(currentUserName).equalsIgnoreCase(AuthenticationUtil.getGuestUserName())) {
            isGuestUser = true;
        }
        if (!isAdminUser && !isGuestUser && this.guestGroups.size() != 0) {
            for (String authority : this.guestGroups) {
                if (!this.hasAuthority(currentUserName, authority, positiveHits, negativeHits) && !this.hasAuthority(currentUserName, this.tenantService.getBaseNameUser(authority), positiveHits, negativeHits)) continue;
                isGuestUser = true;
                break;
            }
        }
        if (isAdminUser) {
            authorities.addAll(this.adminSet);
            positiveHits.addAll(this.adminSet);
        }
        if (!isGuestUser) {
            authorities.addAll(this.allSet);
            positiveHits.addAll(this.allSet);
        } else {
            authorities.addAll(this.guestSet);
            positiveHits.addAll(this.guestSet);
        }
        return authorities;
    }

    @Override
    public Set<String> getAllAuthorities(AuthorityType type) {
        List auths = this.getAuthorities(type, null, null, false, false, new PagingRequest(0, Integer.MAX_VALUE, null)).getPage();
        HashSet<String> authorities = new HashSet<String>(auths.size());
        authorities.addAll(auths);
        return authorities;
    }

    @Override
    public PagingResults<AuthorityInfo> getAuthoritiesInfo(AuthorityType type, String zoneName, String displayNameFilter, String sortBy, boolean sortAscending, PagingRequest pagingRequest) {
        ParameterCheck.mandatory((String)"pagingRequest", (Object)pagingRequest);
        ParameterCheck.mandatory((String)"type", (Object)type);
        if (type != AuthorityType.USER && type != AuthorityType.GROUP && type != AuthorityType.ROLE) {
            throw new UnsupportedOperationException("Unexpected authority type: " + type);
        }
        return this.authorityDAO.getAuthoritiesInfo(type, zoneName, displayNameFilter, sortBy, sortAscending, pagingRequest);
    }

    @Override
    public PagingResults<String> getAuthorities(AuthorityType type, String zoneName, String displayNameFilter, boolean sortByDisplayName, boolean sortAscending, PagingRequest pagingRequest) {
        ParameterCheck.mandatory((String)"pagingRequest", (Object)pagingRequest);
        if (type == null && zoneName == null) {
            throw new IllegalArgumentException("Type and/or zoneName required - both cannot be null");
        }
        if (type != null) {
            switch (type) {
                case GROUP: 
                case ROLE: 
                case USER: {
                    return this.authorityDAO.getAuthorities(type, zoneName, displayNameFilter, sortByDisplayName, sortAscending, pagingRequest);
                }
            }
            return this.getOtherAuthorities(type);
        }
        return this.authorityDAO.getAuthorities(type, zoneName, displayNameFilter, sortByDisplayName, sortAscending, pagingRequest);
    }

    private PagingResults<String> getOtherAuthorities(AuthorityType type) {
        final ArrayList<String> auths = new ArrayList<String>();
        switch (type) {
            case GROUP: 
            case ROLE: 
            case USER: {
                throw new UnsupportedOperationException("Unexpected authority type: " + type);
            }
            case ADMIN: {
                auths.addAll(this.adminSet);
                break;
            }
            case EVERYONE: {
                auths.addAll(this.allSet);
                break;
            }
            case GUEST: {
                auths.addAll(this.guestSet);
                break;
            }
            case OWNER: {
                break;
            }
        }
        return new PagingResults<String>(){

            public String getQueryExecutionId() {
                return null;
            }

            public List<String> getPage() {
                return auths;
            }

            public boolean hasMoreItems() {
                return false;
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                return new Pair((Object)auths.size(), (Object)auths.size());
            }
        };
    }

    @Override
    public void addAuthority(String parentName, String childName) {
        this.addAuthority(Collections.singleton(parentName), childName);
    }

    @Override
    public void addAuthority(Collection<String> parentNames, String childName) {
        this.authorityDAO.addAuthority(parentNames, childName);
        AuthorityServicePolicies.OnAuthorityAddedToGroup policy = this.onAuthorityAddedToGroups.get(ContentModel.TYPE_AUTHORITY);
        for (String parentGroup : parentNames) {
            policy.onAuthorityAddedToGroup(parentGroup, childName);
        }
    }

    private boolean containsMatch(Set<String> names, String name) {
        String baseName = this.tenantService.getBaseNameUser(name);
        if (this.tenantService.isEnabled()) {
            for (String candidate : names) {
                if (!this.userNameMatcher.matches(candidate, name) && !this.userNameMatcher.matches(this.tenantService.getBaseNameUser(candidate), baseName)) continue;
                return true;
            }
        } else {
            for (String candidate : names) {
                if (!this.userNameMatcher.matches(candidate, name) && !this.userNameMatcher.matches(candidate, baseName)) continue;
                return true;
            }
        }
        return false;
    }

    private void checkTypeIsMutable(AuthorityType type) {
        if (type == AuthorityType.GROUP || type == AuthorityType.ROLE) {
            return;
        }
        throw new AuthorityException("Trying to modify a fixed authority");
    }

    @Override
    public String createAuthority(AuthorityType type, String shortName) {
        return this.createAuthority(type, shortName, shortName, this.getDefaultZones());
    }

    @Override
    public String createAuthority(AuthorityType type, String shortName, Map<QName, Serializable> properties) {
        return this.createAuthority(type, shortName, shortName, this.getDefaultZones(), properties);
    }

    @Override
    public void deleteAuthority(String name) {
        this.deleteAuthority(name, false);
    }

    @Override
    public void deleteAuthority(String name, boolean cascade) {
        AuthorityType type = AuthorityType.getAuthorityType((String)name);
        this.checkTypeIsMutable(type);
        if (cascade) {
            for (String child : this.getContainedAuthorities(type, name, true)) {
                this.deleteAuthority(child, true);
            }
        }
        this.authorityDAO.deleteAuthority(name);
        this.permissionServiceSPI.deletePermissions(name);
        if (this.isGroup(type)) {
            AuthorityServicePolicies.OnGroupDeleted onGroupDelete = this.onGroupDeletedDelegate.get(ContentModel.TYPE_AUTHORITY);
            onGroupDelete.onGroupDeleted(name, cascade);
        }
    }

    private boolean isGroup(AuthorityType authorityType) {
        return AuthorityType.GROUP == authorityType || AuthorityType.EVERYONE == authorityType;
    }

    @Override
    public Set<String> getAllRootAuthorities(AuthorityType type) {
        return this.getAllRootAuthoritiesInZone(null, type);
    }

    @Override
    public Set<String> getContainedAuthorities(AuthorityType type, String name, boolean immediate) {
        return this.authorityDAO.getContainedAuthorities(type, name, immediate);
    }

    @Override
    public Set<String> getContainingAuthorities(AuthorityType type, String name, boolean immediate) {
        return this.authorityDAO.getContainingAuthorities(type, name, immediate);
    }

    @Override
    public NodeRef getAuthorityNodeRef(String name) {
        return this.authorityDAO.getAuthorityNodeRefOrNull(name);
    }

    @Override
    public Set<String> getContainingAuthoritiesInZone(AuthorityType type, String authority, String zoneName, AuthorityService.AuthorityFilter filter, int size) {
        return this.authorityDAO.getContainingAuthoritiesInZone(type, authority, zoneName, filter, size);
    }

    @Override
    public void removeAuthority(String parentName, String childName) {
        this.authorityDAO.removeAuthority(parentName, childName);
        AuthorityServicePolicies.OnAuthorityRemovedFromGroup policy = this.onAuthorityRemovedFromGroup.get(ContentModel.TYPE_AUTHORITY);
        policy.onAuthorityRemovedFromGroup(parentName, childName);
    }

    @Override
    public boolean authorityExists(String name) {
        return this.authorityDAO.authorityExists(name);
    }

    @Override
    public String createAuthority(AuthorityType type, String shortName, String authorityDisplayName, Set<String> authorityZones) {
        return this.createAuthority(type, shortName, authorityDisplayName, authorityZones, null);
    }

    @Override
    public String createAuthority(AuthorityType type, String shortName, String authorityDisplayName, Set<String> authorityZones, Map<QName, Serializable> properties) {
        this.checkTypeIsMutable(type);
        String name = this.getName(type, shortName);
        this.authorityDAO.createAuthority(name, authorityDisplayName, authorityZones, properties);
        return name;
    }

    @Override
    public String getAuthorityDisplayName(String name) {
        String displayName = this.authorityDAO.getAuthorityDisplayName(name);
        if (displayName == null) {
            displayName = this.getShortName(name);
        }
        return displayName;
    }

    @Override
    public void setAuthorityDisplayName(String authorityName, String authorityDisplayName) {
        AuthorityType type = AuthorityType.getAuthorityType((String)authorityName);
        this.checkTypeIsMutable(type);
        this.authorityDAO.setAuthorityDisplayName(authorityName, authorityDisplayName);
    }

    @Override
    public Pair<String, String> getAuthorityDisplayNameAndDescription(String name) {
        Pair<String, String> displayNameAndDescription = this.authorityDAO.getAuthorityDisplayNameAndDescription(name);
        if (displayNameAndDescription.getFirst() == null) {
            displayNameAndDescription.setFirst((Object)this.getShortName(name));
        }
        return displayNameAndDescription;
    }

    @Override
    public void setAuthorityDisplayNameAndDescription(String authorityName, String authorityDisplayName, String description) {
        AuthorityType type = AuthorityType.getAuthorityType((String)authorityName);
        this.checkTypeIsMutable(type);
        this.authorityDAO.setAuthorityDisplayNameAndDescription(authorityName, authorityDisplayName, description);
    }

    @Override
    public Set<String> getAuthorityZones(String name) {
        return this.authorityDAO.getAuthorityZones(name);
    }

    @Override
    public NodeRef getOrCreateZone(String zoneName) {
        return this.authorityDAO.getOrCreateZone(zoneName);
    }

    @Override
    public NodeRef getZone(String zoneName) {
        return this.authorityDAO.getZone(zoneName);
    }

    @Override
    public Set<String> getAllAuthoritiesInZone(String zoneName, AuthorityType type) {
        return this.authorityDAO.getAllAuthoritiesInZone(zoneName, type);
    }

    @Override
    public void addAuthorityToZones(String authorityName, Set<String> zones) {
        this.authorityDAO.addAuthorityToZones(authorityName, zones);
    }

    @Override
    public void removeAuthorityFromZones(String authorityName, Set<String> zones) {
        this.authorityDAO.removeAuthorityFromZones(authorityName, zones);
    }

    @Override
    public Set<String> getDefaultZones() {
        return DEFAULT_ZONES;
    }

    @Override
    public Set<String> getAllRootAuthoritiesInZone(String zoneName, AuthorityType type) {
        return this.authorityDAO.getRootAuthorities(type, zoneName);
    }

    @Override
    public Set<String> findAuthorities(AuthorityType type, String parentAuthority, boolean immediate, String displayNamePattern, String zoneName) {
        if (type == null || type == AuthorityType.GROUP || type == AuthorityType.USER) {
            return this.authorityDAO.findAuthorities(type, parentAuthority, immediate, displayNamePattern, zoneName);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName(AuthorityType type, String shortName) {
        return this.authorityDAO.getName(type, shortName);
    }

    @Override
    public String getShortName(String name) {
        return this.authorityDAO.getShortName(name);
    }

    @Override
    public boolean hasSysAdminAuthority() {
        String currentUserName = AuthenticationUtil.getRunAsUser();
        if (currentUserName == null) {
            return false;
        }
        return this.getAuthoritiesForUser(currentUserName).contains(GROUP_ALFRESCO_SYSTEM_ADMINISTRATORS_AUTHORITY);
    }

    public final class UserAuthoritySet
    extends AbstractSet<String> {
        private final String username;
        private Set<String> positiveHits;
        private Set<String> negativeHits;
        private boolean allAuthoritiesLoaded;

        public UserAuthoritySet(String username) {
            this.username = username;
            this.positiveHits = new TreeSet<String>();
            this.negativeHits = new TreeSet<String>();
            AuthorityServiceImpl.this.getRoleAuthorities(username, this.positiveHits, this.negativeHits);
        }

        private Set<String> getAllAuthorities() {
            if (!this.allAuthoritiesLoaded) {
                this.allAuthoritiesLoaded = true;
                this.positiveHits.addAll(AuthorityServiceImpl.this.getContainingAuthorities(null, this.username, false));
                this.negativeHits = null;
            }
            return this.positiveHits;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(String e) {
            return this.positiveHits.add(e);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof String)) {
                return false;
            }
            if (this.positiveHits.contains(o)) {
                return true;
            }
            if (this.allAuthoritiesLoaded || this.negativeHits.contains(o)) {
                return false;
            }
            return AuthorityServiceImpl.this.hasAuthority(this.username, (String)o, this.positiveHits, this.negativeHits);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<String> iterator() {
            return this.getAllAuthorities().iterator();
        }

        @Override
        public int size() {
            return this.getAllAuthorities().size();
        }

        public Object getUsername() {
            return this.username;
        }
    }
}

