/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.text.Normalizer;
import org.alfresco.repo.security.authentication.UserNameGenerator;
import org.apache.commons.lang3.RandomStringUtils;

public class NameBasedUserNameGenerator
implements UserNameGenerator {
    private int userNameLength = 10;
    private String namePattern = "%lastName%_%firstName%";

    public void setNamePattern(String userNamePattern) {
        this.namePattern = userNamePattern;
    }

    public void setUserNameLength(int userNameLength) {
        this.userNameLength = userNameLength;
    }

    @Override
    public String generateUserName(String firstName, String lastName, String emailAddress, int seed) {
        String pattern = this.namePattern;
        String initial = firstName.toLowerCase().substring(0, 1);
        String userName = pattern.replace("%i%", initial).replace("%firstName%", this.cleanseName(firstName)).replace("%lastName%", this.cleanseName(lastName)).replace("%emailAddress%", emailAddress.toLowerCase());
        if (seed > 0) {
            userName = userName.length() < this.userNameLength + 3 ? String.valueOf(userName) + RandomStringUtils.randomNumeric((int)3) : String.valueOf(userName.substring(0, this.userNameLength - 3)) + RandomStringUtils.randomNumeric((int)3);
        }
        return userName;
    }

    private String cleanseName(String name) {
        String result = name.trim().toLowerCase().replaceAll("\\s+", "_");
        return Normalizer.normalize(result, Normalizer.Form.NFD).replaceAll("[^a-zA-z0-9_]+", "");
    }
}

