/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr.facet.facetsresponse;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.search.impl.solr.facet.facetsresponse.Metric;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;

public class PercentileMetric
implements Metric {
    private static Log logger = LogFactory.getLog(PercentileMetric.class);
    private final Metric.METRIC_TYPE type;
    private final Map<String, Object> value = new HashMap<String, Object>(1);

    public PercentileMetric(Metric.METRIC_TYPE type, Object val) {
        this.type = type;
        try {
            JSONArray jsonArray = (JSONArray)val;
            HashMap<String, Double> percentiles = new HashMap<String, Double>(jsonArray.length() / 2);
            int i = 0;
            int length = jsonArray.length();
            while (i < length) {
                percentiles.put(jsonArray.getString(i++), jsonArray.getDouble(i));
                ++i;
            }
            this.value.put(type.toString(), percentiles);
        }
        catch (ClassCastException classCastException) {
            logger.debug((Object)("ClassCastException for " + val));
        }
        catch (JSONException e) {
            logger.debug((Object)("Failed to process percentile for " + val + " " + e.getMessage()));
        }
    }

    @Override
    public Metric.METRIC_TYPE getType() {
        return this.type;
    }

    @Override
    public Map<String, Object> getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PercentileMetric that = (PercentileMetric)o;
        if (this.type != that.type) {
            return false;
        }
        return this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }
}

