/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.remotecredentials;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.node.encryption.MetadataEncryptor;
import org.alfresco.repo.remotecredentials.OAuth1CredentialsInfoImpl;
import org.alfresco.repo.remotecredentials.RemoteCredentialsInfoFactory;
import org.alfresco.repo.remotecredentials.RemoteCredentialsModel;
import org.alfresco.service.cmr.remotecredentials.BaseCredentialsInfo;
import org.alfresco.service.cmr.remotecredentials.OAuth1CredentialsInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

public class OAuth1CredentialsFactory
implements RemoteCredentialsInfoFactory {
    private MetadataEncryptor metadataEncryptor;

    public void setMetadataEncryptor(MetadataEncryptor metadataEncryptor) {
        this.metadataEncryptor = metadataEncryptor;
    }

    @Override
    public OAuth1CredentialsInfo createCredentials(QName type, NodeRef nodeRef, String remoteSystemName, NodeRef remoteSystemContainerNodeRef, Map<QName, Serializable> properties) {
        String token = (String)((Object)this.metadataEncryptor.decrypt(RemoteCredentialsModel.PROP_OAUTH1_TOKEN, properties.get(RemoteCredentialsModel.PROP_OAUTH1_TOKEN)));
        String secret = (String)((Object)this.metadataEncryptor.decrypt(RemoteCredentialsModel.PROP_OAUTH1_TOKEN_SECRET, properties.get(RemoteCredentialsModel.PROP_OAUTH1_TOKEN_SECRET)));
        OAuth1CredentialsInfoImpl credentials = new OAuth1CredentialsInfoImpl(nodeRef, remoteSystemName, remoteSystemContainerNodeRef);
        RemoteCredentialsInfoFactory.FactoryHelper.setCoreCredentials(credentials, properties);
        credentials.setOAuthToken(token);
        credentials.setOAuthSecret(secret);
        return credentials;
    }

    @Override
    public Map<QName, Serializable> serializeCredentials(BaseCredentialsInfo info) {
        if (!(info instanceof OAuth1CredentialsInfo)) {
            throw new IllegalStateException("Incorrect registration, info must be a OAuth1CredentialsInfo");
        }
        OAuth1CredentialsInfo credentials = (OAuth1CredentialsInfo)info;
        Serializable tokenEncrypted = this.metadataEncryptor.encrypt(RemoteCredentialsModel.PROP_OAUTH1_TOKEN, (Serializable)((Object)credentials.getOAuthToken()));
        Serializable secretEncrypted = this.metadataEncryptor.encrypt(RemoteCredentialsModel.PROP_OAUTH1_TOKEN_SECRET, (Serializable)((Object)credentials.getOAuthSecret()));
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        properties.put(RemoteCredentialsModel.PROP_OAUTH1_TOKEN, tokenEncrypted);
        properties.put(RemoteCredentialsModel.PROP_OAUTH1_TOKEN_SECRET, secretEncrypted);
        return properties;
    }
}

