/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.importer;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.view.ImportPackageHandler;
import org.alfresco.service.cmr.view.ImporterContentCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultImporterContentCache
implements ImporterContentCache {
    private static final Log logger = LogFactory.getLog(DefaultImporterContentCache.class);
    private ContentService contentService;
    private Map<String, ContentData> contentUrls = new HashMap<String, ContentData>();
    private final ReadWriteLock contentUrlsLock = new ReentrantReadWriteLock();

    public void setContentService(ContentService service) {
        this.contentService = service;
    }

    @Override
    public ContentData getContent(final ImportPackageHandler handler, final ContentData sourceContentData) {
        String sourceContentUrl;
        ContentData cachedContentData;
        block8: {
            cachedContentData = null;
            sourceContentUrl = sourceContentData.getContentUrl();
            this.contentUrlsLock.readLock().lock();
            try {
                cachedContentData = this.contentUrls.get(sourceContentUrl);
                if (cachedContentData != null) break block8;
                this.contentUrlsLock.readLock().unlock();
                this.contentUrlsLock.writeLock().lock();
                try {
                    cachedContentData = this.contentUrls.get(sourceContentUrl);
                    if (cachedContentData == null) {
                        cachedContentData = (ContentData)TenantUtil.runAsTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<ContentData>(){

                            public ContentData doWork() throws Exception {
                                InputStream contentStream = handler.importStream(sourceContentUrl);
                                ContentWriter writer = DefaultImporterContentCache.this.contentService.getWriter(null, null, false);
                                writer.setEncoding(sourceContentData.getEncoding());
                                writer.setMimetype(sourceContentData.getMimetype());
                                writer.putContent(contentStream);
                                return writer.getContentData();
                            }
                        }, (String)"");
                        this.contentUrls.put(sourceContentUrl, cachedContentData);
                    }
                }
                finally {
                    this.contentUrlsLock.readLock().lock();
                    this.contentUrlsLock.writeLock().unlock();
                }
            }
            finally {
                this.contentUrlsLock.readLock().unlock();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Mapped contentUrl " + sourceContentUrl + " to " + cachedContentData));
        }
        return cachedContentData;
    }
}

