/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.registry;

import java.io.Serializable;
import java.util.Arrays;

public class RegistryKey
implements Serializable {
    private static final long serialVersionUID = 1137822242292626854L;
    static final String REGISTRY_1_0_URI = "http://www.alfresco.org/system/registry/1.0";
    private String namespaceUri;
    private String[] path;
    private String property;

    private static String buildPathString(String ... elements) {
        if (elements.length == 0) {
            return "/";
        }
        StringBuilder sb = new StringBuilder();
        String[] stringArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (element == null || element.length() == 0) {
                throw new IllegalArgumentException("Key elements may not be empty or null");
            }
            sb.append("/").append(element);
            ++n2;
        }
        return sb.toString();
    }

    public RegistryKey(String namespaceUri, String ... key) {
        if (namespaceUri == null) {
            namespaceUri = REGISTRY_1_0_URI;
        }
        this.namespaceUri = namespaceUri;
        int length = key.length;
        if (length == 0) {
            throw new IllegalArgumentException("No value supplied for the RegistryKey property");
        }
        this.property = key[length - 1];
        this.path = new String[length - 1];
        System.arraycopy(key, 0, this.path, 0, length - 1);
    }

    public RegistryKey(String namespaceUri, String[] path, String property) {
        if (namespaceUri == null) {
            namespaceUri = REGISTRY_1_0_URI;
        }
        this.namespaceUri = namespaceUri;
        if ((path == null || path.length == 0) && property == null) {
            throw new IllegalArgumentException("No path or property supplied for the RegistryKey");
        }
        this.property = property;
        this.path = path;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("RegistryKey").append("[ ").append(RegistryKey.buildPathString(this.path)).append("/").append(this.property).append(" ]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegistryKey other = (RegistryKey)obj;
        if (this.namespaceUri == null ? other.namespaceUri != null : !this.namespaceUri.equals(other.namespaceUri)) {
            return false;
        }
        if (!Arrays.equals(this.path, other.path)) {
            return false;
        }
        return !(this.property == null ? other.property != null : !this.property.equals(other.property));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.namespaceUri == null ? 0 : this.namespaceUri.hashCode());
        result = 31 * result + Arrays.hashCode(this.path);
        result = 31 * result + (this.property == null ? 0 : this.property.hashCode());
        return result;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String[] getPath() {
        return this.path;
    }

    public String getProperty() {
        return this.property;
    }
}

