/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.forms.Form;
import org.alfresco.repo.forms.FormData;
import org.alfresco.repo.forms.FormException;
import org.alfresco.repo.forms.Item;
import org.alfresco.repo.forms.processor.node.TypeFormProcessor;
import org.alfresco.repo.model.Repository;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.InvalidQNameException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TypeAndAspectsFormProcessor
extends TypeFormProcessor {
    private static Log logger = LogFactory.getLog(TypeAndAspectsFormProcessor.class);
    private Item typeItem = null;
    private List<String> aspectsItems = new ArrayList<String>();
    private MimetypeService mimetypeService;
    private Repository repository;
    private static final String PHYSICAL_STRUCTURE = "physical_structure";

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public Form generate(Item item, List<String> fields, List<String> forcedFields, Map<String, Object> context) {
        this.parseItems(item);
        return super.generate(this.typeItem, fields, forcedFields, context);
    }

    public Object persist(Item item, FormData data) {
        this.parseItems(item);
        return super.persist(this.typeItem, data);
    }

    protected Log getLogger() {
        return logger;
    }

    protected Set<QName> getAspectNames(TypeDefinition item) {
        HashSet<QName> requestedAspects = new HashSet<QName>();
        requestedAspects.addAll(super.getAspectNames((Object)item));
        requestedAspects.addAll(this.getRequestedAspects());
        return requestedAspects;
    }

    private Set<QName> getRequestedAspects() {
        HashSet<QName> requestedAspects = new HashSet<QName>();
        for (String aspectItem : this.aspectsItems) {
            QName aspectQname = this.getAspectQname(aspectItem);
            requestedAspects.add(aspectQname);
        }
        return requestedAspects;
    }

    private List<String> parseIds(String id) {
        String[] ids = id.split(",");
        ArrayList<String> parsedIds = new ArrayList<String>(Arrays.asList(ids));
        return parsedIds;
    }

    private void parseItems(Item item) {
        this.typeItem = null;
        this.aspectsItems = new ArrayList<String>();
        String id = item.getId();
        List<String> parsedIds = this.parseIds(id);
        this.typeItem = new Item("type", parsedIds.get(0));
        Iterator<String> iterator = parsedIds.iterator();
        iterator.next();
        while (iterator.hasNext()) {
            String nextAspect = iterator.next();
            this.aspectsItems.add(nextAspect);
        }
    }

    private QName getAspectQname(String aspectName) {
        AspectDefinition aspectDef = null;
        QName aspect = null;
        try {
            aspect = aspectName.startsWith("{") ? QName.createQName((String)aspectName) : QName.createQName((String)aspectName, (NamespacePrefixResolver)this.namespaceService);
            aspectDef = this.dictionaryService.getAspect(aspect);
            if (aspectDef == null) {
                throw new FormException(aspectName, (Throwable)new IllegalArgumentException("Aspect does not exist: " + aspectName));
            }
        }
        catch (InvalidQNameException iqne) {
            throw new FormException(aspectName, (Throwable)iqne);
        }
        return aspect;
    }

    protected void persistNode(NodeRef nodeRef, FormData data) {
        super.persistNode(nodeRef, data);
        QName type = this.nodeService.getType(nodeRef);
        Set<QName> aspectNames = this.getAspectNames(this.getTypedItem(this.typeItem));
        TypeDefinition typeDef = this.dictionaryService.getAnonymousType(type, aspectNames);
        Map propDefs = typeDef.getProperties();
        HashMap propsToPersist = new HashMap();
        for (FormData.FieldData fieldData : data) {
            String fieldName = fieldData.getName();
            if (!fieldName.startsWith("prop_")) continue;
            this.processPropertyPersist(nodeRef, propDefs, fieldData, propsToPersist, data);
        }
        this.nodeService.addProperties(nodeRef, propsToPersist);
    }

    protected void processContentPropertyPersist(NodeRef nodeRef, FormData.FieldData fieldData, Map<QName, Serializable> propsToPersist, FormData data) {
        if (fieldData.isFile()) {
            ContentWriter writer = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
            ContentData contentData = null;
            if (writer != null) {
                boolean defaultMimetypeRequired = this.nodeService.getProperty(nodeRef, ContentModel.PROP_CONTENT) == null;
                InputStream inputStream = fieldData.getInputStream();
                writer.putContent(inputStream);
                if (defaultMimetypeRequired) {
                    contentData = (ContentData)propsToPersist.get(ContentModel.PROP_CONTENT);
                    if (contentData != null) {
                        String mimetype = contentData.getMimetype();
                        if (mimetype == null) {
                            contentData = ContentData.setMimetype((ContentData)contentData, (String)this.determineDefaultMimetype(data));
                        }
                    } else {
                        contentData = (ContentData)this.nodeService.getProperty(nodeRef, ContentModel.PROP_CONTENT);
                        if (contentData != null) {
                            String fileName = (String)fieldData.getValue();
                            contentData = ContentData.setMimetype((ContentData)contentData, (String)this.mimetypeService.getMimetype(fileName.substring(fileName.lastIndexOf(".") + 1)));
                        }
                    }
                } else {
                    contentData = (ContentData)this.nodeService.getProperty(nodeRef, ContentModel.PROP_CONTENT);
                    if (contentData != null && propsToPersist.containsKey(ContentModel.PROP_CONTENT)) {
                        ContentData mimetypeEncoding = (ContentData)propsToPersist.get(ContentModel.PROP_CONTENT);
                        contentData = ContentData.setMimetype((ContentData)contentData, (String)mimetypeEncoding.getMimetype());
                        contentData = ContentData.setEncoding((ContentData)contentData, (String)mimetypeEncoding.getEncoding());
                    }
                }
                if (contentData != null) {
                    propsToPersist.put(ContentModel.PROP_CONTENT, (Serializable)contentData);
                }
            }
        } else {
            super.processContentPropertyPersist(nodeRef, fieldData, propsToPersist, data);
        }
    }

    protected NodeRef createNode(TypeDefinition typeDef, FormData data) {
        NodeRef nodeRef = null;
        if (data != null) {
            NodeRef parentRef = null;
            FormData.FieldData destination = data.getFieldData("alf_destination");
            if (destination == null) {
                throw new FormException("Failed to persist form for '" + typeDef.getName().toPrefixString((NamespacePrefixResolver)this.namespaceService) + "' as '" + "alf_destination" + "' data was not provided.");
            }
            String destinationValue = (String)destination.getValue();
            parentRef = this.getParentNodeRef(destinationValue);
            if (parentRef == null) {
                throw new FormException("Failed to persist form for '" + typeDef.getName().toPrefixString((NamespacePrefixResolver)this.namespaceService) + "' as '" + destinationValue + "' does not exist as path or NodeRef in the system.");
            }
            data.removeFieldData("alf_destination");
            String nodeName = null;
            FormData.FieldData nameData = data.getFieldData("prop_cm_name");
            if (nameData != null) {
                nodeName = (String)nameData.getValue();
                data.removeFieldData("prop_cm_name");
            }
            if (nodeName == null || nodeName.length() == 0) {
                nodeName = GUID.generate();
            }
            HashMap<QName, String> nodeProps = new HashMap<QName, String>(1);
            nodeProps.put(ContentModel.PROP_NAME, nodeName);
            nodeRef = this.nodeService.createNode(parentRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)nodeName)), typeDef.getName(), nodeProps).getChildRef();
            for (QName qname : this.getRequestedAspects()) {
                this.nodeService.addAspect(nodeRef, qname, new HashMap());
            }
            FormData.FieldData physicalStructure = data.getFieldData(PHYSICAL_STRUCTURE);
            if (physicalStructure != null) {
                List folderPhysicalStructure = (List)physicalStructure.getValue();
                this.createPhysicalStructure(nodeRef, folderPhysicalStructure);
                data.removeFieldData(PHYSICAL_STRUCTURE);
            }
        }
        return nodeRef;
    }

    private void createPhysicalStructure(NodeRef nodeRef, List<String> folderNames) {
        for (String folderName : folderNames) {
            HashMap<QName, String> nodeProps = new HashMap<QName, String>(1);
            nodeProps.put(ContentModel.PROP_NAME, folderName);
            this.nodeService.createNode(nodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)folderName)), ContentModel.TYPE_FOLDER, nodeProps);
        }
    }

    private NodeRef getParentNodeRef(String destination) {
        NodeRef parentRef = null;
        if (destination.contains("://")) {
            String node = destination.replace("://", "/");
            parentRef = this.repository.findNodeRef("node", node.split("/"));
        } else {
            String path = "workspace/SpacesStore/Company Home/" + destination;
            parentRef = this.repository.findNodeRef("path", path.split("/"));
        }
        return parentRef;
    }
}

