/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.permissions;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.alfresco.repo.domain.permissions.AclChangeSet;
import org.alfresco.repo.domain.permissions.AclCrudDAO;
import org.alfresco.repo.domain.permissions.Authority;
import org.alfresco.repo.domain.permissions.Permission;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.impl.SimplePermissionReference;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.testing.category.DBTests;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class, DBTests.class})
public class AclCrudDAOTest
extends TestCase {
    private ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private RetryingTransactionHelper txnHelper;
    private AclCrudDAO aclCrudDAO;

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.txnHelper = this.transactionService.getRetryingTransactionHelper();
        this.aclCrudDAO = (AclCrudDAO)this.ctx.getBean("aclCrudDAO");
    }

    private long createAclChangeSet() throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Long> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            public Long execute() throws Throwable {
                return AclCrudDAOTest.this.aclCrudDAO.createAclChangeSet();
            }
        };
        return (Long)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
    }

    private void updateAclChangeSet(final Long aclChangeSetId) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AclCrudDAOTest.this.aclCrudDAO.updateAclChangeSet(aclChangeSetId, System.currentTimeMillis());
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
    }

    private void deleteAclChangeSet(final Long aclChangeSetId) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AclCrudDAOTest.this.aclCrudDAO.deleteAclChangeSet(aclChangeSetId);
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
    }

    private AclChangeSet getAclChangeSet(final long aclChangeSetId) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<AclChangeSet> callback = new RetryingTransactionHelper.RetryingTransactionCallback<AclChangeSet>(){

            public AclChangeSet execute() throws Throwable {
                return AclCrudDAOTest.this.aclCrudDAO.getAclChangeSet(Long.valueOf(aclChangeSetId));
            }
        };
        return (AclChangeSet)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
    }

    public void testCreateAndDeleteAclChangeSet() throws Exception {
        Long aclChangeSetId = this.createAclChangeSet();
        AclChangeSet acsEntity = this.getAclChangeSet(aclChangeSetId);
        AclCrudDAOTest.assertNotNull((Object)acsEntity);
        AclCrudDAOTest.assertEquals((Object)aclChangeSetId, (Object)acsEntity.getId());
        this.updateAclChangeSet(aclChangeSetId);
        this.deleteAclChangeSet(aclChangeSetId);
        AclCrudDAOTest.assertNull((Object)this.getAclChangeSet(aclChangeSetId));
    }

    public void testCreateAclChangeSetWithRollback() throws Exception {
        final ArrayList tmp = new ArrayList(1);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                long acsEntityId = AclCrudDAOTest.this.createAclChangeSet();
                tmp.add(acsEntityId);
                throw new RuntimeException("Forced");
            }
        };
        try {
            this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
            AclCrudDAOTest.fail((String)"Transaction didn't roll back");
        }
        catch (RuntimeException runtimeException) {}
        AclCrudDAOTest.assertEquals((int)1, (int)tmp.size());
        AclCrudDAOTest.assertNull((Object)this.getAclChangeSet((Long)tmp.get(0)));
    }

    private Authority createAuth(final String authName) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Authority> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Authority>(){

            public Authority execute() throws Throwable {
                return AclCrudDAOTest.this.aclCrudDAO.getOrCreateAuthority(authName);
            }
        };
        return (Authority)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
    }

    private void deleteAuth(final long authId) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AclCrudDAOTest.this.aclCrudDAO.deleteAuthority(authId);
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
    }

    private void updateAuth(final String before, final String after) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AclCrudDAOTest.this.aclCrudDAO.renameAuthority(before, after);
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
    }

    private Authority getAuth(final String authName) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Authority> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Authority>(){

            public Authority execute() throws Throwable {
                return AclCrudDAOTest.this.aclCrudDAO.getAuthority(authName);
            }
        };
        return (Authority)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
    }

    public void testCreateUpdateAndDeleteAuth() throws Exception {
        String authName = String.valueOf(this.getName()) + "-" + System.currentTimeMillis();
        Authority authEntity = this.getAuth(authName);
        AclCrudDAOTest.assertNull((Object)authEntity);
        Authority createAuthEntity = this.createAuth(authName);
        AclCrudDAOTest.assertNotNull((Object)createAuthEntity);
        authEntity = this.getAuth(authName);
        AclCrudDAOTest.assertEquals((Object)createAuthEntity, (Object)authEntity);
        String newAuthName = String.valueOf(authName) + "-new";
        this.updateAuth(authName, newAuthName);
        AclCrudDAOTest.assertNull((Object)this.getAuth(authName));
        authEntity = this.getAuth(newAuthName);
        AclCrudDAOTest.assertNotNull((Object)authEntity);
        AclCrudDAOTest.assertEquals((Object)createAuthEntity.getId(), (Object)authEntity.getId());
        AclCrudDAOTest.assertEquals((String)newAuthName, (String)authEntity.getAuthority());
        this.deleteAuth(authEntity.getId());
        AclCrudDAOTest.assertNull((Object)this.getAuth(newAuthName));
    }

    public void testCreateAuthWithRollback() throws Exception {
        final String authName = String.valueOf(this.getName()) + "-" + System.currentTimeMillis();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AclCrudDAOTest.this.createAuth(authName);
                throw new RuntimeException("Forced");
            }
        };
        try {
            this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
            AclCrudDAOTest.fail((String)"Transaction didn't roll back");
        }
        catch (RuntimeException runtimeException) {}
        AclCrudDAOTest.assertNull((Object)this.getAuth(authName));
    }

    private Permission createPermission(final PermissionReference permissionReference) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Permission> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Permission>(){

            public Permission execute() throws Throwable {
                return AclCrudDAOTest.this.aclCrudDAO.getOrCreatePermission(permissionReference);
            }
        };
        return (Permission)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
    }

    private void deletePermission(final long permissionId) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AclCrudDAOTest.this.aclCrudDAO.deletePermission(permissionId);
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
    }

    private Permission getPermission(final PermissionReference permissionReference) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Permission> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Permission>(){

            public Permission execute() throws Throwable {
                return AclCrudDAOTest.this.aclCrudDAO.getPermission(permissionReference);
            }
        };
        return (Permission)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
    }

    public void testCreateAndDeletePermission() throws Exception {
        String name = String.valueOf(this.getName()) + "-" + System.currentTimeMillis();
        SimplePermissionReference permRef = SimplePermissionReference.getPermissionReference((QName)QName.createQName((String)"cm:cmobject"), (String)name);
        Permission createdPermEntity = this.createPermission((PermissionReference)permRef);
        AclCrudDAOTest.assertNotNull((Object)createdPermEntity);
        Permission permEntity = this.getPermission((PermissionReference)permRef);
        AclCrudDAOTest.assertEquals((Object)createdPermEntity, (Object)permEntity);
        this.deletePermission(permEntity.getId());
        AclCrudDAOTest.assertNull((Object)this.getPermission((PermissionReference)permRef));
    }

    public void testCreatePermissionWithRollback() throws Exception {
        String name = String.valueOf(this.getName()) + "-" + System.currentTimeMillis();
        final SimplePermissionReference permRef = SimplePermissionReference.getPermissionReference((QName)QName.createQName((String)"cm:cmobject"), (String)name);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AclCrudDAOTest.this.createPermission((PermissionReference)permRef);
                throw new RuntimeException("Forced");
            }
        };
        try {
            this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
            AclCrudDAOTest.fail((String)"Transaction didn't roll back");
        }
        catch (RuntimeException runtimeException) {}
        AclCrudDAOTest.assertNull((Object)this.getPermission((PermissionReference)permRef));
    }
}

