/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.AbstractAsynchronousActionFilter;
import org.alfresco.repo.action.ActionCancelledException;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.OngoingAsyncAction;
import org.alfresco.repo.action.ParameterizedItemImpl;
import org.alfresco.repo.action.evaluator.compare.ComparePropertyValueOperation;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.ActionConditionDefinition;
import org.alfresco.service.cmr.action.ActionDefinition;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.ActionServiceTransientException;
import org.alfresco.service.cmr.action.ActionStatus;
import org.alfresco.service.cmr.action.ActionTrackingService;
import org.alfresco.service.cmr.action.CancellableAction;
import org.alfresco.service.cmr.action.CompositeAction;
import org.alfresco.service.cmr.action.CompositeActionCondition;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.BaseSpringTestsCategory;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.alfresco.util.GUID;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.transaction.TestTransaction;
import org.springframework.transaction.annotation.Transactional;

@Category(value={BaseSpringTestsCategory.class})
@Transactional
@ContextConfiguration(value={"classpath:alfresco/application-context.xml", "classpath:org/alfresco/repo/action/test-action-services-context.xml"})
public class ActionServiceImplTest
extends BaseAlfrescoSpringTest {
    private static final String BAD_NAME = "badName";
    private NodeRef nodeRef;
    private NodeRef folder;
    private RetryingTransactionHelper transactionHelper;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.transactionHelper = (RetryingTransactionHelper)this.applicationContext.getBean("retryingTransactionHelper");
        this.nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testnode"), ContentModel.TYPE_CONTENT).getChildRef();
        this.nodeService.setProperty(this.nodeRef, ContentModel.PROP_CONTENT, (Serializable)new ContentData(null, "text/plain", 0L, null));
        this.folder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testFolder"), ContentModel.TYPE_FOLDER).getChildRef();
        SleepActionExecuter.registerIfNeeded(this.applicationContext);
    }

    @Test
    public void testGetActionDefinition() {
        ActionDefinition action = this.actionService.getActionDefinition("add-features");
        ActionServiceImplTest.assertNotNull((Object)action);
        ActionServiceImplTest.assertEquals((String)"add-features", (String)action.getName());
        ActionConditionDefinition nullCondition = this.actionService.getActionConditionDefinition(BAD_NAME);
        ActionServiceImplTest.assertNull((Object)nullCondition);
    }

    @Test
    public void testGetActionDefinitions() {
        List defintions = this.actionService.getActionDefinitions();
        ActionServiceImplTest.assertNotNull((Object)defintions);
        ActionServiceImplTest.assertFalse((boolean)defintions.isEmpty());
        int totalCount = defintions.size();
        for (ActionDefinition definition : defintions) {
            System.out.println(definition.getTitle());
        }
        List definitions = this.actionService.getActionDefinitions(this.folder);
        ActionServiceImplTest.assertNotNull((Object)definitions);
        ActionServiceImplTest.assertTrue((totalCount > definitions.size() ? 1 : 0) != 0);
    }

    @Test
    public void testGetActionConditionDefinition() {
        ActionConditionDefinition condition = this.actionService.getActionConditionDefinition("no-condition");
        ActionServiceImplTest.assertNotNull((Object)condition);
        ActionServiceImplTest.assertEquals((String)"no-condition", (String)condition.getName());
        ActionConditionDefinition nullCondition = this.actionService.getActionConditionDefinition(BAD_NAME);
        ActionServiceImplTest.assertNull((Object)nullCondition);
    }

    @Test
    public void testGetActionConditionDefinitions() {
        List defintions = this.actionService.getActionConditionDefinitions();
        ActionServiceImplTest.assertNotNull((Object)defintions);
        ActionServiceImplTest.assertFalse((boolean)defintions.isEmpty());
        for (ActionConditionDefinition definition : defintions) {
            System.out.println(definition.getTitle());
        }
    }

    @Test
    public void testCreateActionCondition() {
        ActionCondition condition = this.actionService.createActionCondition("no-condition");
        ActionServiceImplTest.assertNotNull((Object)condition);
        ActionServiceImplTest.assertEquals((String)"no-condition", (String)condition.getActionConditionDefinitionName());
        HashMap params = new HashMap(0);
        condition = this.actionService.createActionCondition("no-condition", params);
        ActionServiceImplTest.assertNotNull((Object)condition);
        ActionServiceImplTest.assertEquals((String)"no-condition", (String)condition.getActionConditionDefinitionName());
    }

    @Test
    public void testCreateCompositeActionCondition() {
        CompositeActionCondition action = this.actionService.createCompositeActionCondition();
        ActionServiceImplTest.assertNotNull((Object)action);
        ActionServiceImplTest.assertEquals((String)"composite-condition", (String)action.getActionConditionDefinitionName());
    }

    @Test
    public void testCreateAction() {
        Action action = this.actionService.createAction("add-features");
        ActionServiceImplTest.assertNotNull((Object)action);
        ActionServiceImplTest.assertEquals((String)"add-features", (String)action.getActionDefinitionName());
        HashMap params = new HashMap(0);
        action = this.actionService.createAction("add-features", params);
        ActionServiceImplTest.assertNotNull((Object)action);
        ActionServiceImplTest.assertEquals((String)"add-features", (String)action.getActionDefinitionName());
    }

    @Test
    public void testCreateCompositeAction() {
        CompositeAction action = this.actionService.createCompositeAction();
        ActionServiceImplTest.assertNotNull((Object)action);
        ActionServiceImplTest.assertEquals((String)"composite-action", (String)action.getActionDefinitionName());
    }

    @Test
    public void testEvaluateAction() {
        Action action = this.actionService.createAction("add-features");
        ActionServiceImplTest.assertTrue((boolean)this.actionService.evaluateAction(action, this.nodeRef));
        ActionCondition condition = this.actionService.createActionCondition("compare-property-value");
        condition.setParameterValue("value", (Serializable)((Object)"*.doc"));
        action.addActionCondition(condition);
        ActionServiceImplTest.assertFalse((boolean)this.actionService.evaluateAction(action, this.nodeRef));
        this.nodeService.setProperty(this.nodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"myDocument.doc"));
        ActionServiceImplTest.assertTrue((boolean)this.actionService.evaluateAction(action, this.nodeRef));
        ActionCondition condition2 = this.actionService.createActionCondition("compare-property-value");
        condition2.setParameterValue("value", (Serializable)((Object)"my"));
        action.addActionCondition(condition2);
        ActionServiceImplTest.assertTrue((boolean)this.actionService.evaluateAction(action, this.nodeRef));
        this.nodeService.setProperty(this.nodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"document.doc"));
        ActionServiceImplTest.assertFalse((boolean)this.actionService.evaluateAction(action, this.nodeRef));
    }

    @Test
    public void testEvaluateActionCondition() {
        ActionCondition condition = this.actionService.createActionCondition("compare-property-value");
        condition.setParameterValue("value", (Serializable)((Object)"*.doc"));
        ActionServiceImplTest.assertFalse((boolean)this.actionService.evaluateActionCondition(condition, this.nodeRef));
        this.nodeService.setProperty(this.nodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"myDocument.doc"));
        ActionServiceImplTest.assertTrue((boolean)this.actionService.evaluateActionCondition(condition, this.nodeRef));
        condition.setInvertCondition(true);
        ActionServiceImplTest.assertFalse((boolean)this.actionService.evaluateActionCondition(condition, this.nodeRef));
    }

    @Test
    public void testEvaluateCompositeActionConditionWith1SubCondition() {
        CompositeActionCondition compositeCondition = this.actionService.createCompositeActionCondition();
        ActionCondition condition = this.actionService.createActionCondition("compare-property-value");
        condition.setParameterValue("value", (Serializable)((Object)"*.doc"));
        compositeCondition.addActionCondition(condition);
        this.nodeService.setProperty(this.nodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"myDocument.doc"));
        ActionServiceImplTest.assertTrue((boolean)this.actionService.evaluateActionCondition((ActionCondition)compositeCondition, this.nodeRef));
        compositeCondition.setInvertCondition(true);
        ActionServiceImplTest.assertFalse((boolean)this.actionService.evaluateActionCondition((ActionCondition)compositeCondition, this.nodeRef));
    }

    @Test
    public void testEvaluateCompositeActionConditionWith2SubConditions() {
        CompositeActionCondition compositeCondition = this.actionService.createCompositeActionCondition();
        ActionCondition condition = this.actionService.createActionCondition("compare-property-value");
        condition.setParameterValue("value", (Serializable)((Object)"*.doc"));
        compositeCondition.addActionCondition(condition);
        this.nodeService.setProperty(this.nodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"myDocument.doc"));
        ActionServiceImplTest.assertTrue((boolean)this.actionService.evaluateActionCondition((ActionCondition)compositeCondition, this.nodeRef));
        ActionCondition conditionTwo = this.actionService.createActionCondition("compare-text-property");
        conditionTwo.setParameterValue("value", (Serializable)((Object)"Doc"));
        conditionTwo.setParameterValue("property", (Serializable)QName.createQName(null, (String)"name"));
        conditionTwo.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.CONTAINS.toString()));
        compositeCondition.addActionCondition(conditionTwo);
        ActionServiceImplTest.assertFalse((boolean)this.actionService.evaluateActionCondition((ActionCondition)compositeCondition, this.nodeRef));
        compositeCondition.removeAllActionConditions();
        ActionServiceImplTest.assertFalse((boolean)compositeCondition.hasActionConditions());
        compositeCondition.addActionCondition(condition);
        conditionTwo.setParameterValue("value", (Serializable)((Object)"NotFound"));
        ActionServiceImplTest.assertFalse((boolean)this.actionService.evaluateActionCondition(conditionTwo, this.nodeRef));
        compositeCondition.addActionCondition(conditionTwo);
        compositeCondition.setORCondition(true);
        ActionServiceImplTest.assertTrue((boolean)this.actionService.evaluateActionCondition((ActionCondition)compositeCondition, this.nodeRef));
        compositeCondition.setORCondition(false);
        ActionServiceImplTest.assertFalse((boolean)this.actionService.evaluateActionCondition((ActionCondition)compositeCondition, this.nodeRef));
        compositeCondition.setInvertCondition(true);
        ActionServiceImplTest.assertTrue((boolean)this.actionService.evaluateActionCondition((ActionCondition)compositeCondition, this.nodeRef));
    }

    @Test
    public void testExecuteAction() {
        ActionServiceImplTest.assertFalse((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE));
        Action action = this.actionService.createAction("add-features");
        action.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_VERSIONABLE);
        this.actionService.executeAction(action, this.nodeRef);
        ActionServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.nodeService.removeAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE);
        ActionServiceImplTest.assertFalse((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE));
        ActionCondition condition = this.actionService.createActionCondition("compare-property-value");
        condition.setParameterValue("value", (Serializable)((Object)"*.doc"));
        action.addActionCondition(condition);
        this.actionService.executeAction(action, this.nodeRef);
        ActionServiceImplTest.assertFalse((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.actionService.executeAction(action, this.nodeRef, true);
        ActionServiceImplTest.assertFalse((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.actionService.executeAction(action, this.nodeRef, false);
        ActionServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.nodeService.removeAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE);
        ActionServiceImplTest.assertFalse((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.nodeService.setProperty(this.nodeRef, ContentModel.PROP_NAME, (Serializable)((Object)"myDocument.doc"));
        this.actionService.executeAction(action, this.nodeRef);
        ActionServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.nodeService.removeAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE);
        ActionServiceImplTest.assertFalse((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.nodeService.removeAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE);
        ActionServiceImplTest.assertFalse((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE));
        Action action1 = this.actionService.createAction("add-features");
        action1.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_LOCKABLE);
        Action action2 = this.actionService.createAction("add-features");
        action2.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_VERSIONABLE);
        CompositeAction compAction = this.actionService.createCompositeAction();
        compAction.setTitle("title");
        compAction.setDescription("description");
        compAction.addAction(action1);
        compAction.addAction(action2);
        this.actionService.executeAction((Action)compAction, this.nodeRef);
        ActionServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_LOCKABLE));
        ActionServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE));
    }

    @Test
    public void testGetAndGetAllWithNoActions() {
        ActionServiceImplTest.assertNull((Object)this.actionService.getAction(this.nodeRef, "add-features"));
        List actions = this.actionService.getActions(this.nodeRef);
        ActionServiceImplTest.assertNotNull((Object)actions);
        ActionServiceImplTest.assertEquals((int)0, (int)actions.size());
    }

    @Test
    public void testExecuteActionWithNoParameterDef() {
        Action action = this.actionService.createAction("empty-action");
        this.actionService.executeAction(action, this.nodeRef);
        ActionServiceImplTest.assertTrue((String)"If we got here then the test is successful", (boolean)true);
    }

    @Test
    public void testSaveActionNoCondition() {
        Action action = this.actionService.createAction("add-features");
        String actionId = action.getId();
        action.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_VERSIONABLE);
        action.setTitle("title");
        action.setDescription("description");
        action.setExecuteAsynchronously(true);
        this.actionService.saveAction(this.nodeRef, action);
        Action savedAction = this.actionService.getAction(this.nodeRef, actionId);
        ActionServiceImplTest.assertEquals((String)action.getId(), (String)savedAction.getId());
        ActionServiceImplTest.assertEquals((String)action.getActionDefinitionName(), (String)savedAction.getActionDefinitionName());
        ActionServiceImplTest.assertEquals((String)"title", (String)savedAction.getTitle());
        ActionServiceImplTest.assertEquals((String)"description", (String)savedAction.getDescription());
        ActionServiceImplTest.assertTrue((boolean)savedAction.getExecuteAsychronously());
        ActionServiceImplTest.assertNull((Object)savedAction.getCompensatingAction());
        ActionServiceImplTest.assertEquals((int)1, (int)savedAction.getParameterValues().size());
        ActionServiceImplTest.assertEquals((Object)ContentModel.ASPECT_VERSIONABLE, (Object)savedAction.getParameterValue("aspect-name"));
        ActionServiceImplTest.assertNotNull((Object)savedAction.getActionConditions());
        ActionServiceImplTest.assertEquals((int)0, (int)savedAction.getActionConditions().size());
        HashMap<QName, String> properties = new HashMap<QName, String>(1);
        properties.put(ContentModel.PROP_NAME, "testName");
        action.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_AUDITABLE);
        Action compensatingAction = this.actionService.createAction("add-features");
        compensatingAction.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_VERSIONABLE);
        action.setCompensatingAction(compensatingAction);
        this.actionService.saveAction(this.nodeRef, action);
        Action savedAction2 = this.actionService.getAction(this.nodeRef, actionId);
        ActionServiceImplTest.assertEquals((int)1, (int)savedAction2.getParameterValues().size());
        ActionServiceImplTest.assertEquals((Object)ContentModel.ASPECT_AUDITABLE, (Object)savedAction2.getParameterValue("aspect-name"));
        Action savedCompensatingAction = savedAction2.getCompensatingAction();
        ActionServiceImplTest.assertNotNull((Object)savedCompensatingAction);
        ActionServiceImplTest.assertEquals((Object)compensatingAction, (Object)savedCompensatingAction);
        ActionServiceImplTest.assertEquals((String)"add-features", (String)savedCompensatingAction.getActionDefinitionName());
        ActionServiceImplTest.assertEquals((Object)ContentModel.ASPECT_VERSIONABLE, (Object)savedCompensatingAction.getParameterValue("aspect-name"));
        compensatingAction.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_CLASSIFIABLE);
        this.actionService.saveAction(this.nodeRef, action);
        Action savedAction3 = this.actionService.getAction(this.nodeRef, actionId);
        Action savedCompensatingAction2 = savedAction3.getCompensatingAction();
        ActionServiceImplTest.assertNotNull((Object)savedCompensatingAction2);
        ActionServiceImplTest.assertEquals((Object)compensatingAction, (Object)savedCompensatingAction2);
        ActionServiceImplTest.assertEquals((String)"add-features", (String)savedCompensatingAction2.getActionDefinitionName());
        ActionServiceImplTest.assertEquals((Object)ContentModel.ASPECT_CLASSIFIABLE, (Object)savedCompensatingAction2.getParameterValue("aspect-name"));
        action.setCompensatingAction(null);
        this.actionService.saveAction(this.nodeRef, action);
        Action savedAction4 = this.actionService.getAction(this.nodeRef, actionId);
        ActionServiceImplTest.assertNull((Object)savedAction4.getCompensatingAction());
    }

    @Test
    public void testOwningNodeRef() {
        Action action = this.actionService.createAction("add-features");
        String actionId = action.getId();
        action.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_VERSIONABLE);
        action.setTitle("title");
        action.setDescription("description");
        action.setExecuteAsynchronously(true);
        this.actionService.saveAction(this.nodeRef, action);
        this.actionService.getAction(this.nodeRef, actionId);
    }

    @Test
    public void testSaveActionWithConditions() {
        Action action = this.actionService.createAction("add-features");
        String actionId = action.getId();
        action.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_VERSIONABLE);
        ActionCondition actionCondition = this.actionService.createActionCondition("no-condition");
        actionCondition.setInvertCondition(true);
        ActionCondition actionCondition2 = this.actionService.createActionCondition("compare-property-value");
        actionCondition2.setParameterValue("value", (Serializable)((Object)"*.doc"));
        action.addActionCondition(actionCondition);
        action.addActionCondition(actionCondition2);
        this.actionService.saveAction(this.nodeRef, action);
        Action savedAction = this.actionService.getAction(this.nodeRef, actionId);
        ActionServiceImplTest.assertEquals((String)action.getId(), (String)savedAction.getId());
        ActionServiceImplTest.assertEquals((String)action.getActionDefinitionName(), (String)savedAction.getActionDefinitionName());
        ActionServiceImplTest.assertEquals((int)action.getParameterValues().size(), (int)savedAction.getParameterValues().size());
        ActionServiceImplTest.assertEquals((Object)ContentModel.ASPECT_VERSIONABLE, (Object)savedAction.getParameterValue("aspect-name"));
        ActionServiceImplTest.assertNotNull((Object)savedAction.getActionConditions());
        ActionServiceImplTest.assertEquals((int)2, (int)savedAction.getActionConditions().size());
        for (ActionCondition savedCondition : savedAction.getActionConditions()) {
            if (savedCondition.getActionConditionDefinitionName().equals("no-condition")) {
                ActionServiceImplTest.assertEquals((int)0, (int)savedCondition.getParameterValues().size());
                ActionServiceImplTest.assertTrue((boolean)savedCondition.getInvertCondition());
                continue;
            }
            if (savedCondition.getActionConditionDefinitionName().equals("compare-property-value")) {
                ActionServiceImplTest.assertEquals((int)1, (int)savedCondition.getParameterValues().size());
                ActionServiceImplTest.assertEquals((Object)"*.doc", (Object)savedCondition.getParameterValue("value"));
                ActionServiceImplTest.assertFalse((boolean)savedCondition.getInvertCondition());
                continue;
            }
            ActionServiceImplTest.fail((String)"There is a condition here that we are not expecting.");
        }
        ActionCondition actionCondition3 = this.actionService.createActionCondition("in-category");
        actionCondition3.setParameterValue("category-aspect", (Serializable)ContentModel.ASPECT_OWNABLE);
        action.addActionCondition(actionCondition3);
        action.removeActionCondition(actionCondition);
        actionCondition2.setParameterValue("value", (Serializable)((Object)"*.exe"));
        actionCondition2.setParameterValue("operation", (Serializable)ComparePropertyValueOperation.EQUALS);
        this.actionService.saveAction(this.nodeRef, action);
        Action savedAction2 = this.actionService.getAction(this.nodeRef, actionId);
        ActionServiceImplTest.assertNotNull((Object)savedAction2.getActionConditions());
        ActionServiceImplTest.assertEquals((int)2, (int)savedAction2.getActionConditions().size());
        for (ActionCondition savedCondition : savedAction2.getActionConditions()) {
            if (savedCondition.getActionConditionDefinitionName().equals("in-category")) {
                ActionServiceImplTest.assertEquals((int)1, (int)savedCondition.getParameterValues().size());
                ActionServiceImplTest.assertEquals((Object)ContentModel.ASPECT_OWNABLE, (Object)savedCondition.getParameterValue("category-aspect"));
                continue;
            }
            if (savedCondition.getActionConditionDefinitionName().equals("compare-property-value")) {
                ActionServiceImplTest.assertEquals((int)2, (int)savedCondition.getParameterValues().size());
                ActionServiceImplTest.assertEquals((Object)"*.exe", (Object)savedCondition.getParameterValue("value"));
                ActionServiceImplTest.assertEquals((Object)ComparePropertyValueOperation.EQUALS, (Object)savedCondition.getParameterValue("operation"));
                continue;
            }
            ActionServiceImplTest.fail((String)"There is a condition here that we are not expecting.");
        }
    }

    @Test
    public void testSaveCompositeAction() {
        Action action1 = this.actionService.createAction("add-features");
        Action action2 = this.actionService.createAction("check-in");
        CompositeAction compositeAction = this.actionService.createCompositeAction();
        String actionId = compositeAction.getId();
        compositeAction.addAction(action1);
        compositeAction.addAction(action2);
        this.actionService.saveAction(this.nodeRef, (Action)compositeAction);
        ActionServiceImplTest.assertEquals((int)1, (int)this.actionService.getActions(this.nodeRef).size());
        CompositeAction savedCompositeAction = (CompositeAction)this.actionService.getAction(this.nodeRef, actionId);
        ActionServiceImplTest.assertEquals((int)2, (int)savedCompositeAction.getActions().size());
        for (Action action : savedCompositeAction.getActions()) {
            if (action.getActionDefinitionName().equals("add-features")) {
                ActionServiceImplTest.assertEquals((Object)action, (Object)action1);
                continue;
            }
            if (action.getActionDefinitionName().equals("check-in")) {
                ActionServiceImplTest.assertEquals((Object)action, (Object)action2);
                continue;
            }
            ActionServiceImplTest.fail((String)"We have an action here we are not expecting.");
        }
        compositeAction.removeAction(action1);
        Action action3 = this.actionService.createAction("check-out");
        compositeAction.addAction(action3);
        action2.setParameterValue("description", (Serializable)((Object)"description"));
        this.actionService.saveAction(this.nodeRef, (Action)compositeAction);
        ActionServiceImplTest.assertEquals((int)1, (int)this.actionService.getActions(this.nodeRef).size());
        CompositeAction savedCompositeAction2 = (CompositeAction)this.actionService.getAction(this.nodeRef, actionId);
        ActionServiceImplTest.assertEquals((int)2, (int)savedCompositeAction2.getActions().size());
        for (Action action : savedCompositeAction2.getActions()) {
            if (action.getActionDefinitionName().equals("check-out")) {
                ActionServiceImplTest.assertEquals((Object)action, (Object)action3);
                continue;
            }
            if (action.getActionDefinitionName().equals("check-in")) {
                ActionServiceImplTest.assertEquals((Object)action, (Object)action2);
                ActionServiceImplTest.assertEquals((Object)"description", (Object)action2.getParameterValue("description"));
                continue;
            }
            ActionServiceImplTest.fail((String)"We have an action here we are not expecting.");
        }
    }

    @Test
    public void testRemove() {
        ActionServiceImplTest.assertEquals((int)0, (int)this.actionService.getActions(this.nodeRef).size());
        Action action1 = this.actionService.createAction("add-features");
        this.actionService.saveAction(this.nodeRef, action1);
        Action action2 = this.actionService.createAction("check-in");
        this.actionService.saveAction(this.nodeRef, action2);
        ActionServiceImplTest.assertEquals((int)2, (int)this.actionService.getActions(this.nodeRef).size());
        this.actionService.removeAction(this.nodeRef, action1);
        ActionServiceImplTest.assertEquals((int)1, (int)this.actionService.getActions(this.nodeRef).size());
        this.actionService.removeAllActions(this.nodeRef);
        ActionServiceImplTest.assertEquals((int)0, (int)this.actionService.getActions(this.nodeRef).size());
    }

    @Test
    public void testConditionOrder() {
        Action action = this.actionService.createAction("add-features");
        String actionId = action.getId();
        ActionCondition condition1 = this.actionService.createActionCondition("no-condition");
        ActionCondition condition2 = this.actionService.createActionCondition("no-condition");
        action.addActionCondition(condition1);
        action.addActionCondition(condition2);
        this.actionService.saveAction(this.nodeRef, action);
        Action savedAction = this.actionService.getAction(this.nodeRef, actionId);
        ActionServiceImplTest.assertNotNull((Object)savedAction);
        ActionServiceImplTest.assertEquals((Object)condition1, (Object)savedAction.getActionCondition(0));
        ActionServiceImplTest.assertEquals((Object)condition2, (Object)savedAction.getActionCondition(1));
        ActionCondition condition3 = this.actionService.createActionCondition("no-condition");
        ActionCondition condition4 = this.actionService.createActionCondition("no-condition");
        savedAction.removeActionCondition(condition1);
        savedAction.addActionCondition(condition3);
        savedAction.addActionCondition(condition4);
        this.actionService.saveAction(this.nodeRef, savedAction);
        Action savedAction2 = this.actionService.getAction(this.nodeRef, actionId);
        ActionServiceImplTest.assertNotNull((Object)savedAction2);
        ActionServiceImplTest.assertEquals((Object)condition2, (Object)savedAction2.getActionCondition(0));
        ActionServiceImplTest.assertEquals((Object)condition3, (Object)savedAction2.getActionCondition(1));
        ActionServiceImplTest.assertEquals((Object)condition4, (Object)savedAction2.getActionCondition(2));
    }

    @Test
    public void testActionOrder() {
        CompositeAction action = this.actionService.createCompositeAction();
        String actionId = action.getId();
        Action action1 = this.actionService.createAction("add-features");
        Action action2 = this.actionService.createAction("add-features");
        action.addAction(action1);
        action.addAction(action2);
        this.actionService.saveAction(this.nodeRef, (Action)action);
        CompositeAction savedAction = (CompositeAction)this.actionService.getAction(this.nodeRef, actionId);
        ActionServiceImplTest.assertNotNull((Object)savedAction);
        ActionServiceImplTest.assertEquals((Object)action1, (Object)savedAction.getAction(0));
        ActionServiceImplTest.assertEquals((Object)action2, (Object)savedAction.getAction(1));
        Action action3 = this.actionService.createAction("add-features");
        Action action4 = this.actionService.createAction("add-features");
        savedAction.removeAction(action1);
        savedAction.addAction(action3);
        savedAction.addAction(action4);
        this.actionService.saveAction(this.nodeRef, (Action)savedAction);
        CompositeAction savedAction2 = (CompositeAction)this.actionService.getAction(this.nodeRef, actionId);
        ActionServiceImplTest.assertNotNull((Object)savedAction2);
        ActionServiceImplTest.assertEquals((Object)action2, (Object)savedAction2.getAction(0));
        ActionServiceImplTest.assertEquals((Object)action3, (Object)savedAction2.getAction(1));
        ActionServiceImplTest.assertEquals((Object)action4, (Object)savedAction2.getAction(2));
    }

    public void offtestAsyncLongRunningActionsFilter() {
        TestTransaction.flagForCommit();
        TestTransaction.end();
        final SleepActionExecuter sleepAction = (SleepActionExecuter)((Object)this.applicationContext.getBean("sleep-action"));
        ActionServiceImplTest.assertNotNull((Object)((Object)sleepAction));
        sleepAction.setSleepMs(10);
        int i = 0;
        while (i < 4) {
            this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    Action action = ActionServiceImplTest.this.actionService.createAction("sleep-action");
                    action.setExecuteAsynchronously(true);
                    ActionServiceImplTest.this.actionService.executeAction(action, ActionServiceImplTest.this.nodeRef);
                    return null;
                }
            });
            ++i;
        }
        try {
            Thread.sleep(sleepAction.getSleepMs() * 4 + 1000);
        }
        catch (InterruptedException interruptedException) {}
        this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Action action = ActionServiceImplTest.this.actionService.createAction("sleep-action");
                action.setExecuteAsynchronously(true);
                ActionServiceImplTest.this.actionService.executeAction(action, ActionServiceImplTest.this.nodeRef);
                return null;
            }
        });
        try {
            Thread.sleep(sleepAction.getSleepMs() + 2000);
        }
        catch (InterruptedException interruptedException) {}
        int sleepTime = 0;
        int maxTries = 1;
        ActionServiceImplTest.postAsyncActionTest(this.transactionService, sleepTime, maxTries, new AsyncTest(){

            @Override
            public String executeTest() {
                int actualResult = sleepAction.getTimesExecuted();
                return actualResult == 2 ? null : "Expected timesExecuted 2 was " + actualResult;
            }
        });
    }

    @Test
    public void testAsyncExecuteAction() {
        ActionServiceImplTest.assertFalse((boolean)this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE));
        Action action = this.actionService.createAction("add-features");
        action.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_CLASSIFIABLE);
        action.setExecuteAsynchronously(true);
        this.actionService.executeAction(action, this.nodeRef);
        TestTransaction.flagForCommit();
        TestTransaction.end();
        final NodeService finalNodeService = this.nodeService;
        final NodeRef finalNodeRef = this.nodeRef;
        ActionServiceImplTest.postAsyncActionTest(this.transactionService, 1000L, 10, new AsyncTest(){

            @Override
            public String executeTest() {
                boolean result = finalNodeService.hasAspect(finalNodeRef, ContentModel.ASPECT_CLASSIFIABLE);
                return result ? null : "Expected aspect Classifiable";
            }
        });
    }

    @Test
    public void testAsyncCompositeActionExecute() {
        Action action1 = this.actionService.createAction("add-features");
        action1.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_LOCKABLE);
        Action action2 = this.actionService.createAction("add-features");
        action2.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_VERSIONABLE);
        CompositeAction compAction = this.actionService.createCompositeAction();
        compAction.setTitle("title");
        compAction.setDescription("description");
        compAction.addAction(action1);
        compAction.addAction(action2);
        compAction.setExecuteAsynchronously(true);
        this.actionService.executeAction((Action)compAction, this.nodeRef);
        TestTransaction.flagForCommit();
        TestTransaction.end();
        final NodeService finalNodeService = this.nodeService;
        final NodeRef finalNodeRef = this.nodeRef;
        ActionServiceImplTest.postAsyncActionTest(this.transactionService, 1000L, 10, new AsyncTest(){

            @Override
            public String executeTest() {
                boolean result = finalNodeService.hasAspect(finalNodeRef, ContentModel.ASPECT_VERSIONABLE) && finalNodeService.hasAspect(finalNodeRef, ContentModel.ASPECT_LOCKABLE);
                return result ? null : "Expected aspects Versionable & Lockable";
            }
        });
    }

    public void xtestAsyncLoadTest() {
        Action action = this.actionService.createAction("add-features");
        action.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_VERSIONABLE);
        action.setExecuteAsynchronously(true);
        int i = 0;
        while (i < 1000) {
            this.actionService.executeAction(action, this.nodeRef);
            ++i;
        }
        TestTransaction.flagForCommit();
        TestTransaction.end();
    }

    public static void postAsyncActionTest(TransactionService transactionService, long sleepTime, int maxTries, final AsyncTest test) {
        try {
            int tries = 0;
            String errorMsg = null;
            while (errorMsg == null && tries < maxTries) {
                try {
                    ++tries;
                    Thread.sleep(sleepTime);
                    errorMsg = (String)transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

                        public String execute() {
                            String done = test.executeTest();
                            return done;
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (errorMsg != null) {
                throw new RuntimeException("Asynchronous action was not executed. " + errorMsg);
            }
        }
        catch (Throwable exception) {
            exception.printStackTrace();
            ActionServiceImplTest.fail((String)("An exception was encountered whilst checking the async action was executed: " + exception.getMessage()));
        }
    }

    @Test
    public void testSyncFailureBehaviour() {
        Action action = this.createFailingMoveAction(true);
        try {
            this.actionService.executeAction(action, this.nodeRef);
            ActionServiceImplTest.fail((String)"An exception should have been raised.");
        }
        catch (RuntimeException runtimeException) {}
        Action action1 = this.actionService.createAction("add-features");
        action1.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_LOCKABLE);
        Action action2 = this.actionService.createAction("add-features");
        action2.setParameterValue("aspect-name", (Serializable)QName.createQName((String)"{test}badDogAspect"));
        CompositeAction compAction = this.actionService.createCompositeAction();
        compAction.setTitle("title");
        compAction.setDescription("description");
        compAction.addAction(action1);
        compAction.addAction(action2);
        try {
            this.actionService.executeAction((Action)compAction, this.nodeRef);
            ActionServiceImplTest.fail((String)"An exception should have been raised here !!");
        }
        catch (RuntimeException runtimeException) {}
    }

    @Test
    public void testCompensatingAction() {
        final Action fatalAction = this.createFailingMoveAction(true);
        Action nonfatalAction = this.createFailingMoveAction(false);
        fatalAction.setTitle("fatal title");
        nonfatalAction.setTitle("non-fatal title");
        Action compensatingAction = this.actionService.createAction("add-features");
        compensatingAction.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_CLASSIFIABLE);
        compensatingAction.setTitle("title");
        fatalAction.setCompensatingAction(compensatingAction);
        Action compensatingAction2 = this.actionService.createAction("add-features");
        compensatingAction2.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_TEMPORARY);
        compensatingAction2.setTitle("title");
        nonfatalAction.setCompensatingAction(compensatingAction2);
        fatalAction.setExecuteAsynchronously(true);
        nonfatalAction.setExecuteAsynchronously(true);
        this.actionService.executeAction(fatalAction, this.nodeRef);
        this.actionService.executeAction(nonfatalAction, this.nodeRef);
        TestTransaction.flagForCommit();
        TestTransaction.end();
        ActionServiceImplTest.postAsyncActionTest(this.transactionService, 1000L, 10, new AsyncTest(){

            @Override
            public String executeTest() {
                boolean fatalCompensatingActionRun = ActionServiceImplTest.this.nodeService.hasAspect(ActionServiceImplTest.this.nodeRef, ContentModel.ASPECT_CLASSIFIABLE);
                boolean nonFatalCompensatingActionRun = ActionServiceImplTest.this.nodeService.hasAspect(ActionServiceImplTest.this.nodeRef, ContentModel.ASPECT_TEMPORARY);
                StringBuilder result = new StringBuilder();
                if (!fatalCompensatingActionRun) {
                    result.append("Expected aspect Classifiable.");
                }
                if (nonFatalCompensatingActionRun) {
                    result.append(" Did not expect aspect Temporary");
                }
                return !fatalCompensatingActionRun || nonFatalCompensatingActionRun ? result.toString() : null;
            }
        });
        compensatingAction.setParameterValue("aspect-name", (Serializable)QName.createQName((String)"{test}badAspect"));
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() {
                try {
                    ActionServiceImplTest.this.actionService.executeAction(fatalAction, ActionServiceImplTest.this.nodeRef);
                }
                catch (RuntimeException exception) {
                    exception.printStackTrace();
                    ActionServiceImplTest.fail((String)"An exception should not have been raised here.");
                }
                return null;
            }
        });
    }

    @Test
    public void testALF5027() throws Exception {
        String userName = "bob" + GUID.generate();
        this.createUser(userName);
        PermissionService permissionService = (PermissionService)this.applicationContext.getBean("PermissionService");
        permissionService.setPermission(this.rootNodeRef, userName, "Coordinator", true);
        AuthenticationUtil.setRunAsUser((String)userName);
        NodeRef myNodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)("{test}myTestNode" + GUID.generate())), ContentModel.TYPE_CONTENT).getChildRef();
        CheckOutCheckInService coci = (CheckOutCheckInService)this.applicationContext.getBean("CheckoutCheckinService");
        NodeRef workingcopy = coci.checkout(myNodeRef);
        ActionServiceImplTest.assertNotNull((Object)workingcopy);
        ActionServiceImplTest.assertFalse((boolean)this.nodeService.hasAspect(myNodeRef, ContentModel.ASPECT_DUBLINCORE));
        Action action1 = this.actionService.createAction("add-features");
        action1.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_DUBLINCORE);
        this.actionService.executeAction(action1, myNodeRef);
        ActionServiceImplTest.assertFalse((boolean)this.nodeService.hasAspect(myNodeRef, ContentModel.ASPECT_DUBLINCORE));
        coci.checkin(workingcopy, null);
        this.actionService.executeAction(action1, myNodeRef);
        ActionServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(myNodeRef, ContentModel.ASPECT_DUBLINCORE));
    }

    @Test
    public void testExecutionTrackingDetails() {
        Action action = this.actionService.createAction("add-features");
        String actionId = action.getId();
        ActionServiceImplTest.assertNull((Object)action.getExecutionStartDate());
        ActionServiceImplTest.assertNull((Object)action.getExecutionEndDate());
        ActionServiceImplTest.assertNull((Object)action.getExecutionFailureMessage());
        ActionServiceImplTest.assertEquals((Object)ActionStatus.New, (Object)action.getExecutionStatus());
        this.actionService.saveAction(this.nodeRef, action);
        action = this.actionService.getAction(this.nodeRef, actionId);
        ActionServiceImplTest.assertNull((Object)action.getExecutionStartDate());
        ActionServiceImplTest.assertNull((Object)action.getExecutionEndDate());
        ActionServiceImplTest.assertNull((Object)action.getExecutionFailureMessage());
        ActionServiceImplTest.assertEquals((Object)ActionStatus.New, (Object)action.getExecutionStatus());
        ((ActionImpl)action).setExecutionStatus(ActionStatus.Running);
        ((ActionImpl)action).setExecutionStartDate(new Date(12345L));
        this.actionService.saveAction(this.nodeRef, action);
        action = this.actionService.getAction(this.nodeRef, actionId);
        ActionServiceImplTest.assertEquals((Object)ActionStatus.Running, (Object)action.getExecutionStatus());
        ActionServiceImplTest.assertEquals((long)12345L, (long)action.getExecutionStartDate().getTime());
        ActionServiceImplTest.assertNull((Object)action.getExecutionEndDate());
        ActionServiceImplTest.assertNull((Object)action.getExecutionFailureMessage());
        ((ActionImpl)action).setExecutionStatus(ActionStatus.Failed);
        ((ActionImpl)action).setExecutionStartDate(new Date(123450L));
        ((ActionImpl)action).setExecutionEndDate(new Date(123455L));
        ((ActionImpl)action).setExecutionFailureMessage("Testing");
        this.actionService.saveAction(this.nodeRef, action);
        action = this.actionService.getAction(this.nodeRef, actionId);
        ActionServiceImplTest.assertEquals((Object)ActionStatus.Failed, (Object)action.getExecutionStatus());
        ActionServiceImplTest.assertEquals((long)123450L, (long)action.getExecutionStartDate().getTime());
        ActionServiceImplTest.assertEquals((long)123455L, (long)action.getExecutionEndDate().getTime());
        ActionServiceImplTest.assertEquals((String)"Testing", (String)action.getExecutionFailureMessage());
        ((ActionImpl)action).setExecutionStatus(null);
        ((ActionImpl)action).setExecutionStartDate(new Date(123450L));
        ((ActionImpl)action).setExecutionFailureMessage(null);
        this.actionService.saveAction(this.nodeRef, action);
        action = this.actionService.getAction(this.nodeRef, actionId);
        ActionServiceImplTest.assertEquals((Object)ActionStatus.New, (Object)action.getExecutionStatus());
        ActionServiceImplTest.assertEquals((long)123450L, (long)action.getExecutionStartDate().getTime());
        ActionServiceImplTest.assertEquals((long)123455L, (long)action.getExecutionEndDate().getTime());
        ActionServiceImplTest.assertEquals(null, (String)action.getExecutionFailureMessage());
    }

    protected Action createFailingMoveAction(boolean isFatal) {
        Action failingAction;
        if (isFatal) {
            failingAction = this.actionService.createAction("move");
            NodeRef badNodeRef = new NodeRef(this.storeRef, "123123");
            failingAction.setParameterValue("destination-folder", (Serializable)badNodeRef);
        } else {
            failingAction = this.actionService.createAction("transient-fail-action");
        }
        return failingAction;
    }

    protected Action createFailingSleepAction(String id, boolean isFatal) throws Exception {
        return ActionServiceImplTest.createFailingSleepAction(id, isFatal, this.actionService);
    }

    protected static Action createFailingSleepAction(String id, boolean isFatal, ActionService actionService) throws Exception {
        Action failingAction = ActionServiceImplTest.createWorkingSleepAction(id, actionService);
        failingAction.setParameterValue("GoBang", (Serializable)Boolean.TRUE);
        failingAction.setParameterValue("failFatally", (Serializable)Boolean.valueOf(isFatal));
        return failingAction;
    }

    protected Action createWorkingSleepAction() throws Exception {
        return this.createWorkingSleepAction(null);
    }

    protected Action createWorkingSleepAction(String id) throws Exception {
        return ActionServiceImplTest.createWorkingSleepAction(id, this.actionService);
    }

    protected static Action createWorkingSleepAction(String id, ActionService actionService) throws Exception {
        CancellableSleepAction workingAction = new CancellableSleepAction(actionService.createAction("sleep-action"));
        workingAction.setTrackStatus(Boolean.TRUE);
        if (id != null) {
            Field idF = ParameterizedItemImpl.class.getDeclaredField("id");
            idF.setAccessible(true);
            idF.set((Object)workingAction, id);
        }
        return workingAction;
    }

    public static void assertBefore(Date before, Date after) {
        ActionServiceImplTest.assertTrue((String)(String.valueOf(before.toString()) + " not before " + after.toString()), (before.getTime() <= after.getTime() ? 1 : 0) != 0);
    }

    public static interface AsyncTest {
        public String executeTest();
    }

    protected static class CancellableSleepAction
    extends ActionImpl
    implements CancellableAction {
        public CancellableSleepAction(Action action) {
            super(action);
            this.setTrackStatus(Boolean.TRUE);
        }
    }

    public static class SleepActionExecuter
    extends ActionExecuterAbstractBase {
        public static final String NAME = "sleep-action";
        public static final String GO_BANG = "GoBang";
        public static final String FAIL_FATALLY = "failFatally";
        private int sleepMs;
        private Thread executingThread;
        private int timesExecuted = 0;
        private ActionTrackingService actionTrackingService;

        private void incrementTimesExecutedCount() {
            ++this.timesExecuted;
        }

        public int getTimesExecuted() {
            return this.timesExecuted;
        }

        public void resetTimesExecuted() {
            this.timesExecuted = 0;
        }

        public static void registerIfNeeded(ApplicationContext ctx) {
            if (!ctx.containsBean(NAME)) {
                SleepActionExecuter executor = new SleepActionExecuter();
                executor.setTrackStatus(true);
                executor.actionTrackingService = (ActionTrackingService)ctx.getBean("actionTrackingService");
                ((ConfigurableApplicationContext)ctx).getBeanFactory().registerSingleton(NAME, (Object)executor);
            }
        }

        public Thread getExecutingThread() {
            return this.executingThread;
        }

        public int getSleepMs() {
            return this.sleepMs;
        }

        public void setSleepMs(int sleepMs) {
            this.sleepMs = sleepMs;
        }

        protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        }

        protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
            CancellableSleepAction ca;
            boolean cancelled;
            block8: {
                this.executingThread = Thread.currentThread();
                try {
                    try {
                        Thread.sleep(this.sleepMs);
                    }
                    catch (InterruptedException interruptedException) {
                        this.incrementTimesExecutedCount();
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    this.incrementTimesExecutedCount();
                    throw throwable;
                }
                this.incrementTimesExecutedCount();
            }
            Boolean fail = (Boolean)action.getParameterValue(GO_BANG);
            Boolean failFatally = (Boolean)action.getParameterValue(FAIL_FATALLY);
            if (fail != null && fail.booleanValue()) {
                if (failFatally != null && failFatally.booleanValue()) {
                    throw new RuntimeException("Bang!");
                }
                throw new ActionServiceTransientException("Pop!");
            }
            if (action instanceof CancellableSleepAction && (cancelled = this.actionTrackingService.isCancellationRequested((CancellableAction)(ca = (CancellableSleepAction)action)))) {
                throw new ActionCancelledException((CancellableAction)ca);
            }
        }
    }

    public static class SleepActionFilter
    extends AbstractAsynchronousActionFilter {
        public int compare(OngoingAsyncAction sae1, OngoingAsyncAction sae2) {
            return 0;
        }
    }

    public static class TransientFailActionExecuter
    extends ActionExecuterAbstractBase {
        public static final String NAME = "transient-fail-action";
        private ActionTrackingService actionTrackingService;

        public static void registerIfNeeded(ConfigurableApplicationContext ctx) {
            if (!ctx.containsBean(NAME)) {
                TransientFailActionExecuter executor = new TransientFailActionExecuter();
                executor.setTrackStatus(true);
                executor.actionTrackingService = (ActionTrackingService)ctx.getBean("actionTrackingService");
                ctx.getBeanFactory().registerSingleton(NAME, (Object)executor);
            }
        }

        protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        }

        protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
            throw new ActionServiceTransientException("action failed intentionally in " + TransientFailActionExecuter.class.getSimpleName());
        }
    }
}

