/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.alfresco.repo.admin.patch.PatchService;
import org.alfresco.repo.admin.patch.impl.SchemaUpgradeScriptPatch;
import org.alfresco.repo.domain.dialect.Dialect;
import org.alfresco.util.DialectUtil;
import org.alfresco.util.schemacomp.Result;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class SchemaDifferenceHelper {
    private static Log logger = LogFactory.getLog(SchemaDifferenceHelper.class);
    private Dialect dialect;
    private PatchService patchService;
    private List<SchemaUpgradeScriptPatch> optionalUpgradePatches;
    private ResourcePatternResolver rpr = new PathMatchingResourcePatternResolver(this.getClass().getClassLoader());

    public SchemaDifferenceHelper(Dialect dialect, PatchService patchService) {
        this.dialect = dialect;
        this.patchService = patchService;
        this.optionalUpgradePatches = new ArrayList<SchemaUpgradeScriptPatch>(4);
    }

    public SchemaDifferenceHelper(Dialect dialect, PatchService patchService, List<SchemaUpgradeScriptPatch> upgradePatches) {
        this.dialect = dialect;
        this.patchService = patchService;
        this.optionalUpgradePatches = upgradePatches;
    }

    public void addUpgradeScriptPatch(SchemaUpgradeScriptPatch patch) {
        if (patch.isIgnored()) {
            this.optionalUpgradePatches.add(patch);
        }
    }

    public String findPatchCausingDifference(Result result) {
        String problemText = this.describe(result);
        for (SchemaUpgradeScriptPatch patch : this.optionalUpgradePatches) {
            if (this.isPatchApplied(patch)) continue;
            List<String> problemPatterns = this.getProblemsPatterns(patch);
            for (String problemPattern : problemPatterns) {
                if (!problemText.matches(problemPattern)) continue;
                return patch.getId();
            }
        }
        return null;
    }

    private boolean isPatchApplied(SchemaUpgradeScriptPatch patch) {
        return this.patchService.getPatch(patch.getId()) != null;
    }

    protected Resource getDialectResource(String resourceUrl) {
        if (resourceUrl == null) {
            return null;
        }
        return DialectUtil.getDialectResource(this.rpr, this.dialect.getClass(), resourceUrl);
    }

    private List<String> getProblemsPatterns(SchemaUpgradeScriptPatch patch) {
        ArrayList<String> optionalProblems = new ArrayList<String>();
        String problemFileUrl = patch.getProblemPatternsFileUrl();
        Resource problemFile = this.getDialectResource(problemFileUrl);
        if (problemFile != null) {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(problemFile.getInputStream(), StandardCharsets.UTF_8));){
                    String line = reader.readLine();
                    while (line != null) {
                        optionalProblems.add(line);
                        line = reader.readLine();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception ex) {
                logger.error((Object)("Error while parsing problems patterns for patch " + patch.getId() + ex));
            }
        }
        return optionalProblems;
    }

    protected String describe(Result result) {
        return result.describe(Locale.ENGLISH);
    }
}

