/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.module;

import org.alfresco.repo.module.AbstractModuleComponent;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoggerModuleComponent
extends AbstractModuleComponent {
    private LogLevel logLevel = LogLevel.INFO;
    private String message;

    public void setLogLevel(String logLevel) {
        this.logLevel = LogLevel.valueOf(logLevel);
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    protected void checkProperties() {
        PropertyCheck.mandatory((Object)this, (String)"message", (Object)this.message);
        super.checkProperties();
    }

    @Override
    protected void executeInternal() throws Throwable {
        String moduleId = super.getModuleId();
        String name = super.getName();
        Log logger = LogFactory.getLog((String)(String.valueOf(moduleId) + "." + name));
        switch (this.logLevel) {
            case INFO: {
                logger.info((Object)this.message);
                break;
            }
            case WARN: {
                logger.warn((Object)this.message);
                break;
            }
            case ERROR: {
                logger.error((Object)this.message);
            }
        }
    }

    private static enum LogLevel {
        INFO,
        WARN,
        ERROR;

    }
}

