/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache.lookup;

import java.io.Serializable;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.cache.lookup.CacheRegionKey;
import org.alfresco.repo.cache.lookup.CacheRegionValueKey;
import org.alfresco.repo.domain.control.ControlDAO;
import org.alfresco.util.Pair;
import org.springframework.extensions.surf.util.ParameterCheck;

public class EntityLookupCache<K extends Serializable, V, VK extends Serializable> {
    private static final Serializable VALUE_NULL = "@@VALUE_NULL@@";
    private static final Serializable VALUE_NOT_FOUND = "@@VALUE_NOT_FOUND@@";
    private static final String CACHE_REGION_DEFAULT = "DEFAULT";
    private final SimpleCache<Serializable, Object> cache;
    private final EntityLookupCallbackDAO<K, V, VK> entityLookup;
    private final String cacheRegion;

    public EntityLookupCache(EntityLookupCallbackDAO<K, V, VK> entityLookup) {
        this(null, CACHE_REGION_DEFAULT, entityLookup);
    }

    public EntityLookupCache(SimpleCache cache, EntityLookupCallbackDAO<K, V, VK> entityLookup) {
        this(cache, CACHE_REGION_DEFAULT, entityLookup);
    }

    public EntityLookupCache(SimpleCache cache, String cacheRegion, EntityLookupCallbackDAO<K, V, VK> entityLookup) {
        ParameterCheck.mandatory((String)"cacheRegion", (Object)cacheRegion);
        ParameterCheck.mandatory((String)"entityLookup", entityLookup);
        this.cache = cache;
        this.cacheRegion = cacheRegion;
        this.entityLookup = entityLookup;
    }

    public Pair<K, V> getByKey(K key) {
        if (key == null) {
            throw new IllegalArgumentException("An entity lookup key may not be null");
        }
        if (this.cache == null) {
            return this.entityLookup.findByKey(key);
        }
        CacheRegionKey keyCacheKey = new CacheRegionKey(this.cacheRegion, (Serializable)key);
        Object value = this.cache.get((Serializable)keyCacheKey);
        if (value != null) {
            if (value.equals(VALUE_NOT_FOUND)) {
                return null;
            }
            if (value.equals(VALUE_NULL)) {
                return new Pair(key, null);
            }
            return new Pair(key, value);
        }
        Pair<K, V> entityPair = this.entityLookup.findByKey(key);
        if (entityPair == null) {
            this.cache.put((Serializable)keyCacheKey, (Object)VALUE_NOT_FOUND);
        } else {
            Serializable valueKey;
            value = entityPair.getSecond();
            Serializable serializable = valueKey = value == null ? VALUE_NULL : this.entityLookup.getValueKey(value);
            if (valueKey != null) {
                CacheRegionValueKey valueCacheKey = new CacheRegionValueKey(this.cacheRegion, valueKey);
                this.cache.put((Serializable)valueCacheKey, key);
            }
            this.cache.put((Serializable)keyCacheKey, value == null ? VALUE_NULL : value);
        }
        return entityPair;
    }

    public List<Pair<K, V>> getByKeys(List<K> keys) {
        Object value;
        if (keys == null || keys.isEmpty()) {
            throw new IllegalArgumentException("An entity lookup key list may not be null or empty");
        }
        ArrayList<Serializable> filteredKeys = new ArrayList<Serializable>(keys.size());
        for (Serializable k : keys) {
            if (k == null) continue;
            filteredKeys.add(k);
        }
        if (this.cache == null) {
            return this.entityLookup.findByKeys(filteredKeys);
        }
        ArrayList<Pair<K, V>> results = new ArrayList<Pair<K, V>>(filteredKeys.size());
        HashMap<Serializable, CacheRegionKey> keysToResolve = new HashMap<Serializable, CacheRegionKey>();
        for (Serializable key : filteredKeys) {
            CacheRegionKey keyCacheKey = new CacheRegionKey(this.cacheRegion, key);
            value = this.cache.get((Serializable)keyCacheKey);
            if (value != null) {
                if (value.equals(VALUE_NOT_FOUND)) continue;
                if (value.equals(VALUE_NULL)) {
                    results.add(new Pair((Object)key, null));
                    continue;
                }
                results.add(new Pair((Object)key, value));
                continue;
            }
            keysToResolve.put(key, keyCacheKey);
        }
        List<Pair<K, V>> entityPairs = this.entityLookup.findByKeys(new ArrayList(keysToResolve.keySet()));
        if (entityPairs != null && !entityPairs.isEmpty()) {
            for (Pair<K, V> entityPair : entityPairs) {
                Serializable valueKey;
                value = entityPair.getSecond();
                Serializable serializable = valueKey = value == null ? VALUE_NULL : this.entityLookup.getValueKey(value);
                if (valueKey != null) {
                    CacheRegionValueKey valueCacheKey = new CacheRegionValueKey(this.cacheRegion, valueKey);
                    this.cache.put((Serializable)valueCacheKey, entityPair.getFirst());
                }
                this.cache.put((Serializable)new CacheRegionKey(this.cacheRegion, (Serializable)entityPair.getFirst()), value == null ? VALUE_NULL : value);
                results.add(entityPair);
            }
        }
        return results;
    }

    public Pair<K, V> getByValue(V value) {
        Serializable valueKey;
        if (this.cache == null) {
            return this.entityLookup.findByValue(value);
        }
        Serializable serializable = valueKey = value == null ? VALUE_NULL : this.entityLookup.getValueKey(value);
        if (valueKey == null) {
            return this.entityLookup.findByValue(value);
        }
        CacheRegionValueKey valueCacheKey = new CacheRegionValueKey(this.cacheRegion, valueKey);
        Serializable key = (Serializable)this.cache.get((Serializable)valueCacheKey);
        if (key != null) {
            if (key.equals(VALUE_NOT_FOUND)) {
                return null;
            }
            return this.getByKey(key);
        }
        Pair<K, V> entityPair = this.entityLookup.findByValue(value);
        if (entityPair == null) {
            this.cache.put((Serializable)valueCacheKey, (Object)VALUE_NOT_FOUND);
        } else {
            key = (Serializable)entityPair.getFirst();
            this.cache.put((Serializable)valueCacheKey, (Object)key);
            this.cache.put((Serializable)new CacheRegionKey(this.cacheRegion, key), entityPair.getSecond() == null ? VALUE_NULL : entityPair.getSecond());
        }
        return entityPair;
    }

    public List<Pair<K, V>> getByValues(List<V> values) {
        Serializable key;
        if (values == null || values.isEmpty()) {
            throw new IllegalArgumentException("An entity lookup value list may not be null or empty");
        }
        ArrayList<V> filteredValues = new ArrayList<V>(values.size());
        for (V v : values) {
            if (v == null) continue;
            filteredValues.add(v);
        }
        if (this.cache == null) {
            return this.entityLookup.findByValues(filteredValues);
        }
        ArrayList<Pair<K, V>> results = new ArrayList<Pair<K, V>>(filteredValues.size());
        ArrayList valuesToFind = new ArrayList(filteredValues.size());
        ArrayList<Pair> lookInCache = new ArrayList<Pair>(filteredValues.size());
        ArrayList<Object> valuesToResolve = new ArrayList<Object>(filteredValues.size());
        ArrayList<Serializable> keysToGet = new ArrayList<Serializable>(filteredValues.size());
        for (Object value : filteredValues) {
            Serializable valueKey;
            Serializable serializable = valueKey = value == null ? VALUE_NULL : this.entityLookup.getValueKey(value);
            if (valueKey == null) {
                valuesToFind.add(value);
                continue;
            }
            lookInCache.add(new Pair((Object)valueKey, value));
        }
        if (!valuesToFind.isEmpty()) {
            results.addAll(this.entityLookup.findByValues(valuesToFind));
        }
        for (Pair valuePair : lookInCache) {
            CacheRegionValueKey valueCacheKey = new CacheRegionValueKey(this.cacheRegion, (Serializable)valuePair.getFirst());
            key = (Serializable)this.cache.get((Serializable)valueCacheKey);
            if (key != null) {
                if (key.equals(VALUE_NOT_FOUND)) continue;
                keysToGet.add(key);
                continue;
            }
            valuesToResolve.add(valuePair.getSecond());
        }
        if (!keysToGet.isEmpty()) {
            results.addAll(this.getByKeys(keysToGet));
        }
        if (!valuesToResolve.isEmpty()) {
            List<Pair<K, V>> entityPairs = this.entityLookup.findByValues(valuesToResolve);
            for (Pair<K, V> entityPair : entityPairs) {
                if (entityPair == null) continue;
                key = (Serializable)entityPair.getFirst();
                this.cache.put((Serializable)new CacheRegionValueKey(this.cacheRegion, (Serializable)entityPair.getSecond()), (Object)key);
                this.cache.put((Serializable)new CacheRegionKey(this.cacheRegion, key), entityPair.getSecond() == null ? VALUE_NULL : entityPair.getSecond());
                results.add(entityPair);
            }
        }
        return results;
    }

    public Pair<K, V> createOrGetByValue(V value, ControlDAO controlDAO) {
        if (controlDAO == null) {
            throw new IllegalArgumentException("The ControlDAO is required in order to perform a safe attempted insert.");
        }
        Savepoint savepoint = controlDAO.createSavepoint("EntityLookupCache.createOrGetByValue");
        try {
            Pair<K, V> entityPair = this.entityLookup.createValue(value);
            controlDAO.releaseSavepoint(savepoint);
            if (this.cache != null) {
                this.cache.put((Serializable)new CacheRegionKey(this.cacheRegion, (Serializable)entityPair.getFirst()), entityPair.getSecond() == null ? VALUE_NULL : entityPair.getSecond());
            }
            return entityPair;
        }
        catch (Exception exception) {
            controlDAO.rollbackToSavepoint(savepoint);
            return this.getOrCreateByValue(value);
        }
    }

    public Pair<K, V> getOrCreateByValue(V value) {
        Serializable valueKey;
        if (this.cache == null) {
            Pair<K, V> entityPair = this.entityLookup.findByValue(value);
            if (entityPair == null) {
                entityPair = this.entityLookup.createValue(value);
            }
            return entityPair;
        }
        Serializable serializable = valueKey = value == null ? VALUE_NULL : this.entityLookup.getValueKey(value);
        if (valueKey == null) {
            Pair<K, V> entityPair = this.entityLookup.findByValue(value);
            if (entityPair == null) {
                entityPair = this.entityLookup.createValue(value);
                this.cache.put((Serializable)new CacheRegionKey(this.cacheRegion, (Serializable)entityPair.getFirst()), entityPair.getSecond() == null ? VALUE_NULL : entityPair.getSecond());
            }
            return entityPair;
        }
        CacheRegionValueKey valueCacheKey = new CacheRegionValueKey(this.cacheRegion, valueKey);
        Serializable key = (Serializable)this.cache.get((Serializable)valueCacheKey);
        if (key != null && !key.equals(VALUE_NOT_FOUND)) {
            return this.getByKey(key);
        }
        Pair<K, V> entityPair = this.entityLookup.findByValue(value);
        if (entityPair == null) {
            entityPair = this.entityLookup.createValue(value);
        }
        key = (Serializable)entityPair.getFirst();
        this.cache.put((Serializable)valueCacheKey, (Object)key);
        this.cache.put((Serializable)new CacheRegionKey(this.cacheRegion, key), (Object)(value == null ? VALUE_NULL : value));
        return entityPair;
    }

    public int updateValue(K key, V value) {
        Serializable valueKey;
        if (this.cache == null) {
            return this.entityLookup.updateValue(key, value);
        }
        this.removeByKey(key, false);
        int updateCount = this.entityLookup.updateValue(key, value);
        if (updateCount == 0) {
            return updateCount;
        }
        Serializable serializable = valueKey = value == null ? VALUE_NULL : this.entityLookup.getValueKey(value);
        if (valueKey != null) {
            CacheRegionValueKey valueCacheKey = new CacheRegionValueKey(this.cacheRegion, valueKey);
            this.cache.put((Serializable)valueCacheKey, key);
        }
        this.cache.put((Serializable)new CacheRegionKey(this.cacheRegion, (Serializable)key), (Object)(value == null ? VALUE_NULL : value));
        return updateCount;
    }

    public K getKey(VK valueKey) {
        CacheRegionValueKey valueCacheKey = new CacheRegionValueKey(this.cacheRegion, (Serializable)valueKey);
        Serializable key = (Serializable)this.cache.get((Serializable)valueCacheKey);
        if (key != null && key.equals(VALUE_NOT_FOUND)) {
            key = null;
        }
        return (K)key;
    }

    public V getValue(K key) {
        CacheRegionKey keyCacheKey = new CacheRegionKey(this.cacheRegion, (Serializable)key);
        Object value = this.cache.get((Serializable)keyCacheKey);
        if (value == null) {
            return null;
        }
        if (value.equals(VALUE_NOT_FOUND)) {
            return null;
        }
        if (value.equals(VALUE_NULL)) {
            return null;
        }
        return (V)value;
    }

    public void setValue(K key, V value) {
        Serializable valueKey;
        if (this.cache == null) {
            return;
        }
        this.removeByKey(key, false);
        Serializable serializable = valueKey = value == null ? VALUE_NULL : this.entityLookup.getValueKey(value);
        if (valueKey != null) {
            CacheRegionValueKey valueCacheKey = new CacheRegionValueKey(this.cacheRegion, valueKey);
            this.cache.put((Serializable)valueCacheKey, key);
        }
        this.cache.put((Serializable)new CacheRegionKey(this.cacheRegion, (Serializable)key), (Object)(value == null ? VALUE_NULL : value));
    }

    public void setValues(Map<K, V> keyValues) {
        if (this.cache == null) {
            return;
        }
        List keys = keyValues.keySet().stream().collect(Collectors.toList());
        this.removeByKeys(keys, false);
    }

    public int deleteByKey(K key) {
        if (this.cache == null) {
            return this.entityLookup.deleteByKey(key);
        }
        this.removeByKey(key);
        return this.entityLookup.deleteByKey(key);
    }

    public int deleteByValue(V value) {
        if (this.cache == null) {
            return this.entityLookup.deleteByValue(value);
        }
        this.removeByValue(value);
        return this.entityLookup.deleteByValue(value);
    }

    public void removeByKey(K key) {
        if (this.cache == null) {
            return;
        }
        this.removeByKey(key, true);
    }

    public void removeByKeys(Collection<K> keys) {
        if (this.cache == null) {
            return;
        }
        this.removeByKeys(keys, true);
    }

    private void removeByKey(K key, boolean removeKey) {
        VK valueKey;
        CacheRegionKey keyCacheKey = new CacheRegionKey(this.cacheRegion, (Serializable)key);
        Object value = this.cache.get((Serializable)keyCacheKey);
        if (value != null && !value.equals(VALUE_NOT_FOUND) && (valueKey = this.entityLookup.getValueKey(value)) != null) {
            CacheRegionValueKey valueCacheKey = new CacheRegionValueKey(this.cacheRegion, (Serializable)valueKey);
            this.cache.remove((Serializable)valueCacheKey);
        }
        if (removeKey) {
            this.cache.remove((Serializable)keyCacheKey);
        }
    }

    private void removeByKeys(Collection<K> keys, boolean removeKey) {
        List<VK> valueKeys;
        ArrayList<Object> values = new ArrayList<Object>();
        for (Serializable key : keys) {
            CacheRegionKey keyCacheKey = new CacheRegionKey(this.cacheRegion, key);
            Object value = this.cache.get((Serializable)keyCacheKey);
            if (value != null && !value.equals(VALUE_NOT_FOUND)) {
                values.add(value);
            }
            if (!removeKey) continue;
            this.cache.remove((Serializable)keyCacheKey);
        }
        if (!values.isEmpty() && (valueKeys = this.entityLookup.getValueKeys(values)) != null && !valueKeys.isEmpty()) {
            for (Serializable vk : valueKeys) {
                CacheRegionValueKey valueCacheKey = new CacheRegionValueKey(this.cacheRegion, vk);
                this.cache.remove((Serializable)valueCacheKey);
            }
        }
    }

    public void removeByValue(V value) {
        Serializable valueKey;
        if (this.cache == null) {
            return;
        }
        Serializable serializable = valueKey = value == null ? VALUE_NULL : this.entityLookup.getValueKey(value);
        if (valueKey == null) {
            return;
        }
        CacheRegionValueKey valueCacheKey = new CacheRegionValueKey(this.cacheRegion, valueKey);
        Serializable key = (Serializable)this.cache.get((Serializable)valueCacheKey);
        if (key != null && !key.equals(VALUE_NOT_FOUND)) {
            CacheRegionKey keyCacheKey = new CacheRegionKey(this.cacheRegion, key);
            this.cache.remove((Serializable)keyCacheKey);
        }
        this.cache.remove((Serializable)valueCacheKey);
    }

    public void clear() {
        if (this.cache == null) {
            return;
        }
        this.cache.clear();
    }

    public static interface EntityLookupCallbackDAO<K1 extends Serializable, V1, VK1 extends Serializable> {
        public VK1 getValueKey(V1 var1);

        public List<VK1> getValueKeys(List<V1> var1);

        public Pair<K1, V1> findByKey(K1 var1);

        public List<Pair<K1, V1>> findByKeys(List<K1> var1);

        public Pair<K1, V1> findByValue(V1 var1);

        public List<Pair<K1, V1>> findByValues(List<V1> var1);

        public Pair<K1, V1> createValue(V1 var1);

        public int updateValue(K1 var1, V1 var2);

        public int deleteByKey(K1 var1);

        public int deleteByValue(V1 var1);
    }

    public static abstract class EntityLookupCallbackDAOAdaptor<K2 extends Serializable, V2, VK2 extends Serializable>
    implements EntityLookupCallbackDAO<K2, V2, VK2> {
        @Override
        public Pair<K2, V2> findByValue(V2 value) {
            return null;
        }

        public List<Pair<K2, V2>> findByValues(V2 value) {
            return Collections.emptyList();
        }

        @Override
        public VK2 getValueKey(V2 value) {
            return null;
        }

        @Override
        public List<VK2> getValueKeys(List<V2> values) {
            return Collections.emptyList();
        }

        @Override
        public int updateValue(K2 key, V2 value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int deleteByKey(K2 key) {
            throw new UnsupportedOperationException("Entity deletion by key is not supported");
        }

        @Override
        public int deleteByValue(V2 value) {
            throw new UnsupportedOperationException("Entity deletion by value is not supported");
        }
    }
}

