/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.blog;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.query.CannedQueryFactory;
import org.alfresco.query.CannedQueryResults;
import org.alfresco.query.EmptyPagingResults;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.blog.BlogPostInfoImpl;
import org.alfresco.repo.blog.cannedqueries.BlogEntity;
import org.alfresco.repo.blog.cannedqueries.DraftsAndPublishedBlogPostsCannedQuery;
import org.alfresco.repo.blog.cannedqueries.DraftsAndPublishedBlogPostsCannedQueryFactory;
import org.alfresco.repo.blog.cannedqueries.GetBlogPostsCannedQuery;
import org.alfresco.repo.blog.cannedqueries.GetBlogPostsCannedQueryFactory;
import org.alfresco.repo.search.LuceneUtils;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.site.SiteServiceImpl;
import org.alfresco.service.cmr.blog.BlogPostInfo;
import org.alfresco.service.cmr.blog.BlogService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.DuplicateChildNodeNameException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ISO9075;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.registry.NamedObjectRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.ConcurrencyFailureException;

public class BlogServiceImpl
implements BlogService {
    public static final String BLOG_COMPONENT = "blog";
    private static final int MIN_NUMBER_OF_PAGES_FOR_THE_USER_TO_LOOP_THROUGH = 10;
    private static Log logger = LogFactory.getLog(BlogServiceImpl.class);
    private NamedObjectRegistry<CannedQueryFactory<BlogPostInfo>> cannedQueryRegistry;
    private GetBlogPostsCannedQueryFactory draftPostsCannedQueryFactory;
    private GetBlogPostsCannedQueryFactory publishedPostsCannedQueryFactory;
    private GetBlogPostsCannedQueryFactory publishedExternallyPostsCannedQueryFactory;
    private DraftsAndPublishedBlogPostsCannedQueryFactory draftsAndPublishedBlogPostsCannedQueryFactory;
    private ContentService contentService;
    private DictionaryService dictionaryService;
    private NamespaceService namespaceService;
    private NodeService nodeService;
    private SiteService siteService;
    private TransactionService transactionService;
    private PermissionService permissionService;
    private TaggingService taggingService;
    private SearchService searchService;

    public void setCannedQueryRegistry(NamedObjectRegistry<CannedQueryFactory<BlogPostInfo>> cannedQueryRegistry) {
        this.cannedQueryRegistry = cannedQueryRegistry;
    }

    public void setDraftBlogPostsCannedQueryFactory(GetBlogPostsCannedQueryFactory cannedQueryFactory) {
        this.draftPostsCannedQueryFactory = cannedQueryFactory;
    }

    public void setPublishedBlogPostsCannedQueryFactory(GetBlogPostsCannedQueryFactory cannedQueryFactory) {
        this.publishedPostsCannedQueryFactory = cannedQueryFactory;
    }

    public void setPublishedExternallyBlogPostsCannedQueryFactory(GetBlogPostsCannedQueryFactory cannedQueryFactory) {
        this.publishedExternallyPostsCannedQueryFactory = cannedQueryFactory;
    }

    public void setDraftsAndPublishedBlogPostsCannedQueryFactory(DraftsAndPublishedBlogPostsCannedQueryFactory cannedQueryFactory) {
        this.draftsAndPublishedBlogPostsCannedQueryFactory = cannedQueryFactory;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setTaggingService(TaggingService taggingService) {
        this.taggingService = taggingService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    protected NodeRef getSiteBlogContainer(String siteShortName, boolean create) {
        return SiteServiceImpl.getSiteContainer(siteShortName, BLOG_COMPONENT, create, this.siteService, this.transactionService, this.taggingService);
    }

    private BlogPostInfo buildBlogPost(NodeRef nodeRef, NodeRef parentNodeRef, String postName) {
        BlogPostInfoImpl post = new BlogPostInfoImpl(nodeRef, parentNodeRef, postName);
        Map props = this.nodeService.getProperties(nodeRef);
        post.setTitle((String)props.get(ContentModel.PROP_TITLE));
        return post;
    }

    @Override
    public boolean isDraftBlogPost(NodeRef blogPostNode) {
        return this.nodeService.getProperty(blogPostNode, ContentModel.PROP_PUBLISHED) == null;
    }

    @Override
    public BlogPostInfo createBlogPost(String siteShortName, String blogTitle, String blogContent, boolean isDraft) {
        NodeRef container = this.getSiteBlogContainer(siteShortName, true);
        return this.createBlogPost(container, blogTitle, blogContent, isDraft);
    }

    @Override
    public BlogPostInfo createBlogPost(NodeRef blogContainerNode, String blogTitle, String blogContent, boolean isDraft) {
        String nodeName = this.getUniqueChildName(blogContainerNode, "post");
        HashMap<QName, String> nodeProps = new HashMap<QName, String>();
        nodeProps.put(ContentModel.PROP_NAME, nodeName);
        nodeProps.put(ContentModel.PROP_TITLE, blogTitle);
        QName assocName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)nodeName);
        ChildAssociationRef postNode = null;
        try {
            postNode = this.nodeService.createNode(blogContainerNode, ContentModel.ASSOC_CONTAINS, assocName, ContentModel.TYPE_CONTENT, nodeProps);
        }
        catch (DuplicateChildNodeNameException duplicateChildNodeNameException) {
            throw new ConcurrencyFailureException("Blog post name already used: " + nodeName);
        }
        ContentWriter writer = this.contentService.getWriter(postNode.getChildRef(), ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/html");
        writer.setEncoding("UTF-8");
        writer.putContent(blogContent);
        if (isDraft) {
            NodeRef draft = postNode.getChildRef();
            this.permissionService.setInheritParentPermissions(draft, false);
            String creator = (String)((Object)this.nodeService.getProperty(draft, ContentModel.PROP_CREATOR));
            this.permissionService.setPermission(draft, creator, this.permissionService.getAllPermission(), true);
        } else {
            this.setOrUpdateReleasedAndUpdatedDates(postNode.getChildRef());
        }
        BlogPostInfoImpl post = new BlogPostInfoImpl(postNode.getChildRef(), blogContainerNode, nodeName);
        post.setTitle(blogTitle);
        return post;
    }

    @Override
    public BlogPostInfo updateBlogPost(BlogPostInfo post) {
        if (post.getNodeRef() == null) {
            throw new IllegalArgumentException("Can't update a post that was never persisted, call create instead");
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public void deleteBlogPost(BlogPostInfo post) {
        if (post.getNodeRef() == null) {
            throw new IllegalArgumentException("Can't delete a post that was never persisted");
        }
        this.nodeService.deleteNode(post.getNodeRef());
    }

    @Override
    public BlogPostInfo getForNodeRef(NodeRef nodeRef) {
        QName type = this.nodeService.getType(nodeRef);
        if (type.equals((Object)ContentModel.TYPE_CONTENT)) {
            ChildAssociationRef ref = this.nodeService.getPrimaryParent(nodeRef);
            String postName = ref.getQName().getLocalName();
            NodeRef container = ref.getParentRef();
            return this.buildBlogPost(nodeRef, container, postName);
        }
        logger.debug((Object)("Invalid type " + type + " found"));
        return null;
    }

    @Override
    public BlogPostInfo getBlogPost(String siteShortName, String postName) {
        NodeRef container = this.getSiteBlogContainer(siteShortName, false);
        if (container == null) {
            return null;
        }
        return this.getBlogPost(container, postName);
    }

    @Override
    public BlogPostInfo getBlogPost(NodeRef parentNodeRef, String postName) {
        NodeRef postNode;
        try {
            postNode = this.nodeService.getChildByName(parentNodeRef, ContentModel.ASSOC_CONTAINS, postName);
        }
        catch (AccessDeniedException accessDeniedException) {
            postNode = null;
        }
        if (postNode != null) {
            return this.buildBlogPost(postNode, parentNodeRef, postName);
        }
        return null;
    }

    @Override
    public PagingResults<BlogPostInfo> getDrafts(String siteShortName, String username, PagingRequest pagingReq) {
        NodeRef container = this.getSiteBlogContainer(siteShortName, false);
        if (container == null) {
            return new EmptyPagingResults();
        }
        return this.getDrafts(container, username, pagingReq);
    }

    @Override
    public PagingResults<BlogPostInfo> getDrafts(NodeRef blogContainerNode, String username, PagingRequest pagingReq) {
        ParameterCheck.mandatory((String)"blogContainerNode", (Object)blogContainerNode);
        ParameterCheck.mandatory((String)"pagingReq", (Object)pagingReq);
        GetBlogPostsCannedQuery cq = (GetBlogPostsCannedQuery)this.draftPostsCannedQueryFactory.getGetDraftsCannedQuery(blogContainerNode, username, pagingReq);
        CannedQueryResults results = cq.execute();
        return this.wrap((CannedQueryResults<BlogEntity>)results, blogContainerNode);
    }

    @Override
    public PagingResults<BlogPostInfo> getPublished(String siteShortName, Date fromDate, Date toDate, String byUser, PagingRequest pagingReq) {
        NodeRef container = this.getSiteBlogContainer(siteShortName, false);
        if (container == null) {
            return new EmptyPagingResults();
        }
        return this.getPublished(container, fromDate, toDate, byUser, pagingReq);
    }

    @Override
    public PagingResults<BlogPostInfo> getPublished(NodeRef blogContainerNode, Date fromDate, Date toDate, String byUser, PagingRequest pagingReq) {
        ParameterCheck.mandatory((String)"blogContainerNode", (Object)blogContainerNode);
        ParameterCheck.mandatory((String)"pagingReq", (Object)pagingReq);
        GetBlogPostsCannedQuery cq = (GetBlogPostsCannedQuery)this.publishedPostsCannedQueryFactory.getGetPublishedCannedQuery(blogContainerNode, fromDate, toDate, byUser, pagingReq);
        CannedQueryResults results = cq.execute();
        return this.wrap((CannedQueryResults<BlogEntity>)results, blogContainerNode);
    }

    @Override
    public PagingResults<BlogPostInfo> getMyDraftsAndAllPublished(NodeRef blogContainerNode, Date createdFrom, Date createdTo, PagingRequest pagingReq) {
        ParameterCheck.mandatory((String)"blogContainerNode", (Object)blogContainerNode);
        ParameterCheck.mandatory((String)"pagingReq", (Object)pagingReq);
        String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        DraftsAndPublishedBlogPostsCannedQuery cq = (DraftsAndPublishedBlogPostsCannedQuery)this.draftsAndPublishedBlogPostsCannedQueryFactory.getCannedQuery(blogContainerNode, createdFrom, createdTo, currentUser, pagingReq);
        CannedQueryResults results = cq.execute();
        return this.wrap((CannedQueryResults<BlogEntity>)results, blogContainerNode);
    }

    private String getUniqueChildName(NodeRef parentNode, String prefix) {
        return String.valueOf(prefix) + "-" + System.currentTimeMillis();
    }

    private void setOrUpdateReleasedAndUpdatedDates(NodeRef blogPostNode) {
        if (!this.nodeService.hasAspect(blogPostNode, ContentModel.ASPECT_SYNDICATION)) {
            this.nodeService.addAspect(blogPostNode, ContentModel.ASPECT_SYNDICATION, null);
        }
        if (!this.permissionService.getInheritParentPermissions(blogPostNode)) {
            String creator = (String)((Object)this.nodeService.getProperty(blogPostNode, ContentModel.PROP_CREATOR));
            this.permissionService.deletePermission(blogPostNode, creator, this.permissionService.getAllPermission());
            this.permissionService.setInheritParentPermissions(blogPostNode, true);
        }
        if (this.nodeService.getProperty(blogPostNode, ContentModel.PROP_PUBLISHED) == null) {
            this.nodeService.setProperty(blogPostNode, ContentModel.PROP_PUBLISHED, (Serializable)new Date());
        } else {
            this.nodeService.setProperty(blogPostNode, ContentModel.PROP_UPDATED, (Serializable)new Date());
        }
    }

    @Override
    public PagingResults<BlogPostInfo> findBlogPosts(String siteShortName, BlogService.RangedDateProperty dateRange, String tag, PagingRequest pagingReq) {
        NodeRef container = this.getSiteBlogContainer(siteShortName, false);
        if (container == null) {
            return new EmptyPagingResults();
        }
        return this.findBlogPosts(container, dateRange, tag, pagingReq);
    }

    @Override
    public PagingResults<BlogPostInfo> findBlogPosts(final NodeRef blogContainerNode, BlogService.RangedDateProperty dateRange, String tag, final PagingRequest pagingReq) {
        StringBuilder luceneQuery = new StringBuilder();
        luceneQuery.append("+TYPE:\"").append(ContentModel.TYPE_CONTENT).append("\" ").append("+PARENT:\"").append(blogContainerNode.toString()).append("\" ");
        if (tag != null && !tag.trim().isEmpty()) {
            luceneQuery.append("+PATH:\"/cm:taggable/cm:").append(ISO9075.encode((String)tag)).append("/member\"");
        }
        if (dateRange != null) {
            luceneQuery.append(this.createDateRangeQuery(dateRange.getFromDate(), dateRange.getToDate(), dateRange.getDateProperty()));
        }
        SearchParameters sp = new SearchParameters();
        sp.addStore(blogContainerNode.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery(luceneQuery.toString());
        sp.addSort(ContentModel.PROP_PUBLISHED.toString(), false);
        sp.setMaxItems(pagingReq.getMaxItems() * 10);
        sp.setSkipCount(pagingReq.getSkipCount());
        PagingResults<BlogPostInfo> results = null;
        try (ResultSet luceneResults = null;){
            final ResultSet finalLuceneResults = luceneResults = this.searchService.query(sp);
            final List nodeRefs = finalLuceneResults.getNodeRefs().subList(0, Math.min(pagingReq.getMaxItems(), finalLuceneResults.length()));
            results = new PagingResults<BlogPostInfo>(){

                public List<BlogPostInfo> getPage() {
                    ArrayList<BlogPostInfo> blogPostInfos = new ArrayList<BlogPostInfo>(nodeRefs.size());
                    for (NodeRef nodeRef : nodeRefs) {
                        String postName = (String)((Object)BlogServiceImpl.this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
                        blogPostInfos.add(new BlogPostInfoImpl(nodeRef, blogContainerNode, postName));
                    }
                    return blogPostInfos;
                }

                public String getQueryExecutionId() {
                    return null;
                }

                public Pair<Integer, Integer> getTotalResultCount() {
                    long totalResultCount = finalLuceneResults.getNumberFound();
                    return new Pair((Object)((int)totalResultCount), (Object)((int)totalResultCount));
                }

                public boolean hasMoreItems() {
                    return finalLuceneResults.length() > pagingReq.getMaxItems();
                }
            };
        }
        return results;
    }

    private PagingResults<BlogPostInfo> wrap(final CannedQueryResults<BlogEntity> results, final NodeRef containerNodeRef) {
        return new PagingResults<BlogPostInfo>(){

            public String getQueryExecutionId() {
                return results.getQueryExecutionId();
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                return results.getTotalResultCount();
            }

            public boolean hasMoreItems() {
                return results.hasMoreItems();
            }

            public List<BlogPostInfo> getPage() {
                List entities = results.getPage();
                ArrayList<BlogPostInfo> posts = new ArrayList<BlogPostInfo>(entities.size());
                for (BlogEntity entity : entities) {
                    posts.add(new BlogPostInfoImpl(entity.getNodeRef(), containerNodeRef, entity.getName()));
                }
                return posts;
            }
        };
    }

    private String createDateRangeQuery(Date fromDate, Date toDate, QName dateProperty) {
        return LuceneUtils.createDateRangeQuery(fromDate, toDate, dateProperty, this.dictionaryService, this.namespaceService);
    }
}

