/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.alfresco.filesys.repo.ContentComparator;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hslf.usermodel.HSLFSlideShowImpl;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.EntryUtils;
import org.apache.poi.poifs.filesystem.FilteringDirectoryNode;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class CIFSContentComparator
implements ContentComparator {
    private Map<String, ContentComparator> customComparators = new HashMap<String, ContentComparator>();
    private static final Log logger = LogFactory.getLog(CIFSContentComparator.class);

    public void init() {
        this.customComparators.put("application/vnd.ms-project", new MPPContentComparator());
        this.customComparators.put("application/vnd.ms-excel", new XLSContentComparator());
        this.customComparators.put("application/vnd.ms-powerpoint", new PPTContentComparator());
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean isContentEqual(ContentReader existingContent, File newFile) {
        String mimetype = existingContent.getMimetype();
        logger.debug((Object)("isContentEqual mimetype=" + mimetype));
        long newSize = newFile.length();
        ContentComparator custom = this.customComparators.get(mimetype);
        if (custom == null) {
            boolean bl;
            InputStream leftIs;
            BufferedInputStream rightIs;
            block23: {
                if (existingContent.getSize() != newSize) {
                    logger.debug((Object)"generic comparision, size is different - not equal");
                    return false;
                }
                rightIs = null;
                leftIs = null;
                rightIs = new BufferedInputStream(new FileInputStream(newFile));
                leftIs = existingContent.getContentInputStream();
                boolean retVal = EqualsHelper.binaryStreamEquals((InputStream)leftIs, (InputStream)rightIs);
                rightIs = null;
                leftIs = null;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("generic comparision, binary content comparison equal=" + retVal));
                }
                bl = retVal;
                if (leftIs == null) break block23;
                try {
                    leftIs.close();
                }
                catch (IOException iOException) {}
            }
            if (rightIs != null) {
                try {
                    ((InputStream)rightIs).close();
                }
                catch (IOException iOException) {}
            }
            return bl;
            catch (IOException e) {
                block24: {
                    try {
                        logger.debug((Object)"Unable to compare contents", (Throwable)e);
                        if (leftIs == null) break block24;
                    }
                    catch (Throwable throwable) {
                        if (leftIs != null) {
                            try {
                                leftIs.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (rightIs != null) {
                            try {
                                ((InputStream)rightIs).close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    try {
                        leftIs.close();
                    }
                    catch (IOException iOException) {}
                }
                if (rightIs != null) {
                    try {
                        ((InputStream)rightIs).close();
                    }
                    catch (IOException iOException) {}
                }
                return false;
            }
        }
        return custom.isContentEqual(existingContent, newFile);
    }

    private boolean isContentIdentical(POIFSFileSystem fs1, POIFSFileSystem fs2, Collection<String> excludes) throws IOException {
        DirectoryNode de1 = fs1.getRoot();
        DirectoryNode de2 = fs2.getRoot();
        FilteringDirectoryNode fs1Filtered = new FilteringDirectoryNode((DirectoryEntry)de1, excludes);
        FilteringDirectoryNode fs2Filtered = new FilteringDirectoryNode((DirectoryEntry)de2, excludes);
        boolean retVal = EntryUtils.areDirectoriesIdentical((DirectoryEntry)fs1Filtered, (DirectoryEntry)fs2Filtered);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("returning equal=" + retVal));
        }
        return retVal;
    }

    private class MPPContentComparator
    implements ContentComparator {
        private MPPContentComparator() {
        }

        /*
         * Loose catch block
         */
        @Override
        public boolean isContentEqual(ContentReader existingContent, File newFile) {
            boolean bl;
            POIFSFileSystem fs1;
            POIFSFileSystem fs2;
            InputStream leftIs;
            block29: {
                long newSize = newFile.length();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("comparing two project files size:" + existingContent.getSize() + ", and " + newFile.length()));
                }
                if (existingContent.getSize() != newSize) {
                    logger.debug((Object)"project files are different size");
                    return false;
                }
                leftIs = null;
                HashSet<String> excludes = new HashSet<String>();
                excludes.add("Props");
                excludes.add("Props12");
                excludes.add("Props9");
                leftIs = existingContent.getContentInputStream();
                fs2 = new POIFSFileSystem(leftIs);
                fs1 = new POIFSFileSystem(newFile);
                bl = CIFSContentComparator.this.isContentIdentical(fs1, fs2, excludes);
                try {
                    fs1.close();
                }
                catch (IOException iOException) {}
                try {
                    fs2.close();
                }
                catch (IOException iOException) {}
                if (leftIs == null) break block29;
                try {
                    leftIs.close();
                }
                catch (IOException iOException) {}
            }
            return bl;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            fs1.close();
                        }
                        catch (IOException iOException) {}
                        try {
                            fs2.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    catch (ContentIOException ce) {
                        logger.debug((Object)"Unable to compare contents", (Throwable)ce);
                        if (leftIs != null) {
                            try {
                                leftIs.close();
                            }
                            catch (IOException iOException) {}
                        }
                        return false;
                    }
                    catch (IOException e) {
                        block30: {
                            try {
                                logger.debug((Object)"Unable to compare contents", (Throwable)e);
                                if (leftIs == null) break block30;
                            }
                            catch (Throwable throwable2) {
                                if (leftIs != null) {
                                    try {
                                        leftIs.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                throw throwable2;
                            }
                            try {
                                leftIs.close();
                            }
                            catch (IOException iOException) {}
                        }
                        return false;
                    }
                }
            }
        }
    }

    private class PPTContentComparator
    implements ContentComparator {
        private PPTContentComparator() {
        }

        /*
         * Loose catch block
         */
        @Override
        public boolean isContentEqual(ContentReader existingContent, File newFile) {
            InputStream leftIs;
            File tpm2;
            File tpm1;
            block79: {
                boolean bl;
                block84: {
                    HSLFSlideShowImpl slideShow2;
                    HSLFSlideShowImpl slideShow1;
                    HashSet<String> excludes;
                    block82: {
                        block83: {
                            block80: {
                                block81: {
                                    long fileSizesDifference = newFile.length() - existingContent.getSize();
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)("comparing two powerpoint files size:" + existingContent.getSize() + ", and " + newFile.length()));
                                    }
                                    tpm1 = null;
                                    tpm2 = null;
                                    leftIs = null;
                                    if (fileSizesDifference == 0L) break block79;
                                    if (fileSizesDifference <= 3072L || fileSizesDifference >= 0L) break block80;
                                    logger.debug((Object)"powerpoint files are different size");
                                    if (tpm1 == null) break block81;
                                    try {
                                        tpm1.delete();
                                    }
                                    catch (Exception exception) {}
                                }
                                if (tpm2 != null) {
                                    try {
                                        tpm2.delete();
                                    }
                                    catch (Exception exception) {}
                                }
                                if (leftIs != null) {
                                    try {
                                        leftIs.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                return false;
                            }
                            excludes = new HashSet<String>();
                            excludes.add("Current User");
                            leftIs = existingContent.getContentInputStream();
                            slideShow1 = new HSLFSlideShowImpl(leftIs);
                            slideShow2 = new HSLFSlideShowImpl((InputStream)new FileInputStream(newFile));
                            String lastEditUsername1 = slideShow1.getCurrentUserAtom().getLastEditUsername();
                            String lastEditUsername2 = slideShow2.getCurrentUserAtom().getLastEditUsername();
                            if (!lastEditUsername1.equals(lastEditUsername2)) break block82;
                            logger.debug((Object)"powerpoint files are edited by different users");
                            if (tpm1 == null) break block83;
                            try {
                                tpm1.delete();
                            }
                            catch (Exception exception) {}
                        }
                        if (tpm2 != null) {
                            try {
                                tpm2.delete();
                            }
                            catch (Exception exception) {}
                        }
                        if (leftIs != null) {
                            try {
                                leftIs.close();
                            }
                            catch (IOException iOException) {}
                        }
                        return false;
                    }
                    tpm1 = TempFileProvider.createTempFile((String)"CIFSContentComparator1", (String)"ppt");
                    FileOutputStream os = new FileOutputStream(tpm1);
                    try {
                        slideShow1.write((OutputStream)os);
                    }
                    catch (Throwable throwable) {
                        try {
                            os.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {}
                    tpm2 = TempFileProvider.createTempFile((String)"CIFSContentComparator2", (String)"ppt");
                    FileOutputStream os2 = new FileOutputStream(tpm2);
                    try {
                        slideShow2.write((OutputStream)os2);
                    }
                    catch (Throwable throwable) {
                        try {
                            os2.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        os2.close();
                    }
                    catch (IOException iOException) {}
                    POIFSFileSystem fs1 = new POIFSFileSystem(tpm1);
                    POIFSFileSystem fs2 = new POIFSFileSystem(tpm2);
                    bl = CIFSContentComparator.this.isContentIdentical(fs1, fs2, excludes);
                    if (tpm1 == null) break block84;
                    try {
                        tpm1.delete();
                    }
                    catch (Exception exception) {}
                }
                if (tpm2 != null) {
                    try {
                        tpm2.delete();
                    }
                    catch (Exception exception) {}
                }
                if (leftIs != null) {
                    try {
                        leftIs.close();
                    }
                    catch (IOException iOException) {}
                }
                return bl;
            }
            if (tpm1 != null) {
                try {
                    tpm1.delete();
                }
                catch (Exception exception) {}
            }
            if (tpm2 != null) {
                try {
                    tpm2.delete();
                }
                catch (Exception exception) {}
            }
            if (leftIs != null) {
                try {
                    leftIs.close();
                }
                catch (IOException iOException) {}
            }
            return true;
            catch (ContentIOException ce) {
                block85: {
                    logger.debug((Object)"Unable to compare contents", (Throwable)ce);
                    if (tpm1 == null) break block85;
                    try {
                        tpm1.delete();
                    }
                    catch (Exception exception) {}
                }
                if (tpm2 != null) {
                    try {
                        tpm2.delete();
                    }
                    catch (Exception exception) {}
                }
                if (leftIs != null) {
                    try {
                        leftIs.close();
                    }
                    catch (IOException iOException) {}
                }
                return false;
            }
            catch (IOException e) {
                block86: {
                    logger.debug((Object)"Unable to compare contents", (Throwable)e);
                    if (tpm1 == null) break block86;
                    {
                        catch (Throwable throwable) {
                            if (tpm1 != null) {
                                try {
                                    tpm1.delete();
                                }
                                catch (Exception exception) {}
                            }
                            if (tpm2 != null) {
                                try {
                                    tpm2.delete();
                                }
                                catch (Exception exception) {}
                            }
                            if (leftIs != null) {
                                try {
                                    leftIs.close();
                                }
                                catch (IOException iOException) {}
                            }
                            throw throwable;
                        }
                    }
                    try {
                        tpm1.delete();
                    }
                    catch (Exception exception) {}
                }
                if (tpm2 != null) {
                    try {
                        tpm2.delete();
                    }
                    catch (Exception exception) {}
                }
                if (leftIs != null) {
                    try {
                        leftIs.close();
                    }
                    catch (IOException iOException) {}
                }
                return false;
            }
        }
    }

    private class XLSContentComparator
    implements ContentComparator {
        private XLSContentComparator() {
        }

        /*
         * Loose catch block
         */
        @Override
        public boolean isContentEqual(ContentReader existingContent, File newFile) {
            boolean bl;
            InputStream leftIs;
            File tpm2;
            File tpm1;
            block49: {
                long newSize = newFile.length();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("comparing two excel files size:" + existingContent.getSize() + ", and " + newFile.length()));
                }
                if (existingContent.getSize() != newSize) {
                    logger.debug((Object)"excel files are different size");
                    return false;
                }
                tpm1 = null;
                tpm2 = null;
                leftIs = null;
                HashSet excludes = new HashSet();
                tpm1 = TempFileProvider.createTempFile((String)"CIFSContentComparator1", (String)"xls");
                tpm2 = TempFileProvider.createTempFile((String)"CIFSContentComparator2", (String)"xls");
                leftIs = existingContent.getContentInputStream();
                HSSFWorkbook wb1 = new HSSFWorkbook(leftIs);
                HSSFWorkbook wb2 = new HSSFWorkbook((InputStream)new FileInputStream(newFile));
                wb1.writeProtectWorkbook("", "CIFSContentComparator");
                wb2.writeProtectWorkbook("", "CIFSContentComparator");
                try (FileOutputStream os = new FileOutputStream(tpm1);){
                    wb1.write((OutputStream)os);
                }
                try (FileOutputStream os2 = new FileOutputStream(tpm2);){
                    wb2.write((OutputStream)os2);
                }
                POIFSFileSystem fs1 = new POIFSFileSystem(tpm1);
                POIFSFileSystem fs2 = new POIFSFileSystem(tpm2);
                bl = CIFSContentComparator.this.isContentIdentical(fs1, fs2, excludes);
                if (tpm1 == null) break block49;
                try {
                    tpm1.delete();
                }
                catch (Exception exception) {}
            }
            if (tpm2 != null) {
                try {
                    tpm2.delete();
                }
                catch (Exception exception) {}
            }
            if (leftIs != null) {
                try {
                    leftIs.close();
                }
                catch (IOException iOException) {}
            }
            return bl;
            catch (ContentIOException ce) {
                block50: {
                    logger.debug((Object)"Unable to compare contents", (Throwable)ce);
                    if (tpm1 == null) break block50;
                    try {
                        tpm1.delete();
                    }
                    catch (Exception exception) {}
                }
                if (tpm2 != null) {
                    try {
                        tpm2.delete();
                    }
                    catch (Exception exception) {}
                }
                if (leftIs != null) {
                    try {
                        leftIs.close();
                    }
                    catch (IOException iOException) {}
                }
                return false;
            }
            catch (IOException e) {
                block51: {
                    logger.debug((Object)"Unable to compare contents", (Throwable)e);
                    if (tpm1 == null) break block51;
                    {
                        catch (Throwable throwable) {
                            if (tpm1 != null) {
                                try {
                                    tpm1.delete();
                                }
                                catch (Exception exception) {}
                            }
                            if (tpm2 != null) {
                                try {
                                    tpm2.delete();
                                }
                                catch (Exception exception) {}
                            }
                            if (leftIs != null) {
                                try {
                                    leftIs.close();
                                }
                                catch (IOException iOException) {}
                            }
                            throw throwable;
                        }
                    }
                    try {
                        tpm1.delete();
                    }
                    catch (Exception exception) {}
                }
                if (tpm2 != null) {
                    try {
                        tpm2.delete();
                    }
                    catch (Exception exception) {}
                }
                if (leftIs != null) {
                    try {
                        leftIs.close();
                    }
                    catch (IOException iOException) {}
                }
                return false;
            }
        }
    }
}

