/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp.model;

import org.alfresco.test_category.BaseSpringTestsCategory;
import org.alfresco.util.schemacomp.ComparisonUtils;
import org.alfresco.util.schemacomp.DbObjectVisitor;
import org.alfresco.util.schemacomp.DbProperty;
import org.alfresco.util.schemacomp.model.Column;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.model.DbObjectTestBase;
import org.alfresco.util.schemacomp.model.Table;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={BaseSpringTestsCategory.class})
public class ColumnTest
extends DbObjectTestBase<Column> {
    private Column thisColumn;
    private Column thatColumn;

    @Before
    public void setUp() throws Exception {
        this.thisColumn = new Column(null, "this_column", "VARCHAR2(100)", false);
        this.thatColumn = new Column(null, "that_column", "NUMBER(10)", true);
    }

    @Override
    protected Column getThisObject() {
        return this.thisColumn;
    }

    @Override
    protected Column getThatObject() {
        return this.thatColumn;
    }

    @Override
    protected void doDiffTests() {
        DbProperty thisTypeProp = new DbProperty((DbObject)this.thisColumn, "type");
        DbProperty thatTypeProp = new DbProperty((DbObject)this.thatColumn, "type");
        ((ComparisonUtils)this.inOrder.verify((Object)this.comparisonUtils)).compareSimple(thisTypeProp, thatTypeProp, this.ctx);
        DbProperty thisNullableProp = new DbProperty((DbObject)this.thisColumn, "nullable");
        DbProperty thatNullableProp = new DbProperty((DbObject)this.thatColumn, "nullable");
        ((ComparisonUtils)this.inOrder.verify((Object)this.comparisonUtils)).compareSimple(thisNullableProp, thatNullableProp, this.ctx);
        DbProperty thisOrderProp = new DbProperty((DbObject)this.thisColumn, "order");
        DbProperty thatOrderProp = new DbProperty((DbObject)this.thatColumn, "order");
        ((ComparisonUtils)this.inOrder.verify((Object)this.comparisonUtils)).compareSimple(thisOrderProp, thatOrderProp, this.ctx);
        DbProperty thisAutoIncProp = new DbProperty((DbObject)this.thisColumn, "autoIncrement");
        DbProperty thatAutoIncProp = new DbProperty((DbObject)this.thatColumn, "autoIncrement");
        ((ComparisonUtils)this.inOrder.verify((Object)this.comparisonUtils)).compareSimple(thisAutoIncProp, thatAutoIncProp, this.ctx);
    }

    @Test
    public void acceptVisitor() {
        this.thisColumn.accept(this.visitor);
        ((DbObjectVisitor)Mockito.verify((Object)this.visitor)).visit((DbObject)this.thisColumn);
    }

    @Test
    public void sameAs() {
        Table thisTable = new Table("the_table");
        this.thisColumn = new Column(thisTable, "this_column", "VARCHAR2(100)", false);
        Table thatTable = new Table("the_table");
        this.thatColumn = new Column(thatTable, "this_column", "VARCHAR2(100)", false);
        Table anotherTable = new Table("another_table");
        Column anotherColumn = new Column(anotherTable, "this_column", "VARCHAR2(100)", false);
        Assert.assertTrue((String)"Column should always be the same as itself", (boolean)this.thisColumn.sameAs((DbObject)this.thisColumn));
        Assert.assertTrue((String)"Columns should be the same due to same parent table names", (boolean)this.thisColumn.sameAs((DbObject)this.thatColumn));
        Assert.assertFalse((String)"Should NOT be the same due to different parent table names", (boolean)this.thisColumn.sameAs((DbObject)anotherColumn));
    }
}

