/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.subscriptions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.activities.feed.FeedGenerator;
import org.alfresco.repo.activities.feed.local.LocalFeedTaskProcessor;
import org.alfresco.repo.activities.post.lookup.PostLookup;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.cmr.subscriptions.SubscriptionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.GUID;
import org.alfresco.util.test.junitrules.AlfrescoPerson;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.alfresco.util.test.junitrules.TemporarySites;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class})
public class SubscriptionServiceActivitiesTest {
    private static final Log log = LogFactory.getLog(SubscriptionServiceActivitiesTest.class);
    public static ApplicationContextInit APP_CONTEXT_INIT = new ApplicationContextInit();
    private static final long NOW = System.currentTimeMillis();
    public static final String USER_ONE_NAME = "UserOne" + NOW;
    public static final String USER_TWO_NAME = "UserTwo" + NOW;
    private static String ADMIN;
    public static AlfrescoPerson TEST_USER1;
    public static AlfrescoPerson TEST_USER2;
    @ClassRule
    public static RuleChain STATIC_RULE_CHAIN;
    @Rule
    public TemporarySites testSites = new TemporarySites(APP_CONTEXT_INIT);
    protected static final String TEST_TEMPLATES_LOCATION = "activities";
    protected static SubscriptionService subscriptionService;
    protected static PersonService personService;
    protected static SiteService siteService;
    protected static ActivityService activityService;
    protected static NodeService nodeService;
    protected static ContentService contentService;
    protected static PostLookup postLookup;
    protected static FeedGenerator feedGenerator;
    protected static RetryingTransactionHelper transactionHelper;
    protected static NodeArchiveService nodeArchiveService;
    private static Scheduler QUARTZ_SCHEDULER;
    private SiteInfo publicSite;
    private SiteInfo privateSite1;
    private SiteInfo privateSite2;
    private SiteInfo modSite1;
    private SiteInfo modSite2;

    static {
        TEST_USER1 = new AlfrescoPerson(APP_CONTEXT_INIT, USER_ONE_NAME);
        TEST_USER2 = new AlfrescoPerson(APP_CONTEXT_INIT, USER_TWO_NAME);
        STATIC_RULE_CHAIN = RuleChain.outerRule((TestRule)APP_CONTEXT_INIT).around((TestRule)TEST_USER1).around((TestRule)TEST_USER2);
    }

    @BeforeClass
    public static void setUp() throws Exception {
        ApplicationContext ctx = APP_CONTEXT_INIT.getApplicationContext();
        QUARTZ_SCHEDULER = (Scheduler)ctx.getBean("schedulerFactory", Scheduler.class);
        QUARTZ_SCHEDULER.standby();
        subscriptionService = (SubscriptionService)ctx.getBean("SubscriptionService");
        personService = (PersonService)ctx.getBean("PersonService");
        siteService = (SiteService)ctx.getBean("SiteService");
        activityService = (ActivityService)ctx.getBean("activityService");
        nodeService = (NodeService)ctx.getBean("NodeService");
        contentService = (ContentService)ctx.getBean("ContentService");
        nodeArchiveService = (NodeArchiveService)ctx.getBean("nodeArchiveService");
        transactionHelper = (RetryingTransactionHelper)ctx.getBean("retryingTransactionHelper");
        ChildApplicationContextFactory activitiesFeed = (ChildApplicationContextFactory)ctx.getBean("ActivitiesFeed");
        ApplicationContext activitiesFeedCtx = activitiesFeed.getApplicationContext();
        postLookup = (PostLookup)activitiesFeedCtx.getBean("postLookup");
        feedGenerator = (FeedGenerator)activitiesFeedCtx.getBean("feedGenerator");
        LocalFeedTaskProcessor feedProcessor = (LocalFeedTaskProcessor)activitiesFeedCtx.getBean("feedTaskProcessor");
        ArrayList<String> templateSearchPaths = new ArrayList<String>(1);
        templateSearchPaths.add(TEST_TEMPLATES_LOCATION);
        feedProcessor.setTemplateSearchPaths(templateSearchPaths);
        feedProcessor.setUseRemoteCallbacks(false);
    }

    @AfterClass
    public static void restartQuartzScheduler() throws SchedulerException {
        QUARTZ_SCHEDULER.start();
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    @Before
    public void createTestSites() throws Exception {
        ADMIN = AuthenticationUtil.getAdminUserName();
        String guid = GUID.generate();
        this.publicSite = this.testSites.createSite("sitePreset", "pub" + guid, "", "", SiteVisibility.PUBLIC, ADMIN);
        this.privateSite1 = this.testSites.createSite("sitePreset", "priv1" + guid, "", "", SiteVisibility.PRIVATE, ADMIN);
        this.privateSite2 = this.testSites.createSite("sitePreset", "priv2" + guid, "", "", SiteVisibility.PRIVATE, ADMIN);
        this.modSite1 = this.testSites.createSite("sitePreset", "mod1" + guid, "", "", SiteVisibility.MODERATED, ADMIN);
        this.modSite2 = this.testSites.createSite("sitePreset", "mod2" + guid, "", "", SiteVisibility.MODERATED, ADMIN);
        log.debug((Object)"Created some test sites...");
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    protected NodeRef addTextContent(String siteId, String name) {
        String textData = name;
        String mimeType = "text/plain";
        HashMap<QName, String> contentProps = new HashMap<QName, String>();
        contentProps.put(ContentModel.PROP_NAME, name);
        NodeRef parentRef = siteService.getContainer(siteId, "documentLibrary");
        if (parentRef == null) {
            parentRef = siteService.createContainer(siteId, "documentLibrary", ContentModel.TYPE_FOLDER, null);
        }
        ChildAssociationRef association = nodeService.createNode(parentRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)name), ContentModel.TYPE_CONTENT, contentProps);
        NodeRef content = association.getChildRef();
        HashMap<QName, String> titledProps = new HashMap<QName, String>();
        titledProps.put(ContentModel.PROP_TITLE, name);
        titledProps.put(ContentModel.PROP_DESCRIPTION, name);
        nodeService.addAspect(content, ContentModel.ASPECT_TITLED, titledProps);
        ContentWriter writer = contentService.getWriter(content, ContentModel.PROP_CONTENT, true);
        writer.setMimetype(mimeType);
        writer.setEncoding("UTF-8");
        writer.putContent(textData);
        activityService.postActivity("org.alfresco.documentlibrary.file-added", siteId, "documentlibrary", content, name, ContentModel.PROP_CONTENT, parentRef);
        return content;
    }

    protected void generateFeed() throws Exception {
        postLookup.execute();
        feedGenerator.execute();
    }

    @Test
    public void testFollowingActivity() throws Exception {
        this.doWorkAs(ADMIN, new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                SiteInfo[] siteInfoArray = new SiteInfo[]{SubscriptionServiceActivitiesTest.this.publicSite, SubscriptionServiceActivitiesTest.this.privateSite1, SubscriptionServiceActivitiesTest.this.privateSite2, SubscriptionServiceActivitiesTest.this.modSite1, SubscriptionServiceActivitiesTest.this.modSite2};
                int n = siteInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SiteInfo s = siteInfoArray[n2];
                    siteService.setMembership(s.getShortName(), USER_ONE_NAME, "SiteManager");
                    ++n2;
                }
                return null;
            }
        });
        log.debug((Object)("Made user '" + USER_ONE_NAME + "' a SiteManager in each test site."));
        this.doWorkAs(ADMIN, new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                log.debug((Object)"Now to check if the activity tables have the correct number of entries for our test users");
                List feed = activityService.getUserFeedEntries(USER_ONE_NAME, null, false, false, null, null);
                Assert.assertEquals((String)(String.valueOf(USER_ONE_NAME) + " had wrong feed size."), (long)0L, (long)feed.size());
                feed = activityService.getUserFeedEntries(USER_TWO_NAME, null, false, false, null, null);
                Assert.assertEquals((String)(String.valueOf(USER_TWO_NAME) + " had wrong feed size."), (long)0L, (long)feed.size());
                return null;
            }
        });
        this.generateFeed();
        this.doWorkAs(ADMIN, new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                List feed = activityService.getUserFeedEntries(USER_ONE_NAME, null, false, false, null, null);
                log.debug((Object)(String.valueOf(USER_ONE_NAME) + "'s feed: " + SubscriptionServiceActivitiesTest.this.prettyJson(feed)));
                Assert.assertEquals((String)(String.valueOf(USER_ONE_NAME) + " had wrong feed size"), (long)5L, (long)feed.size());
                feed = activityService.getUserFeedEntries(USER_TWO_NAME, null, false, false, null, null);
                log.debug((Object)(String.valueOf(USER_TWO_NAME) + "'s feed: " + SubscriptionServiceActivitiesTest.this.prettyJson(feed)));
                Assert.assertEquals((String)(String.valueOf(USER_TWO_NAME) + " had wrong feed size"), (long)0L, (long)feed.size());
                return null;
            }
        });
        this.doWorkAs(USER_ONE_NAME, new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                subscriptionService.follow(USER_ONE_NAME, USER_TWO_NAME);
                return null;
            }
        });
        log.debug((Object)(String.valueOf(USER_ONE_NAME) + " is now following " + USER_TWO_NAME));
        this.doWorkAs(USER_TWO_NAME, new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                subscriptionService.follow(USER_TWO_NAME, USER_ONE_NAME);
                return null;
            }
        });
        log.debug((Object)("And " + USER_TWO_NAME + " is now following " + USER_ONE_NAME));
        this.generateFeed();
        this.doWorkAs(ADMIN, new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                List feed = activityService.getUserFeedEntries(USER_ONE_NAME, null, false, false, null, null);
                log.debug((Object)(String.valueOf(USER_ONE_NAME) + "'s feed: " + SubscriptionServiceActivitiesTest.this.prettyJson(feed)));
                Assert.assertEquals((String)(String.valueOf(USER_ONE_NAME) + "'s feed was wrong size"), (long)7L, (long)feed.size());
                feed = activityService.getUserFeedEntries(USER_TWO_NAME, null, false, false, null, null);
                log.debug((Object)(String.valueOf(USER_TWO_NAME) + "'s feed: " + SubscriptionServiceActivitiesTest.this.prettyJson(feed)));
                Assert.assertEquals((String)(String.valueOf(USER_TWO_NAME) + "'s feed was wrong size"), (long)2L, (long)feed.size());
                return null;
            }
        });
        this.doWorkAs(USER_ONE_NAME, new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                SubscriptionServiceActivitiesTest.this.addTextContent(SubscriptionServiceActivitiesTest.this.publicSite.getShortName(), String.valueOf(USER_ONE_NAME) + "pub-a");
                SubscriptionServiceActivitiesTest.this.addTextContent(SubscriptionServiceActivitiesTest.this.privateSite1.getShortName(), String.valueOf(USER_ONE_NAME) + "priv1-a");
                SubscriptionServiceActivitiesTest.this.addTextContent(SubscriptionServiceActivitiesTest.this.privateSite2.getShortName(), String.valueOf(USER_ONE_NAME) + "priv2-a");
                SubscriptionServiceActivitiesTest.this.addTextContent(SubscriptionServiceActivitiesTest.this.modSite1.getShortName(), String.valueOf(USER_ONE_NAME) + "mod1-a");
                SubscriptionServiceActivitiesTest.this.addTextContent(SubscriptionServiceActivitiesTest.this.modSite2.getShortName(), String.valueOf(USER_ONE_NAME) + "mod2-a");
                return null;
            }
        });
        log.debug((Object)(String.valueOf(USER_ONE_NAME) + " added some content across the sites."));
        this.generateFeed();
        this.doWorkAs(ADMIN, new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                List feed = activityService.getUserFeedEntries(USER_ONE_NAME, null, false, false, null, null);
                log.debug((Object)(String.valueOf(USER_ONE_NAME) + "'s feed: " + SubscriptionServiceActivitiesTest.this.prettyJson(feed)));
                Assert.assertEquals((String)(String.valueOf(USER_ONE_NAME) + "'s feed was wrong size"), (long)12L, (long)feed.size());
                feed = activityService.getUserFeedEntries(USER_TWO_NAME, null, false, false, null, null);
                log.debug((Object)(String.valueOf(USER_TWO_NAME) + "'s feed: " + SubscriptionServiceActivitiesTest.this.prettyJson(feed)));
                Assert.assertEquals((String)(String.valueOf(USER_TWO_NAME) + "'s feed was wrong size"), (long)3L, (long)feed.size());
                siteService.setMembership(SubscriptionServiceActivitiesTest.this.privateSite2.getShortName(), USER_TWO_NAME, "SiteConsumer");
                siteService.setMembership(SubscriptionServiceActivitiesTest.this.modSite2.getShortName(), USER_TWO_NAME, "SiteManager");
                log.debug((Object)(String.valueOf(USER_TWO_NAME) + "'s role changed on some sites."));
                return null;
            }
        });
        this.generateFeed();
        this.doWorkAs(ADMIN, new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                List feed = activityService.getUserFeedEntries(USER_ONE_NAME, null, false, false, null, null);
                log.debug((Object)(String.valueOf(USER_ONE_NAME) + "'s feed: " + SubscriptionServiceActivitiesTest.this.prettyJson(feed)));
                Assert.assertEquals((String)(String.valueOf(USER_ONE_NAME) + "'s feed was wrong size"), (long)14L, (long)feed.size());
                feed = activityService.getUserFeedEntries(USER_TWO_NAME, null, false, false, null, null);
                log.debug((Object)(String.valueOf(USER_TWO_NAME) + "'s feed: " + SubscriptionServiceActivitiesTest.this.prettyJson(feed)));
                Assert.assertEquals((String)(String.valueOf(USER_TWO_NAME) + "'s feed was wrong size"), (long)5L, (long)feed.size());
                return null;
            }
        });
        this.doWorkAs(USER_ONE_NAME, new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                SubscriptionServiceActivitiesTest.this.addTextContent(SubscriptionServiceActivitiesTest.this.publicSite.getShortName(), String.valueOf(USER_ONE_NAME) + "pub-b");
                SubscriptionServiceActivitiesTest.this.addTextContent(SubscriptionServiceActivitiesTest.this.privateSite1.getShortName(), String.valueOf(USER_ONE_NAME) + "priv1-b");
                SubscriptionServiceActivitiesTest.this.addTextContent(SubscriptionServiceActivitiesTest.this.privateSite2.getShortName(), String.valueOf(USER_ONE_NAME) + "priv2-b");
                SubscriptionServiceActivitiesTest.this.addTextContent(SubscriptionServiceActivitiesTest.this.modSite1.getShortName(), String.valueOf(USER_ONE_NAME) + "mod1-b");
                SubscriptionServiceActivitiesTest.this.addTextContent(SubscriptionServiceActivitiesTest.this.modSite2.getShortName(), String.valueOf(USER_ONE_NAME) + "mod2-b");
                return null;
            }
        });
        log.debug((Object)(String.valueOf(USER_ONE_NAME) + " has added some more content..."));
        this.generateFeed();
        this.doWorkAs(ADMIN, new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                List feed = activityService.getUserFeedEntries(USER_ONE_NAME, null, false, false, null, null);
                Assert.assertEquals((String)"User's feed was wrong size", (long)19L, (long)feed.size());
                feed = activityService.getUserFeedEntries(USER_TWO_NAME, null, false, false, null, null);
                Assert.assertEquals((String)"User's feed was wrong size", (long)8L, (long)feed.size());
                return null;
            }
        });
        log.debug((Object)"Now to delete the test sites...");
        this.doWorkAs(ADMIN, new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                SiteInfo[] siteInfoArray = new SiteInfo[]{SubscriptionServiceActivitiesTest.this.publicSite, SubscriptionServiceActivitiesTest.this.privateSite1, SubscriptionServiceActivitiesTest.this.privateSite2, SubscriptionServiceActivitiesTest.this.modSite1, SubscriptionServiceActivitiesTest.this.modSite2};
                int n = siteInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SiteInfo s = siteInfoArray[n2];
                    SubscriptionServiceActivitiesTest.this.deleteSite(s.getShortName());
                    ++n2;
                }
                log.debug((Object)"Deleted all the test sites.");
                return null;
            }
        });
        this.doWorkAs(ADMIN, new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                List feed = activityService.getUserFeedEntries(USER_ONE_NAME, null, false, false, null, null);
                log.debug((Object)(String.valueOf(USER_ONE_NAME) + "'s feed:\n" + SubscriptionServiceActivitiesTest.this.prettyJson(feed)));
                Assert.assertEquals((String)"User's feed was wrong size", (long)2L, (long)feed.size());
                feed = activityService.getUserFeedEntries(USER_TWO_NAME, null, false, false, null, null);
                Assert.assertEquals((String)"User's feed was wrong size", (long)2L, (long)feed.size());
                return null;
            }
        });
        log.debug((Object)"Now to delete the users...");
        this.doWorkAs(ADMIN, new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                String[] stringArray = new String[]{USER_ONE_NAME, USER_TWO_NAME};
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String user = stringArray[n2];
                    SubscriptionServiceActivitiesTest.this.deletePerson(user);
                    ++n2;
                }
                log.debug((Object)"Deleted the test people.");
                return null;
            }
        });
        this.doWorkAs(ADMIN, new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                List feed = activityService.getUserFeedEntries(USER_ONE_NAME, null, false, false, null, null);
                log.debug((Object)("User1's feed: " + SubscriptionServiceActivitiesTest.this.prettyJson(feed)));
                Assert.assertEquals((String)"User's feed was wrong size", (long)0L, (long)feed.size());
                feed = activityService.getUserFeedEntries(USER_TWO_NAME, null, false, false, null, null);
                Assert.assertEquals((String)"User's feed was wrong size", (long)0L, (long)feed.size());
                return null;
            }
        });
    }

    private void deleteSite(String siteShortName) {
        SiteInfo siteInfo = siteService.getSite(siteShortName);
        if (siteInfo != null) {
            log.debug((Object)("Deleting site: " + siteShortName));
            siteService.deleteSite(siteShortName);
            nodeArchiveService.purgeArchivedNode(nodeArchiveService.getArchivedNode(siteInfo.getNodeRef()));
        } else {
            log.debug((Object)("Not deleting site: " + siteShortName + ", as it doesn't appear to exist"));
        }
    }

    private void deletePerson(String userName) {
        if (personService.personExists(userName)) {
            log.debug((Object)("Deleting person: " + userName));
            personService.deletePerson(userName);
        } else {
            log.debug((Object)("Not deleting person: " + userName + ", as they don't appear to exist"));
        }
    }

    private <T> T doWorkAs(String userName, final RetryingTransactionHelper.RetryingTransactionCallback<T> work) {
        return (T)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<T>(){

            public T doWork() throws Exception {
                return transactionHelper.doInTransaction(work);
            }
        }, (String)userName);
    }

    private String prettyJson(List<String> jsonStrings) {
        StringBuilder result = new StringBuilder();
        for (String jsonString : jsonStrings) {
            result.append(this.prettyJson(jsonString));
            result.append("\n");
        }
        return result.toString();
    }

    private String prettyJson(String jsonString) {
        String result = jsonString;
        try {
            JSONObject json = new JSONObject(new JSONTokener(jsonString));
            result = json.toString(2);
        }
        catch (JSONException jSONException) {}
        return result;
    }
}

