/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.node;

import java.io.Serializable;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.ibatis.BatchingDAO;
import org.alfresco.ibatis.RetryingCallbackHelper;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cache.NullCache;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.cache.TransactionalCache;
import org.alfresco.repo.cache.lookup.EntityLookupCache;
import org.alfresco.repo.domain.contentdata.ContentDataDAO;
import org.alfresco.repo.domain.control.ControlDAO;
import org.alfresco.repo.domain.locale.LocaleDAO;
import org.alfresco.repo.domain.node.AuditablePropertiesEntity;
import org.alfresco.repo.domain.node.ChildAssocEntity;
import org.alfresco.repo.domain.node.ChildByNameKey;
import org.alfresco.repo.domain.node.ContentDataWithId;
import org.alfresco.repo.domain.node.LocalizedPropertiesEntity;
import org.alfresco.repo.domain.node.Node;
import org.alfresco.repo.domain.node.NodeAssocEntity;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.node.NodeEntity;
import org.alfresco.repo.domain.node.NodeExistsException;
import org.alfresco.repo.domain.node.NodeIdAndAclId;
import org.alfresco.repo.domain.node.NodePropertyHelper;
import org.alfresco.repo.domain.node.NodePropertyKey;
import org.alfresco.repo.domain.node.NodePropertyValue;
import org.alfresco.repo.domain.node.NodeUpdateEntity;
import org.alfresco.repo.domain.node.NodeVersionKey;
import org.alfresco.repo.domain.node.NonRootNodeWithoutParentsException;
import org.alfresco.repo.domain.node.ParentAssocsInfo;
import org.alfresco.repo.domain.node.ReferenceablePropertiesEntity;
import org.alfresco.repo.domain.node.StoreEntity;
import org.alfresco.repo.domain.node.Transaction;
import org.alfresco.repo.domain.node.TransactionEntity;
import org.alfresco.repo.domain.permissions.AccessControlListDAO;
import org.alfresco.repo.domain.permissions.AclDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.domain.usage.UsageDAO;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.permissions.AccessControlListProperties;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionalDao;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.InvalidTypeException;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.AssociationExistsException;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.CyclicChildRelationshipException;
import org.alfresco.service.cmr.repository.DuplicateChildNodeNameException;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.InvalidStoreRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.ReadOnlyServerException;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.ValueProtectingMap;
import org.alfresco.util.transaction.TransactionListener;
import org.alfresco.util.transaction.TransactionListenerAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.util.Assert;

public abstract class AbstractNodeDAOImpl
implements NodeDAO,
BatchingDAO {
    private static final String CACHE_REGION_ROOT_NODES = "N.RN";
    public static final String CACHE_REGION_NODES = "N.N";
    private static final String CACHE_REGION_ASPECTS = "N.A";
    private static final String CACHE_REGION_PROPERTIES = "N.P";
    private static final String KEY_LOST_NODE_PAIRS = String.valueOf(AbstractNodeDAOImpl.class.getName()) + ".lostNodePairs";
    private static final String KEY_DELETED_ASSOCS = String.valueOf(AbstractNodeDAOImpl.class.getName()) + ".deletedAssocs";
    protected Log logger = LogFactory.getLog(AbstractNodeDAOImpl.class);
    private Log loggerPaths = LogFactory.getLog((String)(String.valueOf(AbstractNodeDAOImpl.class.getName()) + ".paths"));
    private NodePropertyHelper nodePropertyHelper;
    private UpdateTransactionListener updateTransactionListener = new UpdateTransactionListener();
    private RetryingCallbackHelper childAssocRetryingHelper = new RetryingCallbackHelper();
    private TransactionService transactionService;
    private DictionaryService dictionaryService;
    private BehaviourFilter policyBehaviourFilter;
    private AclDAO aclDAO;
    private AccessControlListDAO accessControlListDAO;
    private ControlDAO controlDAO;
    private QNameDAO qnameDAO;
    private ContentDataDAO contentDataDAO;
    private LocaleDAO localeDAO;
    private UsageDAO usageDAO;
    private int cachingThreshold = 10;
    private int batchSize = 256;
    private boolean forceBatching;
    private EntityLookupCache<StoreRef, Node, Serializable> rootNodesCache;
    private SimpleCache<StoreRef, Set<NodeRef>> allRootNodesCache;
    private EntityLookupCache<Long, Node, NodeRef> nodesCache;
    private TransactionalCache<Serializable, Serializable> nodesTransactionalCache;
    private EntityLookupCache<NodeVersionKey, Set<QName>, Serializable> aspectsCache;
    private EntityLookupCache<NodeVersionKey, Map<QName, Serializable>, Serializable> propertiesCache;
    private ParentAssocsCache parentAssocsCache;
    private int parentAssocsCacheSize;
    private int parentAssocsCacheLimitFactor = 8;
    private SimpleCache<ChildByNameKey, ChildAssocEntity> childByNameCache;
    private static final String KEY_TRANSACTION = "node.transaction.id";
    private static final int PARENT_ASSOCS_CACHE_FILTER_THRESHOLD = 2000;
    public static final Long LONG_ZERO = 0L;

    public AbstractNodeDAOImpl() {
        this.childAssocRetryingHelper.setRetryWaitMs(10);
        this.childAssocRetryingHelper.setMaxRetries(5);
        this.rootNodesCache = new EntityLookupCache<StoreRef, Node, Serializable>(new RootNodesCacheCallbackDAO());
        this.nodesCache = new EntityLookupCache<Long, Node, NodeRef>(new NodesCacheCallbackDAO());
        this.aspectsCache = new EntityLookupCache<NodeVersionKey, Set<QName>, Serializable>(new AspectsCallbackDAO());
        this.propertiesCache = new EntityLookupCache<NodeVersionKey, Map<QName, Serializable>, Serializable>(new PropertiesCallbackDAO());
        this.childByNameCache = new NullCache<ChildByNameKey, ChildAssocEntity>();
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setCachingThreshold(int cachingThreshold) {
        this.cachingThreshold = cachingThreshold;
    }

    public void setPolicyBehaviourFilter(BehaviourFilter policyBehaviourFilter) {
        this.policyBehaviourFilter = policyBehaviourFilter;
    }

    public void setAclDAO(AclDAO aclDAO) {
        this.aclDAO = aclDAO;
    }

    public void setAccessControlListDAO(AccessControlListDAO accessControlListDAO) {
        this.accessControlListDAO = accessControlListDAO;
    }

    public void setControlDAO(ControlDAO controlDAO) {
        this.controlDAO = controlDAO;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void setContentDataDAO(ContentDataDAO contentDataDAO) {
        this.contentDataDAO = contentDataDAO;
    }

    public void setLocaleDAO(LocaleDAO localeDAO) {
        this.localeDAO = localeDAO;
    }

    public void setUsageDAO(UsageDAO usageDAO) {
        this.usageDAO = usageDAO;
    }

    public void setRootNodesCache(SimpleCache<Serializable, Serializable> cache) {
        this.rootNodesCache = new EntityLookupCache<StoreRef, Node, Serializable>(cache, CACHE_REGION_ROOT_NODES, new RootNodesCacheCallbackDAO());
    }

    public void setAllRootNodesCache(SimpleCache<StoreRef, Set<NodeRef>> allRootNodesCache) {
        this.allRootNodesCache = allRootNodesCache;
    }

    public void setNodesCache(SimpleCache<Serializable, Serializable> cache) {
        this.nodesCache = new EntityLookupCache<Long, Node, NodeRef>(cache, CACHE_REGION_NODES, new NodesCacheCallbackDAO());
        if (cache instanceof TransactionalCache) {
            this.nodesTransactionalCache = (TransactionalCache)cache;
        }
    }

    public void setAspectsCache(SimpleCache<NodeVersionKey, Set<QName>> aspectsCache) {
        this.aspectsCache = new EntityLookupCache<NodeVersionKey, Set<QName>, Serializable>(aspectsCache, CACHE_REGION_ASPECTS, new AspectsCallbackDAO());
    }

    public void setPropertiesCache(SimpleCache<NodeVersionKey, Map<QName, Serializable>> propertiesCache) {
        this.propertiesCache = new EntityLookupCache<NodeVersionKey, Map<QName, Serializable>, Serializable>(propertiesCache, CACHE_REGION_PROPERTIES, new PropertiesCallbackDAO());
    }

    public void setParentAssocsCacheSize(int parentAssocsCacheSize) {
        this.parentAssocsCacheSize = parentAssocsCacheSize;
    }

    public void setParentAssocsCacheLimitFactor(int parentAssocsCacheLimitFactor) {
        this.parentAssocsCacheLimitFactor = parentAssocsCacheLimitFactor;
    }

    public void setChildByNameCache(SimpleCache<ChildByNameKey, ChildAssocEntity> childByNameCache) {
        this.childByNameCache = childByNameCache;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        if (batchSize < 1) {
            this.batchSize = 1;
            this.logger.info((Object)"Batch size can not be set to a value less than 1.  The size is now set to 1.");
        } else if (batchSize >= 1000) {
            this.logger.info((Object)"Batch size is set to 1000 or greater.  Oracle databases have a hard limit of 1000 values allowed in an IN clause.The other supported databases have no specified limit.");
        }
    }

    public void setForceBatching(boolean forceBatching) {
        this.forceBatching = forceBatching;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"dictionaryService", (Object)this.dictionaryService);
        PropertyCheck.mandatory((Object)this, (String)"aclDAO", (Object)this.aclDAO);
        PropertyCheck.mandatory((Object)this, (String)"accessControlListDAO", (Object)this.accessControlListDAO);
        PropertyCheck.mandatory((Object)this, (String)"qnameDAO", (Object)this.qnameDAO);
        PropertyCheck.mandatory((Object)this, (String)"contentDataDAO", (Object)this.contentDataDAO);
        PropertyCheck.mandatory((Object)this, (String)"localeDAO", (Object)this.localeDAO);
        PropertyCheck.mandatory((Object)this, (String)"usageDAO", (Object)this.usageDAO);
        this.nodePropertyHelper = new NodePropertyHelper(this.dictionaryService, this.qnameDAO, this.localeDAO, this.contentDataDAO);
        this.parentAssocsCache = new ParentAssocsCache(this.parentAssocsCacheSize, this.parentAssocsCacheLimitFactor);
    }

    private void clearCaches() {
        this.nodesCache.clear();
        this.aspectsCache.clear();
        this.propertiesCache.clear();
        this.parentAssocsCache.clear();
    }

    private int invalidateNodeChildrenCaches(Long parentNodeId, boolean primary, boolean touchNodes) {
        Long txnId = this.getCurrentTransaction().getId();
        int count = 0;
        ArrayList<Long> childNodeIds = new ArrayList<Long>(256);
        Long minChildNodeIdInclusive = Long.MIN_VALUE;
        while (minChildNodeIdInclusive != null) {
            childNodeIds.clear();
            List<ChildAssocEntity> childAssocs = this.selectChildNodeIds(parentNodeId, primary, minChildNodeIdInclusive, 256);
            for (ChildAssocEntity childAssoc : childAssocs) {
                Long childNodeId = childAssoc.getChildNode().getId();
                if (childNodeId.compareTo(minChildNodeIdInclusive) < 0) {
                    throw new RuntimeException("Query results did not increase for child node id ID");
                }
                minChildNodeIdInclusive = childNodeId + 1L;
                childNodeIds.add(childNodeId);
                this.invalidateNodeCaches(childNodeId);
                ++count;
            }
            if (touchNodes) {
                this.updateNodes(txnId, childNodeIds);
            }
            if (childAssocs.size() < 256) break;
        }
        return count;
    }

    private void invalidateNodeCaches(Long nodeId) {
        Node node = this.nodesCache.getValue(nodeId);
        if (node != null) {
            this.invalidateNodeCaches(node, true, true, true);
        }
        this.nodesCache.removeByKey(nodeId);
    }

    private void invalidateNodeCaches(Node node, boolean invalidateNodeAspectsCache, boolean invalidateNodePropertiesCache, boolean invalidateParentAssocsCache) {
        NodeVersionKey nodeVersionKey = node.getNodeVersionKey();
        if (invalidateNodeAspectsCache) {
            this.aspectsCache.removeByKey(nodeVersionKey);
        }
        if (invalidateNodePropertiesCache) {
            this.propertiesCache.removeByKey(nodeVersionKey);
        }
        if (invalidateParentAssocsCache) {
            this.invalidateParentAssocsCached(node);
        }
    }

    private TransactionEntity getCurrentTransaction() {
        TransactionEntity txn = (TransactionEntity)AlfrescoTransactionSupport.getResource((Object)KEY_TRANSACTION);
        if (txn != null) {
            return txn;
        }
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_READ_WRITE) {
            throw new ReadOnlyServerException();
        }
        Long now = System.currentTimeMillis();
        String changeTxnId = AlfrescoTransactionSupport.getTransactionId();
        Long txnId = this.insertTransaction(changeTxnId, now);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Create txn: " + txnId));
        }
        txn = new TransactionEntity();
        txn.setId(txnId);
        txn.setChangeTxnId(changeTxnId);
        txn.setCommitTimeMs(now);
        AlfrescoTransactionSupport.bindResource((Object)KEY_TRANSACTION, (Object)txn);
        AlfrescoTransactionSupport.bindDaoService(this.updateTransactionListener);
        return txn;
    }

    @Override
    public Long getCurrentTransactionCommitTime() {
        Long commitTime = null;
        TransactionEntity resource = (TransactionEntity)AlfrescoTransactionSupport.getResource((Object)KEY_TRANSACTION);
        if (resource != null) {
            commitTime = resource.getCommitTimeMs();
        }
        return commitTime;
    }

    @Override
    public Long getCurrentTransactionId(boolean ensureNew) {
        TransactionEntity txn = ensureNew ? this.getCurrentTransaction() : (TransactionEntity)AlfrescoTransactionSupport.getResource((Object)KEY_TRANSACTION);
        return txn == null ? null : txn.getId();
    }

    @Override
    public Pair<Long, StoreRef> getStore(StoreRef storeRef) {
        Pair<StoreRef, Node> rootNodePair = this.rootNodesCache.getByKey(storeRef);
        if (rootNodePair == null) {
            return null;
        }
        return new Pair((Object)((Node)rootNodePair.getSecond()).getStore().getId(), (Object)((StoreRef)rootNodePair.getFirst()));
    }

    @Override
    public List<Pair<Long, StoreRef>> getStores() {
        List<StoreEntity> storeEntities = this.selectAllStores();
        ArrayList<Pair<Long, StoreRef>> storeRefs = new ArrayList<Pair<Long, StoreRef>>(storeEntities.size());
        for (StoreEntity storeEntity : storeEntities) {
            storeRefs.add((Pair<Long, StoreRef>)new Pair((Object)storeEntity.getId(), (Object)storeEntity.getStoreRef()));
        }
        return storeRefs;
    }

    private StoreEntity getStoreNotNull(StoreRef storeRef) {
        Pair<StoreRef, Node> rootNodePair = this.rootNodesCache.getByKey(storeRef);
        if (rootNodePair == null) {
            throw new InvalidStoreRefException(storeRef);
        }
        return ((Node)rootNodePair.getSecond()).getStore();
    }

    @Override
    public boolean exists(StoreRef storeRef) {
        Pair<StoreRef, Node> rootNodePair = this.rootNodesCache.getByKey(storeRef);
        return rootNodePair != null;
    }

    @Override
    public Pair<Long, NodeRef> getRootNode(StoreRef storeRef) {
        Pair<StoreRef, Node> rootNodePair = this.rootNodesCache.getByKey(storeRef);
        if (rootNodePair == null) {
            throw new InvalidStoreRefException(storeRef);
        }
        return ((Node)rootNodePair.getSecond()).getNodePair();
    }

    @Override
    public Set<NodeRef> getAllRootNodes(StoreRef storeRef) {
        Set rootNodes = (Set)this.allRootNodesCache.get((Serializable)storeRef);
        if (rootNodes == null) {
            final HashMap allRootNodes = new HashMap(97);
            this.getNodesWithAspects(Collections.singleton(ContentModel.ASPECT_ROOT), 0L, Long.MAX_VALUE, new NodeDAO.NodeRefQueryCallback(){

                @Override
                public boolean handle(Pair<Long, NodeRef> nodePair) {
                    NodeRef nodeRef = (NodeRef)nodePair.getSecond();
                    StoreRef storeRef = nodeRef.getStoreRef();
                    HashSet<NodeRef> rootNodes = (HashSet<NodeRef>)allRootNodes.get(storeRef);
                    if (rootNodes == null) {
                        rootNodes = new HashSet<NodeRef>(97);
                        allRootNodes.put(storeRef, rootNodes);
                    }
                    rootNodes.add(nodeRef);
                    return true;
                }
            });
            rootNodes = (Set)allRootNodes.get(storeRef);
            if (rootNodes == null) {
                rootNodes = Collections.emptySet();
                allRootNodes.put(storeRef, rootNodes);
            }
            for (Map.Entry entry : allRootNodes.entrySet()) {
                StoreRef entryStoreRef = (StoreRef)entry.getKey();
                if (this.allRootNodesCache.contains((Serializable)entryStoreRef)) continue;
                this.allRootNodesCache.put((Serializable)entryStoreRef, (Object)((Set)entry.getValue()));
            }
        }
        return rootNodes;
    }

    @Override
    public Pair<Long, NodeRef> newStore(StoreRef storeRef) {
        StoreEntity store = new StoreEntity();
        store.setProtocol(storeRef.getProtocol());
        store.setIdentifier(storeRef.getIdentifier());
        Long storeId = this.insertStore(store);
        store.setId(storeId);
        Long aclId = this.aclDAO.createAccessControlList();
        Long nodeTypeQNameId = (Long)this.qnameDAO.getOrCreateQName(ContentModel.TYPE_STOREROOT).getFirst();
        NodeEntity rootNode = this.newNodeImpl(store, null, nodeTypeQNameId, null, aclId, null, true);
        Long rootNodeId = rootNode.getId();
        this.addNodeAspects(rootNodeId, Collections.singleton(ContentModel.ASPECT_ROOT));
        store.setRootNode(rootNode);
        this.updateStoreRoot(store);
        this.rootNodesCache.setValue(storeRef, rootNode);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Created store: \n   " + store));
        }
        return new Pair((Object)rootNode.getId(), (Object)rootNode.getNodeRef());
    }

    @Override
    public void moveStore(StoreRef oldStoreRef, StoreRef newStoreRef) {
        StoreEntity store = this.getStoreNotNull(oldStoreRef);
        store.setProtocol(newStoreRef.getProtocol());
        store.setIdentifier(newStoreRef.getIdentifier());
        int count = this.updateStore(store);
        if (count != 1) {
            throw new ConcurrencyFailureException("Store not updated: " + oldStoreRef);
        }
        Long txnId = this.getCurrentTransaction().getId();
        Long storeId = store.getId();
        this.updateNodesInStore(txnId, storeId);
        this.rootNodesCache.removeByKey(oldStoreRef);
        this.allRootNodesCache.remove((Serializable)oldStoreRef);
        this.nodesCache.clear();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Moved store: " + oldStoreRef + " --> " + newStoreRef));
        }
    }

    @Override
    public boolean exists(Long nodeId) {
        Pair<Long, Node> pair = this.nodesCache.getByKey(nodeId);
        return pair != null && !((Node)pair.getSecond()).getDeleted(this.qnameDAO);
    }

    @Override
    public boolean exists(NodeRef nodeRef) {
        NodeEntity node = new NodeEntity(nodeRef);
        Pair<Long, Node> pair = this.nodesCache.getByValue(node);
        return pair != null && !((Node)pair.getSecond()).getDeleted(this.qnameDAO);
    }

    @Override
    public List<NodeRef> exists(List<NodeRef> nodeRefs) {
        ArrayList<NodeEntity> nodeRefsToCheck = new ArrayList<NodeEntity>(nodeRefs.size());
        for (NodeRef nodeRef : nodeRefs) {
            nodeRefsToCheck.add(new NodeEntity(nodeRef));
        }
        ArrayList<NodeRef> existingNodeRefs = new ArrayList<NodeRef>(nodeRefs.size());
        List<Pair<Long, Node>> nodes = this.nodesCache.getByValues(nodeRefsToCheck);
        if (nodes != null) {
            for (Pair<Long, Node> pair : nodes) {
                if (pair == null || ((Node)pair.getSecond()).getDeleted(this.qnameDAO)) continue;
                existingNodeRefs.add(((Node)pair.getSecond()).getNodeRef());
            }
        }
        return existingNodeRefs;
    }

    @Override
    public boolean isInCurrentTxn(Long nodeId) {
        Long currentTxnId = this.getCurrentTransactionId(false);
        if (currentTxnId == null) {
            return false;
        }
        Node node = this.getNodeNotNull(nodeId, false);
        Long nodeTxnId = node.getTransaction().getId();
        return nodeTxnId.equals(currentTxnId);
    }

    @Override
    public NodeRef.Status getNodeRefStatus(NodeRef nodeRef) {
        NodeEntity node = new NodeEntity(nodeRef);
        Pair<Long, Node> nodePair = this.nodesCache.getByValue(node);
        if (nodePair == null) {
            return null;
        }
        return ((Node)nodePair.getSecond()).getNodeStatus(this.qnameDAO);
    }

    @Override
    public NodeRef.Status getNodeIdStatus(Long nodeId) {
        Pair<Long, Node> nodePair = this.nodesCache.getByKey(nodeId);
        if (nodePair == null) {
            return null;
        }
        return ((Node)nodePair.getSecond()).getNodeStatus(this.qnameDAO);
    }

    @Override
    public Pair<Long, NodeRef> getNodePair(NodeRef nodeRef) {
        NodeEntity node = new NodeEntity(nodeRef);
        Pair<Long, Node> pair = this.nodesCache.getByValue(node);
        if (pair == null || ((Node)pair.getSecond()).getDeleted(this.qnameDAO)) {
            NodeEntity dbNode = this.selectNodeByNodeRef(nodeRef);
            if (dbNode == null) {
                return null;
            }
            if (dbNode.getDeleted(this.qnameDAO)) {
                this.pruneDanglingAssocs(dbNode.getId());
                return null;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Repairing stale cache entry for node: " + nodeRef));
            }
            Long nodeId = dbNode.getId();
            this.invalidateNodeCaches(nodeId);
            dbNode.lock();
            this.nodesCache.setValue(nodeId, dbNode);
            return dbNode.getNodePair();
        }
        return ((Node)pair.getSecond()).getNodePair();
    }

    @Override
    public List<Pair<Long, NodeRef>> getNodePairs(StoreRef storeRef, List<NodeRef> nodeRefs) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Getting node pairs for " + nodeRefs.size() + " nodeRefs" + (storeRef != null ? " in store " + storeRef : "")));
        }
        ArrayList<Pair<Long, NodeRef>> results = new ArrayList<Pair<Long, NodeRef>>(nodeRefs.size());
        TreeSet<Long> uncachedNodeIds = new TreeSet<Long>();
        List<Pair<Long, Node>> nodePairs = this.nodesCache.getByValues(nodeRefs.stream().map(NodeEntity::new).collect(Collectors.toList()));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Cache lookup returned " + nodePairs.size() + " node pairs"));
        }
        for (Pair<Long, Node> nodePair : nodePairs) {
            if (nodePair != null && ((Node)nodePair.getSecond()).getDeleted(this.qnameDAO)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Node " + nodePair.getFirst() + " is marked deleted in cache"));
                }
                uncachedNodeIds.add((Long)nodePair.getFirst());
                continue;
            }
            if (nodePair == null) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Node " + nodePair.getFirst() + " found in cache"));
            }
            results.add(((Node)nodePair.getSecond()).getNodePair());
        }
        Set existingUuids = nodePairs.stream().map(Pair::getSecond).map(Node::getNodeRef).map(NodeRef::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Existing UUIDs from cache: " + existingUuids.size()));
        }
        SortedSet missingUuids = nodeRefs.stream().map(NodeRef::getId).filter(refId -> !existingUuids.contains(refId)).collect(Collectors.toCollection(TreeSet::new));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Missing UUIDs to check in DB: " + missingUuids.size()));
        }
        if (!uncachedNodeIds.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Checking " + uncachedNodeIds.size() + " uncached node IDs in DB"));
            }
            List<Node> dbNodes = this.selectNodesByIds(uncachedNodeIds);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("DB lookup returned " + dbNodes.size() + " nodes"));
            }
            if (missingUuids != null && !missingUuids.isEmpty()) {
                if (storeRef != null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Also checking " + missingUuids.size() + " missing UUIDs in store " + storeRef));
                    }
                    StoreEntity store = this.getStoreNotNull(storeRef);
                    dbNodes.addAll(this.selectNodesByUuids(store.getId(), missingUuids));
                } else {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Also checking " + missingUuids.size() + " missing UUIDs across all stores"));
                    }
                    dbNodes.addAll(this.selectNodesByUuids(missingUuids));
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Total DB lookup returned " + dbNodes.size() + " nodes after UUID check"));
            }
            for (Node dbNode : dbNodes) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Processing DB node: " + dbNode));
                }
                Long nodeId = dbNode.getId();
                if (dbNode.getDeleted(this.qnameDAO)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Node " + nodeId + " is marked deleted in DB"));
                    }
                    this.pruneDanglingAssocs(nodeId);
                    continue;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Repairing stale cache entry for node: " + nodeId));
                }
                this.invalidateNodeCaches(nodeId);
                dbNode.lock();
                this.nodesCache.setValue(nodeId, dbNode);
                results.add(dbNode.getNodePair());
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Returning " + results.size() + " node pairs"));
        }
        return results;
    }

    private void pruneDanglingAssocs(Long nodeId) {
        this.selectChildAssocs(nodeId, null, null, null, null, null, new NodeDAO.ChildAssocRefQueryCallback(){

            @Override
            public boolean preLoadNodes() {
                return false;
            }

            @Override
            public boolean orderResults() {
                return false;
            }

            @Override
            public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
                AbstractNodeDAOImpl.this.bindFixAssocAndCollectLostAndFound((Pair<Long, NodeRef>)childNodePair, "childNodeWithDeletedParent", (Long)childAssocPair.getFirst(), ((ChildAssociationRef)childAssocPair.getSecond()).isPrimary() && AbstractNodeDAOImpl.this.exists((Long)childAssocPair.getFirst()));
                return true;
            }

            @Override
            public void done() {
            }
        });
        this.selectParentAssocs(nodeId, null, null, null, new NodeDAO.ChildAssocRefQueryCallback(){

            @Override
            public boolean preLoadNodes() {
                return false;
            }

            @Override
            public boolean orderResults() {
                return false;
            }

            @Override
            public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
                AbstractNodeDAOImpl.this.bindFixAssocAndCollectLostAndFound((Pair<Long, NodeRef>)childNodePair, "deletedChildWithParents", (Long)childAssocPair.getFirst(), false);
                return true;
            }

            @Override
            public void done() {
            }
        });
    }

    @Override
    public Pair<Long, NodeRef> getNodePair(Long nodeId) {
        Pair<Long, Node> pair = this.nodesCache.getByKey(nodeId);
        if (pair == null || ((Node)pair.getSecond()).getDeleted(this.qnameDAO)) {
            NodeEntity dbNode = this.selectNodeById(nodeId);
            if (dbNode == null) {
                return null;
            }
            if (dbNode.getDeleted(this.qnameDAO)) {
                this.pruneDanglingAssocs(dbNode.getId());
                return null;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Repairing stale cache entry for node: " + nodeId));
            }
            this.invalidateNodeCaches(nodeId);
            dbNode.lock();
            this.nodesCache.setValue(nodeId, dbNode);
            return dbNode.getNodePair();
        }
        return ((Node)pair.getSecond()).getNodePair();
    }

    @Override
    public List<Pair<Long, NodeRef>> getNodePairs(List<Long> nodeIds) {
        ArrayList<Pair<Long, NodeRef>> results = new ArrayList<Pair<Long, NodeRef>>(nodeIds.size());
        TreeSet<Long> uncachedNodeIds = new TreeSet<Long>();
        for (Long nodeId : nodeIds) {
            Pair<Long, Node> pair = this.nodesCache.getByKey(nodeId);
            if (pair == null || ((Node)pair.getSecond()).getDeleted(this.qnameDAO)) {
                uncachedNodeIds.add(nodeId);
                continue;
            }
            results.add(((Node)pair.getSecond()).getNodePair());
        }
        if (!uncachedNodeIds.isEmpty()) {
            List<Node> dbNodes = this.selectNodesByIds(uncachedNodeIds);
            for (Node dbNode : dbNodes) {
                Long nodeId = dbNode.getId();
                if (dbNode.getDeleted(this.qnameDAO)) {
                    this.pruneDanglingAssocs(nodeId);
                    continue;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Repairing stale cache entry for node: " + nodeId));
                }
                this.invalidateNodeCaches(nodeId);
                dbNode.lock();
                this.nodesCache.setValue(nodeId, dbNode);
                results.add(dbNode.getNodePair());
            }
        }
        return results;
    }

    private Node getNodeNotNull(Long nodeId, boolean liveOnly) {
        Pair<Long, Node> pair = this.nodesCache.getByKey(nodeId);
        if (pair == null) {
            NodeEntity dbNode = this.selectNodeById(nodeId);
            this.nodesCache.removeByKey(nodeId);
            throw new ConcurrencyFailureException("No node row exists: \n   ID:        " + nodeId + "\n" + "   DB row:    " + dbNode);
        }
        if (((Node)pair.getSecond()).getDeleted(this.qnameDAO) && liveOnly) {
            NodeEntity dbNode = this.selectNodeById(nodeId);
            this.nodesCache.removeByKey(nodeId);
            this.pruneDanglingAssocs(nodeId);
            throw new ConcurrencyFailureException("No live node exists: \n   ID:        " + nodeId + "\n" + "   DB row:    " + dbNode);
        }
        return (Node)pair.getSecond();
    }

    private List<Node> getNodesNotNull(List<Long> nodeIds, boolean liveOnly) {
        List<Pair<Long, Node>> pairs = this.nodesCache.getByKeys(nodeIds);
        if (pairs.isEmpty()) {
            List<NodeEntity> dbNodes = this.selectNodesByIds(nodeIds);
            this.nodesCache.removeByKeys(nodeIds);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No node rows exists: \n   IDs:        " + nodeIds + "\n" + "   DB rows:    " + dbNodes));
            }
            return Collections.emptyList();
        }
        Set pairNodeIds = pairs.stream().map(Pair::getFirst).collect(Collectors.toSet());
        nodeIds.stream().filter(nodeId -> !pairNodeIds.contains(nodeId)).forEach(this.nodesCache::removeByKey);
        ArrayList<Long> deletedNodeIds = new ArrayList<Long>();
        ArrayList<Node> liveNodes = new ArrayList<Node>();
        for (Pair<Long, Node> pair : pairs) {
            if (((Node)pair.getSecond()).getDeleted(this.qnameDAO) && liveOnly) {
                deletedNodeIds.add((Long)pair.getFirst());
                continue;
            }
            liveNodes.add((Node)pair.getSecond());
        }
        if (!deletedNodeIds.isEmpty()) {
            this.nodesCache.removeByKeys(deletedNodeIds);
            for (Long nodeId2 : deletedNodeIds) {
                this.pruneDanglingAssocs(nodeId2);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("No node rows exists: \n   IDs:        " + nodeId2 + "\n"));
            }
        }
        return liveNodes;
    }

    @Override
    public QName getNodeType(Long nodeId) {
        Node node = this.getNodeNotNull(nodeId, false);
        Long nodeTypeQNameId = node.getTypeQNameId();
        return (QName)this.qnameDAO.getQName(nodeTypeQNameId).getSecond();
    }

    @Override
    public Long getNodeAclId(Long nodeId) {
        Node node = this.getNodeNotNull(nodeId, true);
        return node.getAclId();
    }

    @Override
    public ChildAssocEntity newNode(Long parentNodeId, QName assocTypeQName, QName assocQName, StoreRef storeRef, String uuid, QName nodeTypeQName, Locale nodeLocale, String childNodeName, Map<QName, Serializable> auditableProperties) throws InvalidTypeException {
        AuditablePropertiesEntity auditableProps;
        boolean setAuditProps;
        Assert.notNull((Object)parentNodeId, (String)"parentNodeId");
        Assert.notNull((Object)assocTypeQName, (String)"assocTypeQName");
        Assert.notNull((Object)assocQName, (String)"assocQName");
        Assert.notNull((Object)storeRef, (String)"storeRef");
        if (auditableProperties == null) {
            auditableProperties = Collections.emptyMap();
        }
        Node parentNode = this.getNodeNotNull(parentNodeId, true);
        Long parentAclId = parentNode.getAclId();
        AccessControlListProperties inheritedAcl = null;
        Long childAclId = null;
        if (parentAclId != null) {
            try {
                Long inheritedACL = this.aclDAO.getInheritedAccessControlList(parentAclId);
                inheritedAcl = this.aclDAO.getAccessControlListProperties(inheritedACL);
                if (inheritedAcl != null) {
                    childAclId = inheritedAcl.getId();
                }
            }
            catch (RuntimeException e) {
                this.invalidateNodeCaches(parentNodeId);
                throw new RuntimeException("Failure while 'getting' inherited ACL or ACL properties: \n   parent ACL ID:  " + parentAclId + "\n" + "   inheritied ACL: " + inheritedAcl, e);
            }
        }
        if (!(setAuditProps = (auditableProps = new AuditablePropertiesEntity()).setAuditValues(null, null, auditableProperties))) {
            auditableProps = null;
        }
        StoreEntity store = this.getStoreNotNull(storeRef);
        Long nodeTypeQNameId = (Long)this.qnameDAO.getOrCreateQName(nodeTypeQName).getFirst();
        Long nodeLocaleId = (Long)this.localeDAO.getOrCreateLocalePair(nodeLocale).getFirst();
        NodeEntity node = this.newNodeImpl(store, uuid, nodeTypeQNameId, nodeLocaleId, childAclId, auditableProps, true);
        Long nodeId = node.getId();
        if (setAuditProps) {
            NodeRef nodeRef = node.getNodeRef();
            this.policyBehaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
        }
        if (childNodeName == null) {
            childNodeName = node.getUuid();
        }
        ChildAssocEntity assoc = this.newChildAssocImpl(parentNodeId, nodeId, true, assocTypeQName, assocQName, childNodeName, false);
        boolean isRoot = false;
        boolean isStoreRoot = nodeTypeQName.equals((Object)ContentModel.TYPE_STOREROOT);
        ParentAssocsInfo parentAssocsInfo = new ParentAssocsInfo(isRoot, isStoreRoot, assoc);
        this.setParentAssocsCached(nodeId, parentAssocsInfo);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Created new node: \n   Node: " + node + "\n" + "   Assoc: " + assoc));
        }
        return assoc;
    }

    private NodeEntity newNodeImpl(StoreEntity store, String uuid, Long nodeTypeQNameId, Long nodeLocaleId, Long aclId, AuditablePropertiesEntity auditableProps, boolean allowAuditableAspect) throws InvalidTypeException {
        NodeEntity node = new NodeEntity();
        node.setStore(store);
        if (uuid == null) {
            node.setUuid(GUID.generate());
        } else {
            node.setUuid(uuid);
        }
        node.setTypeQNameId(nodeTypeQNameId);
        QName nodeTypeQName = (QName)this.qnameDAO.getQName(nodeTypeQNameId).getSecond();
        if (nodeLocaleId == null) {
            nodeLocaleId = (Long)this.localeDAO.getOrCreateDefaultLocalePair().getFirst();
        }
        node.setLocaleId(nodeLocaleId);
        node.setAclId(aclId);
        TransactionEntity txn = this.getCurrentTransaction();
        node.setTransaction(txn);
        boolean addAuditableAspect = false;
        if (auditableProps != null) {
            node.setAuditableProperties(auditableProps);
            addAuditableAspect = true;
        } else if (AuditablePropertiesEntity.hasAuditableAspect(nodeTypeQName, this.dictionaryService)) {
            auditableProps = new AuditablePropertiesEntity();
            auditableProps.setAuditValues(null, null, true, 0L);
            node.setAuditableProperties(auditableProps);
            addAuditableAspect = true;
        }
        if (!allowAuditableAspect) {
            addAuditableAspect = false;
        }
        Long id = this.newNodeImplInsert(node);
        node.setId(id);
        Set<QName> nodeAspects = null;
        if (addAuditableAspect) {
            Long auditableAspectQNameId = (Long)this.qnameDAO.getOrCreateQName(ContentModel.ASPECT_AUDITABLE).getFirst();
            this.insertNodeAspect(id, auditableAspectQNameId);
            nodeAspects = Collections.singleton(ContentModel.ASPECT_AUDITABLE);
        } else {
            nodeAspects = Collections.emptySet();
        }
        node.lock();
        this.nodesCache.setValue(id, node);
        this.setNodeAspectsCached(id, nodeAspects);
        this.setNodePropertiesCached(id, Collections.emptyMap());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Created new node: \n   " + node));
        }
        return node;
    }

    protected Long newNodeImplInsert(NodeEntity node) {
        Long id = null;
        Savepoint savepoint = this.controlDAO.createSavepoint("newNodeImpl");
        try {
            id = this.insertNode(node);
            this.controlDAO.releaseSavepoint(savepoint);
        }
        catch (Throwable e) {
            this.controlDAO.rollbackToSavepoint(savepoint);
            NodeRef targetNodeRef = node.getNodeRef();
            NodeEntity dbTargetNode = this.selectNodeByNodeRef(targetNodeRef);
            if (dbTargetNode == null) {
                throw new AlfrescoRuntimeException("Failed to insert new node: " + node, e);
            }
            if (dbTargetNode.getDeleted(this.qnameDAO)) {
                Long dbTargetNodeId = dbTargetNode.getId();
                this.deleteNodeProperties(dbTargetNodeId, (Set<Long>)null);
                this.deleteNodeById(dbTargetNodeId);
                id = this.insertNode(node);
            }
            throw new NodeExistsException(dbTargetNode.getNodePair(), e);
        }
        return id;
    }

    @Override
    public Pair<Pair<Long, ChildAssociationRef>, Pair<Long, NodeRef>> moveNode(Long childNodeId, Long newParentNodeId, QName assocTypeQName, QName assocQName) {
        Long oldParentNodeId;
        Long oldParentAclId;
        Node newParentNode = this.getNodeNotNull(newParentNodeId, true);
        StoreEntity newParentStore = newParentNode.getStore();
        Node childNode = this.getNodeNotNull(childNodeId, true);
        StoreEntity childStore = childNode.getStore();
        ChildAssocEntity primaryParentAssoc = this.getPrimaryParentAssocImpl(childNodeId);
        if (primaryParentAssoc == null) {
            oldParentAclId = null;
            oldParentNodeId = null;
        } else if (primaryParentAssoc.getParentNode() == null) {
            oldParentAclId = null;
            oldParentNodeId = null;
        } else {
            oldParentNodeId = primaryParentAssoc.getParentNode().getId();
            oldParentAclId = this.getNodeNotNull(oldParentNodeId, true).getAclId();
        }
        String childNodeName = (String)((Object)this.getNodeProperty(childNodeId, ContentModel.PROP_NAME));
        Node newChildNode = childNode;
        if (!childStore.getId().equals(newParentStore.getId())) {
            AuditablePropertiesEntity auditableProps = childNode.getAuditableProperties();
            newChildNode = this.newNodeImpl(newParentStore, childNode.getUuid(), childNode.getTypeQNameId(), childNode.getLocaleId(), childNode.getAclId(), auditableProps, false);
            Long newChildNodeId = newChildNode.getId();
            this.moveNodeData(childNode.getId(), newChildNodeId);
            this.invalidateNodeCaches(newChildNodeId);
            this.invalidateNodeChildrenCaches(newChildNodeId, true, true);
            this.invalidateNodeChildrenCaches(newChildNodeId, false, true);
            this.deleteNodeImpl(childNodeId, false);
        } else {
            this.touchNode(childNodeId, null, null, false, false, true);
        }
        Long newChildNodeId = newChildNode.getId();
        this.updatePrimaryParentAssocs(primaryParentAssoc, newParentNode, childNode, newChildNodeId, childNodeName, oldParentNodeId, assocTypeQName, assocQName);
        if (!EqualsHelper.nullSafeEquals((Object)newParentNodeId, (Object)oldParentNodeId)) {
            this.getPaths(newChildNode.getNodePair(), false);
            Long newParentAclId = newParentNode.getAclId();
            if (this.hasNodeAspect(oldParentNodeId, ContentModel.ASPECT_PENDING_FIX_ACL)) {
                Long oldParentSharedAclId = (Long)this.getNodeProperty(oldParentNodeId, ContentModel.PROP_SHARED_ACL_TO_REPLACE);
                this.accessControlListDAO.updateInheritance(newChildNodeId, oldParentSharedAclId, newParentAclId);
            } else {
                this.accessControlListDAO.updateInheritance(newChildNodeId, oldParentAclId, newParentAclId);
            }
        }
        Pair<Long, ChildAssociationRef> assocPair = this.getPrimaryParentAssoc(newChildNode.getId());
        Pair<Long, NodeRef> nodePair = newChildNode.getNodePair();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Moved node: " + assocPair + " ... " + nodePair));
        }
        return new Pair(assocPair, nodePair);
    }

    protected void updatePrimaryParentAssocs(final ChildAssocEntity primaryParentAssoc, final Node newParentNode, final Node childNode, final Long newChildNodeId, final String childNodeName, final Long oldParentNodeId, final QName assocTypeQName, final QName assocQName) {
        RetryingCallbackHelper.RetryingCallback<Integer> callback = new RetryingCallbackHelper.RetryingCallback<Integer>(){

            @Override
            public Integer execute() throws Throwable {
                return AbstractNodeDAOImpl.this.updatePrimaryParentAssocsImpl(primaryParentAssoc, newParentNode, childNode, newChildNodeId, childNodeName, oldParentNodeId, assocTypeQName, assocQName);
            }
        };
        this.childAssocRetryingHelper.doWithRetry(callback);
    }

    protected int updatePrimaryParentAssocsImpl(ChildAssocEntity primaryParentAssoc, Node newParentNode, Node childNode, Long newChildNodeId, String childNodeName, Long oldParentNodeId, QName assocTypeQName, QName assocQName) {
        Long newParentNodeId = newParentNode.getId();
        Long childNodeId = childNode.getId();
        Savepoint savepoint = this.controlDAO.createSavepoint("DuplicateChildNodeNameException");
        String childNodeNameToUse = childNodeName == null ? childNode.getUuid() : childNodeName;
        try {
            Pair<Long, QName> oldTypeQnamePair;
            int updated = this.updatePrimaryParentAssocs(newChildNodeId, newParentNodeId, assocTypeQName, assocQName, childNodeNameToUse);
            this.controlDAO.releaseSavepoint(savepoint);
            if (updated > 0 && primaryParentAssoc != null && (oldTypeQnamePair = this.qnameDAO.getQName(primaryParentAssoc.getTypeQNameId())) != null) {
                this.childByNameCache.remove((Serializable)new ChildByNameKey(oldParentNodeId, (QName)oldTypeQnamePair.getSecond(), primaryParentAssoc.getChildNodeName()));
            }
            return updated;
        }
        catch (Throwable e) {
            this.controlDAO.rollbackToSavepoint(savepoint);
            String lowerMsg = e.getMessage().toLowerCase();
            if (lowerMsg.contains("fk_alf_cass_")) {
                throw new ConcurrencyFailureException("FK violation updating primary parent association for " + childNodeId, e);
            }
            throw new DuplicateChildNodeNameException(newParentNode.getNodeRef(), assocTypeQName, childNodeName, e);
        }
    }

    @Override
    public boolean updateNode(Long nodeId, QName nodeTypeQName, Locale nodeLocale) {
        Node oldNode = this.getNodeNotNull(nodeId, true);
        Long nodeTypeQNameId = nodeTypeQName == null ? oldNode.getTypeQNameId() : (Long)this.qnameDAO.getOrCreateQName(nodeTypeQName).getFirst();
        Long nodeLocaleId = nodeLocale == null ? oldNode.getLocaleId() : (Long)this.localeDAO.getOrCreateLocalePair(nodeLocale).getFirst();
        NodeUpdateEntity nodeUpdate = new NodeUpdateEntity();
        nodeUpdate.setId(nodeId);
        nodeUpdate.setStore(oldNode.getStore());
        nodeUpdate.setUuid(oldNode.getUuid());
        if (!nodeTypeQNameId.equals(oldNode.getTypeQNameId())) {
            nodeUpdate.setTypeQNameId(nodeTypeQNameId);
            nodeUpdate.setUpdateTypeQNameId(true);
        }
        if (!nodeLocaleId.equals(oldNode.getLocaleId())) {
            nodeUpdate.setLocaleId(nodeLocaleId);
            nodeUpdate.setUpdateLocaleId(true);
        }
        return this.updateNodeImpl(oldNode, nodeUpdate, null);
    }

    @Override
    public int touchNodes(Long txnId, List<Long> nodeIds) {
        int batchSize = 1000;
        int touched = 0;
        ArrayList<Long> batch = new ArrayList<Long>(batchSize);
        for (Long nodeId : nodeIds) {
            this.invalidateNodeCaches(nodeId);
            batch.add(nodeId);
            if (batch.size() % batchSize != 0) continue;
            touched += this.updateNodes(txnId, batch);
            batch.clear();
        }
        if (batch.size() > 0) {
            touched += this.updateNodes(txnId, batch);
        }
        return touched;
    }

    private boolean touchNode(Long nodeId, AuditablePropertiesEntity auditableProps, Set<QName> nodeAspects, boolean invalidateNodeAspectsCache, boolean invalidateNodePropertiesCache, boolean invalidateParentAssocsCache) {
        Node node = null;
        try {
            node = this.getNodeNotNull(nodeId, false);
        }
        catch (DataIntegrityViolationException dataIntegrityViolationException) {
            return false;
        }
        NodeUpdateEntity nodeUpdate = new NodeUpdateEntity();
        nodeUpdate.setId(nodeId);
        nodeUpdate.setAuditableProperties(auditableProps);
        boolean updatedNode = this.updateNodeImpl(node, nodeUpdate, nodeAspects);
        NodeVersionKey nodeVersionKey = node.getNodeVersionKey();
        if (updatedNode) {
            Node newNode = this.getNodeNotNull(nodeId, false);
            NodeVersionKey newNodeVersionKey = newNode.getNodeVersionKey();
            if (!invalidateNodeAspectsCache) {
                this.copyNodeAspectsCached(nodeVersionKey, newNodeVersionKey);
            }
            if (!invalidateNodePropertiesCache) {
                this.copyNodePropertiesCached(nodeVersionKey, newNodeVersionKey);
            }
            if (invalidateParentAssocsCache) {
                this.invalidateParentAssocsCached(node);
            } else {
                this.copyParentAssocsCached(node);
            }
        } else {
            this.invalidateNodeCaches(node, invalidateNodeAspectsCache, invalidateNodePropertiesCache, invalidateParentAssocsCache);
        }
        return updatedNode;
    }

    private boolean updateNodeImpl(Node oldNode, NodeUpdateEntity nodeUpdate, Set<QName> nodeAspects) {
        Long nodeId = oldNode.getId();
        if (!EqualsHelper.nullSafeEquals((Object)nodeId, (Object)nodeUpdate.getId())) {
            throw new IllegalArgumentException("NodeUpdateEntity node ID is not correct: " + nodeUpdate);
        }
        nodeUpdate.setStore(oldNode.getStore());
        nodeUpdate.setUuid(oldNode.getUuid());
        if (!nodeUpdate.isUpdateTypeQNameId()) {
            nodeUpdate.setTypeQNameId(oldNode.getTypeQNameId());
        }
        if (!nodeUpdate.isUpdateLocaleId()) {
            nodeUpdate.setLocaleId(oldNode.getLocaleId());
        }
        if (!nodeUpdate.isUpdateAclId()) {
            nodeUpdate.setAclId(oldNode.getAclId());
        }
        nodeUpdate.setVersion(oldNode.getVersion());
        TransactionEntity txn = this.getCurrentTransaction();
        nodeUpdate.setTransaction(txn);
        if (!txn.getId().equals(oldNode.getTransaction().getId())) {
            nodeUpdate.setUpdateTransaction(true);
        }
        if (nodeAspects == null) {
            nodeAspects = this.getNodeAspects(nodeId);
        }
        if (nodeAspects.contains(ContentModel.ASPECT_AUDITABLE)) {
            AuditablePropertiesEntity auditableProps;
            NodeRef oldNodeRef = oldNode.getNodeRef();
            if (this.policyBehaviourFilter.isEnabled(oldNodeRef, ContentModel.ASPECT_AUDITABLE)) {
                auditableProps = oldNode.getAuditableProperties();
                auditableProps = auditableProps == null ? new AuditablePropertiesEntity() : new AuditablePropertiesEntity(auditableProps);
                long modifiedDateToleranceMs = 1000L;
                if (nodeUpdate.isUpdateTransaction()) {
                    modifiedDateToleranceMs = 0L;
                }
                boolean updateAuditableProperties = auditableProps.setAuditValues(null, null, false, modifiedDateToleranceMs);
                nodeUpdate.setAuditableProperties(auditableProps);
                nodeUpdate.setUpdateAuditableProperties(updateAuditableProperties);
            } else if (nodeUpdate.getAuditableProperties() == null) {
                auditableProps = oldNode.getAuditableProperties();
                if (auditableProps != null) {
                    nodeUpdate.setAuditableProperties(auditableProps);
                    nodeUpdate.setUpdateAuditableProperties(true);
                }
            } else {
                nodeUpdate.setUpdateAuditableProperties(true);
            }
        } else {
            AuditablePropertiesEntity auditableProps = oldNode.getAuditableProperties();
            if (auditableProps != null) {
                nodeUpdate.setAuditableProperties(null);
                nodeUpdate.setUpdateAuditableProperties(true);
            }
        }
        if (!nodeUpdate.isUpdateAnything()) {
            return false;
        }
        int count = 0;
        Throwable concurrencyException = null;
        try {
            count = this.updateNode(nodeUpdate);
        }
        catch (Throwable e) {
            concurrencyException = e;
        }
        if (count != 1) {
            this.nodesCache.removeByKey(nodeId);
            this.nodesCache.removeByValue(nodeUpdate);
            throw new ConcurrencyFailureException("Failed to update node " + nodeId, concurrencyException);
        }
        if (nodeUpdate.getVersion().equals(LONG_ZERO)) {
            this.propertiesCache.clear();
            this.aspectsCache.clear();
            this.parentAssocsCache.clear();
        }
        nodeUpdate.lock();
        this.nodesCache.setValue(nodeId, nodeUpdate);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Updated Node: \n   OLD: " + oldNode + "\n" + "   NEW: " + nodeUpdate));
        }
        return true;
    }

    @Override
    public void setNodeAclId(Long nodeId, Long aclId) {
        Node oldNode = this.getNodeNotNull(nodeId, true);
        NodeUpdateEntity nodeUpdateEntity = new NodeUpdateEntity();
        nodeUpdateEntity.setId(nodeId);
        nodeUpdateEntity.setAclId(aclId);
        nodeUpdateEntity.setUpdateAclId(true);
        this.updateNodeImpl(oldNode, nodeUpdateEntity, null);
    }

    @Override
    public void setPrimaryChildrenSharedAclId(Long primaryParentNodeId, Long optionalOldSharedAlcIdInAdditionToNull, Long newSharedAclId) {
        Long txnId = this.getCurrentTransaction().getId();
        this.updatePrimaryChildrenSharedAclId(txnId, primaryParentNodeId, optionalOldSharedAlcIdInAdditionToNull, newSharedAclId);
        this.invalidateNodeChildrenCaches(primaryParentNodeId, true, false);
    }

    @Override
    public void deleteNode(Long nodeId) {
        this.deleteNodeImpl(nodeId, true);
    }

    private void deleteNodeImpl(Long nodeId, boolean deleteAcl) {
        Node node = this.getNodeNotNull(nodeId, true);
        Long aclId = node.getAclId();
        Set<QName> nodeAspects = this.getNodeAspects(nodeId);
        HashSet<QName> contentQNames = new HashSet<QName>(this.dictionaryService.getAllProperties(DataTypeDefinition.CONTENT));
        Set<Long> contentQNamesToRemoveIds = this.qnameDAO.convertQNamesToIds(contentQNames, false);
        this.contentDataDAO.deleteContentDataForNode(nodeId, contentQNamesToRemoveIds);
        this.usageDAO.deleteDeltas(nodeId);
        if (nodeAspects.contains(ContentModel.ASPECT_ROOT)) {
            StoreRef storeRef = node.getStore().getStoreRef();
            this.allRootNodesCache.remove((Serializable)storeRef);
        }
        this.invalidateNodeChildrenCaches(nodeId, true, true);
        this.invalidateNodeChildrenCaches(nodeId, false, true);
        this.deleteNodeAspects(nodeId, null);
        this.deleteNodeProperties(nodeId, (Set<Long>)null);
        this.deleteSubscriptions(nodeId);
        int deleted = this.deleteNodeById(nodeId);
        this.invalidateNodeCaches(nodeId);
        if (deleted != 1) {
            throw new ConcurrencyFailureException("Failed to delete node: \n   Node: " + node);
        }
        if (deleteAcl && aclId != null) {
            this.aclDAO.deleteAclForNode(aclId);
        }
        StoreEntity store = node.getStore();
        String uuid = node.getUuid();
        Long deletedQNameId = (Long)this.qnameDAO.getOrCreateQName(ContentModel.TYPE_DELETED).getFirst();
        Long defaultLocaleId = (Long)this.localeDAO.getOrCreateDefaultLocalePair().getFirst();
        NodeEntity deletedNode = this.newNodeImpl(store, uuid, deletedQNameId, defaultLocaleId, null, null, true);
        Long deletedNodeId = deletedNode.getId();
        Map<QName, Serializable> trackingProps = Collections.singletonMap(ContentModel.PROP_ORIGINAL_ID, nodeId);
        this.setNodePropertiesImpl(deletedNodeId, trackingProps, true);
    }

    @Override
    public int purgeNodes(long fromTxnCommitTimeMs, long toTxnCommitTimeMs) {
        return this.deleteNodesByCommitTime(fromTxnCommitTimeMs, toTxnCommitTimeMs);
    }

    @Override
    public Map<QName, Serializable> getNodeProperties(Long nodeId) {
        Map<QName, Serializable> props = this.getNodePropertiesCached(nodeId);
        props = new HashMap<QName, Serializable>(props);
        Node node = this.getNodeNotNull(nodeId, false);
        ReferenceablePropertiesEntity.addReferenceableProperties(node, props);
        LocalizedPropertiesEntity.addLocalizedProperties(this.localeDAO, node, props);
        if (this.hasNodeAspect(nodeId, ContentModel.ASPECT_AUDITABLE)) {
            AuditablePropertiesEntity auditableProperties = node.getAuditableProperties();
            if (auditableProperties == null) {
                auditableProperties = new AuditablePropertiesEntity();
            }
            props.putAll(auditableProperties.getAuditableProperties());
        }
        props = new ValueProtectingMap<QName, Serializable>(props, NodePropertyValue.IMMUTABLE_CLASSES);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Fetched properties for Node: \n   Node:  " + nodeId + "\n" + "   Props: " + props));
        }
        return props;
    }

    @Override
    public Map<Long, Map<QName, Serializable>> getNodeProperties(List<Long> nodeIds) {
        Map<Long, Map<QName, Serializable>> props = this.getNodePropertiesCached(nodeIds);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Fetched cached properties for Nodes: \n   Node Ids: " + nodeIds + "\n" + "   Props:    " + props));
        }
        props = new HashMap<Long, Map<QName, Serializable>>(props);
        List<Node> nodes = this.getNodesNotNull(nodeIds, false);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Fetched nodes for Nodes: \n   Node Ids: " + nodeIds + "\n" + "   Nodes:    " + nodes));
        }
        for (Node node : nodes) {
            Map<QName, Serializable> nodeProps = new HashMap<QName, Serializable>(props.get(node.getId()));
            ReferenceablePropertiesEntity.addReferenceableProperties(node.getId(), node.getNodeRef(), nodeProps);
            LocalizedPropertiesEntity.addLocalizedProperties(this.localeDAO, node, nodeProps);
            if (this.hasNodeAspect(node.getId(), ContentModel.ASPECT_AUDITABLE)) {
                AuditablePropertiesEntity auditableProperties = node.getAuditableProperties();
                if (auditableProperties == null) {
                    auditableProperties = new AuditablePropertiesEntity();
                }
                nodeProps.putAll(auditableProperties.getAuditableProperties());
            }
            nodeProps = new ValueProtectingMap<QName, Serializable>(nodeProps, NodePropertyValue.IMMUTABLE_CLASSES);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Fetched properties for Node: \n   Node:  " + node.getId() + "\n" + "   Props: " + nodeProps));
            }
            props.put(node.getId(), nodeProps);
        }
        return props;
    }

    @Override
    public Serializable getNodeProperty(Long nodeId, QName propertyQName) {
        Serializable value = null;
        if (AuditablePropertiesEntity.isAuditableProperty(propertyQName)) {
            Node node = this.getNodeNotNull(nodeId, false);
            AuditablePropertiesEntity auditableProperties = node.getAuditableProperties();
            if (auditableProperties != null) {
                value = auditableProperties.getAuditableProperty(propertyQName);
            }
        } else if (ReferenceablePropertiesEntity.isReferenceableProperty(propertyQName)) {
            Node node = this.getNodeNotNull(nodeId, false);
            value = ReferenceablePropertiesEntity.getReferenceableProperty(node, propertyQName);
        } else if (LocalizedPropertiesEntity.isLocalizedProperty(propertyQName)) {
            Node node = this.getNodeNotNull(nodeId, false);
            value = LocalizedPropertiesEntity.getLocalizedProperty(this.localeDAO, node, propertyQName);
        } else {
            Map<QName, Serializable> props = this.getNodePropertiesCached(nodeId);
            props = new ValueProtectingMap<QName, Serializable>(props, NodePropertyValue.IMMUTABLE_CLASSES);
            value = props.get(propertyQName);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Fetched property for Node: \n   Node:  " + nodeId + "\n" + "   QName: " + propertyQName + "\n" + "   Value: " + value));
        }
        return value;
    }

    private boolean setNodePropertiesImpl(Long nodeId, Map<QName, Serializable> newProps, boolean isAddOnly) {
        boolean updated;
        Long newNodeLocaleId;
        if (isAddOnly && newProps.size() == 0) {
            return false;
        }
        Node node = this.getNodeNotNull(nodeId, false);
        NodeUpdateEntity nodeUpdate = new NodeUpdateEntity();
        nodeUpdate.setId(nodeId);
        newProps = new HashMap<QName, Serializable>(newProps);
        if (!this.policyBehaviourFilter.isEnabled(node.getNodeRef(), ContentModel.ASPECT_AUDITABLE) && AuditablePropertiesEntity.hasAuditableProperty(newProps.keySet())) {
            AuditablePropertiesEntity auditableProps = node.getAuditableProperties();
            auditableProps = auditableProps == null ? new AuditablePropertiesEntity() : new AuditablePropertiesEntity(auditableProps);
            boolean containedAuditProperties = auditableProps.setAuditValues(null, null, newProps);
            if (!containedAuditProperties) {
                auditableProps = null;
            }
            nodeUpdate.setAuditableProperties(auditableProps);
            nodeUpdate.setUpdateAuditableProperties(true);
        }
        newProps.keySet().removeAll(AuditablePropertiesEntity.getAuditablePropertyQNames());
        Long oldNodeLocaleId = node.getLocaleId();
        Locale newLocale = (Locale)DefaultTypeConverter.INSTANCE.convert(Locale.class, (Object)newProps.get(ContentModel.PROP_LOCALE));
        if (newLocale != null && !(newNodeLocaleId = (Long)this.localeDAO.getOrCreateLocalePair(newLocale).getFirst()).equals(oldNodeLocaleId)) {
            nodeUpdate.setLocaleId(newNodeLocaleId);
            nodeUpdate.setUpdateLocaleId(true);
        }
        LocalizedPropertiesEntity.removeLocalizedProperties(node, newProps);
        ReferenceablePropertiesEntity.removeReferenceableProperties(node, newProps);
        Map<QName, Serializable> oldPropsCached = this.getNodePropertiesCached(nodeId);
        HashMap<QName, Serializable> oldProps = new HashMap<QName, Serializable>(oldPropsCached);
        if (isAddOnly) {
            oldProps.keySet().retainAll(newProps.keySet());
        }
        Map<NodePropertyKey, NodePropertyValue> newPropsRaw = this.nodePropertyHelper.convertToPersistentProperties(newProps);
        newProps = this.nodePropertyHelper.convertToPublicProperties(newPropsRaw);
        Map diff = EqualsHelper.getMapComparison(oldProps, newProps);
        HashSet<QName> propsToDelete = new HashSet<QName>(oldProps.size() * 2);
        HashMap<QName, Serializable> propsToAdd = new HashMap<QName, Serializable>(newProps.size() * 2);
        HashSet<QName> contentQNamesToDelete = new HashSet<QName>(5);
        block10: for (Map.Entry entry : diff.entrySet()) {
            QName qname = (QName)entry.getKey();
            PropertyDefinition removePropDef = this.dictionaryService.getProperty(qname);
            boolean isContent = removePropDef != null && removePropDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT);
            switch ((EqualsHelper.MapValueComparison)entry.getValue()) {
                case EQUAL: {
                    break;
                }
                case LEFT_ONLY: {
                    propsToDelete.add(qname);
                    if (!isContent) continue block10;
                    contentQNamesToDelete.add(qname);
                    break;
                }
                case NOT_EQUAL: {
                    propsToDelete.add(qname);
                    if (isContent) {
                        contentQNamesToDelete.add(qname);
                    }
                }
                case RIGHT_ONLY: {
                    Object value = newProps.get(qname);
                    if (isContent && value != null) {
                        ContentData newContentData = (ContentData)value;
                        Long newContentDataId = (Long)this.contentDataDAO.createContentData(newContentData).getFirst();
                        value = new ContentDataWithId(newContentData, newContentDataId);
                    }
                    propsToAdd.put(qname, (Serializable)value);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown MapValueComparison: " + entry.getValue());
                }
            }
        }
        boolean modifyProps = propsToDelete.size() > 0 || propsToAdd.size() > 0;
        boolean bl = updated = modifyProps || nodeUpdate.isUpdateAnything();
        if (nodeUpdate.isUpdateAnything()) {
            if (this.updateNodeImpl(node, nodeUpdate, null)) {
                NodeVersionKey nodeVersionKey = node.getNodeVersionKey();
                NodeVersionKey newNodeVersionKey = this.getNodeNotNull(nodeId, false).getNodeVersionKey();
                this.copyNodeAspectsCached(nodeVersionKey, newNodeVersionKey);
                this.copyNodePropertiesCached(nodeVersionKey, newNodeVersionKey);
                this.copyParentAssocsCached(node);
            }
        } else if (modifyProps) {
            this.touchNode(nodeId, null, null, false, false, false);
        }
        if (modifyProps) {
            try {
                if (contentQNamesToDelete.size() > 0) {
                    Set<Long> contentQNameIdsToDelete = this.qnameDAO.convertQNamesToIds(contentQNamesToDelete, false);
                    this.contentDataDAO.deleteContentDataForNode(nodeId, contentQNameIdsToDelete);
                }
            }
            catch (Throwable e) {
                throw new AlfrescoRuntimeException("Failed to delete content properties: \n  Node:          " + nodeId + "\n" + "  Delete Tried:  " + contentQNamesToDelete, e);
            }
            try {
                Set<Long> propQNameIdsToDelete = this.qnameDAO.convertQNamesToIds(propsToDelete, true);
                this.deleteNodeProperties(nodeId, propQNameIdsToDelete);
                newPropsRaw = this.nodePropertyHelper.convertToPersistentProperties(propsToAdd);
                this.insertNodeProperties(nodeId, newPropsRaw);
            }
            catch (Throwable e) {
                this.invalidateNodeCaches(nodeId);
                throw new AlfrescoRuntimeException("Failed to write property deltas: \n  Node:          " + nodeId + "\n" + "  Old:           " + oldProps + "\n" + "  New:           " + newProps + "\n" + "  Diff:          " + diff + "\n" + "  Delete Tried:  " + propsToDelete + "\n" + "  Add Tried:     " + propsToAdd, e);
            }
            Map<QName, Serializable> propsToCache = null;
            if (isAddOnly) {
                propsToCache = new HashMap<QName, Serializable>(oldPropsCached);
                propsToCache.putAll(propsToAdd);
            } else {
                propsToCache = newProps;
                propsToCache.putAll(propsToAdd);
            }
            this.setNodePropertiesCached(nodeId, propsToCache);
        }
        if (this.logger.isDebugEnabled() && updated) {
            this.logger.debug((Object)("Modified node properties: " + nodeId + "\n" + "   Removed:     " + propsToDelete + "\n" + "   Added:       " + propsToAdd + "\n" + "   Node Update: " + nodeUpdate));
        }
        return updated;
    }

    @Override
    public boolean setNodeProperties(Long nodeId, Map<QName, Serializable> properties) {
        boolean modified = this.setNodePropertiesImpl(nodeId, properties, false);
        return modified;
    }

    @Override
    public boolean addNodeProperty(Long nodeId, QName qname, Serializable value) {
        HashMap<QName, Serializable> newProps = new HashMap<QName, Serializable>(3);
        newProps.put(qname, value);
        boolean modified = this.setNodePropertiesImpl(nodeId, newProps, true);
        return modified;
    }

    @Override
    public boolean addNodeProperties(Long nodeId, Map<QName, Serializable> properties) {
        boolean modified = this.setNodePropertiesImpl(nodeId, properties, true);
        return modified;
    }

    @Override
    public boolean removeNodeProperties(Long nodeId, Set<QName> propertyQNames) {
        propertyQNames = new HashSet<QName>(propertyQNames);
        ReferenceablePropertiesEntity.removeReferenceableProperties(propertyQNames);
        if (propertyQNames.size() == 0) {
            return false;
        }
        LocalizedPropertiesEntity.removeLocalizedProperties(propertyQNames);
        if (propertyQNames.size() == 0) {
            return false;
        }
        Set<Long> qnameIds = this.qnameDAO.convertQNamesToIds(propertyQNames, false);
        int deleteCount = this.deleteNodeProperties(nodeId, qnameIds);
        if (deleteCount > 0) {
            this.touchNode(nodeId, null, null, false, false, false);
            Map<QName, Serializable> cachedProps = this.getNodePropertiesCached(nodeId);
            HashMap<QName, Serializable> props = new HashMap<QName, Serializable>(cachedProps);
            props.keySet().removeAll(propertyQNames);
            this.setNodePropertiesCached(nodeId, props);
        }
        return deleteCount > 0;
    }

    @Override
    public boolean setModifiedDate(Long nodeId, Date modifiedDate) {
        return this.setModifiedProperties(nodeId, modifiedDate, null);
    }

    @Override
    public boolean setModifiedProperties(Long nodeId, Date modifiedDate, String modifiedBy) {
        if (!this.hasNodeAspect(nodeId, ContentModel.ASPECT_AUDITABLE)) {
            return false;
        }
        Node node = this.getNodeNotNull(nodeId, false);
        NodeRef nodeRef = node.getNodeRef();
        AuditablePropertiesEntity auditableProps = node.getAuditableProperties();
        boolean dateChanged = false;
        if (auditableProps == null) {
            auditableProps = new AuditablePropertiesEntity();
            auditableProps.setAuditValues(modifiedBy, modifiedDate, true, 1000L);
            dateChanged = true;
        } else {
            dateChanged = (auditableProps = new AuditablePropertiesEntity(auditableProps)).setAuditModified(modifiedDate, 1000L);
            if (dateChanged) {
                auditableProps.setAuditModifier(modifiedBy);
            }
        }
        if (dateChanged) {
            try {
                this.policyBehaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
                boolean bl = this.touchNode(nodeId, auditableProps, null, false, false, false);
                return bl;
            }
            finally {
                this.policyBehaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
            }
        }
        return false;
    }

    private Map<QName, Serializable> getNodePropertiesCached(Long nodeId) {
        NodeVersionKey nodeVersionKey = this.getNodeNotNull(nodeId, false).getNodeVersionKey();
        Pair<NodeVersionKey, Map<QName, Serializable>> cacheEntry = this.propertiesCache.getByKey(nodeVersionKey);
        if (cacheEntry == null) {
            this.invalidateNodeCaches(nodeId);
            throw new DataIntegrityViolationException("Invalid node ID: " + nodeId);
        }
        Map cachedProperties = (Map)cacheEntry.getSecond();
        return cachedProperties;
    }

    private Map<Long, Map<QName, Serializable>> getNodePropertiesCached(List<Long> nodeIds) {
        HashMap<Long, Map<QName, Serializable>> result = new HashMap<Long, Map<QName, Serializable>>();
        List<Node> nodes = this.getNodesNotNull(nodeIds, false);
        List nodeVersionKeys = nodes.stream().map(Node::getNodeVersionKey).collect(Collectors.toList());
        List<Pair<NodeVersionKey, Map<QName, Serializable>>> cacheEntries = this.propertiesCache.getByKeys(nodeVersionKeys);
        result.putAll(cacheEntries.stream().collect(Collectors.toMap(entry -> ((NodeVersionKey)entry.getFirst()).getNodeId(), Pair::getSecond)));
        return result;
    }

    private void setNodePropertiesCached(Long nodeId, Map<QName, Serializable> properties) {
        NodeVersionKey nodeVersionKey = this.getNodeNotNull(nodeId, false).getNodeVersionKey();
        this.propertiesCache.setValue(nodeVersionKey, Collections.unmodifiableMap(properties));
    }

    private void copyNodePropertiesCached(NodeVersionKey from, NodeVersionKey to) {
        Map<QName, Serializable> cacheEntry = this.propertiesCache.getValue(from);
        if (cacheEntry != null) {
            this.propertiesCache.setValue(to, cacheEntry);
        }
    }

    @Override
    public Set<QName> getNodeAspects(Long nodeId) {
        Set<QName> nodeAspects = this.getNodeAspectsCached(nodeId);
        nodeAspects.add(ContentModel.ASPECT_REFERENCEABLE);
        nodeAspects.add(ContentModel.ASPECT_LOCALIZED);
        return nodeAspects;
    }

    @Override
    public Map<Long, Set<QName>> getNodeAspects(List<Long> nodeIds) {
        Map<Long, Set<QName>> nodeAspects = this.getNodeAspectsCached(nodeIds);
        for (Set<QName> aspects : nodeAspects.values()) {
            aspects.add(ContentModel.ASPECT_REFERENCEABLE);
            aspects.add(ContentModel.ASPECT_LOCALIZED);
        }
        return nodeAspects;
    }

    @Override
    public boolean hasNodeAspect(Long nodeId, QName aspectQName) {
        if (aspectQName.equals((Object)ContentModel.ASPECT_REFERENCEABLE)) {
            return true;
        }
        if (aspectQName.equals((Object)ContentModel.ASPECT_LOCALIZED)) {
            return true;
        }
        Set<QName> nodeAspects = this.getNodeAspectsCached(nodeId);
        return nodeAspects.contains(aspectQName);
    }

    @Override
    public boolean addNodeAspects(Long nodeId, Set<QName> aspectQNames) {
        if (aspectQNames.size() == 0) {
            return false;
        }
        HashSet<QName> aspectQNamesToAdd = new HashSet<QName>(aspectQNames);
        Set<QName> existingAspectQNames = this.getNodeAspectsCached(nodeId);
        aspectQNamesToAdd.removeAll(existingAspectQNames);
        aspectQNamesToAdd.remove(ContentModel.ASPECT_REFERENCEABLE);
        aspectQNamesToAdd.remove(ContentModel.ASPECT_LOCALIZED);
        if (aspectQNamesToAdd.isEmpty()) {
            return false;
        }
        Set<Long> aspectQNameIds = this.qnameDAO.convertQNamesToIds(aspectQNamesToAdd, true);
        this.startBatch();
        try {
            try {
                for (Long aspectQNameId : aspectQNameIds) {
                    this.insertNodeAspect(nodeId, aspectQNameId);
                }
            }
            catch (RuntimeException e) {
                this.invalidateNodeCaches(nodeId);
                throw e;
            }
        }
        finally {
            this.executeBatch();
        }
        HashSet<QName> newAspectQNames = new HashSet<QName>(existingAspectQNames);
        newAspectQNames.addAll(aspectQNamesToAdd);
        if (aspectQNames.contains(ContentModel.ASPECT_ROOT)) {
            StoreRef storeRef = this.getNodeNotNull(nodeId, false).getStore().getStoreRef();
            this.allRootNodesCache.remove((Serializable)storeRef);
            this.touchNode(nodeId, null, newAspectQNames, false, false, true);
        } else {
            this.touchNode(nodeId, null, newAspectQNames, false, false, false);
        }
        this.setNodeAspectsCached(nodeId, newAspectQNames);
        return true;
    }

    @Override
    public boolean removeNodeAspects(Long nodeId) {
        Set<QName> newAspectQNames = Collections.emptySet();
        this.touchNode(nodeId, null, newAspectQNames, false, false, false);
        int deleteCount = this.deleteNodeAspects(nodeId, null);
        this.setNodeAspectsCached(nodeId, newAspectQNames);
        return deleteCount > 0;
    }

    @Override
    public boolean removeNodeAspects(Long nodeId, Set<QName> aspectQNames) {
        if (aspectQNames.size() == 0) {
            return false;
        }
        Set<QName> existingAspectQNames = this.getNodeAspects(nodeId);
        HashSet<QName> newAspectQNames = new HashSet<QName>(existingAspectQNames);
        newAspectQNames.removeAll(aspectQNames);
        this.touchNode(nodeId, null, newAspectQNames, false, false, false);
        Set<Long> aspectQNameIdsToRemove = this.qnameDAO.convertQNamesToIds(aspectQNames, false);
        int deleteCount = this.deleteNodeAspects(nodeId, aspectQNameIdsToRemove);
        if (deleteCount == 0) {
            return false;
        }
        if (aspectQNames.contains(ContentModel.ASPECT_ROOT)) {
            StoreRef storeRef = this.getNodeNotNull(nodeId, false).getStore().getStoreRef();
            this.allRootNodesCache.remove((Serializable)storeRef);
            this.touchNode(nodeId, null, newAspectQNames, false, false, true);
        } else {
            this.touchNode(nodeId, null, newAspectQNames, false, false, false);
        }
        this.setNodeAspectsCached(nodeId, newAspectQNames);
        return deleteCount > 0;
    }

    @Override
    public void getNodesWithAspects(Set<QName> aspectQNames, Long minNodeId, Long maxNodeId, NodeDAO.NodeRefQueryCallback resultsCallback) {
        Set<Long> qnameIdsSet = this.qnameDAO.convertQNamesToIds(aspectQNames, false);
        if (qnameIdsSet.size() == 0) {
            return;
        }
        ArrayList<Long> qnameIds = new ArrayList<Long>(qnameIdsSet);
        this.selectNodesWithAspects(qnameIds, minNodeId, maxNodeId, resultsCallback);
    }

    @Override
    public void getNodesWithAspects(Set<QName> aspectQNames, Long minNodeId, Long maxNodeId, boolean ordered, NodeDAO.NodeRefQueryCallback resultsCallback) {
        Set<Long> qnameIdsSet = this.qnameDAO.convertQNamesToIds(aspectQNames, false);
        if (qnameIdsSet.size() == 0) {
            return;
        }
        ArrayList<Long> qnameIds = new ArrayList<Long>(qnameIdsSet);
        this.selectNodesWithAspects(qnameIds, minNodeId, maxNodeId, ordered, resultsCallback);
    }

    @Override
    public void getNodesWithAspects(Set<QName> aspectQNames, Long minNodeId, Long maxNodeId, boolean ordered, int maxResults, NodeDAO.NodeRefQueryCallback resultsCallback) {
        Set<Long> qnameIdsSet = this.qnameDAO.convertQNamesToIds(aspectQNames, false);
        if (qnameIdsSet.isEmpty()) {
            return;
        }
        ArrayList<Long> qnameIds = new ArrayList<Long>(qnameIdsSet);
        this.selectNodesWithAspects(qnameIds, minNodeId, maxNodeId, ordered, maxResults, resultsCallback);
    }

    private Set<QName> getNodeAspectsCached(Long nodeId) {
        NodeVersionKey nodeVersionKey = this.getNodeNotNull(nodeId, false).getNodeVersionKey();
        Pair<NodeVersionKey, Set<QName>> cacheEntry = this.aspectsCache.getByKey(nodeVersionKey);
        if (cacheEntry == null) {
            this.invalidateNodeCaches(nodeId);
            throw new DataIntegrityViolationException("Invalid node ID: " + nodeId);
        }
        return new HashSet<QName>((Collection)cacheEntry.getSecond());
    }

    private void setNodeAspectsCached(Long nodeId, Set<QName> aspects) {
        NodeVersionKey nodeVersionKey = this.getNodeNotNull(nodeId, false).getNodeVersionKey();
        this.aspectsCache.setValue(nodeVersionKey, Collections.unmodifiableSet(aspects));
    }

    private Map<Long, Set<QName>> getNodeAspectsCached(List<Long> nodeIds) {
        List<Node> nodes = this.getNodesNotNull(nodeIds, false);
        ArrayList<NodeVersionKey> nodeVersionKeys = new ArrayList<NodeVersionKey>(nodes.size());
        for (Node node : nodes) {
            nodeVersionKeys.add(node.getNodeVersionKey());
        }
        List<Pair<NodeVersionKey, Set<QName>>> cacheEntries = this.aspectsCache.getByKeys(nodeVersionKeys);
        for (Pair<NodeVersionKey, Set<QName>> cacheEntry : cacheEntries) {
            if (cacheEntry.getSecond() != null) continue;
            this.invalidateNodeCaches(((NodeVersionKey)cacheEntry.getFirst()).getNodeId());
            this.logger.info((Object)("Invalidating caches for node ID: " + ((NodeVersionKey)cacheEntry.getFirst()).getNodeId()));
        }
        HashMap<Long, Set<QName>> result = new HashMap<Long, Set<QName>>();
        for (Pair<NodeVersionKey, Set<QName>> cacheEntry : cacheEntries) {
            result.put(((NodeVersionKey)cacheEntry.getFirst()).getNodeId(), new HashSet((Collection)cacheEntry.getSecond()));
        }
        return result;
    }

    private void setNodeAspectsCached(Map<Long, Set<QName>> nodeAspects) {
        List<Long> nodeIds = nodeAspects.keySet().stream().collect(Collectors.toList());
        List nodeVersionKeys = this.getNodesNotNull(nodeIds, false).stream().map(Node::getNodeVersionKey).collect(Collectors.toList());
        for (NodeVersionKey nodeVersionKey : nodeVersionKeys) {
            this.aspectsCache.setValue(nodeVersionKey, Collections.unmodifiableSet(nodeAspects.get(nodeVersionKey.getNodeId())));
        }
    }

    private void copyNodeAspectsCached(NodeVersionKey from, NodeVersionKey to) {
        Set<QName> cacheEntry = this.aspectsCache.getValue(from);
        if (cacheEntry != null) {
            this.aspectsCache.setValue(to, cacheEntry);
        }
    }

    @Override
    public Long newNodeAssoc(Long sourceNodeId, Long targetNodeId, QName assocTypeQName, int assocIndex) {
        if (assocIndex == 0) {
            throw new IllegalArgumentException("Index is 1-based, or -1 to indicate 'next value'.");
        }
        this.touchNode(sourceNodeId, null, null, false, false, false);
        Long assocTypeQNameId = (Long)this.qnameDAO.getOrCreateQName(assocTypeQName).getFirst();
        if (assocIndex <= 0) {
            int maxIndex = this.selectNodeAssocMaxIndex(sourceNodeId, assocTypeQNameId);
            assocIndex = maxIndex + 1;
        }
        Long result = null;
        Savepoint savepoint = this.controlDAO.createSavepoint("NodeService.newNodeAssoc");
        try {
            result = this.insertNodeAssoc(sourceNodeId, targetNodeId, assocTypeQNameId, assocIndex);
            this.controlDAO.releaseSavepoint(savepoint);
            return result;
        }
        catch (Throwable e) {
            this.controlDAO.rollbackToSavepoint(savepoint);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Failed to insert node association: \n   sourceNodeId:   " + sourceNodeId + "\n" + "   targetNodeId:   " + targetNodeId + "\n" + "   assocTypeQName: " + assocTypeQName + "\n" + "   assocIndex:     " + assocIndex), e);
            }
            throw new AssociationExistsException(sourceNodeId, targetNodeId, assocTypeQName);
        }
    }

    @Override
    public void setNodeAssocIndex(Long id, int assocIndex) {
        int updated = this.updateNodeAssoc(id, assocIndex);
        if (updated != 1) {
            throw new ConcurrencyFailureException("Expected to update exactly one row: " + id);
        }
    }

    @Override
    public int removeNodeAssoc(Long sourceNodeId, Long targetNodeId, QName assocTypeQName) {
        Pair<Long, QName> assocTypeQNamePair = this.qnameDAO.getQName(assocTypeQName);
        if (assocTypeQNamePair == null) {
            return 0;
        }
        Long assocTypeQNameId = (Long)assocTypeQNamePair.getFirst();
        int deleted = this.deleteNodeAssoc(sourceNodeId, targetNodeId, assocTypeQNameId);
        if (deleted > 0) {
            this.touchNode(sourceNodeId, null, null, false, false, false);
        }
        return deleted;
    }

    @Override
    public int removeNodeAssocs(List<Long> ids) {
        int toDelete = ids.size();
        if (toDelete == 0) {
            return 0;
        }
        int deleted = this.deleteNodeAssocs(ids);
        if (toDelete != deleted) {
            throw new ConcurrencyFailureException("Deleted " + deleted + " but expected " + toDelete);
        }
        return deleted;
    }

    @Override
    public Collection<Pair<Long, AssociationRef>> getNodeAssocsToAndFrom(Long nodeId) {
        List<NodeAssocEntity> nodeAssocEntities = this.selectNodeAssocs(nodeId);
        ArrayList<Pair<Long, AssociationRef>> results = new ArrayList<Pair<Long, AssociationRef>>(nodeAssocEntities.size());
        for (NodeAssocEntity nodeAssocEntity : nodeAssocEntities) {
            Long assocId = nodeAssocEntity.getId();
            AssociationRef assocRef = nodeAssocEntity.getAssociationRef(this.qnameDAO);
            results.add((Pair<Long, AssociationRef>)new Pair((Object)assocId, (Object)assocRef));
        }
        return results;
    }

    @Override
    public Collection<Pair<Long, AssociationRef>> getSourceNodeAssocs(Long targetNodeId, QName typeQName) {
        Long typeQNameId = null;
        if (typeQName != null) {
            Pair<Long, QName> typeQNamePair = this.qnameDAO.getQName(typeQName);
            if (typeQNamePair == null) {
                return Collections.emptyList();
            }
            typeQNameId = (Long)typeQNamePair.getFirst();
        }
        List<NodeAssocEntity> nodeAssocEntities = this.selectNodeAssocsByTarget(targetNodeId, typeQNameId);
        ArrayList<Pair<Long, AssociationRef>> results = new ArrayList<Pair<Long, AssociationRef>>(nodeAssocEntities.size());
        for (NodeAssocEntity nodeAssocEntity : nodeAssocEntities) {
            Long assocId = nodeAssocEntity.getId();
            AssociationRef assocRef = nodeAssocEntity.getAssociationRef(this.qnameDAO);
            results.add((Pair<Long, AssociationRef>)new Pair((Object)assocId, (Object)assocRef));
        }
        return results;
    }

    @Override
    public Collection<Pair<Long, AssociationRef>> getTargetNodeAssocs(Long sourceNodeId, QName typeQName) {
        Long typeQNameId = null;
        if (typeQName != null) {
            Pair<Long, QName> typeQNamePair = this.qnameDAO.getQName(typeQName);
            if (typeQNamePair == null) {
                return Collections.emptyList();
            }
            typeQNameId = (Long)typeQNamePair.getFirst();
        }
        List<NodeAssocEntity> nodeAssocEntities = this.selectNodeAssocsBySource(sourceNodeId, typeQNameId);
        ArrayList<Pair<Long, AssociationRef>> results = new ArrayList<Pair<Long, AssociationRef>>(nodeAssocEntities.size());
        for (NodeAssocEntity nodeAssocEntity : nodeAssocEntities) {
            Long assocId = nodeAssocEntity.getId();
            AssociationRef assocRef = nodeAssocEntity.getAssociationRef(this.qnameDAO);
            results.add((Pair<Long, AssociationRef>)new Pair((Object)assocId, (Object)assocRef));
        }
        return results;
    }

    @Override
    public Collection<Pair<Long, AssociationRef>> getTargetAssocsByPropertyValue(Long sourceNodeId, QName typeQName, QName propertyQName, Serializable propertyValue) {
        Long typeQNameId = null;
        if (typeQName != null) {
            Pair<Long, QName> typeQNamePair = this.qnameDAO.getQName(typeQName);
            if (typeQNamePair == null) {
                return Collections.emptyList();
            }
            typeQNameId = (Long)typeQNamePair.getFirst();
        }
        Long propertyQNameId = null;
        NodePropertyValue nodeValue = null;
        if (propertyQName != null) {
            Pair<Long, QName> propQNamePair = this.qnameDAO.getQName(propertyQName);
            if (propQNamePair == null) {
                return Collections.emptyList();
            }
            propertyQNameId = (Long)propQNamePair.getFirst();
            PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyQName);
            nodeValue = this.nodePropertyHelper.makeNodePropertyValue(propertyDef, propertyValue);
            if (nodeValue != null) {
                switch (nodeValue.getPersistedType()) {
                    case 1: 
                    case 3: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("method not supported for persisted value type " + nodeValue.getPersistedType());
                    }
                }
            }
        }
        List<NodeAssocEntity> nodeAssocEntities = this.selectNodeAssocsBySourceAndPropertyValue(sourceNodeId, typeQNameId, propertyQNameId, nodeValue);
        ArrayList<Pair<Long, AssociationRef>> results = new ArrayList<Pair<Long, AssociationRef>>(nodeAssocEntities.size());
        for (NodeAssocEntity nodeAssocEntity : nodeAssocEntities) {
            Long assocId = nodeAssocEntity.getId();
            AssociationRef assocRef = nodeAssocEntity.getAssociationRef(this.qnameDAO);
            results.add((Pair<Long, AssociationRef>)new Pair((Object)assocId, (Object)assocRef));
        }
        return results;
    }

    @Override
    public Pair<Long, AssociationRef> getNodeAssocOrNull(Long assocId) {
        NodeAssocEntity nodeAssocEntity = this.selectNodeAssocById(assocId);
        if (nodeAssocEntity == null) {
            return null;
        }
        AssociationRef assocRef = nodeAssocEntity.getAssociationRef(this.qnameDAO);
        return new Pair((Object)assocId, (Object)assocRef);
    }

    @Override
    public Pair<Long, AssociationRef> getNodeAssoc(Long assocId) {
        Pair<Long, AssociationRef> ret = this.getNodeAssocOrNull(assocId);
        if (ret == null) {
            throw new ConcurrencyFailureException("Assoc ID does not point to a valid association: " + assocId);
        }
        return ret;
    }

    private ChildAssocEntity newChildAssocImpl(Long parentNodeId, Long childNodeId, boolean isPrimary, QName assocTypeQName, QName assocQName, String childNodeName, boolean allowDeletedChild) {
        Assert.notNull((Object)parentNodeId, (String)"parentNodeId");
        Assert.notNull((Object)childNodeId, (String)"childNodeId");
        Assert.notNull((Object)assocTypeQName, (String)"assocTypeQName");
        Assert.notNull((Object)assocQName, (String)"assocQName");
        Assert.notNull((Object)childNodeName, (String)"childNodeName");
        Node parentNode = this.getNodeNotNull(parentNodeId, true);
        Node childNode = this.getNodeNotNull(childNodeId, !allowDeletedChild);
        ChildAssocEntity assoc = new ChildAssocEntity();
        assoc.setParentNode(new NodeEntity(parentNode));
        assoc.setChildNode(new NodeEntity(childNode));
        assoc.setTypeQNameAll(this.qnameDAO, assocTypeQName, true);
        assoc.setChildNodeNameAll(this.dictionaryService, assocTypeQName, childNodeName);
        assoc.setQNameAll(this.qnameDAO, assocQName, true);
        assoc.setPrimary(isPrimary);
        assoc.setAssocIndex(-1);
        Long assocId = this.newChildAssocInsert(assoc, assocTypeQName, childNodeName);
        assoc.setId(assocId);
        if (!isPrimary) {
            this.updateNode(childNodeId, null, null);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Created child association: " + assoc));
        }
        return assoc;
    }

    protected Long newChildAssocInsert(final ChildAssocEntity assoc, final QName assocTypeQName, final String childNodeName) {
        RetryingCallbackHelper.RetryingCallback<Long> callback = new RetryingCallbackHelper.RetryingCallback<Long>(){

            @Override
            public Long execute() throws Throwable {
                return AbstractNodeDAOImpl.this.newChildAssocInsertImpl(assoc, assocTypeQName, childNodeName);
            }
        };
        Long assocId = this.childAssocRetryingHelper.doWithRetry(callback);
        return assocId;
    }

    protected Long newChildAssocInsertImpl(ChildAssocEntity assoc, QName assocTypeQName, String childNodeName) {
        Savepoint savepoint = this.controlDAO.createSavepoint("DuplicateChildNodeNameException");
        try {
            Long id = this.insertChildAssoc(assoc);
            this.controlDAO.releaseSavepoint(savepoint);
            return id;
        }
        catch (Throwable e) {
            this.controlDAO.rollbackToSavepoint(savepoint);
            if (e instanceof ConcurrencyFailureException) {
                throw e;
            }
            String lowerMsg = e.getMessage().toLowerCase();
            if (lowerMsg.contains("fk_alf_cass_")) {
                throw new ConcurrencyFailureException("FK violation updating primary parent association:" + assoc, e);
            }
            throw new DuplicateChildNodeNameException(assoc.getParentNode().getNodeRef(), assocTypeQName, childNodeName, e);
        }
    }

    @Override
    public Pair<Long, ChildAssociationRef> newChildAssoc(Long parentNodeId, Long childNodeId, QName assocTypeQName, QName assocQName, String childNodeName) {
        ParentAssocsInfo parentAssocInfo = this.getParentAssocsCached(childNodeId);
        ChildAssocEntity assoc = this.newChildAssocImpl(parentNodeId, childNodeId, false, assocTypeQName, assocQName, childNodeName, false);
        Long assocId = assoc.getId();
        this.touchNode(childNodeId, null, null, false, false, true);
        parentAssocInfo = parentAssocInfo.addAssoc(assocId, assoc);
        this.setParentAssocsCached(childNodeId, parentAssocInfo);
        return assoc.getPair(this.qnameDAO);
    }

    @Override
    public void deleteChildAssoc(Long assocId) {
        ChildAssocEntity assoc = this.selectChildAssoc(assocId);
        if (assoc == null) {
            throw new ConcurrencyFailureException("Child association not found: " + assocId + ".  A concurrency violation is likely.\n" + "This can also occur if code reacts to 'beforeDelete' callbacks and pre-emptively deletes associations \n" + "that are about to be cascade-deleted.  The 'onDelete' phase then fails to delete the association.\n" + "See links on issue ALF-12358.");
        }
        Long childNodeId = assoc.getChildNode().getId();
        ParentAssocsInfo parentAssocInfo = this.getParentAssocsCached(childNodeId);
        List<Long> assocIds = Collections.singletonList(assocId);
        int count = this.deleteChildAssocs(assocIds);
        if (count != 1) {
            throw new ConcurrencyFailureException("Child association not deleted: " + assocId);
        }
        this.touchNode(childNodeId, null, null, false, false, true);
        parentAssocInfo = parentAssocInfo.removeAssoc(assocId);
        this.setParentAssocsCached(childNodeId, parentAssocInfo);
    }

    @Override
    public int setChildAssocIndex(Long parentNodeId, Long childNodeId, QName assocTypeQName, QName assocQName, int index) {
        int count = this.updateChildAssocIndex(parentNodeId, childNodeId, assocTypeQName, assocQName, index);
        if (count > 0) {
            this.touchNode(childNodeId, null, null, false, false, true);
        }
        return count;
    }

    @Override
    public void setChildAssocsUniqueName(Long childNodeId, String childName) {
        Integer count = this.setChildAssocsUniqueNameImpl(childNodeId, childName);
        if (count > 0) {
            this.touchNode(childNodeId, null, null, false, false, true);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Updated cm:name to parent assocs: \n   Node:    " + childNodeId + "\n" + "   Name:    " + childName + "\n" + "   Updated: " + count));
        }
    }

    protected int setChildAssocsUniqueNameImpl(final Long childNodeId, final String childName) {
        RetryingCallbackHelper.RetryingCallback<Integer> callback = new RetryingCallbackHelper.RetryingCallback<Integer>(){

            @Override
            public Integer execute() throws Throwable {
                return AbstractNodeDAOImpl.this.updateChildAssocUniqueNameImpl(childNodeId, childName);
            }
        };
        return this.childAssocRetryingHelper.doWithRetry(callback);
    }

    protected int updateChildAssocUniqueNameImpl(Long childNodeId, String childName) {
        int total = 0;
        Savepoint savepoint = this.controlDAO.createSavepoint("DuplicateChildNodeNameException");
        try {
            for (ChildAssocEntity parentAssoc : this.getParentAssocsCached(childNodeId).getParentAssocs().values()) {
                int count;
                if (parentAssoc.getChildNodeNameCrc() <= 0L) continue;
                Pair<Long, QName> oldTypeQnamePair = this.qnameDAO.getQName(parentAssoc.getTypeQNameId());
                if (oldTypeQnamePair != null) {
                    this.childByNameCache.remove((Serializable)new ChildByNameKey(parentAssoc.getParentNode().getId(), (QName)oldTypeQnamePair.getSecond(), parentAssoc.getChildNodeName()));
                }
                if ((count = this.updateChildAssocUniqueName(parentAssoc.getId(), childName)) <= 0) {
                    throw new ConcurrencyFailureException("Failed to update an existing parent association " + parentAssoc.getId());
                }
                total += count;
            }
            this.controlDAO.releaseSavepoint(savepoint);
            return total;
        }
        catch (Throwable e) {
            this.controlDAO.rollbackToSavepoint(savepoint);
            throw new DuplicateChildNodeNameException(null, null, childName, e);
        }
    }

    @Override
    public Pair<Long, ChildAssociationRef> getChildAssoc(Long assocId) {
        ChildAssocEntity assoc = this.selectChildAssoc(assocId);
        if (assoc == null) {
            throw new ConcurrencyFailureException("Child association not found: " + assocId);
        }
        return assoc.getPair(this.qnameDAO);
    }

    @Override
    public List<NodeIdAndAclId> getPrimaryChildrenAcls(Long nodeId) {
        return this.selectPrimaryChildAcls(nodeId);
    }

    @Override
    public Pair<Long, ChildAssociationRef> getChildAssoc(Long parentNodeId, Long childNodeId, QName assocTypeQName, QName assocQName) {
        List<ChildAssocEntity> assocs = this.selectChildAssoc(parentNodeId, childNodeId, assocTypeQName, assocQName);
        if (assocs.size() == 0) {
            return null;
        }
        if (assocs.size() == 1) {
            return assocs.get(0).getPair(this.qnameDAO);
        }
        HashMap<Long, ChildAssocEntity> assocsToDeleteById = new HashMap<Long, ChildAssocEntity>(assocs.size() * 2);
        Long minId = null;
        Long primaryId = null;
        for (ChildAssocEntity assoc : assocs) {
            Long assocId = assoc.getId();
            assocsToDeleteById.put(assocId, assoc);
            if (minId == null || minId.compareTo(assocId) > 0) {
                minId = assocId;
            }
            if (!assoc.isPrimary().booleanValue()) continue;
            primaryId = assocId;
        }
        Long assocToKeepId = primaryId == null ? minId : primaryId;
        ChildAssocEntity assocToKeep = (ChildAssocEntity)assocsToDeleteById.remove(assocToKeepId);
        if (AlfrescoTransactionSupport.getTransactionReadState() == AlfrescoTransactionSupport.TxnReadState.TXN_READ_WRITE) {
            for (Long assocIdToDelete : assocsToDeleteById.keySet()) {
                this.deleteChildAssoc(assocIdToDelete);
            }
        }
        return assocToKeep.getPair(this.qnameDAO);
    }

    @Override
    public void getChildAssocs(Long parentNodeId, Long childNodeId, QName assocTypeQName, QName assocQName, Boolean isPrimary, Boolean sameStore, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        this.selectChildAssocs(parentNodeId, childNodeId, assocTypeQName, assocQName, isPrimary, sameStore, new ChildAssocRefBatchingQueryCallback(resultsCallback));
    }

    @Override
    public void getChildAssocs(Long parentNodeId, QName assocTypeQName, QName assocQName, int maxResults, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        this.selectChildAssocs(parentNodeId, assocTypeQName, assocQName, maxResults, new ChildAssocRefBatchingQueryCallback(resultsCallback));
    }

    @Override
    public void getChildAssocs(Long parentNodeId, Set<QName> assocTypeQNames, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        switch (assocTypeQNames.size()) {
            case 0: {
                return;
            }
            case 1: {
                QName assocTypeQName = assocTypeQNames.iterator().next();
                this.selectChildAssocs(parentNodeId, null, assocTypeQName, null, null, null, new ChildAssocRefBatchingQueryCallback(resultsCallback));
                break;
            }
            default: {
                this.selectChildAssocs(parentNodeId, assocTypeQNames, new ChildAssocRefBatchingQueryCallback(resultsCallback));
            }
        }
    }

    @Override
    public Pair<Long, ChildAssociationRef> getChildAssoc(Long parentNodeId, QName assocTypeQName, String childName) {
        ChildByNameKey key = new ChildByNameKey(parentNodeId, assocTypeQName, childName);
        ChildAssocEntity assoc = (ChildAssocEntity)this.childByNameCache.get((Serializable)key);
        boolean query = false;
        if (assoc == null) {
            query = true;
        } else {
            NodeEntity childNode = assoc.getChildNode();
            Long childNodeId = childNode.getId();
            NodeVersionKey childNodeVersionKey = childNode.getNodeVersionKey();
            Pair<Long, Node> childNodeFromCache = this.nodesCache.getByKey(childNodeId);
            if (childNodeFromCache == null) {
                query = true;
            } else {
                NodeVersionKey childNodeFromCacheVersionKey = ((Node)childNodeFromCache.getSecond()).getNodeVersionKey();
                if (!childNodeFromCacheVersionKey.equals(childNodeVersionKey)) {
                    query = true;
                }
            }
        }
        if (query && (assoc = this.selectChildAssoc(parentNodeId, assocTypeQName, childName)) != null) {
            this.childByNameCache.put((Serializable)key, (Object)assoc);
        }
        return assoc == null ? null : assoc.getPair(this.qnameDAO);
    }

    @Override
    public void getChildAssocs(Long parentNodeId, QName assocTypeQName, Collection<String> childNames, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        this.selectChildAssocs(parentNodeId, assocTypeQName, childNames, new ChildAssocRefBatchingQueryCallback(resultsCallback));
    }

    @Override
    public void getChildAssocsByPropertyValue(Long parentNodeId, QName propertyQName, Serializable value, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyQName);
        NodePropertyValue nodeValue = this.nodePropertyHelper.makeNodePropertyValue(propertyDef, value);
        if (nodeValue != null) {
            switch (nodeValue.getPersistedType()) {
                case 1: 
                case 3: 
                case 5: 
                case 6: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("method not supported for persisted value type " + nodeValue.getPersistedType());
                }
            }
            this.selectChildAssocsByPropertyValue(parentNodeId, propertyQName, nodeValue, new ChildAssocRefBatchingQueryCallback(resultsCallback));
        }
    }

    @Override
    public void getChildAssocsByChildTypes(Long parentNodeId, Set<QName> childNodeTypeQNames, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        this.selectChildAssocsByChildTypes(parentNodeId, childNodeTypeQNames, new ChildAssocRefBatchingQueryCallback(resultsCallback));
    }

    @Override
    public void getChildAssocsWithoutParentAssocsOfType(Long parentNodeId, QName assocTypeQName, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        this.selectChildAssocsWithoutParentAssocsOfType(parentNodeId, assocTypeQName, new ChildAssocRefBatchingQueryCallback(resultsCallback));
    }

    @Override
    public Pair<Long, ChildAssociationRef> getPrimaryParentAssoc(Long childNodeId) {
        ChildAssocEntity childAssocEntity = this.getPrimaryParentAssocImpl(childNodeId);
        if (childAssocEntity == null) {
            return null;
        }
        return childAssocEntity.getPair(this.qnameDAO);
    }

    private ChildAssocEntity getPrimaryParentAssocImpl(Long childNodeId) {
        ParentAssocsInfo parentAssocs = this.getParentAssocsCached(childNodeId);
        return parentAssocs.getPrimaryParentAssoc();
    }

    @Override
    public void getParentAssocs(Long childNodeId, QName assocTypeQName, QName assocQName, Boolean isPrimary, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        if (assocTypeQName == null && assocQName == null && isPrimary == null) {
            ParentAssocsInfo parentAssocs = this.getParentAssocsCached(childNodeId);
            for (ChildAssocEntity assoc : parentAssocs.getParentAssocs().values()) {
                resultsCallback.handle(assoc.getPair(this.qnameDAO), assoc.getParentNode().getNodePair(), assoc.getChildNode().getNodePair());
            }
            resultsCallback.done();
        } else {
            ParentAssocsInfo parentAssocs = this.getParentAssocsCached(childNodeId);
            if (parentAssocs.getParentAssocs().size() > 2000) {
                this.selectParentAssocs(childNodeId, assocTypeQName, assocQName, isPrimary, resultsCallback);
            } else {
                for (ChildAssocEntity assoc : parentAssocs.getParentAssocs().values()) {
                    Pair<Long, ChildAssociationRef> assocPair = assoc.getPair(this.qnameDAO);
                    if (assocTypeQName != null && !((ChildAssociationRef)assocPair.getSecond()).getTypeQName().equals((Object)assocTypeQName) || assocQName != null && !((ChildAssociationRef)assocPair.getSecond()).getQName().equals((Object)assocQName)) continue;
                    resultsCallback.handle(assocPair, assoc.getParentNode().getNodePair(), assoc.getChildNode().getNodePair());
                }
                resultsCallback.done();
            }
        }
    }

    @Override
    public void cycleCheck(Long nodeId) {
        CycleCallBack callback = new CycleCallBack();
        callback.cycleCheck(nodeId);
        if (callback.toThrow != null) {
            throw callback.toThrow;
        }
    }

    @Override
    public List<Path> getPaths(Pair<Long, NodeRef> nodePair, boolean primaryOnly) throws InvalidNodeRefException {
        ArrayList<Path> paths = new ArrayList<Path>(primaryOnly ? 1 : 10);
        Path currentPath = new Path();
        Stack<Long> assocIdStack = new Stack<Long>();
        this.prependPaths(nodePair, null, currentPath, paths, assocIdStack, primaryOnly);
        if (primaryOnly && paths.size() != 1) {
            throw new RuntimeException("Node has " + paths.size() + " primary paths: " + nodePair);
        }
        if (this.loggerPaths.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(256);
            if (primaryOnly) {
                sb.append("Primary paths");
            } else {
                sb.append("Paths");
            }
            sb.append(" for node ").append(nodePair);
            for (Path path : paths) {
                sb.append("\n").append("   ").append(path);
            }
            this.loggerPaths.debug((Object)sb);
        }
        return paths;
    }

    private void bindFixAssocAndCollectLostAndFound(final Pair<Long, NodeRef> lostNodePair, final String lostName, final Long assocId, final boolean orphanChild) {
        final Set lostNodePairs = TransactionalResourceHelper.getSet(KEY_LOST_NODE_PAIRS);
        final Set deletedAssocs = TransactionalResourceHelper.getSet(KEY_DELETED_ASSOCS);
        AlfrescoTransactionSupport.bindListener((TransactionListener)new TransactionListenerAdapter(){

            public void afterRollback() {
                this.afterCommit();
            }

            public void afterCommit() {
                if (AbstractNodeDAOImpl.this.transactionService.getAllowWrite()) {
                    RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        @Override
                        public Void execute() throws Throwable {
                            if (assocId == null) {
                                if (lostNodePairs.add(lostNodePair)) {
                                    AbstractNodeDAOImpl.this.collectLostAndFoundNode((Pair<Long, NodeRef>)lostNodePair, lostName);
                                    (this).AbstractNodeDAOImpl.this.logger.error((Object)("ALF-13066: Orphan child node has been re-homed under lost_found: " + lostNodePair));
                                }
                            } else {
                                if (deletedAssocs.add(assocId)) {
                                    AbstractNodeDAOImpl.this.deleteChildAssoc(assocId);
                                    (this).AbstractNodeDAOImpl.this.logger.error((Object)("ALF-12358: Deleted node - removed child assoc: " + assocId));
                                }
                                if (orphanChild && lostNodePairs.add(lostNodePair)) {
                                    AbstractNodeDAOImpl.this.collectLostAndFoundNode((Pair<Long, NodeRef>)lostNodePair, lostName);
                                    (this).AbstractNodeDAOImpl.this.logger.error((Object)("ALF-12358: Orphan child node has been re-homed under lost_found: " + lostNodePair));
                                }
                            }
                            return null;
                        }
                    };
                    AbstractNodeDAOImpl.this.transactionService.getRetryingTransactionHelper().doInTransaction(callback, false, true);
                }
            }
        });
    }

    private void collectLostAndFoundNode(Pair<Long, NodeRef> lostNodePair, String lostName) {
        Long childNodeId = (Long)lostNodePair.getFirst();
        NodeRef lostNodeRef = (NodeRef)lostNodePair.getSecond();
        Long newParentNodeId = this.getOrCreateLostAndFoundContainer(lostNodeRef.getStoreRef()).getId();
        String assocName = String.valueOf(lostName) + "-" + System.currentTimeMillis();
        ChildAssocEntity assoc = this.newChildAssocImpl(newParentNodeId, childNodeId, true, ContentModel.ASSOC_CHILDREN, QName.createQName((String)assocName), assocName, true);
        this.touchNode(childNodeId, null, null, false, false, false);
        boolean isRoot = false;
        boolean isStoreRoot = false;
        ParentAssocsInfo parentAssocInfo = new ParentAssocsInfo(isRoot, isStoreRoot, assoc);
        this.setParentAssocsCached(childNodeId, parentAssocInfo);
    }

    private Node getOrCreateLostAndFoundContainer(StoreRef storeRef) {
        Pair<Long, NodeRef> rootNodePair = this.getRootNode(storeRef);
        Long rootParentNodeId = (Long)rootNodePair.getFirst();
        final ArrayList nodes = new ArrayList(1);
        NodeDAO.ChildAssocRefQueryCallback callback = new NodeDAO.ChildAssocRefQueryCallback(){

            @Override
            public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
                nodes.add(childNodePair);
                return true;
            }

            @Override
            public boolean preLoadNodes() {
                return false;
            }

            @Override
            public boolean orderResults() {
                return false;
            }

            @Override
            public void done() {
            }
        };
        HashSet<QName> assocTypeQNames = new HashSet<QName>(1);
        assocTypeQNames.add(ContentModel.ASSOC_LOST_AND_FOUND);
        this.getChildAssocs(rootParentNodeId, assocTypeQNames, callback);
        Node lostFoundNode = null;
        if (nodes.size() > 0) {
            Long lostFoundNodeId = (Long)((Pair)nodes.get(0)).getFirst();
            lostFoundNode = this.getNodeNotNull(lostFoundNodeId, true);
            if (nodes.size() > 1) {
                this.logger.warn((Object)("More than one lost_found, using first: " + lostFoundNode.getNodeRef()));
            }
        } else {
            Locale locale = (Locale)this.localeDAO.getOrCreateDefaultLocalePair().getSecond();
            lostFoundNode = this.newNode(rootParentNodeId, ContentModel.ASSOC_LOST_AND_FOUND, ContentModel.ASSOC_LOST_AND_FOUND, storeRef, null, ContentModel.TYPE_LOST_AND_FOUND, locale, ContentModel.ASSOC_LOST_AND_FOUND.getLocalName(), null).getChildNode();
            this.logger.info((Object)("Created lost_found: " + lostFoundNode.getNodeRef()));
        }
        return lostFoundNode;
    }

    private void prependPaths(Pair<Long, NodeRef> currentNodePair, Pair<StoreRef, NodeRef> currentRootNodePair, Path currentPath, Collection<Path> completedPaths, Stack<Long> assocIdStack, boolean primaryOnly) throws CyclicChildRelationshipException {
        boolean hasParents;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("\nPrepending paths: \n   Current node: " + currentNodePair + "\n" + "   Current root: " + currentRootNodePair + "\n" + "   Current path: " + currentPath));
        }
        Long currentNodeId = (Long)currentNodePair.getFirst();
        NodeRef currentNodeRef = (NodeRef)currentNodePair.getSecond();
        StoreRef currentStoreRef = currentNodeRef.getStoreRef();
        if (currentRootNodePair == null || !currentStoreRef.equals(currentRootNodePair.getFirst())) {
            Pair<Long, NodeRef> rootNodePair = this.getRootNode(currentStoreRef);
            currentRootNodePair = new Pair((Object)currentStoreRef, (Object)((NodeRef)rootNodePair.getSecond()));
        }
        ParentAssocsInfo parentAssocInfo = this.getParentAssocsCached(currentNodeId);
        ArrayList<Long> toLoad = new ArrayList<Long>(parentAssocInfo.getParentAssocs().size());
        for (Map.Entry<Long, ChildAssocEntity> entry : parentAssocInfo.getParentAssocs().entrySet()) {
            toLoad.add(entry.getValue().getParentNode().getId());
        }
        this.cacheNodesById(toLoad);
        boolean bl = hasParents = parentAssocInfo.getParentAssocs().size() > 0;
        if (!(primaryOnly && hasParents || !parentAssocInfo.isRoot())) {
            Path.Element element2;
            ChildAssociationRef assocRef = new ChildAssociationRef(null, null, null, (NodeRef)currentRootNodePair.getSecond());
            Path pathToSave = new Path();
            Path.ChildAssocElement first = null;
            for (Path.Element element2 : currentPath) {
                if (first == null) {
                    first = (Path.ChildAssocElement)element2;
                    continue;
                }
                pathToSave.append(element2);
            }
            if (first != null) {
                ChildAssociationRef updateAssocRef = new ChildAssociationRef(parentAssocInfo.isStoreRoot() ? ContentModel.ASSOC_CHILDREN : first.getRef().getTypeQName(), (NodeRef)currentRootNodePair.getSecond(), first.getRef().getQName(), first.getRef().getChildRef());
                Path.ChildAssocElement newFirst = new Path.ChildAssocElement(updateAssocRef);
                pathToSave.prepend((Path.Element)newFirst);
            }
            element2 = new Path.ChildAssocElement(assocRef);
            pathToSave.prepend(element2);
            completedPaths.add(pathToSave);
        }
        for (Map.Entry<Long, ChildAssocEntity> entry : parentAssocInfo.getParentAssocs().entrySet()) {
            Long assocId = entry.getKey();
            ChildAssocEntity assoc = entry.getValue();
            ChildAssociationRef assocRef = assoc.getRef(this.qnameDAO);
            if (primaryOnly && !assocRef.isPrimary()) continue;
            assocRef.setNthSibling(-1);
            Path.ChildAssocElement element = new Path.ChildAssocElement(assocRef);
            Path path = new Path();
            path.append(currentPath);
            path.prepend((Path.Element)element);
            Pair parentNodePair = new Pair((Object)assoc.getParentNode().getId(), (Object)assocRef.getParentRef());
            if (assocIdStack.contains(assocId)) {
                this.logger.error((Object)("Cyclic parent-child relationship detected: \n   current node: " + currentNodeId + "\n" + "   current path: " + currentPath + "\n" + "   next assoc: " + assocId));
                throw new CyclicChildRelationshipException("Node has been pasted into its own tree.", assocRef);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("\n   Prepending path parent: \n      Parent node: " + parentNodePair));
            }
            assocIdStack.push(assocId);
            this.prependPaths((Pair<Long, NodeRef>)parentNodePair, (Pair<StoreRef, NodeRef>)currentRootNodePair, path, completedPaths, assocIdStack, primaryOnly);
            assocIdStack.pop();
        }
    }

    private ParentAssocsInfo getParentAssocsCached(Long nodeId) {
        Node node = this.getNodeNotNull(nodeId, false);
        Pair cacheKey = new Pair((Object)nodeId, (Object)node.getTransaction().getChangeTxnId());
        ParentAssocsInfo value = this.parentAssocsCache.get((Pair<Long, String>)cacheKey);
        if (value == null) {
            value = this.loadParentAssocs(node.getNodeVersionKey());
            this.parentAssocsCache.put((Pair<Long, String>)cacheKey, value);
        }
        if (value.getPrimaryParentAssoc() == null && !node.getDeleted(this.qnameDAO) && !value.isStoreRoot()) {
            Pair<Long, NodeRef> currentNodePair = node.getNodePair();
            this.bindFixAssocAndCollectLostAndFound(currentNodePair, "nonRootNodeWithoutParents", null, false);
            throw new NonRootNodeWithoutParentsException(currentNodePair);
        }
        return value;
    }

    private void setParentAssocsCached(Long nodeId, ParentAssocsInfo parentAssocs) {
        Node node = this.getNodeNotNull(nodeId, false);
        Pair cacheKey = new Pair((Object)nodeId, (Object)node.getTransaction().getChangeTxnId());
        this.parentAssocsCache.put((Pair<Long, String>)cacheKey, parentAssocs);
    }

    private void copyParentAssocsCached(Node from) {
        String toTransactionId;
        String fromTransactionId = from.getTransaction().getChangeTxnId();
        if (fromTransactionId.equals(toTransactionId = this.getCurrentTransaction().getChangeTxnId())) {
            return;
        }
        Pair cacheKey = new Pair((Object)from.getId(), (Object)fromTransactionId);
        ParentAssocsInfo cacheEntry = this.parentAssocsCache.get((Pair<Long, String>)cacheKey);
        if (cacheEntry != null) {
            this.parentAssocsCache.put((Pair<Long, String>)new Pair((Object)from.getId(), (Object)toTransactionId), cacheEntry);
        }
    }

    private void invalidateParentAssocsCached(Node node) {
        String currentTransactionId;
        Long nodeId = node.getId();
        String nodeTransactionId = node.getTransaction().getChangeTxnId();
        this.parentAssocsCache.remove((Pair<Long, String>)new Pair((Object)nodeId, (Object)nodeTransactionId));
        if (AlfrescoTransactionSupport.getTransactionReadState() == AlfrescoTransactionSupport.TxnReadState.TXN_READ_WRITE && !(currentTransactionId = this.getCurrentTransaction().getChangeTxnId()).equals(nodeTransactionId)) {
            this.parentAssocsCache.remove((Pair<Long, String>)new Pair((Object)nodeId, (Object)currentTransactionId));
        }
    }

    private ParentAssocsInfo loadParentAssocs(NodeVersionKey nodeVersionKey) {
        Long nodeId = nodeVersionKey.getNodeId();
        boolean isRoot = this.hasNodeAspect(nodeId, ContentModel.ASPECT_ROOT);
        boolean isStoreRoot = this.getNodeType(nodeId).equals((Object)ContentModel.TYPE_STOREROOT);
        List<ChildAssocEntity> assocs = this.selectParentAssocs(nodeId);
        ParentAssocsInfo value = new ParentAssocsInfo(isRoot, isStoreRoot, assocs);
        if (assocs.isEmpty()) {
            NodeEntity nodeCheckFromDb = this.selectNodeById(nodeId);
            if (nodeCheckFromDb == null || !nodeCheckFromDb.getNodeVersionKey().equals(nodeVersionKey)) {
                this.invalidateNodeCaches(nodeId);
                throw new DataIntegrityViolationException("Detected stale node entry: " + nodeVersionKey + " (now " + nodeCheckFromDb + ")");
            }
        } else {
            ChildAssocEntity childAssoc = assocs.get(0);
            NodeVersionKey childNodeVersionKeyFromDb = childAssoc.getChildNode().getNodeVersionKey();
            if (!childNodeVersionKeyFromDb.equals(nodeVersionKey)) {
                this.invalidateNodeCaches(nodeId);
                throw new DataIntegrityViolationException("Detected stale node entry: " + nodeVersionKey + " (now " + childNodeVersionKeyFromDb + ")");
            }
        }
        return value;
    }

    @Override
    public void setCheckNodeConsistency() {
        if (this.nodesTransactionalCache != null) {
            this.nodesTransactionalCache.setDisableSharedCacheReadForTransaction(true);
        }
    }

    @Override
    public Set<Long> getCachedAncestors(List<Long> nodeIds) {
        this.cacheNodesById(nodeIds);
        for (Long nodeId : nodeIds) {
            if (!this.exists(nodeId)) continue;
            this.getParentAssocsCached(nodeId);
        }
        TreeSet<Long> ancestors = new TreeSet<Long>();
        for (Long nodeId : nodeIds) {
            this.findCachedAncestors(nodeId, ancestors);
        }
        return ancestors;
    }

    private void findCachedAncestors(Long nodeId, Set<Long> ancestors) {
        if (!ancestors.add(nodeId)) {
            return;
        }
        Node node = this.nodesCache.getValue(nodeId);
        if (node == null) {
            return;
        }
        Pair cacheKey = new Pair((Object)nodeId, (Object)node.getTransaction().getChangeTxnId());
        ParentAssocsInfo value = this.parentAssocsCache.get((Pair<Long, String>)cacheKey);
        if (value == null) {
            return;
        }
        for (ChildAssocEntity childAssoc : value.getParentAssocs().values()) {
            this.findCachedAncestors(childAssoc.getParentNode().getId(), ancestors);
        }
    }

    @Override
    public void cacheNodesById(List<Long> nodeIds) {
        boolean disableSharedCacheReadForTransaction = false;
        if (this.nodesTransactionalCache != null) {
            disableSharedCacheReadForTransaction = this.nodesTransactionalCache.getDisableSharedCacheReadForTransaction();
        }
        if (!disableSharedCacheReadForTransaction && nodeIds.size() < 10) {
            return;
        }
        int foundCacheEntryCount = 0;
        int missingCacheEntryCount = 0;
        ArrayList<Long> batchLoadNodeIds = new ArrayList<Long>(nodeIds.size());
        for (Long nodeId : nodeIds) {
            if (!this.forceBatching) {
                if (this.nodesCache.getValue(nodeId) != null) {
                    ++foundCacheEntryCount;
                    continue;
                }
                if (foundCacheEntryCount + ++missingCacheEntryCount % 100 == 0) {
                    this.forceBatching = foundCacheEntryCount < missingCacheEntryCount;
                }
            }
            batchLoadNodeIds.add(nodeId);
        }
        int size = batchLoadNodeIds.size();
        this.cacheNodesBatch(batchLoadNodeIds);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Pre-loaded " + size + " nodes."));
        }
    }

    @Override
    public void cacheNodes(List<NodeRef> nodeRefs) {
        if (nodeRefs.size() < this.cachingThreshold) {
            return;
        }
        int foundCacheEntryCount = 0;
        int missingCacheEntryCount = 0;
        HashMap<StoreRef, ArrayList<String>> uuidsByStore = new HashMap<StoreRef, ArrayList<String>>(3);
        for (NodeRef nodeRef : nodeRefs) {
            StoreRef storeRef;
            ArrayList<String> uuids;
            if (!this.forceBatching) {
                if (this.nodesCache.getKey(nodeRef) != null) {
                    ++foundCacheEntryCount;
                    continue;
                }
                if (foundCacheEntryCount + ++missingCacheEntryCount % 100 == 0) {
                    boolean bl = this.forceBatching = foundCacheEntryCount < missingCacheEntryCount;
                }
            }
            if ((uuids = (ArrayList<String>)uuidsByStore.get(storeRef = nodeRef.getStoreRef())) == null) {
                uuids = new ArrayList<String>(nodeRefs.size());
                uuidsByStore.put(storeRef, uuids);
            }
            uuids.add(nodeRef.getId());
        }
        int size = nodeRefs.size();
        nodeRefs = null;
        for (Map.Entry entry : uuidsByStore.entrySet()) {
            StoreRef storeRef = (StoreRef)entry.getKey();
            List uuids = (List)entry.getValue();
            this.cacheNodes(storeRef, uuids);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Pre-loaded " + size + " nodes."));
        }
    }

    private void cacheNodes(StoreRef storeRef, List<String> uuids) {
        StoreEntity store = this.getStoreNotNull(storeRef);
        Long storeId = store.getId();
        TreeSet<String> batch = new TreeSet<String>();
        for (String uuid : uuids) {
            batch.add(uuid);
            if (batch.size() < this.batchSize) continue;
            List<Node> nodes = this.selectNodesByUuids(storeId, batch);
            this.cacheNodesNoBatch(nodes);
            batch.clear();
        }
        if (batch.size() > 0) {
            List<Node> nodes = this.selectNodesByUuids(storeId, batch);
            this.cacheNodesNoBatch(nodes);
            this.logger.info((Object)("Batch size may be too small " + batch.size() + " nodes."));
        }
    }

    private void cacheNodesBatch(List<Long> nodeIds) {
        TreeSet<Long> batch = new TreeSet<Long>();
        for (Long nodeId : nodeIds) {
            batch.add(nodeId);
            if (batch.size() < this.batchSize) continue;
            List<Node> nodes = this.selectNodesByIds(batch);
            this.cacheNodesNoBatch(nodes);
            batch.clear();
        }
        if (batch.size() > 0) {
            List<Node> nodes = this.selectNodesByIds(batch);
            this.cacheNodesNoBatch(nodes);
            this.logger.info((Object)("Batch size may be too small " + batch.size() + " nodes."));
        }
    }

    private void cacheNodesNoBatch(List<Node> nodes) {
        TreeSet<Long> aspectNodeIds = new TreeSet<Long>();
        TreeSet<Long> propertiesNodeIds = new TreeSet<Long>();
        TreeSet<Long> childAssocsNodeIds = new TreeSet<Long>();
        HashMap<Long, NodeVersionKey> nodeVersionKeysFromCache = new HashMap<Long, NodeVersionKey>(nodes.size() * 2);
        for (Node node : nodes) {
            Pair pair;
            Long nodeId = node.getId();
            NodeVersionKey nodeVersionKey = node.getNodeVersionKey();
            node.lock();
            this.nodesCache.setValue(nodeId, node);
            if (this.propertiesCache.getValue(nodeVersionKey) == null) {
                propertiesNodeIds.add(nodeId);
            }
            if (this.aspectsCache.getValue(nodeVersionKey) == null) {
                aspectNodeIds.add(nodeId);
            }
            if (node.getTransaction() != null && this.parentAssocsCache.get((Pair<Long, String>)(pair = new Pair((Object)nodeId, (Object)node.getTransaction().getChangeTxnId()))) == null) {
                childAssocsNodeIds.add(nodeId);
            }
            nodeVersionKeysFromCache.put(nodeId, nodeVersionKey);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Pre-loaded " + propertiesNodeIds.size() + " properties"));
            this.logger.debug((Object)("Pre-loaded " + propertiesNodeIds.size() + " aspects"));
        }
        Map<NodeVersionKey, Set<QName>> nodeAspects = this.selectNodeAspects(aspectNodeIds);
        HashMap<Long, Set<QName>> aspectsMappedByNodeId = new HashMap<Long, Set<QName>>(aspectNodeIds.size());
        HashMap<Long, Set<QName>> nodesWithNoAspects = new HashMap<Long, Set<QName>>(aspectNodeIds.size());
        for (Map.Entry<NodeVersionKey, Set<QName>> entry : nodeAspects.entrySet()) {
            NodeVersionKey oldKey = entry.getKey();
            Long newKey = oldKey.getNodeId();
            Set<QName> value = entry.getValue();
            aspectsMappedByNodeId.put(newKey, value);
            aspectNodeIds.remove(newKey);
        }
        if (!aspectsMappedByNodeId.isEmpty()) {
            this.setNodeAspectsCached(aspectsMappedByNodeId);
        }
        for (Long nodeId : aspectNodeIds) {
            nodesWithNoAspects.put(nodeId, Collections.emptySet());
        }
        if (!nodesWithNoAspects.isEmpty()) {
            this.setNodeAspectsCached(nodesWithNoAspects);
        }
        if (!propertiesNodeIds.isEmpty()) {
            this.contentDataDAO.cacheContentDataForNodes(propertiesNodeIds);
        }
        Map<NodeVersionKey, Map<NodePropertyKey, NodePropertyValue>> propsByNodeId = this.selectNodeProperties(propertiesNodeIds);
        for (Map.Entry entry : propsByNodeId.entrySet()) {
            Long nodeId = ((NodeVersionKey)entry.getKey()).getNodeId();
            Map propertyValues = (Map)entry.getValue();
            Map<QName, Serializable> props = this.nodePropertyHelper.convertToPublicProperties(propertyValues);
            this.setNodePropertiesCached(nodeId, props);
        }
        List<ChildAssocEntity> list = this.selectParentAssocsOfChildren(childAssocsNodeIds);
        for (ChildAssocEntity assoc : list) {
            Long nodeId = assoc.getChildNode().getId();
            Node childNode = this.getNodeNotNull(nodeId, false);
            boolean isRoot = this.hasNodeAspect(nodeId, ContentModel.ASPECT_ROOT);
            boolean isStoreRoot = this.getNodeType(nodeId).equals((Object)ContentModel.TYPE_STOREROOT);
            if (childNode.getTransaction() == null) {
                this.logger.warn((Object)("Child node " + childNode + " has no transaction - cannot cache parent associations"));
                continue;
            }
            Pair cacheKey = new Pair((Object)nodeId, (Object)childNode.getTransaction().getChangeTxnId());
            ParentAssocsInfo value = new ParentAssocsInfo(isRoot, isStoreRoot, assoc);
            this.parentAssocsCache.put((Pair<Long, String>)cacheKey, value);
        }
    }

    @Override
    public void clear() {
        this.clearCaches();
    }

    @Override
    public Long getMaxTxnIdByCommitTime(long maxCommitTime) {
        Transaction txn = this.selectLastTxnBeforeCommitTime(maxCommitTime);
        return txn == null ? null : txn.getId();
    }

    @Override
    public int getTransactionCount() {
        return this.selectTransactionCount();
    }

    @Override
    public Transaction getTxnById(Long txnId) {
        return this.selectTxnById(txnId);
    }

    @Override
    public List<NodeRef.Status> getTxnChanges(Long txnId) {
        return this.getTxnChangesForStore(null, txnId);
    }

    @Override
    public List<NodeRef.Status> getTxnChangesForStore(StoreRef storeRef, Long txnId) {
        Long storeId = storeRef == null ? null : this.getStoreNotNull(storeRef).getId();
        List<NodeEntity> nodes = this.selectTxnChanges(txnId, storeId);
        ArrayList<NodeRef.Status> nodeStatuses = new ArrayList<NodeRef.Status>(nodes.size());
        for (NodeEntity node : nodes) {
            nodeStatuses.add(node.getNodeStatus(this.qnameDAO));
        }
        return nodeStatuses;
    }

    @Override
    public List<Long> getTxnsUnused(Long minTxnId, long maxCommitTime, int count) {
        return this.selectTxnsUnused(minTxnId, maxCommitTime, count);
    }

    @Override
    public void purgeTxn(Long txnId) {
        this.deleteTransaction(txnId);
    }

    @Override
    public Long getMinTxnCommitTime() {
        Long time = this.selectMinTxnCommitTime();
        return time == null ? LONG_ZERO : time;
    }

    @Override
    public Long getMaxTxnCommitTime() {
        Long time = this.selectMaxTxnCommitTime();
        return time == null ? LONG_ZERO : time;
    }

    @Override
    public Long getMinTxnCommitTimeForDeletedNodes() {
        Long time = this.selectMinTxnCommitTimeForDeletedNodes();
        return time == null ? LONG_ZERO : time;
    }

    @Override
    public Long getMinTxnId() {
        Long id = this.selectMinTxnId();
        return id == null ? LONG_ZERO : id;
    }

    @Override
    public Long getMinUnusedTxnCommitTime() {
        Long id = this.selectMinUnusedTxnCommitTime();
        return id == null ? LONG_ZERO : id;
    }

    @Override
    public Long getMaxTxnId() {
        Long id = this.selectMaxTxnId();
        return id == null ? LONG_ZERO : id;
    }

    @Override
    public Long getMinTxInNodeIdRange(Long fromNodeId, Long toNodeId) {
        return this.selectMinTxInNodeIdRange(fromNodeId, toNodeId);
    }

    @Override
    public Long getMaxTxInNodeIdRange(Long fromNodeId, Long toNodeId) {
        return this.selectMaxTxInNodeIdRange(fromNodeId, toNodeId);
    }

    @Override
    public Long getNextTxCommitTime(Long fromCommitTime) {
        return this.selectNextTxCommitTime(fromCommitTime);
    }

    protected abstract Long insertTransaction(String var1, Long var2);

    protected abstract int updateTransaction(Long var1, Long var2);

    protected abstract int deleteTransaction(Long var1);

    protected abstract List<StoreEntity> selectAllStores();

    protected abstract StoreEntity selectStore(StoreRef var1);

    protected abstract NodeEntity selectStoreRootNode(StoreRef var1);

    protected abstract Long insertStore(StoreEntity var1);

    protected abstract int updateStoreRoot(StoreEntity var1);

    protected abstract int updateStore(StoreEntity var1);

    protected abstract int updateNodesInStore(Long var1, Long var2);

    protected abstract Long insertNode(NodeEntity var1);

    protected abstract int updateNode(NodeUpdateEntity var1);

    protected abstract int updateNodes(Long var1, List<Long> var2);

    protected abstract void updatePrimaryChildrenSharedAclId(Long var1, Long var2, Long var3, Long var4);

    protected abstract int deleteNodeById(Long var1);

    protected abstract int deleteNodesByCommitTime(long var1, long var3);

    protected abstract NodeEntity selectNodeById(Long var1);

    protected abstract List<NodeEntity> selectNodesByIds(List<Long> var1);

    protected abstract NodeEntity selectNodeByNodeRef(NodeRef var1);

    protected abstract List<Node> selectNodesByUuids(Long var1, SortedSet<String> var2);

    protected abstract List<Node> selectNodesByUuids(SortedSet<String> var1);

    protected abstract List<Node> selectNodesByIds(SortedSet<Long> var1);

    protected abstract Map<NodeVersionKey, Map<NodePropertyKey, NodePropertyValue>> selectNodeProperties(Set<Long> var1);

    protected abstract Map<NodeVersionKey, Map<NodePropertyKey, NodePropertyValue>> selectNodeProperties(Long var1);

    protected abstract Map<NodeVersionKey, Map<NodePropertyKey, NodePropertyValue>> selectNodeProperties(Long var1, Set<Long> var2);

    protected abstract int deleteNodeProperties(Long var1, Set<Long> var2);

    protected abstract int deleteNodeProperties(Long var1, List<NodePropertyKey> var2);

    protected abstract void insertNodeProperties(Long var1, Map<NodePropertyKey, NodePropertyValue> var2);

    protected abstract Map<NodeVersionKey, Set<QName>> selectNodeAspects(Set<Long> var1);

    protected abstract void insertNodeAspect(Long var1, Long var2);

    protected abstract int deleteNodeAspects(Long var1, Set<Long> var2);

    protected abstract void selectNodesWithAspects(List<Long> var1, Long var2, Long var3, NodeDAO.NodeRefQueryCallback var4);

    protected abstract void selectNodesWithAspects(List<Long> var1, Long var2, Long var3, boolean var4, NodeDAO.NodeRefQueryCallback var5);

    protected abstract void selectNodesWithAspects(List<Long> var1, Long var2, Long var3, boolean var4, int var5, NodeDAO.NodeRefQueryCallback var6);

    protected abstract Long insertNodeAssoc(Long var1, Long var2, Long var3, int var4);

    protected abstract int updateNodeAssoc(Long var1, int var2);

    protected abstract int deleteNodeAssoc(Long var1, Long var2, Long var3);

    protected abstract int deleteNodeAssocs(List<Long> var1);

    protected abstract List<NodeAssocEntity> selectNodeAssocs(Long var1);

    protected abstract List<NodeAssocEntity> selectNodeAssocsBySource(Long var1, Long var2);

    protected abstract List<NodeAssocEntity> selectNodeAssocsBySourceAndPropertyValue(Long var1, Long var2, Long var3, NodePropertyValue var4);

    protected abstract List<NodeAssocEntity> selectNodeAssocsByTarget(Long var1, Long var2);

    protected abstract NodeAssocEntity selectNodeAssocById(Long var1);

    protected abstract int selectNodeAssocMaxIndex(Long var1, Long var2);

    protected abstract Long insertChildAssoc(ChildAssocEntity var1);

    protected abstract int deleteChildAssocs(List<Long> var1);

    protected abstract int updateChildAssocIndex(Long var1, Long var2, QName var3, QName var4, int var5);

    protected abstract int updateChildAssocUniqueName(Long var1, String var2);

    protected abstract ChildAssocEntity selectChildAssoc(Long var1);

    protected abstract List<ChildAssocEntity> selectChildNodeIds(Long var1, Boolean var2, Long var3, int var4);

    protected abstract List<NodeIdAndAclId> selectPrimaryChildAcls(Long var1);

    protected abstract List<ChildAssocEntity> selectChildAssoc(Long var1, Long var2, QName var3, QName var4);

    protected abstract void selectChildAssocs(Long var1, Long var2, QName var3, QName var4, Boolean var5, Boolean var6, NodeDAO.ChildAssocRefQueryCallback var7);

    protected abstract void selectChildAssocs(Long var1, QName var2, QName var3, int var4, NodeDAO.ChildAssocRefQueryCallback var5);

    protected abstract void selectChildAssocs(Long var1, Set<QName> var2, NodeDAO.ChildAssocRefQueryCallback var3);

    protected abstract ChildAssocEntity selectChildAssoc(Long var1, QName var2, String var3);

    protected abstract void selectChildAssocs(Long var1, QName var2, Collection<String> var3, NodeDAO.ChildAssocRefQueryCallback var4);

    protected abstract void selectChildAssocsByPropertyValue(Long var1, QName var2, NodePropertyValue var3, NodeDAO.ChildAssocRefQueryCallback var4);

    protected abstract void selectChildAssocsByChildTypes(Long var1, Set<QName> var2, NodeDAO.ChildAssocRefQueryCallback var3);

    protected abstract void selectChildAssocsWithoutParentAssocsOfType(Long var1, QName var2, NodeDAO.ChildAssocRefQueryCallback var3);

    protected abstract void selectParentAssocs(Long var1, QName var2, QName var3, Boolean var4, NodeDAO.ChildAssocRefQueryCallback var5);

    protected abstract List<ChildAssocEntity> selectParentAssocs(Long var1);

    protected abstract List<ChildAssocEntity> selectParentAssocsOfChildren(Set<Long> var1);

    protected abstract List<ChildAssocEntity> selectPrimaryParentAssocs(Long var1);

    protected abstract int updatePrimaryParentAssocs(Long var1, Long var2, QName var3, QName var4, String var5);

    protected abstract void moveNodeData(Long var1, Long var2);

    protected abstract void deleteSubscriptions(Long var1);

    protected abstract Transaction selectLastTxnBeforeCommitTime(Long var1);

    protected abstract int selectTransactionCount();

    protected abstract Transaction selectTxnById(Long var1);

    protected abstract List<NodeEntity> selectTxnChanges(Long var1, Long var2);

    public abstract List<Transaction> selectTxns(Long var1, Long var2, Integer var3, List<Long> var4, List<Long> var5, Boolean var6);

    protected abstract List<Long> selectTxnsUnused(Long var1, Long var2, Integer var3);

    protected abstract Long selectMinTxnCommitTime();

    protected abstract Long selectMaxTxnCommitTime();

    protected abstract Long selectMinTxnCommitTimeForDeletedNodes();

    protected abstract Long selectMinTxnId();

    protected abstract Long selectMaxTxnId();

    protected abstract Long selectMinUnusedTxnCommitTime();

    protected abstract Long selectMinTxInNodeIdRange(Long var1, Long var2);

    protected abstract Long selectMaxTxInNodeIdRange(Long var1, Long var2);

    protected abstract Long selectNextTxCommitTime(Long var1);

    private class AspectsCallbackDAO
    extends EntityLookupCache.EntityLookupCallbackDAOAdaptor<NodeVersionKey, Set<QName>, Serializable> {
        private AspectsCallbackDAO() {
        }

        @Override
        public Pair<NodeVersionKey, Set<QName>> createValue(Set<QName> value) {
            throw new UnsupportedOperationException("A node always has a 'set' of aspects.");
        }

        @Override
        public Pair<NodeVersionKey, Set<QName>> findByKey(NodeVersionKey nodeVersionKey) {
            Long nodeId = nodeVersionKey.getNodeId();
            Set<Long> nodeIds = Collections.singleton(nodeId);
            Map<NodeVersionKey, Set<QName>> nodeAspectQNameIdsByVersionKey = AbstractNodeDAOImpl.this.selectNodeAspects(nodeIds);
            Set<Object> nodeAspectQNames = nodeAspectQNameIdsByVersionKey.get(nodeVersionKey);
            if (nodeAspectQNames == null) {
                if (nodeAspectQNameIdsByVersionKey.size() == 0) {
                    nodeAspectQNames = Collections.emptySet();
                } else {
                    AbstractNodeDAOImpl.this.invalidateNodeCaches(nodeId);
                    throw new DataIntegrityViolationException("Detected stale node entry: " + nodeVersionKey + " (now " + nodeAspectQNameIdsByVersionKey.keySet() + ")");
                }
            }
            return new Pair((Object)nodeVersionKey, Collections.unmodifiableSet(nodeAspectQNames));
        }

        @Override
        public List<Pair<NodeVersionKey, Set<QName>>> findByKeys(List<NodeVersionKey> keys) {
            throw new UnsupportedOperationException("Batch lookup not supported for node aspects.");
        }

        @Override
        public List<Pair<NodeVersionKey, Set<QName>>> findByValues(List<Set<QName>> values) {
            throw new UnsupportedOperationException("Batch lookup not supported for node aspects.");
        }
    }

    private class ChildAssocRefBatchingQueryCallback
    implements NodeDAO.ChildAssocRefQueryCallback {
        private final NodeDAO.ChildAssocRefQueryCallback callback;
        private final boolean preload;
        private final List<NodeRef> nodeRefs;

        private ChildAssocRefBatchingQueryCallback(NodeDAO.ChildAssocRefQueryCallback callback) {
            this.callback = callback;
            this.preload = callback.preLoadNodes();
            this.nodeRefs = this.preload ? new LinkedList<NodeRef>() : null;
        }

        @Override
        public boolean preLoadNodes() {
            throw new UnsupportedOperationException("Expected to be used internally only.");
        }

        @Override
        public boolean orderResults() {
            return this.callback.orderResults();
        }

        @Override
        public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
            if (this.preload) {
                this.nodeRefs.add((NodeRef)childNodePair.getSecond());
            }
            return this.callback.handle(childAssocPair, parentNodePair, childNodePair);
        }

        @Override
        public void done() {
            if (this.preload && this.nodeRefs.size() > 0) {
                AbstractNodeDAOImpl.this.cacheNodes(this.nodeRefs);
                this.nodeRefs.clear();
            }
            this.callback.done();
        }
    }

    private class CycleCallBack
    implements NodeDAO.ChildAssocRefQueryCallback {
        final Set<Long> nodeIds = new HashSet<Long>(97);
        CyclicChildRelationshipException toThrow;

        private CycleCallBack() {
        }

        @Override
        public void done() {
        }

        @Override
        public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
            Long nodeId = (Long)childNodePair.getFirst();
            if (!this.nodeIds.add(nodeId)) {
                ChildAssociationRef childAssociationRef = (ChildAssociationRef)childAssocPair.getSecond();
                this.toThrow = new CyclicChildRelationshipException("Child Association Cycle detected hitting nodes: " + this.nodeIds, childAssociationRef);
                return false;
            }
            this.cycleCheck(nodeId);
            this.nodeIds.remove(nodeId);
            return this.toThrow == null;
        }

        @Override
        public boolean preLoadNodes() {
            return false;
        }

        @Override
        public boolean orderResults() {
            return false;
        }

        public void cycleCheck(Long nodeId) {
            AbstractNodeDAOImpl.this.getChildAssocs(nodeId, null, null, null, null, null, this);
        }
    }

    private class NodesCacheCallbackDAO
    extends EntityLookupCache.EntityLookupCallbackDAOAdaptor<Long, Node, NodeRef> {
        private NodesCacheCallbackDAO() {
        }

        @Override
        public Pair<Long, Node> createValue(Node value) {
            throw new UnsupportedOperationException("Node creation is done externally: " + value);
        }

        @Override
        public Pair<Long, Node> findByKey(Long nodeId) {
            NodeEntity node = AbstractNodeDAOImpl.this.selectNodeById(nodeId);
            if (node != null) {
                node.lock();
                return new Pair((Object)nodeId, (Object)node);
            }
            return null;
        }

        @Override
        public List<Pair<Long, Node>> findByKeys(List<Long> nodeIds) {
            if (nodeIds == null || nodeIds.isEmpty()) {
                return new ArrayList<Pair<Long, Node>>(0);
            }
            ArrayList<Pair<Long, Node>> results = new ArrayList<Pair<Long, Node>>(nodeIds.size());
            TreeSet<Long> uniqueNodeIds = new TreeSet<Long>(nodeIds);
            List<Node> nodes = AbstractNodeDAOImpl.this.selectNodesByIds(uniqueNodeIds);
            for (Node node : nodes) {
                if (node == null) continue;
                node.lock();
                results.add((Pair<Long, Node>)new Pair((Object)node.getId(), (Object)node));
            }
            return results;
        }

        @Override
        public NodeRef getValueKey(Node value) {
            return value.getNodeRef();
        }

        @Override
        public Pair<Long, Node> findByValue(Node node) {
            NodeRef nodeRef = node.getNodeRef();
            if ((node = AbstractNodeDAOImpl.this.selectNodeByNodeRef(nodeRef)) != null) {
                node.lock();
                return new Pair((Object)node.getId(), (Object)node);
            }
            return null;
        }

        @Override
        public List<Pair<Long, Node>> findByValues(List<Node> values) {
            ArrayList<Pair<Long, Node>> results = new ArrayList<Pair<Long, Node>>(values.size());
            SortedSet nodeRefs = values.stream().map(Node::getNodeRef).map(NodeRef::getId).collect(Collectors.toCollection(() -> new TreeSet()));
            List<Node> selectedNodes = AbstractNodeDAOImpl.this.selectNodesByUuids(null, nodeRefs);
            selectedNodes.forEach(node -> {
                node.lock();
                results.add(new Pair((Object)node.getId(), node));
            });
            return results;
        }
    }

    private static class ParentAssocsCache {
        private final ReadWriteLock lock = new ReentrantReadWriteLock();
        private final int size;
        private final int maxParentCount;
        private final Map<Pair<Long, String>, ParentAssocsInfo> cache;
        private final Map<Pair<Long, String>, Pair<Long, String>> nextKeys;
        private final Map<Pair<Long, String>, Pair<Long, String>> previousKeys;
        private Pair<Long, String> firstKey;
        private Pair<Long, String> lastKey;
        private int parentCount;

        public ParentAssocsCache(int size, int limitFactor) {
            this.size = size;
            this.maxParentCount = size * limitFactor;
            int mapSize = size * 2;
            this.cache = new HashMap<Pair<Long, String>, ParentAssocsInfo>(mapSize);
            this.nextKeys = new HashMap<Pair<Long, String>, Pair<Long, String>>(mapSize);
            this.previousKeys = new HashMap<Pair<Long, String>, Pair<Long, String>>(mapSize);
        }

        private ParentAssocsInfo get(Pair<Long, String> cacheKey) {
            this.lock.readLock().lock();
            try {
                ParentAssocsInfo parentAssocsInfo = this.cache.get(cacheKey);
                return parentAssocsInfo;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        private void put(Pair<Long, String> cacheKey, ParentAssocsInfo parentAssocs) {
            this.lock.writeLock().lock();
            try {
                if (this.cache.containsKey(cacheKey)) {
                    this.remove(cacheKey);
                }
                this.cache.put(cacheKey, parentAssocs);
                if (this.firstKey == null) {
                    this.lastKey = cacheKey;
                } else {
                    this.nextKeys.put(cacheKey, this.firstKey);
                    this.previousKeys.put(this.firstKey, cacheKey);
                }
                this.firstKey = cacheKey;
                this.parentCount += parentAssocs.getParentAssocs().size();
                int currentSize = this.cache.size();
                while (currentSize > this.size || this.parentCount > this.maxParentCount) {
                    this.remove(this.lastKey);
                    --currentSize;
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        private ParentAssocsInfo remove(Pair<Long, String> cacheKey) {
            this.lock.writeLock().lock();
            try {
                ParentAssocsInfo oldParentAssocs = this.cache.remove(cacheKey);
                if (oldParentAssocs == null) {
                    return null;
                }
                Pair<Long, String> previousCacheKey = this.previousKeys.remove(cacheKey);
                Pair<Long, String> nextCacheKey = this.nextKeys.remove(cacheKey);
                if (nextCacheKey == null) {
                    if (previousCacheKey == null) {
                        this.lastKey = null;
                        this.firstKey = null;
                    } else {
                        this.lastKey = previousCacheKey;
                        this.nextKeys.remove(previousCacheKey);
                    }
                } else if (previousCacheKey == null) {
                    this.firstKey = nextCacheKey;
                    this.previousKeys.remove(nextCacheKey);
                } else {
                    this.nextKeys.put(previousCacheKey, nextCacheKey);
                    this.previousKeys.put(nextCacheKey, previousCacheKey);
                }
                this.parentCount -= oldParentAssocs.getParentAssocs().size();
                ParentAssocsInfo parentAssocsInfo = oldParentAssocs;
                return parentAssocsInfo;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        private void clear() {
            this.lock.writeLock().lock();
            try {
                this.cache.clear();
                this.nextKeys.clear();
                this.previousKeys.clear();
                this.lastKey = null;
                this.firstKey = null;
                this.parentCount = 0;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    private class PropertiesCallbackDAO
    extends EntityLookupCache.EntityLookupCallbackDAOAdaptor<NodeVersionKey, Map<QName, Serializable>, Serializable> {
        private PropertiesCallbackDAO() {
        }

        @Override
        public Pair<NodeVersionKey, Map<QName, Serializable>> createValue(Map<QName, Serializable> value) {
            throw new UnsupportedOperationException("A node always has a 'map' of properties.");
        }

        @Override
        public Pair<NodeVersionKey, Map<QName, Serializable>> findByKey(NodeVersionKey nodeVersionKey) {
            Long nodeId = nodeVersionKey.getNodeId();
            Map<NodeVersionKey, Map<NodePropertyKey, NodePropertyValue>> propsRawByNodeVersionKey = AbstractNodeDAOImpl.this.selectNodeProperties(nodeId);
            Map<NodePropertyKey, NodePropertyValue> propsRaw = propsRawByNodeVersionKey.get(nodeVersionKey);
            if (propsRaw == null) {
                if (propsRawByNodeVersionKey.size() == 0) {
                    propsRaw = Collections.emptyMap();
                } else {
                    AbstractNodeDAOImpl.this.invalidateNodeCaches(nodeId);
                    throw new DataIntegrityViolationException("Detected stale node entry: " + nodeVersionKey + " (now " + propsRawByNodeVersionKey.keySet() + ")");
                }
            }
            Map<QName, Serializable> props = AbstractNodeDAOImpl.this.nodePropertyHelper.convertToPublicProperties(propsRaw);
            return new Pair((Object)nodeVersionKey, Collections.unmodifiableMap(props));
        }

        @Override
        public List<Pair<NodeVersionKey, Map<QName, Serializable>>> findByKeys(List<NodeVersionKey> keys) {
            Set<Long> nodeIds = keys.stream().map(NodeVersionKey::getNodeId).distinct().collect(Collectors.toSet());
            Map<NodeVersionKey, Map<NodePropertyKey, NodePropertyValue>> propsRawByNodeVersionKey = AbstractNodeDAOImpl.this.selectNodeProperties(nodeIds);
            ArrayList<Pair<NodeVersionKey, Map<QName, Serializable>>> results = new ArrayList<Pair<NodeVersionKey, Map<QName, Serializable>>>(keys.size());
            for (NodeVersionKey nodeVersionKey : keys) {
                Long nodeId = nodeVersionKey.getNodeId();
                Map<NodePropertyKey, NodePropertyValue> propsRaw = propsRawByNodeVersionKey.get(nodeVersionKey);
                if (propsRaw == null) {
                    if (propsRawByNodeVersionKey.isEmpty()) {
                        propsRaw = Collections.emptyMap();
                    } else {
                        AbstractNodeDAOImpl.this.invalidateNodeCaches(nodeId);
                        throw new DataIntegrityViolationException("Detected stale node entry: " + nodeVersionKey + " (now " + propsRawByNodeVersionKey.keySet() + ")");
                    }
                }
                Map<QName, Serializable> props = AbstractNodeDAOImpl.this.nodePropertyHelper.convertToPublicProperties(propsRaw);
                results.add((Pair<NodeVersionKey, Map<QName, Serializable>>)new Pair((Object)nodeVersionKey, Collections.unmodifiableMap(props)));
            }
            return results;
        }

        @Override
        public List<Pair<NodeVersionKey, Map<QName, Serializable>>> findByValues(List<Map<QName, Serializable>> values) {
            throw new UnsupportedOperationException("Batch lookup not supported for node properties.");
        }
    }

    private class RootNodesCacheCallbackDAO
    extends EntityLookupCache.EntityLookupCallbackDAOAdaptor<StoreRef, Node, Serializable> {
        private RootNodesCacheCallbackDAO() {
        }

        @Override
        public Pair<StoreRef, Node> createValue(Node value) {
            throw new UnsupportedOperationException("Root node creation is done externally: " + value);
        }

        @Override
        public Pair<StoreRef, Node> findByKey(StoreRef storeRef) {
            NodeEntity node = AbstractNodeDAOImpl.this.selectStoreRootNode(storeRef);
            return node == null ? null : new Pair((Object)storeRef, (Object)node);
        }

        @Override
        public List<Pair<StoreRef, Node>> findByKeys(List<StoreRef> storeRefs) {
            throw new UnsupportedOperationException("Bulk root node lookup not supported: " + storeRefs);
        }

        @Override
        public List<Pair<StoreRef, Node>> findByValues(List<Node> values) {
            throw new UnsupportedOperationException("Bulk root node lookup not supported: " + values);
        }
    }

    private class UpdateTransactionListener
    implements TransactionalDao {
        private UpdateTransactionListener() {
        }

        @Override
        public boolean isDirty() {
            Long txnId = AbstractNodeDAOImpl.this.getCurrentTransactionId(false);
            return txnId != null;
        }

        @Override
        public void beforeCommit(boolean readOnly) {
            if (readOnly) {
                return;
            }
            TransactionEntity txn = (TransactionEntity)AlfrescoTransactionSupport.getResource((Object)AbstractNodeDAOImpl.KEY_TRANSACTION);
            Long txnId = txn.getId();
            Long now = System.currentTimeMillis();
            txn.setCommitTimeMs(now);
            AbstractNodeDAOImpl.this.updateTransaction(txnId, now);
        }
    }
}

