/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import org.alfresco.repo.search.SearcherException;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;

public class RepositoryLocation {
    private String storeProtocol = "workspace";
    private String storeId = "SpacesStore";
    private String path = "";
    private String queryLanguage = "xpath";
    public static final String LANGUAGE_PATH = "path";
    public static final String LANGUAGE_CLASSPATH = "classpath";

    public RepositoryLocation() {
    }

    public RepositoryLocation(StoreRef storeRef, String path, String queryLanguage) {
        this.storeProtocol = storeRef.getProtocol();
        this.storeId = storeRef.getIdentifier();
        this.path = path;
        this.setQueryLanguage(queryLanguage);
    }

    public void setStoreProtocol(String storeProtocol) {
        this.storeProtocol = storeProtocol;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setQueryLanguage(String queryLanguage) {
        if (!(queryLanguage.equals("lucene") || queryLanguage.equals("xpath") || queryLanguage.equals(LANGUAGE_PATH) || queryLanguage.equals(LANGUAGE_CLASSPATH))) {
            throw new SearcherException("Unknown query language: " + queryLanguage);
        }
        this.queryLanguage = queryLanguage;
    }

    public StoreRef getStoreRef() {
        return new StoreRef(this.storeProtocol, this.storeId);
    }

    public String getPath() {
        return this.path;
    }

    public String getQueryLanguage() {
        return this.queryLanguage;
    }

    public String getLuceneQueryStatement(QName contentModelType) {
        String result = "+TYPE:\"" + contentModelType.toString() + "\"";
        if (this.path != null && !this.path.equals("")) {
            result = String.valueOf(result) + " +PATH:\"" + this.path + "\"";
        }
        return result;
    }

    public String getXPathQueryStatement(QName prefixResolvedContentModelType) {
        String result = "/*[subtypeOf('" + prefixResolvedContentModelType.toPrefixString() + "')]";
        if (this.path != null && !this.path.equals("")) {
            result = String.valueOf(this.path) + result;
        }
        return result;
    }

    public String[] getPathElements() {
        if (this.path != null && !this.path.equals("")) {
            String pathToSplit = this.path;
            while (pathToSplit.startsWith("/")) {
                pathToSplit = pathToSplit.substring(1);
            }
            while (pathToSplit.endsWith("/")) {
                pathToSplit = pathToSplit.substring(0, pathToSplit.length() - 1);
            }
            String[] pathElements = pathToSplit.split("/");
            return pathElements;
        }
        return new String[0];
    }
}

