/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import junit.framework.TestCase;
import org.alfresco.repo.virtual.ref.NodeRefRadixHasher;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Test;

public class NodeRefRadixHasherTest
extends TestCase {
    private static Log logger = LogFactory.getLog(NodeRefRadixHasherTest.class);

    @Test
    public void testSupportedStores() throws Exception {
        NodeRefRadixHasher h = NodeRefRadixHasher.RADIX_36_HASHER;
        String[] storeProtocols = new String[]{"workspace", "archive", "avm", "deleted", "versionStore"};
        String[] storeIds = new String[]{"SpacesStore", "lightWeightVersionStore", "version2Store"};
        int i = 0;
        while (i < storeProtocols.length) {
            int j = 0;
            while (j < storeIds.length) {
                NodeRef nr = new NodeRef(storeProtocols[i], storeIds[j], "0d3b26ff-c4c1-4680-8622-8608ea7ab4b2");
                Pair nh = h.hash(nr);
                NodeRef nr2 = h.lookup(nh);
                NodeRefRadixHasherTest.assertEquals((String)("Could match hash-lookup " + nr), (Object)nr, (Object)nr2);
                ++j;
            }
            ++i;
        }
    }

    @Test
    public void testZeroPaddedNodeId() throws Exception {
        NodeRefRadixHasher h = NodeRefRadixHasher.RADIX_36_HASHER;
        NodeRef nr = new NodeRef("workspace://SpacesStore/0d3b26ff-c4c1-4680-8622-8608ea7ab4b2");
        Pair nh = h.hash(nr);
        NodeRef nr2 = h.lookup(nh);
        NodeRefRadixHasherTest.assertEquals((Object)nr, (Object)nr2);
    }

    @Test
    public void testInvalidStoreId() throws Exception {
        NodeRefRadixHasher h = NodeRefRadixHasher.RADIX_36_HASHER;
        NodeRef nr = new NodeRef("workspace://ASpacesStore/0d3b26ff-c4c1-4680-8622-8608ea7ab4b2");
        try {
            h.hash(nr);
            NodeRefRadixHasherTest.fail((String)("Should not be able to hash invalid store NodeRef " + nr));
        }
        catch (RuntimeException e) {
            logger.info((Object)("Caught invalid NodeRef " + e.getMessage()));
        }
    }

    @Test
    public void testInvalidStoreProtocol() throws Exception {
        NodeRefRadixHasher h = NodeRefRadixHasher.RADIX_36_HASHER;
        NodeRef nr = new NodeRef("Xworkspace://SpacesStore/0d3b26ff-c4c1-4680-8622-8608ea7ab4b2");
        try {
            h.hash(nr);
            NodeRefRadixHasherTest.fail((String)("Should not be able to hash invalid store NodeRef " + nr));
        }
        catch (RuntimeException e) {
            logger.info((Object)("Caught invalid NodeRef " + e.getMessage()));
        }
    }

    @Test
    public void testInvalidNodeId1() throws Exception {
        NodeRefRadixHasher h = NodeRefRadixHasher.RADIX_36_HASHER;
        NodeRef nr = new NodeRef("workspace://SpacesStore/0d3b26ff-c4c1-4680-8622-8608ea7ab4");
        try {
            h.hash(nr);
            NodeRefRadixHasherTest.fail((String)("Should not be able to hash invalid id (length) NodeRef " + nr));
        }
        catch (RuntimeException e) {
            logger.info((Object)("Caught invalid NodeRef " + e.getMessage()));
        }
    }

    @Test
    public void testInvalidNodeId2() throws Exception {
        NodeRefRadixHasher h = NodeRefRadixHasher.RADIX_36_HASHER;
        NodeRef nr = new NodeRef("workspace://SpacesStore/0d3b26ff-c4c14680-8622-8608ea7ab4b29");
        try {
            h.hash(nr);
            NodeRefRadixHasherTest.fail((String)("Should not be able to hash invalid id (format) NodeRef " + nr));
        }
        catch (RuntimeException e) {
            logger.info((Object)("Caught invalid NodeRef " + e.getMessage()));
        }
    }
}

