/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice.admin;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.security.authentication.identityservice.admin.AdminConsoleAuthenticationCookiesService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class AdminConsoleAuthenticationCookiesServiceUnitTest {
    private static final int DEFAULT_COOKIE_LIFETIME = 86400;
    private static final String COOKIE_NAME = "cookie";
    private static final String COOKIE_VALUE = "value";
    @Mock
    private HttpServletRequest request;
    @Mock
    private HttpServletResponse response;
    @Mock
    private SysAdminParams sysAdminParams;
    @Captor
    private ArgumentCaptor<Cookie> cookieCaptor;
    private AdminConsoleAuthenticationCookiesService cookiesService;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.cookiesService = new AdminConsoleAuthenticationCookiesService(this.sysAdminParams, 86400);
    }

    @Test
    public void cookieShouldBeFoundInRequestThatContainsIt() {
        Mockito.when((Object)this.request.getCookies()).thenReturn((Object)new Cookie[]{new Cookie(COOKIE_NAME, COOKIE_VALUE)});
        String cookie = this.cookiesService.getCookie(COOKIE_NAME, this.request);
        Assert.assertNotNull((String)"The cookie should not be null", (Object)cookie);
        Assert.assertEquals((String)"The cookie's value should match", (Object)COOKIE_VALUE, (Object)cookie);
        ((HttpServletRequest)Mockito.verify((Object)this.request)).getCookies();
    }

    @Test
    public void cookieShouldNotBeFoundInRequestThatDoesNotContainIt() {
        Mockito.when((Object)this.request.getCookies()).thenReturn((Object)new Cookie[]{new Cookie(COOKIE_NAME, COOKIE_VALUE)});
        Assert.assertNull((String)"The cookie should be null", (Object)this.cookiesService.getCookie("non-contained-cookie", this.request));
        ((HttpServletRequest)Mockito.verify((Object)this.request)).getCookies();
    }

    @Test
    public void cookieShouldNotBeFoundInRequestWithoutCookies() {
        Mockito.when((Object)this.request.getCookies()).thenReturn(null);
        Assert.assertNull((String)"The cookie should be null", (Object)this.cookiesService.getCookie(COOKIE_NAME, this.request));
        ((HttpServletRequest)Mockito.verify((Object)this.request)).getCookies();
    }

    @Test
    public void cookieShouldBeAddedToTheResponseWithDefaultParams() {
        Mockito.when((Object)this.sysAdminParams.getAlfrescoProtocol()).thenReturn((Object)"http");
        this.cookiesService.addCookie(COOKIE_NAME, COOKIE_VALUE, this.response);
        ((SysAdminParams)Mockito.verify((Object)this.sysAdminParams)).getAlfrescoProtocol();
        ((HttpServletResponse)Mockito.verify((Object)this.response)).addCookie((Cookie)this.cookieCaptor.capture());
        Cookie cookie = (Cookie)this.cookieCaptor.getValue();
        Assert.assertNotNull((String)"The cookie should not be null", (Object)cookie);
        Assert.assertEquals((String)"Cookie's name should match", (Object)COOKIE_NAME, (Object)cookie.getName());
        Assert.assertEquals((String)"Cookie's value should match", (Object)COOKIE_VALUE, (Object)cookie.getValue());
        Assert.assertEquals((String)"Cookie's path should be the root", (Object)"/", (Object)cookie.getPath());
        Assert.assertEquals((String)"Cookie's maxAge should match the default lifetime", (long)86400L, (long)cookie.getMaxAge());
        Assert.assertFalse((String)"Cookie's secure flag should be false", (boolean)cookie.getSecure());
    }

    @Test
    public void secureCookieShouldBeAddedToTheResponseWhenAlfrescoProtocolIsHttps() {
        Mockito.when((Object)this.sysAdminParams.getAlfrescoProtocol()).thenReturn((Object)"https");
        this.cookiesService.addCookie(COOKIE_NAME, COOKIE_VALUE, this.response);
        ((SysAdminParams)Mockito.verify((Object)this.sysAdminParams)).getAlfrescoProtocol();
        ((HttpServletResponse)Mockito.verify((Object)this.response)).addCookie((Cookie)this.cookieCaptor.capture());
        Cookie cookie = (Cookie)this.cookieCaptor.getValue();
        Assert.assertNotNull((String)"The cookie should not be null", (Object)cookie);
        Assert.assertTrue((String)"Cookie's secure flag should be true", (boolean)cookie.getSecure());
    }

    @Test
    public void cookieWithCustomMaxAgeShouldBeAddedToTheResponse() {
        int customMaxAge = 60;
        this.cookiesService = new AdminConsoleAuthenticationCookiesService(this.sysAdminParams, customMaxAge);
        Mockito.when((Object)this.sysAdminParams.getAlfrescoProtocol()).thenReturn((Object)"https");
        this.cookiesService.addCookie(COOKIE_NAME, COOKIE_VALUE, this.response);
        ((SysAdminParams)Mockito.verify((Object)this.sysAdminParams)).getAlfrescoProtocol();
        ((HttpServletResponse)Mockito.verify((Object)this.response)).addCookie((Cookie)this.cookieCaptor.capture());
        Cookie cookie = (Cookie)this.cookieCaptor.getValue();
        Assert.assertNotNull((String)"The cookie should not be null", (Object)cookie);
        Assert.assertEquals((String)"Cookie's maxAge should match the custom lifetime", (long)customMaxAge, (long)cookie.getMaxAge());
    }

    @Test
    public void cookieShouldBeReset() {
        Mockito.when((Object)this.sysAdminParams.getAlfrescoProtocol()).thenReturn((Object)"http");
        this.cookiesService.resetCookie(COOKIE_NAME, this.response);
        ((SysAdminParams)Mockito.verify((Object)this.sysAdminParams)).getAlfrescoProtocol();
        ((HttpServletResponse)Mockito.verify((Object)this.response)).addCookie((Cookie)this.cookieCaptor.capture());
        Cookie cookie = (Cookie)this.cookieCaptor.getValue();
        Assert.assertNotNull((String)"The cookie should not be null", (Object)cookie);
        Assert.assertEquals((String)"Cookie's name should match", (Object)COOKIE_NAME, (Object)cookie.getName());
        Assert.assertEquals((String)"Cookie's value should be reset", (Object)"", (Object)cookie.getValue());
        Assert.assertEquals((String)"Cookie's path should be the root", (Object)"/", (Object)cookie.getPath());
        Assert.assertEquals((String)"Cookie's maxAge should be 0", (long)0L, (long)cookie.getMaxAge());
        Assert.assertFalse((String)"Cookie's secure flag should be false", (boolean)cookie.getSecure());
    }

    @Test
    public void secureCookieShouldBeReset() {
        Mockito.when((Object)this.sysAdminParams.getAlfrescoProtocol()).thenReturn((Object)"https");
        this.cookiesService.resetCookie(COOKIE_NAME, this.response);
        ((SysAdminParams)Mockito.verify((Object)this.sysAdminParams)).getAlfrescoProtocol();
        ((HttpServletResponse)Mockito.verify((Object)this.response)).addCookie((Cookie)this.cookieCaptor.capture());
        Cookie cookie = (Cookie)this.cookieCaptor.getValue();
        Assert.assertNotNull((String)"The cookie should not be null", (Object)cookie);
        Assert.assertTrue((String)"Cookie's secure flag should be true", (boolean)cookie.getSecure());
    }
}

