/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.bundle;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.repo.preference.traitextender.PreferenceServiceExtension;
import org.alfresco.repo.preference.traitextender.PreferenceServiceTrait;
import org.alfresco.repo.virtual.ref.GetActualNodeRefMethod;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.service.cmr.preference.PreferenceService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.traitextender.SpringBeanExtension;

public class VirtualPreferenceServiceExtension
extends SpringBeanExtension<PreferenceServiceExtension, PreferenceServiceTrait>
implements PreferenceServiceExtension {
    private static final String EMPTY_STRING = "";
    private static final String DOCUMENTS_FAVOURITES_KEY = "org.alfresco.share.documents.favourites";
    private static final String FOLDERS_FAVOURITES_KEY = "org.alfresco.share.folders.favourites";
    private static final String CREATED_AT = ".createdAt";
    private static final String EXT_DOCUMENTS_FAVOURITES = "org.alfresco.ext.documents.favourites.";
    private static final String EXT_FOLDERS_FAVOURITES = "org.alfresco.ext.folders.favourites.";
    private PreferenceService preferenceService;

    public VirtualPreferenceServiceExtension() {
        super(PreferenceServiceTrait.class);
    }

    public void setPreferenceService(PreferenceService preferenceService) {
        this.preferenceService = preferenceService;
    }

    /*
     * Unable to fully structure code
     */
    private String getExtPreferenceKey(Map<String, Serializable> preferences) {
        extKey = null;
        if (!preferences.containsKey("org.alfresco.share.documents.favourites") && !preferences.containsKey("org.alfresco.share.folders.favourites")) {
            return null;
        }
        entrySet = preferences.entrySet();
        if (entrySet == null) {
            return null;
        }
        iterator = entrySet.iterator();
        if (iterator.hasNext()) ** GOTO lbl15
        return null;
lbl-1000:
        // 1 sources

        {
            entry = iterator.next();
            key = entry.getKey();
            if (!key.startsWith("org.alfresco.ext.documents.favourites.") && !key.startsWith("org.alfresco.ext.folders.favourites.")) continue;
            extKey = key;
            break;
lbl15:
            // 2 sources

            ** while (iterator.hasNext())
        }
lbl16:
        // 2 sources

        return extKey;
    }

    @Override
    public void setPreferences(String userName, Map<String, Serializable> preferences) throws Throwable {
        String extKey = this.getExtPreferenceKey(preferences);
        if (extKey != null) {
            String favKey;
            String extFavKey;
            if (extKey.startsWith(EXT_DOCUMENTS_FAVOURITES)) {
                extFavKey = EXT_DOCUMENTS_FAVOURITES;
                favKey = DOCUMENTS_FAVOURITES_KEY;
            } else {
                extFavKey = EXT_FOLDERS_FAVOURITES;
                favKey = FOLDERS_FAVOURITES_KEY;
            }
            String pattern = "^" + extFavKey + "(\\S+)" + CREATED_AT + "$";
            Pattern p = Pattern.compile(pattern);
            Matcher m = p.matcher(extKey);
            if (m.find()) {
                NodeRef documentNodeRef;
                Reference reference;
                String documentNodeRefStr = m.group(1);
                String favorites = (String)((Object)preferences.get(favKey));
                if (documentNodeRefStr != null && !documentNodeRefStr.isEmpty() && (reference = Reference.fromNodeRef(documentNodeRef = new NodeRef(documentNodeRefStr))) != null) {
                    NodeRef actualNodeRef = reference.execute(new GetActualNodeRefMethod(null));
                    String actualNodeRefStr = actualNodeRef.toString();
                    String actualExtPreference = String.valueOf(extFavKey) + actualNodeRefStr + CREATED_AT;
                    ArrayList<String> elements = new ArrayList<String>(Arrays.asList(favorites.split(",")));
                    boolean elementsChanged = false;
                    if (favorites.contains(documentNodeRefStr)) {
                        if (!preferences.containsKey(actualExtPreference)) {
                            Serializable value = preferences.get(extKey);
                            preferences.put(actualExtPreference, value);
                        }
                        preferences.remove(extKey);
                        if (!favorites.contains(actualNodeRefStr)) {
                            favorites = favorites.replace(documentNodeRefStr, actualNodeRefStr);
                        } else if (elements.contains(documentNodeRefStr)) {
                            elements.remove(documentNodeRefStr);
                            elementsChanged = true;
                        }
                    } else if (elements.contains(actualNodeRefStr)) {
                        elements.remove(actualNodeRefStr);
                        this.preferenceService.clearPreferences(userName, actualExtPreference);
                        elementsChanged = true;
                    }
                    if (elementsChanged) {
                        favorites = EMPTY_STRING;
                        for (String element : elements) {
                            favorites = favorites.isEmpty() ? element : String.valueOf(favorites) + "," + element;
                        }
                    }
                    preferences.put(favKey, (Serializable)((Object)favorites));
                }
            }
        }
        ((PreferenceServiceTrait)this.getTrait()).setPreferences(userName, preferences);
    }
}

