/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.util.Set;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceConfig;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceException;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceFacadeFactoryBean;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.springframework.http.HttpStatus;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class ClientRegistrationProviderUnitTest {
    private static final String CLIENT_ID = "alfresco";
    private static final String OPENID_CONFIGURATION = "{\"token_endpoint\":\"https://login.serviceonline.alfresco/common/oauth2/v2.0/token\",\"token_endpoint_auth_methods_supported\":[\"client_secret_post\",\"private_key_jwt\",\"client_secret_basic\"],\"jwks_uri\":\"https://login.serviceonline.alfresco/common/discovery/v2.0/keys\",\"response_modes_supported\":[\"query\",\"fragment\",\"form_post\"],\"subject_types_supported\":[\"pairwise\"],\"id_token_signing_alg_values_supported\":[\"RS256\"],\"response_types_supported\":[\"code\",\"id_token\",\"code id_token\",\"id_token token\"],\"scopes_supported\":[\"openid\",\"profile\",\"email\",\"offline_access\"],\"issuer\":\"https://login.serviceonline.alfresco/alfresco/v2.0\",\"request_uri_parameter_supported\":false,\"userinfo_endpoint\":\"https://graph.service.alfresco/oidc/userinfo\",\"authorization_endpoint\":\"https://login.serviceonline.alfresco/common/oauth2/v2.0/authorize\",\"device_authorization_endpoint\":\"https://login.serviceonline.alfresco/common/oauth2/v2.0/devicecode\",\"http_logout_supported\":true,\"frontchannel_logout_supported\":true,\"end_session_endpoint\":\"https://login.serviceonline.alfresco/common/oauth2/v2.0/logout\",\"claims_supported\":[\"sub\",\"iss\",\"cloud_instance_name\",\"cloud_instance_host_name\",\"cloud_graph_host_name\",\"msgraph_host\",\"aud\",\"exp\",\"iat\",\"auth_time\",\"acr\",\"nonce\",\"preferred_username\",\"name\",\"tid\",\"ver\",\"at_hash\",\"c_hash\",\"email\"],\"kerberos_endpoint\":\"https://login.serviceonline.alfresco/common/kerberos\",\"tenant_region_scope\":null,\"cloud_instance_name\":\"serviceonline.alfresco\",\"cloud_graph_host_name\":\"graph.oidc.net\",\"msgraph_host\":\"graph.service.alfresco\",\"rbac_url\":\"https://pas.oidc.alfresco\"}";
    private static final String DISCOVERY_PATH_SEGMENTS = "/.well-known/openid-configuration";
    private static final String AUTH_SERVER = "https://login.serviceonline.alfresco";
    private IdentityServiceConfig config;
    private RestTemplate restTemplate;
    private OIDCProviderMetadata oidcResponse;
    private ArgumentCaptor<RequestEntity> requestEntityCaptor = ArgumentCaptor.forClass(RequestEntity.class);

    @Before
    public void setup() throws ParseException {
        this.config = new IdentityServiceConfig();
        this.config.setAuthServerUrl(AUTH_SERVER);
        this.config.setResource(CLIENT_ID);
        this.restTemplate = (RestTemplate)Mockito.mock(RestTemplate.class);
        ResponseEntity responseEntity = (ResponseEntity)Mockito.mock(ResponseEntity.class);
        Mockito.when((Object)this.restTemplate.exchange((RequestEntity)this.requestEntityCaptor.capture(), (Class)ArgumentMatchers.eq(String.class))).thenReturn((Object)responseEntity);
        Mockito.when((Object)responseEntity.getStatusCode()).thenReturn((Object)HttpStatus.OK);
        Mockito.when((Object)responseEntity.hasBody()).thenReturn((Object)true);
        Mockito.when((Object)responseEntity.getBody()).thenReturn((Object)"");
        this.oidcResponse = (OIDCProviderMetadata)Mockito.spy((Object)OIDCProviderMetadata.parse((String)OPENID_CONFIGURATION));
    }

    @Test
    public void shouldCreateClientRegistration() {
        this.config.setIssuerUrl("https://login.serviceonline.alfresco/alfresco/v2.0");
        Throwable throwable = null;
        Object var2_3 = null;
        try (MockedStatic providerMetadata = Mockito.mockStatic(OIDCProviderMetadata.class);){
            providerMetadata.when(() -> {
                OIDCProviderMetadata oIDCProviderMetadata = OIDCProviderMetadata.parse((String)((String)ArgumentMatchers.any(String.class)));
            }).thenReturn((Object)this.oidcResponse);
            ClientRegistration clientRegistration = new IdentityServiceFacadeFactoryBean.ClientRegistrationProvider(this.config).createClientRegistration((RestOperations)this.restTemplate);
            Assertions.assertThat((Object)clientRegistration).isNotNull();
            Assertions.assertThat((String)clientRegistration.getClientId()).isNotNull();
            Assertions.assertThat((String)clientRegistration.getProviderDetails().getAuthorizationUri()).isNotNull();
            Assertions.assertThat((String)clientRegistration.getProviderDetails().getTokenUri()).isNotNull();
            Assertions.assertThat((String)clientRegistration.getProviderDetails().getJwkSetUri()).isNotNull();
            Assertions.assertThat((Object)clientRegistration.getProviderDetails().getUserInfoEndpoint()).isNotNull();
            Assertions.assertThat((String)clientRegistration.getProviderDetails().getIssuerUri()).isNotNull();
            Assertions.assertThat((String)((RequestEntity)this.requestEntityCaptor.getValue()).getUrl().toASCIIString()).isEqualTo("https://login.serviceonline.alfresco/.well-known/openid-configuration");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void shouldCreateClientRegistrationWithoutIssuerConfigured() {
        this.config.setIssuerUrl(null);
        Throwable throwable = null;
        Object var2_3 = null;
        try (MockedStatic providerMetadata = Mockito.mockStatic(OIDCProviderMetadata.class);){
            providerMetadata.when(() -> {
                OIDCProviderMetadata oIDCProviderMetadata = OIDCProviderMetadata.parse((String)((String)ArgumentMatchers.any(String.class)));
            }).thenReturn((Object)this.oidcResponse);
            ClientRegistration clientRegistration = new IdentityServiceFacadeFactoryBean.ClientRegistrationProvider(this.config).createClientRegistration((RestOperations)this.restTemplate);
            Assertions.assertThat((Object)clientRegistration).isNotNull();
            Assertions.assertThat((String)clientRegistration.getClientId()).isNotNull();
            Assertions.assertThat((String)clientRegistration.getProviderDetails().getAuthorizationUri()).isNotNull();
            Assertions.assertThat((String)clientRegistration.getProviderDetails().getTokenUri()).isNotNull();
            Assertions.assertThat((String)clientRegistration.getProviderDetails().getJwkSetUri()).isNotNull();
            Assertions.assertThat((Object)clientRegistration.getProviderDetails().getUserInfoEndpoint()).isNotNull();
            Assertions.assertThat((String)clientRegistration.getProviderDetails().getIssuerUri()).isNotNull();
            Assertions.assertThat((String)((RequestEntity)this.requestEntityCaptor.getValue()).getUrl().toASCIIString()).isEqualTo("https://login.serviceonline.alfresco/.well-known/openid-configuration");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void shouldThrowIdentityServiceExceptionIfIssuerIsNotValid() {
        this.config.setIssuerUrl("https://invalidissuer.alfresco");
        Throwable throwable = null;
        Object var2_3 = null;
        try (MockedStatic providerMetadata = Mockito.mockStatic(OIDCProviderMetadata.class);){
            providerMetadata.when(() -> {
                OIDCProviderMetadata oIDCProviderMetadata = OIDCProviderMetadata.parse((String)((String)ArgumentMatchers.any(String.class)));
            }).thenReturn((Object)this.oidcResponse);
            Assert.assertThrows(IdentityServiceException.class, () -> {
                ClientRegistration clientRegistration = new IdentityServiceFacadeFactoryBean.ClientRegistrationProvider(this.config).createClientRegistration((RestOperations)this.restTemplate);
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void shouldThrowIdentityServiceExceptionIfIssuerIsNull() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (MockedStatic providerMetadata = Mockito.mockStatic(OIDCProviderMetadata.class);){
            Mockito.when((Object)this.oidcResponse.getIssuer()).thenReturn(null);
            providerMetadata.when(() -> {
                OIDCProviderMetadata oIDCProviderMetadata = OIDCProviderMetadata.parse((String)((String)ArgumentMatchers.any(String.class)));
            }).thenReturn((Object)this.oidcResponse);
            Assert.assertThrows(IdentityServiceException.class, () -> {
                ClientRegistration clientRegistration = new IdentityServiceFacadeFactoryBean.ClientRegistrationProvider(this.config).createClientRegistration((RestOperations)this.restTemplate);
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void shouldThrowIdentityServiceExceptionIfTokenEndpointIsNull() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (MockedStatic providerMetadata = Mockito.mockStatic(OIDCProviderMetadata.class);){
            Mockito.when((Object)this.oidcResponse.getTokenEndpointURI()).thenReturn(null);
            providerMetadata.when(() -> {
                OIDCProviderMetadata oIDCProviderMetadata = OIDCProviderMetadata.parse((String)((String)ArgumentMatchers.any(String.class)));
            }).thenReturn((Object)this.oidcResponse);
            Assert.assertThrows(IdentityServiceException.class, () -> {
                ClientRegistration clientRegistration = new IdentityServiceFacadeFactoryBean.ClientRegistrationProvider(this.config).createClientRegistration((RestOperations)this.restTemplate);
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void shouldThrowIdentityServiceExceptionIfAuthorizationEndpointIsNull() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (MockedStatic providerMetadata = Mockito.mockStatic(OIDCProviderMetadata.class);){
            Mockito.when((Object)this.oidcResponse.getAuthorizationEndpointURI()).thenReturn(null);
            providerMetadata.when(() -> {
                OIDCProviderMetadata oIDCProviderMetadata = OIDCProviderMetadata.parse((String)((String)ArgumentMatchers.any(String.class)));
            }).thenReturn((Object)this.oidcResponse);
            Assert.assertThrows(IdentityServiceException.class, () -> {
                ClientRegistration clientRegistration = new IdentityServiceFacadeFactoryBean.ClientRegistrationProvider(this.config).createClientRegistration((RestOperations)this.restTemplate);
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void shouldThrowIdentityServiceExceptionIfUserInfoEndpointIsNull() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (MockedStatic providerMetadata = Mockito.mockStatic(OIDCProviderMetadata.class);){
            Mockito.when((Object)this.oidcResponse.getUserInfoEndpointURI()).thenReturn(null);
            providerMetadata.when(() -> {
                OIDCProviderMetadata oIDCProviderMetadata = OIDCProviderMetadata.parse((String)((String)ArgumentMatchers.any(String.class)));
            }).thenReturn((Object)this.oidcResponse);
            Assert.assertThrows(IdentityServiceException.class, () -> {
                ClientRegistration clientRegistration = new IdentityServiceFacadeFactoryBean.ClientRegistrationProvider(this.config).createClientRegistration((RestOperations)this.restTemplate);
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void shouldThrowIdentityServiceExceptionIfJWKSetEndpointIsNull() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (MockedStatic providerMetadata = Mockito.mockStatic(OIDCProviderMetadata.class);){
            Mockito.when((Object)this.oidcResponse.getJWKSetURI()).thenReturn(null);
            providerMetadata.when(() -> {
                OIDCProviderMetadata oIDCProviderMetadata = OIDCProviderMetadata.parse((String)((String)ArgumentMatchers.any(String.class)));
            }).thenReturn((Object)this.oidcResponse);
            Assert.assertThrows(IdentityServiceException.class, () -> {
                ClientRegistration clientRegistration = new IdentityServiceFacadeFactoryBean.ClientRegistrationProvider(this.config).createClientRegistration((RestOperations)this.restTemplate);
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void shouldCreateDiscoveryEndpointWithRealm() {
        this.config.setRealm(CLIENT_ID);
        this.config.setIssuerUrl("https://login.serviceonline.alfresco/alfresco/v2.0");
        Throwable throwable = null;
        Object var2_3 = null;
        try (MockedStatic providerMetadata = Mockito.mockStatic(OIDCProviderMetadata.class);){
            providerMetadata.when(() -> {
                OIDCProviderMetadata oIDCProviderMetadata = OIDCProviderMetadata.parse((String)((String)ArgumentMatchers.any(String.class)));
            }).thenReturn((Object)this.oidcResponse);
            new IdentityServiceFacadeFactoryBean.ClientRegistrationProvider(this.config).createClientRegistration((RestOperations)this.restTemplate);
            Assertions.assertThat((String)((RequestEntity)this.requestEntityCaptor.getValue()).getUrl().toASCIIString()).isEqualTo("https://login.serviceonline.alfresco/realms/alfresco/.well-known/openid-configuration");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void shouldSetAllSupportedScopes() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (MockedStatic providerMetadata = Mockito.mockStatic(OIDCProviderMetadata.class);){
            providerMetadata.when(() -> {
                OIDCProviderMetadata oIDCProviderMetadata = OIDCProviderMetadata.parse((String)((String)ArgumentMatchers.any(String.class)));
            }).thenReturn((Object)this.oidcResponse);
            ClientRegistration clientRegistration = new IdentityServiceFacadeFactoryBean.ClientRegistrationProvider(this.config).createClientRegistration((RestOperations)this.restTemplate);
            Assertions.assertThat((boolean)clientRegistration.getScopes().containsAll(Set.of("openid", "profile", "email"))).isTrue();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void shouldSetOneSupportedScope() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (MockedStatic providerMetadata = Mockito.mockStatic(OIDCProviderMetadata.class);){
            Mockito.when((Object)this.oidcResponse.getScopes()).thenReturn((Object)new Scope(new String[]{"openid"}));
            providerMetadata.when(() -> {
                OIDCProviderMetadata oIDCProviderMetadata = OIDCProviderMetadata.parse((String)((String)ArgumentMatchers.any(String.class)));
            }).thenReturn((Object)this.oidcResponse);
            ClientRegistration clientRegistration = new IdentityServiceFacadeFactoryBean.ClientRegistrationProvider(this.config).createClientRegistration((RestOperations)this.restTemplate);
            Assertions.assertThat((int)clientRegistration.getScopes().size()).isEqualTo(1);
            Assertions.assertThat((String)((String)clientRegistration.getScopes().stream().findFirst().get())).isEqualTo("openid");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void shouldCreateDiscoveryEndpointFromIssuer() {
        this.config.setAuthServerUrl(null);
        this.config.setIssuerUrl("https://login.serviceonline.alfresco/alfresco/v2.0");
        Throwable throwable = null;
        Object var2_3 = null;
        try (MockedStatic providerMetadata = Mockito.mockStatic(OIDCProviderMetadata.class);){
            providerMetadata.when(() -> {
                OIDCProviderMetadata oIDCProviderMetadata = OIDCProviderMetadata.parse((String)((String)ArgumentMatchers.any(String.class)));
            }).thenReturn((Object)this.oidcResponse);
            new IdentityServiceFacadeFactoryBean.ClientRegistrationProvider(this.config).createClientRegistration((RestOperations)this.restTemplate);
            Assertions.assertThat((String)((RequestEntity)this.requestEntityCaptor.getValue()).getUrl().toASCIIString()).isEqualTo("https://login.serviceonline.alfresco/alfresco/v2.0/.well-known/openid-configuration");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

