/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.Date;
import java.util.Properties;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.repo.content.transform.TransformerLog;
import org.alfresco.repo.content.transform.TransformerLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class TransformerLogTest {
    @Mock
    private TransformerDebug transformerDebug;
    @Mock
    private Properties properties;
    private TransformerLog log;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.log = new TransformerLog();
        this.log.setTransformerDebug(this.transformerDebug);
        this.log.setProperties(this.properties);
    }

    static String[] stripDateStamp(String[] actual) {
        int beginIndex = (String.valueOf(TransformerLogger.DATE_FORMAT.format(new Date())) + ' ').length();
        int i = actual.length - 1;
        while (i >= 0) {
            actual[i] = actual[i].substring(beginIndex);
            --i;
        }
        return actual;
    }

    static void assertLogEntriesEquals(String[] expected, String[] actual) {
        Assert.assertArrayEquals((Object[])expected, (Object[])TransformerLogTest.stripDateStamp(actual));
    }

    @Test
    public void noEntriesDisabledTest() {
        Assert.assertArrayEquals((Object[])new String[]{"No entries are available. transformer.log.entries must be set to a number between 1 and 1000"}, (Object[])this.log.getEntries(10));
    }

    @Test
    public void oneEntryTest() {
        Mockito.when((Object)this.properties.getProperty("transformer.log.entries")).thenReturn((Object)"3");
        this.log.debug((Object)"one");
        TransformerLogTest.assertLogEntriesEquals(new String[]{"one"}, this.log.getEntries(10));
    }

    @Test
    public void fiveEntryTest() {
        Mockito.when((Object)this.properties.getProperty("transformer.log.entries")).thenReturn((Object)"3");
        this.log.debug((Object)"one");
        this.log.debug((Object)"two");
        this.log.debug((Object)"three");
        this.log.debug((Object)"four");
        this.log.debug((Object)"five");
        TransformerLogTest.assertLogEntriesEquals(new String[]{"five", "four", "three"}, this.log.getEntries(10));
    }
}

