/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.alfresco.repo.transfer.AbstractManifestProcessorBase;
import org.alfresco.repo.transfer.AlienProcessor;
import org.alfresco.repo.transfer.CorrespondingNodeResolver;
import org.alfresco.repo.transfer.TransferModel;
import org.alfresco.repo.transfer.manifest.TransferManifestDeletedNode;
import org.alfresco.repo.transfer.manifest.TransferManifestHeader;
import org.alfresco.repo.transfer.manifest.TransferManifestNormalNode;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.transfer.TransferReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepoTertiaryManifestProcessorImpl
extends AbstractManifestProcessorBase {
    private NodeService nodeService;
    private AlienProcessor alienProcessor;
    CorrespondingNodeResolver nodeResolver;
    private static final Log log = LogFactory.getLog(RepoTertiaryManifestProcessorImpl.class);
    boolean isSync = false;
    String manifestRepositoryId;

    public RepoTertiaryManifestProcessorImpl(TransferReceiver receiver, String transferId) {
        super(receiver, transferId);
    }

    @Override
    protected void endManifest() {
    }

    @Override
    protected void processNode(TransferManifestDeletedNode node) {
    }

    @Override
    protected void processNode(TransferManifestNormalNode node) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing node with incoming noderef of " + node.getNodeRef()));
        }
        this.logComment("Tertiary Processing incoming node: " + node.getNodeRef() + " --  Source path = " + node.getParentPath() + "/" + node.getPrimaryParentAssoc().getQName());
        if (this.isSync) {
            ChildAssociationRef primaryParentAssoc = node.getPrimaryParentAssoc();
            CorrespondingNodeResolver.ResolvedParentChildPair resolvedNodes = this.nodeResolver.resolveCorrespondingNode(node.getNodeRef(), primaryParentAssoc, node.getParentPath());
            NodeRef nodeRef = resolvedNodes.resolvedChild;
            if (this.nodeService.exists(nodeRef)) {
                log.debug((Object)"destination node exists - check the children");
                List<ChildAssociationRef> expectedChildren = node.getChildAssocs();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Checking node in TERTIARY_MANIFEST_PROCESSOR");
                }
                if (resolvedNodes.resolvedParent != null && this.nodeService.exists(resolvedNodes.resolvedParent)) {
                    if (log.isTraceEnabled()) {
                        this.logInvasionHierarchy(resolvedNodes.resolvedParent, nodeRef, this.nodeService, log);
                    }
                } else {
                    List parentAssocs = this.nodeService.getParentAssocs(nodeRef);
                    if (log.isTraceEnabled()) {
                        this.logInvasionHierarchy(((ChildAssociationRef)parentAssocs.iterator().next()).getParentRef(), nodeRef, this.nodeService, log);
                    }
                }
                ArrayList<NodeRef> expectedChildNodeRefs = new ArrayList<NodeRef>();
                HashSet<Path> expectedChildNodePaths = new HashSet<Path>();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Expected children:");
                }
                for (ChildAssociationRef ref : expectedChildren) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Expecting child node " + ref));
                    }
                    NodeRef childRef = null;
                    if (this.nodeService.exists(ref.getChildRef())) {
                        childRef = ref.getChildRef();
                        if (log.isTraceEnabled()) {
                            this.logInvasionHierarchy(nodeRef, ref.getChildRef(), this.nodeService, log);
                        }
                    } else {
                        Path parentPath = node.getParentPath();
                        parentPath = parentPath.subPath(0, parentPath.size() - 1);
                        parentPath.append((Path.Element)new Path.ChildAssocElement(ref));
                        CorrespondingNodeResolver.ResolvedParentChildPair resolvedChild = this.nodeResolver.resolveCorrespondingNode(ref.getChildRef(), ref, parentPath);
                        if (resolvedChild.resolvedChild != null) {
                            childRef = resolvedChild.resolvedChild;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"The node has been RESOLVED!");
                            }
                            if (log.isTraceEnabled()) {
                                this.logInvasionHierarchy(resolvedChild.resolvedParent, resolvedChild.resolvedChild, this.nodeService, log);
                            }
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"The node DOES NOT exist in current repository! Processing will be made by its PATH!");
                            }
                            expectedChildNodePaths.add(parentPath);
                        }
                    }
                    if (childRef == null) continue;
                    expectedChildNodeRefs.add(childRef);
                }
                List actualChildren = this.nodeService.getChildAssocs(nodeRef);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Traversing ACTUAL children:");
                }
                for (ChildAssociationRef child : actualChildren) {
                    log.debug((Object)("checking child: " + child));
                    if (!child.isPrimary()) continue;
                    if (log.isTraceEnabled()) {
                        this.logInvasionHierarchy(child.getParentRef(), child.getChildRef(), this.nodeService, log);
                    }
                    NodeRef childNodeRef = child.getChildRef();
                    Path actualChildPath = this.nodeService.getPath(childNodeRef);
                    if (expectedChildNodeRefs.contains(childNodeRef) || expectedChildNodePaths.contains(actualChildPath)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"This child IS NOT EXPECTED!");
                    }
                    if (!this.nodeService.hasAspect(childNodeRef, TransferModel.ASPECT_TRANSFERRED)) continue;
                    log.debug((Object)("an unexpected transferred child node:" + child));
                    this.logComment("Transfer sync mode - checking unexpected child node:" + child);
                    String fromRepositoryId = (String)((Object)this.nodeService.getProperty(childNodeRef, TransferModel.PROP_FROM_REPOSITORY_ID));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("'manifestRepositoryId': " + this.manifestRepositoryId));
                    }
                    if (fromRepositoryId != null && this.manifestRepositoryId != null) {
                        String initialRepositoryId;
                        if (this.nodeService.hasAspect(childNodeRef, TransferModel.ASPECT_ALIEN)) {
                            log.debug((Object)("node to be deleted contains alien content so needs to be pruned." + childNodeRef));
                            this.logComment("Transfer sync mode - node contains alien content so can't be deleted. " + childNodeRef);
                            this.alienProcessor.pruneNode(childNodeRef, this.manifestRepositoryId);
                            continue;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Node not alien. Trying to delete the node...");
                        }
                        if (this.manifestRepositoryId.equalsIgnoreCase(initialRepositoryId = (String)((Object)this.nodeService.getProperty(childNodeRef, TransferModel.PROP_FROM_REPOSITORY_ID)))) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Replication is initiated from the same repository from which this node was transferred! Deleting");
                            }
                            this.logDeleted(node.getNodeRef(), childNodeRef, this.nodeService.getPath(childNodeRef).toString());
                            this.logSummaryDeleted(node.getNodeRef(), childNodeRef, this.nodeService.getPath(childNodeRef).toString());
                            this.nodeService.deleteNode(childNodeRef);
                            continue;
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)"It is not an alien, but 'fromRepositoryId' is not equal to the 'manifestRepositoryId'! Cannot delete the foreign node...");
                        continue;
                    }
                    log.debug((Object)"node does not have a transferred aspect");
                }
            } else {
                log.debug((Object)"not sync mode - do nothing");
            }
        }
    }

    @Override
    protected void processHeader(TransferManifestHeader header) {
        this.isSync = header.isSync();
        log.debug((Object)("isSync :" + this.isSync));
        this.manifestRepositoryId = header.getRepositoryId();
        log.debug((Object)("fromRepositoryId:" + this.manifestRepositoryId));
    }

    @Override
    protected void startManifest() {
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setAlienProcessor(AlienProcessor alienProcessor) {
        this.alienProcessor = alienProcessor;
    }

    public AlienProcessor getAlienProcessor() {
        return this.alienProcessor;
    }

    public void setNodeResolver(CorrespondingNodeResolver nodeResolver) {
        this.nodeResolver = nodeResolver;
    }
}

