/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl.acegi;

import java.util.Iterator;
import net.sf.acegisecurity.ConfigAttributeDefinition;
import net.sf.acegisecurity.vote.AccessDecisionVoter;
import net.sf.acegisecurity.vote.AffirmativeBased;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.security.AccessStatus;

public class AffirmativeBasedAccessDecisionManger
extends AffirmativeBased {
    public AccessStatus pre(Object object, ConfigAttributeDefinition attr) {
        Iterator iter = this.getDecisionVoters().iterator();
        int deny = 0;
        while (iter.hasNext()) {
            AccessDecisionVoter voter = (AccessDecisionVoter)iter.next();
            int result = voter.vote(AuthenticationUtil.getFullAuthentication(), object, attr);
            switch (result) {
                case 1: {
                    return AccessStatus.ALLOWED;
                }
                case -1: {
                    ++deny;
                    break;
                }
            }
        }
        if (deny > 0) {
            return AccessStatus.DENIED;
        }
        if (this.isAllowIfAllAbstainDecisions()) {
            return AccessStatus.ALLOWED;
        }
        return AccessStatus.DENIED;
    }
}

