/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities.feed;

import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.activities.feed.EmailUserNotifier;
import org.alfresco.repo.activities.feed.FeedGenerator;
import org.alfresco.repo.activities.feed.FeedNotifierImpl;
import org.alfresco.repo.activities.feed.FeedNotifierJob;
import org.alfresco.repo.activities.feed.UserNotifier;
import org.alfresco.repo.activities.post.lookup.PostLookup;
import org.alfresco.repo.domain.activities.ActivityPostDAO;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.admin.RepoAdminService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.EmailHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.context.ApplicationContext;

@RunWith(value=MockitoJUnitRunner.class)
public class FeedNotifierJobTest {
    private static ApplicationContext ctx = null;
    private FeedNotifierJob feedNotifierJob;
    @Mock
    private JobExecutionContext jobCtx;
    private TenantAdminService tenantAdminService;
    private TransactionService transactionService;
    private FeedNotifierImpl feedNotifier;
    private JobDetail jobDetail;
    private ActivityService activityService;
    private PersonService personService;
    private FeedGenerator feedGenerator;
    private PostLookup postLookup;
    private ActivityPostDAO postDAO;
    private RegisterErrorUserFeedNotifier userNotifier;
    private NodeService nodeService;
    private NamespaceService namespaceService;
    private SiteService siteService;
    private RepoAdminService repoAdminService;
    private ActionService actionService;
    private AuthenticationContext authenticationContext;
    private NodeRef failingPersonNodeRef;
    private NodeRef personNodeRef;
    private String userName1 = "user1." + GUID.generate();
    private String userName2 = "user2." + GUID.generate();

    @BeforeClass
    public static void init() {
        ApplicationContextHelper.setUseLazyLoading((boolean)false);
        ApplicationContextHelper.setNoAutoStart((boolean)true);
        ctx = ApplicationContextHelper.getApplicationContext();
    }

    @Before
    public void setUp() throws Exception {
        ChildApplicationContextFactory activitiesFeed = (ChildApplicationContextFactory)ctx.getBean("ActivitiesFeed");
        ApplicationContext activitiesFeedCtx = activitiesFeed.getApplicationContext();
        this.feedNotifier = (FeedNotifierImpl)activitiesFeedCtx.getBean("feedNotifier");
        this.activityService = (ActivityService)activitiesFeedCtx.getBean("activityService");
        this.feedGenerator = (FeedGenerator)activitiesFeedCtx.getBean("feedGenerator");
        this.postLookup = (PostLookup)activitiesFeedCtx.getBean("postLookup");
        ObjectFactory feedModelBuilderFactory = (ObjectFactory)activitiesFeedCtx.getBean("feedModelBuilderFactory");
        EmailUserNotifier emailUserNotifier = (EmailUserNotifier)activitiesFeedCtx.getBean("emailUserNotifier");
        this.tenantAdminService = (TenantAdminService)ctx.getBean("tenantAdminService");
        this.transactionService = (TransactionService)ctx.getBean("transactionService");
        this.personService = (PersonService)ctx.getBean("personService");
        this.postDAO = (ActivityPostDAO)ctx.getBean("postDAO");
        this.nodeService = (NodeService)ctx.getBean("nodeService");
        this.namespaceService = (NamespaceService)ctx.getBean("namespaceService");
        this.siteService = (SiteService)ctx.getBean("siteService");
        this.repoAdminService = (RepoAdminService)ctx.getBean("repoAdminService");
        this.actionService = (ActionService)ctx.getBean("ActionService");
        this.authenticationContext = (AuthenticationContext)ctx.getBean("authenticationContext");
        EmailHelper emailHelper = (EmailHelper)ctx.getBean("emailHelper");
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                FeedNotifierJobTest.this.personNodeRef = FeedNotifierJobTest.this.createUser(FeedNotifierJobTest.this.userName1);
                FeedNotifierJobTest.this.failingPersonNodeRef = FeedNotifierJobTest.this.createUser(FeedNotifierJobTest.this.userName2);
                return null;
            }
        }, false, true);
        this.userNotifier = new RegisterErrorUserFeedNotifier();
        this.userNotifier.setNodeService(this.nodeService);
        this.userNotifier.setNamespaceService(this.namespaceService);
        this.userNotifier.setSiteService(this.siteService);
        this.userNotifier.setActivityService(this.activityService);
        this.userNotifier.setRepoAdminService(this.repoAdminService);
        this.userNotifier.setActionService(this.actionService);
        this.userNotifier.setActivitiesFeedModelBuilderFactory(feedModelBuilderFactory);
        this.userNotifier.setAuthenticationContext(this.authenticationContext);
        this.userNotifier.setExcludedEmailSuffixes(emailUserNotifier.getExcludedEmailSuffixes());
        this.userNotifier.setEmailHelper(emailHelper);
        this.feedNotifier.setUserNotifier((UserNotifier)this.userNotifier);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("tenantAdminService", (Object)this.tenantAdminService);
        jobDataMap.put("feedNotifier", (Object)this.feedNotifier);
        this.jobDetail = JobBuilder.newJob().withIdentity("feedNotifier").ofType(FeedNotifierJob.class).setJobData(jobDataMap).build();
        this.feedNotifierJob = new FeedNotifierJob();
        Mockito.when((Object)this.jobCtx.getJobDetail()).thenReturn((Object)this.jobDetail);
    }

    private NodeRef createUser(String userName) {
        PropertyMap personProps = new PropertyMap();
        personProps.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
        personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)userName);
        personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)userName);
        personProps.put((Object)ContentModel.PROP_EMAIL, (Object)(String.valueOf(userName) + "@email.com"));
        return this.personService.createPerson((Map)personProps);
    }

    private void generateActivities() throws Exception {
        this.postLookup.execute();
        Long maxSequence = this.postDAO.getMaxActivitySeq();
        while (maxSequence != null) {
            this.feedGenerator.execute();
            maxSequence = this.postDAO.getMaxActivitySeq();
        }
    }

    @After
    public void cleanUp() {
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                FeedNotifierJobTest.this.personService.deletePerson(FeedNotifierJobTest.this.failingPersonNodeRef);
                FeedNotifierJobTest.this.personService.deletePerson(FeedNotifierJobTest.this.personNodeRef);
                return null;
            }
        }, false, true);
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    @Test
    public void testAuthentication() throws Exception {
        final String siteId = null;
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.pushAuthentication();
                AuthenticationUtil.setFullyAuthenticatedUser((String)FeedNotifierJobTest.this.userName1);
                FeedNotifierJobTest.this.activityService.postActivity("org.alfresco.profile.status-changed", siteId, "profile", "{\"status\":\"test\"}");
                AuthenticationUtil.popAuthentication();
                return null;
            }
        }, false, true);
        this.generateActivities();
        AuthenticationUtil.setFullyAuthenticatedUser((String)this.userName2);
        this.feedNotifierJob.execute(this.jobCtx);
        Assert.assertNull((String)("The notification failed with error " + this.userNotifier.getError()), (Object)this.userNotifier.getError());
    }

    private class RegisterErrorUserFeedNotifier
    extends EmailUserNotifier {
        private Exception error = null;

        private RegisterErrorUserFeedNotifier() {
        }

        public Exception getError() {
            return this.error;
        }

        public Pair<Integer, Long> notifyUser(NodeRef personNodeRef, String subject, Object[] subjectParams, Map<String, String> siteNames, String shareUrl, int repeatIntervalMins, String templateNodeRef) {
            try {
                return super.notifyUser(personNodeRef, subject, subjectParams, siteNames, shareUrl, repeatIntervalMins, templateNodeRef);
            }
            catch (AccessDeniedException e) {
                this.error = e;
                throw e;
            }
        }
    }
}

