/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2.mapper;

import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.event2.mapper.PropertyMapper;
import org.alfresco.repo.event2.shared.QNameMatcher;
import org.alfresco.repo.transfer.TransferModel;
import org.alfresco.service.namespace.QName;

public class ReplaceSensitivePropertyWithTextMapper
implements PropertyMapper {
    private static final Set<QName> DEFAULT_SENSITIVE_PROPERTIES = Set.of(ContentModel.PROP_PASSWORD, ContentModel.PROP_SALT, ContentModel.PROP_PASSWORD_HASH, TransferModel.PROP_PASSWORD);
    private static final String DEFAULT_REPLACEMENT_TEXT = "SENSITIVE_DATA_REMOVED";
    private final QNameMatcher qNameMatcher;
    private final String replacementText;

    public ReplaceSensitivePropertyWithTextMapper(Set<QName> userConfiguredSensitiveProperties, String userConfiguredReplacementText) {
        Set<QName> sensitiveProperties = Optional.ofNullable(userConfiguredSensitiveProperties).filter(Predicate.not(Collection::isEmpty)).orElse(DEFAULT_SENSITIVE_PROPERTIES);
        this.qNameMatcher = new QNameMatcher(sensitiveProperties);
        this.replacementText = Optional.ofNullable(userConfiguredReplacementText).filter(Predicate.not(String::isEmpty)).filter(userInput -> !userInput.contains("${")).orElse(DEFAULT_REPLACEMENT_TEXT);
    }

    @Override
    public Serializable map(QName propertyQName, Serializable value) {
        if (this.qNameMatcher.isMatching(propertyQName)) {
            return this.replacementText;
        }
        return value;
    }
}

