/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.registry;

import java.io.Serializable;
import java.util.Collection;
import junit.framework.TestCase;
import org.alfresco.repo.admin.registry.RegistryKey;
import org.alfresco.repo.admin.registry.RegistryService;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class})
public class RegistryServiceImplTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private AuthenticationComponent authenticationComponent;
    private RegistryService registryService;
    private static final Long VALUE_ONE = 1L;
    private static final Long VALUE_TWO = 2L;
    private static final Long VALUE_THREE = 3L;
    private static final RegistryKey KEY_A = new RegistryKey(null, new String[]{"a", null});
    private static final RegistryKey KEY_A_B = new RegistryKey(null, new String[]{"a", "b", null});
    private static final RegistryKey KEY_A_B_0 = new RegistryKey(null, new String[]{"a", "b", "0"});
    private static final RegistryKey KEY_A_B_1 = new RegistryKey(null, new String[]{"a", "b", "1"});
    private static final RegistryKey KEY_A_B_C = new RegistryKey(null, new String[]{"a", "b", "c", null});
    private static final RegistryKey KEY_A_B_C_0 = new RegistryKey(null, new String[]{"a", "b", "c", "0"});
    private static final RegistryKey KEY_A_B_C_1 = new RegistryKey(null, new String[]{"a", "b", "c", "1"});
    private static final RegistryKey KEY_A_B_C_2 = new RegistryKey(null, new String[]{"a", "b", "c", "2"});
    private static final RegistryKey KEY_A_B_C_3 = new RegistryKey(null, new String[]{"a", "b", "c", "3"});
    private static final RegistryKey KEY_A_B_C_D_0 = new RegistryKey(null, new String[]{"a", "b", "c", "d", "0"});
    private static final RegistryKey KEY_A_B_C_D_1 = new RegistryKey(null, new String[]{"a", "b", "c", "d", "1"});
    private static final RegistryKey KEY_A_B_C_D_2 = new RegistryKey(null, new String[]{"a", "b", "c", "d", "2"});
    private static final RegistryKey KEY_A_B_C_D_3 = new RegistryKey(null, new String[]{"a", "b", "c", "d", "3"});
    private static final RegistryKey KEY_X_Y_Z = new RegistryKey(null, new String[]{"x", "y", "z", null});
    private static final RegistryKey KEY_X_Y_Z_0 = new RegistryKey(null, new String[]{"x", "y", "z", "0"});
    private static final RegistryKey KEY_X_Y_Z_1 = new RegistryKey(null, new String[]{"x", "y", "z", "1"});
    private static final RegistryKey KEY_X_Y_Z_2 = new RegistryKey(null, new String[]{"x", "y", "z", "2"});
    private static final RegistryKey KEY_X_Y_Z_D_1 = new RegistryKey(null, new String[]{"x", "y", "z", "d", "1"});
    private static final RegistryKey KEY_X_Y_Z_D_2 = new RegistryKey(null, new String[]{"x", "y", "z", "d", "2"});
    private static final RegistryKey KEY_SPECIAL = new RegistryKey(null, new String[]{"me & you", "whatever"});
    private static final RegistryKey KEY_DOES_NOT_EXIST = new RegistryKey(null, new String[]{"does", "not", "exist"});

    protected void setUp() throws Exception {
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("AuthenticationComponent");
        this.registryService = (RegistryService)ctx.getBean("RegistryService");
        this.authenticationComponent.setSystemUserAsCurrentUser();
    }

    protected void tearDown() throws Exception {
        try {
            this.authenticationComponent.clearCurrentSecurityContext();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void testSetup() throws Exception {
    }

    public void testProperUsage() throws Exception {
        this.registryService.addProperty(KEY_A_B_C_1, (Serializable)VALUE_ONE);
        this.registryService.addProperty(KEY_A_B_C_2, (Serializable)VALUE_TWO);
        this.registryService.addProperty(KEY_A_B_C_3, (Serializable)VALUE_THREE);
        this.registryService.addProperty(KEY_A_B_C_D_1, (Serializable)VALUE_ONE);
        this.registryService.addProperty(KEY_A_B_C_D_2, (Serializable)VALUE_TWO);
        this.registryService.addProperty(KEY_A_B_C_D_3, (Serializable)VALUE_THREE);
        RegistryServiceImplTest.assertEquals((String)"Incorrect value from service registry", (Object)VALUE_ONE, (Object)this.registryService.getProperty(KEY_A_B_C_1));
        RegistryServiceImplTest.assertEquals((String)"Incorrect value from service registry", (Object)VALUE_TWO, (Object)this.registryService.getProperty(KEY_A_B_C_2));
        RegistryServiceImplTest.assertEquals((String)"Incorrect value from service registry", (Object)VALUE_THREE, (Object)this.registryService.getProperty(KEY_A_B_C_3));
        RegistryServiceImplTest.assertEquals((String)"Incorrect value from service registry", (Object)VALUE_ONE, (Object)this.registryService.getProperty(KEY_A_B_C_D_1));
        RegistryServiceImplTest.assertEquals((String)"Incorrect value from service registry", (Object)VALUE_TWO, (Object)this.registryService.getProperty(KEY_A_B_C_D_2));
        RegistryServiceImplTest.assertEquals((String)"Incorrect value from service registry", (Object)VALUE_THREE, (Object)this.registryService.getProperty(KEY_A_B_C_D_3));
        RegistryServiceImplTest.assertNull((String)"Missing key should return null value", (Object)this.registryService.getProperty(KEY_A_B_C_0));
        RegistryServiceImplTest.assertNull((String)"Missing key should return null value", (Object)this.registryService.getProperty(KEY_A_B_C_D_0));
        RegistryServiceImplTest.assertNull((String)"Missing key should return null value", (Object)this.registryService.getProperty(KEY_DOES_NOT_EXIST));
    }

    public void testGetElements() throws Exception {
        this.registryService.addProperty(KEY_A_B_C_1, (Serializable)VALUE_ONE);
        this.registryService.addProperty(KEY_A_B_C_2, (Serializable)VALUE_TWO);
        RegistryServiceImplTest.assertEquals((String)"Excpected empty collection for random query", (int)0, (int)this.registryService.getChildElements(KEY_DOES_NOT_EXIST).size());
        RegistryServiceImplTest.assertEquals((String)"Incorrect number ofchild elements", (int)1, (int)this.registryService.getChildElements(KEY_A_B_0).size());
        RegistryServiceImplTest.assertEquals((String)"Incorrect number ofchild elements", (int)1, (int)this.registryService.getChildElements(KEY_A_B_1).size());
        Collection childElements = this.registryService.getChildElements(KEY_A_B_0);
        RegistryServiceImplTest.assertTrue((String)"Incorrect child elements retrieved", (boolean)childElements.contains("c"));
    }

    public void testSpecialCharacters() {
        this.registryService.addProperty(KEY_SPECIAL, (Serializable)VALUE_THREE);
        RegistryServiceImplTest.assertEquals((String)"Incorrect value for special key", (Object)VALUE_THREE, (Object)this.registryService.getProperty(KEY_SPECIAL));
    }

    public void testDelete() {
        this.registryService.addProperty(KEY_A_B_C_1, (Serializable)VALUE_ONE);
        this.registryService.addProperty(KEY_A_B_C_2, (Serializable)VALUE_TWO);
        RegistryServiceImplTest.assertEquals((String)"Incorrect value from service registry", (Object)VALUE_ONE, (Object)this.registryService.getProperty(KEY_A_B_C_1));
        RegistryServiceImplTest.assertEquals((String)"Incorrect value from service registry", (Object)VALUE_TWO, (Object)this.registryService.getProperty(KEY_A_B_C_2));
        this.registryService.delete(KEY_A_B_C_1);
        RegistryServiceImplTest.assertNull((String)"Expected deleted value to be null", (Object)this.registryService.getProperty(KEY_A_B_C_1));
        this.registryService.delete(KEY_A_B);
        RegistryServiceImplTest.assertNull((String)"Expected deleted value to be null", (Object)this.registryService.getProperty(KEY_A_B_C_1));
        RegistryServiceImplTest.assertNull((String)"Expected deleted value to be null", (Object)this.registryService.getProperty(KEY_A_B_C_2));
        Collection childElements = this.registryService.getChildElements(KEY_A);
        RegistryServiceImplTest.assertEquals((String)"There should be no more elements within A", (int)0, (int)childElements.size());
    }

    public void testCopy() {
        this.registryService.addProperty(KEY_A_B_C_1, (Serializable)VALUE_ONE);
        this.registryService.addProperty(KEY_A_B_C_2, (Serializable)VALUE_TWO);
        this.registryService.addProperty(KEY_A_B_C_D_1, (Serializable)VALUE_ONE);
        this.registryService.addProperty(KEY_A_B_C_D_2, (Serializable)VALUE_TWO);
        try {
            this.registryService.copy(KEY_A_B_C_1, KEY_X_Y_Z);
            RegistryServiceImplTest.fail((String)"Failed to detect copy from property to path");
        }
        catch (Throwable throwable) {}
        try {
            this.registryService.copy(KEY_A_B_C, KEY_X_Y_Z_0);
            RegistryServiceImplTest.fail((String)"Failed to detect copy from path to property");
        }
        catch (Throwable throwable) {}
        this.registryService.copy(KEY_A_B_C_1, KEY_X_Y_Z_0);
        RegistryServiceImplTest.assertEquals((String)"Incorrect value after property copy", (Object)VALUE_ONE, (Object)this.registryService.getProperty(KEY_X_Y_Z_0));
        this.registryService.copy(KEY_A_B_C, KEY_X_Y_Z);
        RegistryServiceImplTest.assertEquals((String)"Value not recursively copied during path copy", (Object)VALUE_ONE, (Object)this.registryService.getProperty(KEY_X_Y_Z_1));
        RegistryServiceImplTest.assertEquals((String)"Value not recursively copied during path copy", (Object)VALUE_TWO, (Object)this.registryService.getProperty(KEY_X_Y_Z_2));
        RegistryServiceImplTest.assertEquals((String)"Path not recursively copied during path copy", (Object)VALUE_ONE, (Object)this.registryService.getProperty(KEY_X_Y_Z_D_1));
        RegistryServiceImplTest.assertEquals((String)"Path not recursively copied during path copy", (Object)VALUE_TWO, (Object)this.registryService.getProperty(KEY_X_Y_Z_D_2));
    }
}

