/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.site;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.alfresco.query.AbstractCannedQuery;
import org.alfresco.query.CannedQueryParameters;
import org.alfresco.query.CannedQuerySortDetails;
import org.alfresco.repo.site.SiteGroupMembership;
import org.alfresco.repo.site.SiteMembersCannedQueryParams;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.util.Pair;

public class SiteGroupCannedQuery
extends AbstractCannedQuery<SiteGroupMembership> {
    private AuthorityService authorityService;
    private SiteService siteService;

    protected SiteGroupCannedQuery(SiteService siteService, AuthorityService authorityService, CannedQueryParameters parameters) {
        super(parameters);
        this.authorityService = authorityService;
        this.siteService = siteService;
    }

    protected List<SiteGroupMembership> queryAndFilter(CannedQueryParameters parameters) {
        SiteMembersCannedQueryParams paramBean = (SiteMembersCannedQueryParams)parameters.getParameterBean();
        String siteShortName = paramBean.getShortName();
        CannedQuerySortDetails sortDetails = parameters.getSortDetails();
        CQSiteGroupsCallback callback = new CQSiteGroupsCallback(siteShortName, sortDetails.getSortPairs());
        this.siteService.listMembers(siteShortName, null, null, false, true, paramBean.isExpandGroups(), callback);
        callback.done();
        return callback.getSiteMembers();
    }

    protected boolean isApplyPostQuerySorting() {
        return false;
    }

    private class CQSiteGroupsCallback
    implements SiteService.SiteMembersCallback {
        private SiteInfo siteInfo;
        private Set<SiteGroupMembership> siteGroups;

        CQSiteGroupsCallback(String siteShortName, List<Pair<? extends Object, CannedQuerySortDetails.SortOrder>> sortPairs) {
            this.siteInfo = SiteGroupCannedQuery.this.siteService.getSite(siteShortName);
            this.siteGroups = sortPairs != null && sortPairs.size() > 0 ? new TreeSet<SiteGroupMembership>(SiteGroupMembership.getComparator(sortPairs)) : new HashSet<SiteGroupMembership>();
        }

        @Override
        public void siteMember(String authority, String role) {
            if (SiteGroupCannedQuery.this.authorityService.authorityExists(authority)) {
                String displayName = SiteGroupCannedQuery.this.authorityService.getAuthorityDisplayName(authority);
                this.siteGroups.add(new SiteGroupMembership(this.siteInfo, authority, role, displayName));
            }
        }

        @Override
        public boolean isDone() {
            return false;
        }

        List<SiteGroupMembership> getSiteMembers() {
            return new ArrayList<SiteGroupMembership>(this.siteGroups);
        }

        void done() {
        }
    }
}

