/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.admin.BaseInterpreter;
import org.alfresco.repo.admin.RepoModelDefinition;
import org.alfresco.service.cmr.admin.RepoAdminService;
import org.alfresco.service.namespace.QName;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.extensions.surf.util.I18NUtil;

public class RepoAdminInterpreter
extends BaseInterpreter {
    private RepoAdminService repoAdminService;

    public void setRepoAdminService(RepoAdminService repoAdminService) {
        this.repoAdminService = repoAdminService;
    }

    public static void main(String[] args) {
        RepoAdminInterpreter.runMain("repoAdminInterpreter");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected String executeCommand(String line) throws IOException {
        String bundleBaseName;
        String modelFileName;
        ClassPathResource file;
        String[] command = line.split(" ");
        if (command.length == 0) {
            command = new String[]{line};
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bout);
        if (command[0].equals("r")) {
            if (this.lastCommand != null) return "repeating command " + this.lastCommand + "\n\n" + this.executeCommand(this.lastCommand);
            return "No command entered yet.";
        }
        this.lastCommand = line;
        if (command[0].equals("help")) {
            String helpFile = I18NUtil.getMessage((String)"repoadmin_console.help");
            ClassPathResource helpResource = new ClassPathResource(helpFile);
            byte[] helpBytes = new byte[500];
            try (InputStream helpStream = helpResource.getInputStream();){
                int read = helpStream.read(helpBytes);
                while (read != -1) {
                    bout.write(helpBytes, 0, read);
                    read = helpStream.read(helpBytes);
                }
            }
        } else if (command[0].equals("show")) {
            if (command.length < 2) {
                return "Syntax Error.\n";
            }
            if (command[1].equals("file")) {
                if (command.length != 3) {
                    return "Syntax Error.\n";
                }
                file = new ClassPathResource(command[2]);
                InputStream fileStream = file.getInputStream();
                if (fileStream != null) {
                    byte[] fileBytes = new byte[500];
                    try {
                        int read = fileStream.read(fileBytes);
                        while (read != -1) {
                            bout.write(fileBytes, 0, read);
                            read = fileStream.read(fileBytes);
                        }
                    }
                    finally {
                        fileStream.close();
                    }
                } else {
                    out.println("No matching file found: " + command[2]);
                }
                out.println();
            } else if (command[1].equals("file-list")) {
                if (command.length != 3) {
                    return "Syntax Error.\n";
                }
                String pattern = "classpath*:" + command[2];
                PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
                Resource[] resources = resolver.getResources(pattern);
                ArrayList<String> names = new ArrayList<String>();
                if (resources != null) {
                    int i = 0;
                    while (i < resources.length) {
                        String filename = resources[i].getFilename();
                        if (!names.contains(filename)) {
                            out.println("resource: " + filename + ", url: " + resources[i].getURL());
                            names.add(filename);
                        }
                        ++i;
                    }
                } else {
                    out.println("No matching files found: " + command[2]);
                }
            } else if (command[1].equals("models")) {
                List<RepoModelDefinition> models = this.repoAdminService.getModels();
                if (models != null && models.size() > 0) {
                    for (RepoModelDefinition model : models) {
                        out.println(model.toString());
                    }
                } else {
                    out.println("No additional models have been deployed to the Alfresco Repository");
                }
            } else {
                if (!command[1].equals("messages")) return "No such sub-command, try 'help'.\n";
                List<String> messageResources = this.repoAdminService.getMessageBundles();
                if (messageResources != null && messageResources.size() > 0) {
                    for (String messageResourceName : messageResources) {
                        out.println("message resource bundle: " + messageResourceName);
                    }
                } else {
                    out.println("No additional messages resource bundles have been deployed to the Alfresco Repository");
                }
            }
        } else if (command[0].equals("deploy")) {
            if (command.length != 3) {
                return "Syntax Error.\n";
            }
            if (command[1].equals("model")) {
                file = new ClassPathResource(command[2]);
                InputStream fileStream = file.getInputStream();
                String modelFileName2 = file.getFilename();
                this.repoAdminService.deployModel(fileStream, modelFileName2);
                out.println("Model deployed: " + modelFileName2);
            } else {
                if (!command[1].equals("messages")) return "No such sub-command, try 'help'.\n";
                String bundleBasePath = command[2];
                String bundleBaseName2 = this.repoAdminService.deployMessageBundle(bundleBasePath);
                out.println("Message resource bundle deployed: " + bundleBaseName2);
            }
        } else if (command[0].equals("activate")) {
            if (command.length != 3) {
                return "Syntax Error.\n";
            }
            if (command[1].equals("model")) {
                modelFileName = command[2];
                QName modelQName = this.repoAdminService.activateModel(modelFileName);
                out.println("Model activated: " + modelFileName + " [" + modelQName + "]");
            }
        } else if (command[0].equals("deactivate")) {
            if (command.length != 3) {
                return "Syntax Error.\n";
            }
            if (command[1].equals("model")) {
                modelFileName = command[2];
                QName modelQName = this.repoAdminService.deactivateModel(modelFileName);
                out.println("Model deactivated: " + modelFileName + " [" + modelQName + "]");
            }
        } else if (command[0].equals("reload")) {
            if (command.length != 3) {
                return "Syntax Error.\n";
            }
            if (!command[1].equals("messages")) return "No such sub-command, try 'help'.\n";
            bundleBaseName = command[2];
            this.repoAdminService.reloadMessageBundle(bundleBaseName);
            out.println("Message resource bundle reloaded: " + bundleBaseName);
        } else {
            if (!command[0].equals("undeploy")) return "No such command, try 'help'.\n";
            if (command.length != 3) {
                return "Syntax Error.\n";
            }
            if (command[1].equals("model")) {
                modelFileName = command[2];
                QName modelQName = this.repoAdminService.undeployModel(modelFileName);
                out.println("Model undeployed: " + modelFileName + " [" + modelQName + "]");
                out.println("");
                out.println("Remaining models:");
                out.print(this.executeCommand("show models"));
            } else {
                if (!command[1].equals("messages")) return "No such sub-command, try 'help'.\n";
                bundleBaseName = command[2];
                this.repoAdminService.undeployMessageBundle(bundleBaseName);
                out.println("Message resource bundle undeployed: " + bundleBaseName);
                out.println("");
                out.println("Remaining message resource bundles:");
                out.print(this.executeCommand("show messages"));
            }
        }
        out.flush();
        String retVal = new String(bout.toByteArray());
        out.close();
        return retVal;
    }
}

