/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.jscript.ScriptAction;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionDefinition;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.ParameterConstraint;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.ScriptLocation;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.util.UrlUtil;

public class ScriptActionExecuter
extends ActionExecuterAbstractBase {
    public static final String NAME = "script";
    public static final String PARAM_SCRIPTREF = "script-ref";
    private ServiceRegistry serviceRegistry;
    private SysAdminParams sysAdminParams;
    private PersonService personService;
    private String companyHomePath;
    private StoreRef storeRef;
    private ScriptLocation scriptLocation;

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setSysAdminParams(SysAdminParams sysAdminParams) {
        this.sysAdminParams = sysAdminParams;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setStoreUrl(String storeUrl) {
        this.storeRef = new StoreRef(storeUrl);
    }

    public void setCompanyHomePath(String companyHomePath) {
        this.companyHomePath = companyHomePath;
    }

    public void setScriptLocation(ScriptLocation scriptLocation) {
        this.scriptLocation = scriptLocation;
    }

    @Override
    protected boolean getAdhocPropertiesAllowed() {
        return true;
    }

    @Override
    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        NodeService nodeService = this.serviceRegistry.getNodeService();
        if (nodeService.exists(actionedUponNodeRef)) {
            NodeRef scriptRef = (NodeRef)action.getParameterValue(PARAM_SCRIPTREF);
            if (!this.isValidScriptRef(action)) {
                throw new IllegalStateException("Invalid script ref path: " + scriptRef);
            }
            NodeRef spaceRef = this.serviceRegistry.getRuleService().getOwningNodeRef(action);
            if (spaceRef == null) {
                spaceRef = this.serviceRegistry.getDictionaryService().isSubClass(nodeService.getType(actionedUponNodeRef), ContentModel.TYPE_FOLDER) ? actionedUponNodeRef : nodeService.getPrimaryParent(actionedUponNodeRef).getParentRef();
            }
            if (this.scriptLocation != null || scriptRef != null && nodeService.exists(scriptRef)) {
                String userName = this.serviceRegistry.getAuthenticationService().getCurrentUserName();
                NodeRef personRef = this.personService.getPerson(userName);
                NodeRef homeSpaceRef = (NodeRef)nodeService.getProperty(personRef, ContentModel.PROP_HOMEFOLDER);
                Map<String, Object> model = this.serviceRegistry.getScriptService().buildDefaultModel(personRef, this.getCompanyHome(), homeSpaceRef, scriptRef, actionedUponNodeRef, spaceRef);
                ScriptAction scriptAction = new ScriptAction(this.serviceRegistry, action, this.actionDefinition);
                model.put("action", scriptAction);
                model.put("webApplicationContextUrl", UrlUtil.getAlfrescoUrl(this.sysAdminParams));
                Object result = null;
                result = this.scriptLocation == null ? this.serviceRegistry.getScriptService().executeScript(scriptRef, ContentModel.PROP_CONTENT, model) : this.serviceRegistry.getScriptService().executeScript(this.scriptLocation, model);
                if (result != null) {
                    action.setParameterValue("result", (Serializable)result);
                }
            }
        }
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        if (this.scriptLocation == null) {
            paramList.add(new ParameterDefinitionImpl(PARAM_SCRIPTREF, DataTypeDefinition.NODE_REF, true, this.getParamDisplayLabel(PARAM_SCRIPTREF), false, "ac-scripts"));
        }
    }

    private NodeRef getCompanyHome() {
        List refs = this.serviceRegistry.getSearchService().selectNodes(this.serviceRegistry.getNodeService().getRootNode(this.storeRef), this.companyHomePath, null, (NamespacePrefixResolver)this.serviceRegistry.getNamespaceService(), false);
        if (refs.size() != 1) {
            throw new IllegalStateException("Invalid company home path: " + this.companyHomePath + " - found: " + refs.size());
        }
        NodeRef companyHomeRef = (NodeRef)refs.get(0);
        return companyHomeRef;
    }

    private boolean isValidScriptRef(Action action) {
        String paramConstraintName;
        NodeRef scriptRef = (NodeRef)action.getParameterValue(PARAM_SCRIPTREF);
        ActionService actionService = this.serviceRegistry.getActionService();
        ActionDefinition actDef = actionService.getActionDefinition(action.getActionDefinitionName());
        ParameterDefinition parameterDef = actDef.getParameterDefintion(PARAM_SCRIPTREF);
        if (parameterDef != null && (paramConstraintName = parameterDef.getParameterConstraintName()) != null) {
            ParameterConstraint paramConstraint = actionService.getParameterConstraint(paramConstraintName);
            return paramConstraint.isValidValue(scriptRef.toString());
        }
        return true;
    }
}

