/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice;

import java.util.Map;
import java.util.Optional;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceConfig;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceFacade;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceJITProvisioningHandler;
import org.alfresco.repo.security.authentication.identityservice.OIDCUserInfo;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.transaction.TransactionService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class IdentityServiceJITProvisioningHandlerUnitTest {
    @Mock
    private IdentityServiceFacade identityServiceFacade;
    @Mock
    private PersonService personService;
    @Mock
    private IdentityServiceFacade.DecodedAccessToken decodedAccessToken;
    @Mock
    private TransactionService transactionService;
    @Mock
    private IdentityServiceConfig identityServiceConfig;
    @Mock
    private OIDCUserInfo userInfo;
    private IdentityServiceJITProvisioningHandler jitProvisioningHandler;
    private static final String JWT_TOKEN = "myToken";

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.transactionService.isReadOnly()).thenReturn((Object)false);
        Mockito.when((Object)this.identityServiceFacade.decodeToken(JWT_TOKEN)).thenReturn((Object)this.decodedAccessToken);
        Mockito.when((Object)this.personService.createMissingPeople()).thenReturn((Object)true);
        this.jitProvisioningHandler = new IdentityServiceJITProvisioningHandler(this.identityServiceFacade, this.personService, this.transactionService, this.identityServiceConfig);
    }

    @Test
    public void shouldExtractUserInfoForExistingUser() {
        Mockito.when((Object)this.personService.personExists("johny123")).thenReturn((Object)true);
        Mockito.when((Object)this.decodedAccessToken.getClaim("preferred_username")).thenReturn((Object)"johny123");
        Optional result = this.jitProvisioningHandler.extractUserInfoAndCreateUserIfNeeded(JWT_TOKEN);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)"johny123", (Object)((OIDCUserInfo)result.get()).username());
        Assert.assertFalse((boolean)((OIDCUserInfo)result.get()).allFieldsNotEmpty());
        ((IdentityServiceFacade)Mockito.verify((Object)this.identityServiceFacade, (VerificationMode)Mockito.never())).getUserInfo(JWT_TOKEN, "preferred_username");
    }

    @Test
    public void shouldExtractUserInfoForExistingUserWithProviderPrincipalAttribute() {
        Mockito.when((Object)this.identityServiceConfig.getPrincipalAttribute()).thenReturn((Object)"nickname");
        Mockito.when((Object)this.personService.personExists("johny123")).thenReturn((Object)true);
        Mockito.when((Object)this.decodedAccessToken.getClaim("nickname")).thenReturn((Object)"johny123");
        Optional result = this.jitProvisioningHandler.extractUserInfoAndCreateUserIfNeeded(JWT_TOKEN);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)"johny123", (Object)((OIDCUserInfo)result.get()).username());
        Assert.assertFalse((boolean)((OIDCUserInfo)result.get()).allFieldsNotEmpty());
        ((IdentityServiceFacade)Mockito.verify((Object)this.identityServiceFacade, (VerificationMode)Mockito.never())).getUserInfo(JWT_TOKEN, "nickname");
    }

    @Test
    public void shouldExtractUserInfoFromAccessTokenAndCreateUser() {
        Mockito.when((Object)this.personService.personExists("johny123")).thenReturn((Object)false);
        Mockito.when((Object)this.decodedAccessToken.getClaim("preferred_username")).thenReturn((Object)"johny123");
        Mockito.when((Object)this.decodedAccessToken.getClaim("given_name")).thenReturn((Object)"John");
        Mockito.when((Object)this.decodedAccessToken.getClaim("family_name")).thenReturn((Object)"Doe");
        Mockito.when((Object)this.decodedAccessToken.getClaim("email")).thenReturn((Object)"johny123@email.com");
        Optional result = this.jitProvisioningHandler.extractUserInfoAndCreateUserIfNeeded(JWT_TOKEN);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)"johny123", (Object)((OIDCUserInfo)result.get()).username());
        Assert.assertEquals((Object)"John", (Object)((OIDCUserInfo)result.get()).firstName());
        Assert.assertEquals((Object)"Doe", (Object)((OIDCUserInfo)result.get()).lastName());
        Assert.assertEquals((Object)"johny123@email.com", (Object)((OIDCUserInfo)result.get()).email());
        Assert.assertTrue((boolean)((OIDCUserInfo)result.get()).allFieldsNotEmpty());
        ((PersonService)Mockito.verify((Object)this.personService)).createPerson((Map)ArgumentMatchers.any());
        ((IdentityServiceFacade)Mockito.verify((Object)this.identityServiceFacade, (VerificationMode)Mockito.never())).getUserInfo(JWT_TOKEN, "preferred_username");
    }

    @Test
    public void shouldExtractUserInfoFromUserInfoEndpointAndCreateUser() {
        Mockito.when((Object)this.userInfo.username()).thenReturn((Object)"johny123");
        Mockito.when((Object)this.userInfo.firstName()).thenReturn((Object)"John");
        Mockito.when((Object)this.userInfo.lastName()).thenReturn((Object)"Doe");
        Mockito.when((Object)this.userInfo.email()).thenReturn((Object)"johny123@email.com");
        Mockito.when((Object)this.personService.personExists("johny123")).thenReturn((Object)false);
        Mockito.when((Object)this.decodedAccessToken.getClaim("preferred_username")).thenReturn((Object)"johny123");
        Mockito.when((Object)this.identityServiceFacade.getUserInfo(JWT_TOKEN, "preferred_username")).thenReturn(Optional.of(this.userInfo));
        Optional result = this.jitProvisioningHandler.extractUserInfoAndCreateUserIfNeeded(JWT_TOKEN);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)"johny123", (Object)((OIDCUserInfo)result.get()).username());
        Assert.assertEquals((Object)"John", (Object)((OIDCUserInfo)result.get()).firstName());
        Assert.assertEquals((Object)"Doe", (Object)((OIDCUserInfo)result.get()).lastName());
        Assert.assertEquals((Object)"johny123@email.com", (Object)((OIDCUserInfo)result.get()).email());
        Assert.assertTrue((boolean)((OIDCUserInfo)result.get()).allFieldsNotEmpty());
        ((PersonService)Mockito.verify((Object)this.personService)).createPerson((Map)ArgumentMatchers.any());
        ((IdentityServiceFacade)Mockito.verify((Object)this.identityServiceFacade)).getUserInfo(JWT_TOKEN, "preferred_username");
    }

    @Test
    public void shouldReturnEmptyOptionalIfUsernameNotExtracted() {
        Mockito.when((Object)this.identityServiceFacade.getUserInfo(JWT_TOKEN, "preferred_username")).thenReturn(Optional.of(this.userInfo));
        Optional result = this.jitProvisioningHandler.extractUserInfoAndCreateUserIfNeeded(JWT_TOKEN);
        Assert.assertFalse((boolean)result.isPresent());
        ((PersonService)Mockito.verify((Object)this.personService, (VerificationMode)Mockito.never())).createPerson((Map)ArgumentMatchers.any());
        ((IdentityServiceFacade)Mockito.verify((Object)this.identityServiceFacade)).getUserInfo(JWT_TOKEN, "preferred_username");
    }

    @Test
    public void shouldCallUserInfoEndpointToGetUsername() {
        Mockito.when((Object)this.personService.personExists("johny123")).thenReturn((Object)true);
        Mockito.when((Object)this.decodedAccessToken.getClaim("preferred_username")).thenReturn((Object)"");
        Mockito.when((Object)this.userInfo.username()).thenReturn((Object)"johny123");
        Mockito.when((Object)this.identityServiceFacade.getUserInfo(JWT_TOKEN, "preferred_username")).thenReturn(Optional.of(this.userInfo));
        Optional result = this.jitProvisioningHandler.extractUserInfoAndCreateUserIfNeeded(JWT_TOKEN);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)"johny123", (Object)((OIDCUserInfo)result.get()).username());
        Assert.assertEquals((Object)"", (Object)((OIDCUserInfo)result.get()).firstName());
        Assert.assertEquals((Object)"", (Object)((OIDCUserInfo)result.get()).lastName());
        Assert.assertEquals((Object)"", (Object)((OIDCUserInfo)result.get()).email());
        Assert.assertFalse((boolean)((OIDCUserInfo)result.get()).allFieldsNotEmpty());
        ((PersonService)Mockito.verify((Object)this.personService, (VerificationMode)Mockito.never())).createPerson((Map)ArgumentMatchers.any());
        ((IdentityServiceFacade)Mockito.verify((Object)this.identityServiceFacade)).getUserInfo(JWT_TOKEN, "preferred_username");
    }

    @Test
    public void shouldCallUserInfoEndpointToGetUsernameWithProvidedPrincipalAttribute() {
        Mockito.when((Object)this.identityServiceConfig.getPrincipalAttribute()).thenReturn((Object)"nickname");
        Mockito.when((Object)this.personService.personExists("johny123")).thenReturn((Object)true);
        Mockito.when((Object)this.decodedAccessToken.getClaim("nickname")).thenReturn((Object)"");
        Mockito.when((Object)this.userInfo.username()).thenReturn((Object)"johny123");
        Mockito.when((Object)this.identityServiceFacade.getUserInfo(JWT_TOKEN, "nickname")).thenReturn(Optional.of(this.userInfo));
        Optional result = this.jitProvisioningHandler.extractUserInfoAndCreateUserIfNeeded(JWT_TOKEN);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)"johny123", (Object)((OIDCUserInfo)result.get()).username());
        Assert.assertEquals((Object)"", (Object)((OIDCUserInfo)result.get()).firstName());
        Assert.assertEquals((Object)"", (Object)((OIDCUserInfo)result.get()).lastName());
        Assert.assertEquals((Object)"", (Object)((OIDCUserInfo)result.get()).email());
        Assert.assertFalse((boolean)((OIDCUserInfo)result.get()).allFieldsNotEmpty());
        ((PersonService)Mockito.verify((Object)this.personService, (VerificationMode)Mockito.never())).createPerson((Map)ArgumentMatchers.any());
        ((IdentityServiceFacade)Mockito.verify((Object)this.identityServiceFacade)).getUserInfo(JWT_TOKEN, "nickname");
    }

    @Test
    public void shouldNotCallUserInfoEndpointIfTokenIsNullOrEmpty() {
        this.jitProvisioningHandler.extractUserInfoAndCreateUserIfNeeded(null);
        this.jitProvisioningHandler.extractUserInfoAndCreateUserIfNeeded("");
        ((PersonService)Mockito.verify((Object)this.personService, (VerificationMode)Mockito.never())).createPerson((Map)ArgumentMatchers.any());
        ((IdentityServiceFacade)Mockito.verify((Object)this.identityServiceFacade, (VerificationMode)Mockito.never())).decodeToken(null);
        ((IdentityServiceFacade)Mockito.verify((Object)this.identityServiceFacade, (VerificationMode)Mockito.never())).decodeToken("");
        ((IdentityServiceFacade)Mockito.verify((Object)this.identityServiceFacade, (VerificationMode)Mockito.never())).getUserInfo(null, "preferred_username");
        ((IdentityServiceFacade)Mockito.verify((Object)this.identityServiceFacade, (VerificationMode)Mockito.never())).getUserInfo("", "preferred_username");
    }
}

