/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice;

import java.net.ConnectException;
import java.util.Optional;
import org.alfresco.error.ExceptionStackUtil;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceAuthenticationComponent;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceFacade;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceJITProvisioningHandler;
import org.alfresco.repo.security.authentication.identityservice.OIDCUserInfo;
import org.alfresco.repo.security.sync.UserRegistrySynchronizer;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.BaseSpringTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;

public class IdentityServiceAuthenticationComponentTest
extends BaseSpringTest {
    private final IdentityServiceAuthenticationComponent authComponent = new IdentityServiceAuthenticationComponent();
    @Autowired
    private AuthenticationContext authenticationContext;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UserRegistrySynchronizer userRegistrySynchronizer;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private PersonService personService;
    private IdentityServiceJITProvisioningHandler jitProvisioning;
    private IdentityServiceFacade mockIdentityServiceFacade;

    @Before
    public void setUp() {
        this.authComponent.setAuthenticationContext(this.authenticationContext);
        this.authComponent.setTransactionService(this.transactionService);
        this.authComponent.setUserRegistrySynchronizer(this.userRegistrySynchronizer);
        this.authComponent.setNodeService(this.nodeService);
        this.authComponent.setPersonService(this.personService);
        this.jitProvisioning = (IdentityServiceJITProvisioningHandler)Mockito.mock(IdentityServiceJITProvisioningHandler.class);
        this.mockIdentityServiceFacade = (IdentityServiceFacade)Mockito.mock(IdentityServiceFacade.class);
        this.authComponent.setJitProvisioningHandler(this.jitProvisioning);
        this.authComponent.setIdentityServiceFacade(this.mockIdentityServiceFacade);
    }

    @After
    public void tearDown() {
        this.authenticationContext.clearCurrentSecurityContext();
    }

    @Test(expected=AuthenticationException.class)
    public void testAuthenticationFail() {
        IdentityServiceFacade.AuthorizationGrant grant = IdentityServiceFacade.AuthorizationGrant.password((String)"username", (String)"password");
        ((IdentityServiceFacade)Mockito.doThrow((Throwable[])new Throwable[]{new IdentityServiceFacade.AuthorizationException("Failed")}).when((Object)this.mockIdentityServiceFacade)).authorize(grant);
        this.authComponent.authenticateImpl("username", "password".toCharArray());
    }

    @Test(expected=AuthenticationException.class)
    public void testAuthenticationFail_connectionException() {
        IdentityServiceFacade.AuthorizationGrant grant = IdentityServiceFacade.AuthorizationGrant.password((String)"username", (String)"password");
        ((IdentityServiceFacade)Mockito.doThrow((Throwable[])new Throwable[]{new IdentityServiceFacade.AuthorizationException("Couldn't connect to server", (Throwable)new ConnectException("ConnectionRefused"))}).when((Object)this.mockIdentityServiceFacade)).authorize(grant);
        try {
            this.authComponent.authenticateImpl("username", "password".toCharArray());
        }
        catch (RuntimeException ex) {
            Throwable cause = ExceptionStackUtil.getCause((Throwable)ex, (Class[])new Class[]{ConnectException.class});
            IdentityServiceAuthenticationComponentTest.assertNotNull((Object)cause);
            throw ex;
        }
    }

    @Test(expected=AuthenticationException.class)
    public void testAuthenticationFail_otherException() {
        IdentityServiceFacade.AuthorizationGrant grant = IdentityServiceFacade.AuthorizationGrant.password((String)"username", (String)"password");
        ((IdentityServiceFacade)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Some other errors!")}).when((Object)this.mockIdentityServiceFacade)).authorize(grant);
        this.authComponent.authenticateImpl("username", "password".toCharArray());
    }

    @Test
    public void testAuthenticationPass() {
        IdentityServiceFacade.AuthorizationGrant grant = IdentityServiceFacade.AuthorizationGrant.password((String)"username", (String)"password");
        IdentityServiceFacade.AccessTokenAuthorization authorization = (IdentityServiceFacade.AccessTokenAuthorization)Mockito.mock(IdentityServiceFacade.AccessTokenAuthorization.class);
        IdentityServiceFacade.AccessToken accessToken = (IdentityServiceFacade.AccessToken)Mockito.mock(IdentityServiceFacade.AccessToken.class);
        Mockito.when((Object)authorization.getAccessToken()).thenReturn((Object)accessToken);
        Mockito.when((Object)accessToken.getTokenValue()).thenReturn((Object)"JWT_TOKEN");
        Mockito.when((Object)this.mockIdentityServiceFacade.authorize(grant)).thenReturn((Object)authorization);
        Mockito.when((Object)this.jitProvisioning.extractUserInfoAndCreateUserIfNeeded("JWT_TOKEN")).thenReturn(Optional.of(new OIDCUserInfo("username", "", "", "")));
        this.authComponent.authenticateImpl("username", "password".toCharArray());
        IdentityServiceAuthenticationComponentTest.assertEquals((String)"User has not been set as expected.", (String)"username", (String)this.authenticationContext.getCurrentUserName());
    }

    @Test(expected=AuthenticationException.class)
    public void testFallthroughWhenIdentityServiceFacadeIsNull() {
        this.authComponent.setIdentityServiceFacade(null);
        this.authComponent.authenticateImpl("username", "password".toCharArray());
    }

    @Test
    public void testSettingAllowGuestUser() {
        this.authComponent.setAllowGuestLogin(true);
        IdentityServiceAuthenticationComponentTest.assertTrue((boolean)this.authComponent.guestUserAuthenticationAllowed());
        this.authComponent.setAllowGuestLogin(false);
        IdentityServiceAuthenticationComponentTest.assertFalse((boolean)this.authComponent.guestUserAuthenticationAllowed());
    }
}

