/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2;

import java.util.HashSet;
import java.util.Set;
import org.alfresco.repo.event2.EventGeneratorTest;
import org.alfresco.repo.event2.EventSender;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.ContextHierarchy;

@ContextHierarchy(value={@ContextConfiguration(classes={TestConfig.class})})
@DirtiesContext(classMode=DirtiesContext.ClassMode.BEFORE_CLASS)
public class DirectEventGeneratorTest
extends EventGeneratorTest {
    @Autowired
    private InstantiatedBeansRegistry instantiatedBeansRegistry;
    @Autowired
    private EventSender directEventSender;

    @BeforeClass
    public static void beforeClass() {
        System.setProperty("repo.event2.queue.skip", "true");
    }

    @Test
    public void testIfEnqueuingEventSenderIsNotInstantiated() {
        Set<String> instantiatedBeans = this.instantiatedBeansRegistry.getBeans();
        DirectEventGeneratorTest.assertTrue((boolean)this.skipEventQueue);
        DirectEventGeneratorTest.assertFalse((boolean)instantiatedBeans.contains("enqueuingEventSender"));
    }

    @Test
    public void testIfDirectSenderIsSetInEventGenerator() {
        DirectEventGeneratorTest.assertTrue((boolean)this.skipEventQueue);
        DirectEventGeneratorTest.assertEquals((Object)this.directEventSender, (Object)this.eventGenerator.getEventSender());
    }

    protected static class InstantiatedBeansRegistry
    implements BeanPostProcessor {
        private final Set<String> registeredBeans = new HashSet<String>();

        protected InstantiatedBeansRegistry() {
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            this.registeredBeans.add(beanName);
            return bean;
        }

        public Set<String> getBeans() {
            return this.registeredBeans;
        }
    }

    @Configuration
    public static class TestConfig {
        @Bean
        public BeanPostProcessor instantiatedBeansRegistry() {
            return new InstantiatedBeansRegistry();
        }
    }
}

