/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.caching.test;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.alfresco.repo.content.caching.CachingContentStore;
import org.alfresco.repo.content.caching.test.SlowContentStore;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.util.ApplicationContextHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public class ConcurrentCachingStoreTest {
    private static final Log log = LogFactory.getLog(ConcurrentCachingStoreTest.class);
    private static final int NUM_THREADS = 200;
    private static final int NUM_URLS = 40;
    private ApplicationContext ctx;
    private CachingContentStore store;
    private SlowContentStore backingStore;

    @Before
    public void setUp() {
        String slowconf = "classpath:cachingstore/test-slow-context.xml";
        this.ctx = ApplicationContextHelper.getApplicationContext((String[])new String[]{slowconf});
        this.store = (CachingContentStore)this.ctx.getBean("cachingContentStore");
        this.store.setCacheOnInbound(false);
        this.backingStore = (SlowContentStore)((Object)this.ctx.getBean("backingStore"));
    }

    @Test
    public void concurrentReadsWillReadCacheOncePerURL() throws InterruptedException {
        Thread[] threads = new Thread[200];
        int i = 0;
        while (i < 200) {
            CacheReaderThread t = new CacheReaderThread(i, 40);
            threads[i] = t;
            t.start();
            ++i;
        }
        i = 0;
        while (i < threads.length) {
            threads[i].join();
            ++i;
        }
        log.debug((Object)"\nResults:");
        int failedURLs = 0;
        for (Map.Entry entry : this.backingStore.getUrlHits().entrySet()) {
            String url = (String)entry.getKey();
            long numHits = ((AtomicLong)entry.getValue()).get();
            log.debug((Object)("URL: " + url + ", hits: " + numHits));
            if (numHits <= 1L) continue;
            ++failedURLs;
        }
        if (failedURLs > 0) {
            Assert.fail((String)(String.valueOf(failedURLs) + " URLs were requested more than once."));
        }
    }

    private class CacheReaderThread
    extends Thread {
        private final int threadNum;
        private final int numUrls;
        private int reads;

        CacheReaderThread(int threadNum, int numUrls) {
            super(String.valueOf(CacheReaderThread.class.getSimpleName()) + "-" + threadNum);
            this.reads = 50;
            this.threadNum = threadNum;
            this.numUrls = numUrls;
        }

        @Override
        public void run() {
            while (this.reads > 0) {
                String url = this.generateUrlToRead();
                ContentReader reader = ConcurrentCachingStoreTest.this.store.getReader(url);
                String content = reader.getContentString();
                log.debug((Object)("Thread: " + this.getName() + ", URL: " + url + ", content: " + content));
                --this.reads;
            }
        }

        private String generateUrlToRead() {
            int urlNum = this.threadNum % this.numUrls;
            return "store://2010/11/5/17/33/" + urlNum + ".bin";
        }
    }
}

