/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.executer.ExecuteAllRulesActionExecuter;
import org.alfresco.repo.rule.RuleModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.service.namespace.QName;
import org.alfresco.test_category.BaseSpringTestsCategory;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.alfresco.util.testing.category.NeverRunsTests;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.springframework.test.context.transaction.TestTransaction;
import org.springframework.transaction.annotation.Transactional;

@Category(value={BaseSpringTestsCategory.class, NeverRunsTests.class})
@Transactional
public class ExecuteAllRulesActionExecuterTest
extends BaseSpringTest {
    private NodeService nodeService;
    private RuleService ruleService;
    private ActionService actionService;
    private CheckOutCheckInService checkOutCheckInService;
    private RetryingTransactionHelper transactionHelper;
    private FileFolderService fileFolderService;
    private ContentService contentService;
    private StoreRef testStoreRef;
    private NodeRef rootNodeRef;
    private ExecuteAllRulesActionExecuter executer;
    private static final String ID = GUID.generate();

    @Before
    protected void before() throws Exception {
        this.checkOutCheckInService = (CheckOutCheckInService)this.applicationContext.getBean("checkOutCheckInService");
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.ruleService = (RuleService)this.applicationContext.getBean("ruleService");
        this.actionService = (ActionService)this.applicationContext.getBean("actionService");
        this.transactionHelper = (RetryingTransactionHelper)this.applicationContext.getBean("retryingTransactionHelper");
        this.fileFolderService = (FileFolderService)this.applicationContext.getBean("fileFolderService", FileFolderService.class);
        this.contentService = (ContentService)this.applicationContext.getBean("contentService", ContentService.class);
        AuthenticationComponent authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        authenticationComponent.setCurrentUser(authenticationComponent.getSystemUserName());
        this.testStoreRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.testStoreRef);
        this.executer = (ExecuteAllRulesActionExecuter)this.applicationContext.getBean("execute-all-rules");
    }

    public void testRevertVersion() {
        final NodeRef folder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}FolderWithInboundRule"), ContentModel.TYPE_FOLDER).getChildRef();
        Rule classifiableRule = new Rule();
        classifiableRule.setRuleType("inbound");
        Action addFeaturesAction = this.actionService.createAction("add-features");
        addFeaturesAction.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_CLASSIFIABLE);
        classifiableRule.setAction(addFeaturesAction);
        this.ruleService.saveRule(folder, classifiableRule);
        final NodeRef doc = this.nodeService.createNode(folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}TestDoc"), ContentModel.TYPE_CONTENT).getChildRef();
        ActionImpl action = new ActionImpl(null, ID, "execute-all-rules", null);
        this.executer.execute((Action)action, folder);
        TestTransaction.flagForCommit();
        TestTransaction.end();
        ExecuteAllRulesActionExecuterTest.assertTrue((boolean)this.nodeService.hasAspect(doc, ContentModel.ASPECT_CLASSIFIABLE));
        this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                NodeRef workingCopyRef = ExecuteAllRulesActionExecuterTest.this.checkOutCheckInService.checkout(doc);
                HashMap<String, String> props = new HashMap<String, String>(2, 1.0f);
                props.put("description", "");
                props.put("versionType", (String)VersionType.MAJOR);
                ExecuteAllRulesActionExecuterTest.this.checkOutCheckInService.checkin(workingCopyRef, props);
                ActionImpl action = new ActionImpl(null, ID, "execute-all-rules", null);
                action.setParameterValue("run-all-rules-on-children", (Serializable)Boolean.TRUE);
                ExecuteAllRulesActionExecuterTest.this.executer.execute((Action)action, folder);
                return null;
            }
        });
        ExecuteAllRulesActionExecuterTest.assertTrue((boolean)this.nodeService.hasAspect(doc, ContentModel.ASPECT_CLASSIFIABLE));
    }

    public void testExecution() {
        final NodeRef folder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}folderOne"), ContentModel.TYPE_FOLDER).getChildRef();
        final NodeRef doc1 = this.nodeService.createNode(folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}docOne"), ContentModel.TYPE_CONTENT).getChildRef();
        final NodeRef doc2 = this.nodeService.createNode(folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}docTwo"), ContentModel.TYPE_CONTENT).getChildRef();
        NodeRef folder2 = this.nodeService.createNode(folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}folderTwo"), ContentModel.TYPE_FOLDER).getChildRef();
        final NodeRef doc3 = this.nodeService.createNode(folder2, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}docThree"), ContentModel.TYPE_CONTENT).getChildRef();
        Rule rule1 = new Rule();
        rule1.setRuleType("inbound");
        Action action1 = this.actionService.createAction("add-features");
        action1.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_VERSIONABLE);
        rule1.setAction(action1);
        this.ruleService.saveRule(folder, rule1);
        Rule rule2 = new Rule();
        rule2.setRuleType("inbound");
        Action action2 = this.actionService.createAction("add-features");
        action2.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_CLASSIFIABLE);
        rule2.setAction(action2);
        this.ruleService.saveRule(folder, rule2);
        Rule rule3 = new Rule();
        rule3.setRuleType("inbound");
        Action action3 = this.actionService.createAction("add-features");
        action3.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_TITLED);
        rule3.setAction(action3);
        this.ruleService.saveRule(folder2, rule3);
        ExecuteAllRulesActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(doc1, ContentModel.ASPECT_VERSIONABLE));
        ExecuteAllRulesActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(doc1, ContentModel.ASPECT_CLASSIFIABLE));
        ExecuteAllRulesActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(doc1, ContentModel.ASPECT_TITLED));
        ExecuteAllRulesActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(doc2, ContentModel.ASPECT_VERSIONABLE));
        ExecuteAllRulesActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(doc2, ContentModel.ASPECT_CLASSIFIABLE));
        ExecuteAllRulesActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(doc2, ContentModel.ASPECT_TITLED));
        ExecuteAllRulesActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(doc3, ContentModel.ASPECT_VERSIONABLE));
        ExecuteAllRulesActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(doc3, ContentModel.ASPECT_CLASSIFIABLE));
        ExecuteAllRulesActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(doc3, ContentModel.ASPECT_TITLED));
        ExecuteAllRulesActionExecuterTest.assertTrue((boolean)this.nodeService.exists(folder));
        ActionImpl action = new ActionImpl(null, ID, "execute-all-rules", null);
        this.executer.execute((Action)action, folder);
        TestTransaction.flagForCommit();
        TestTransaction.end();
        this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                ExecuteAllRulesActionExecuterTest.assertTrue((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc1, ContentModel.ASPECT_VERSIONABLE));
                ExecuteAllRulesActionExecuterTest.assertTrue((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc1, ContentModel.ASPECT_CLASSIFIABLE));
                ExecuteAllRulesActionExecuterTest.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc2, ContentModel.ASPECT_TITLED));
                ExecuteAllRulesActionExecuterTest.assertTrue((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc2, ContentModel.ASPECT_VERSIONABLE));
                ExecuteAllRulesActionExecuterTest.assertTrue((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc2, ContentModel.ASPECT_CLASSIFIABLE));
                ExecuteAllRulesActionExecuterTest.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc2, ContentModel.ASPECT_TITLED));
                ExecuteAllRulesActionExecuterTest.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc3, ContentModel.ASPECT_VERSIONABLE));
                ExecuteAllRulesActionExecuterTest.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc3, ContentModel.ASPECT_CLASSIFIABLE));
                ExecuteAllRulesActionExecuterTest.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc3, ContentModel.ASPECT_TITLED));
                ExecuteAllRulesActionExecuterTest.this.clearAspects(doc1);
                ExecuteAllRulesActionExecuterTest.this.clearAspects(doc2);
                ExecuteAllRulesActionExecuterTest.this.clearAspects(doc3);
                return null;
            }
        });
        this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                ExecuteAllRulesActionExecuterTest.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc1, ContentModel.ASPECT_VERSIONABLE));
                ExecuteAllRulesActionExecuterTest.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc1, ContentModel.ASPECT_CLASSIFIABLE));
                ExecuteAllRulesActionExecuterTest.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc1, ContentModel.ASPECT_TITLED));
                ExecuteAllRulesActionExecuterTest.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc2, ContentModel.ASPECT_VERSIONABLE));
                ExecuteAllRulesActionExecuterTest.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc2, ContentModel.ASPECT_CLASSIFIABLE));
                ExecuteAllRulesActionExecuterTest.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc2, ContentModel.ASPECT_TITLED));
                ExecuteAllRulesActionExecuterTest.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc3, ContentModel.ASPECT_VERSIONABLE));
                ExecuteAllRulesActionExecuterTest.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc3, ContentModel.ASPECT_CLASSIFIABLE));
                ExecuteAllRulesActionExecuterTest.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc3, ContentModel.ASPECT_TITLED));
                ActionImpl action = new ActionImpl(null, ID, "execute-all-rules", null);
                action.setParameterValue("run-all-rules-on-children", (Serializable)Boolean.TRUE);
                ExecuteAllRulesActionExecuterTest.this.executer.execute((Action)action, folder);
                return null;
            }
        });
        this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                ExecuteAllRulesActionExecuterTest.assertTrue((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc1, ContentModel.ASPECT_VERSIONABLE));
                ExecuteAllRulesActionExecuterTest.assertTrue((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc1, ContentModel.ASPECT_CLASSIFIABLE));
                ExecuteAllRulesActionExecuterTest.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc2, ContentModel.ASPECT_TITLED));
                ExecuteAllRulesActionExecuterTest.assertTrue((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc2, ContentModel.ASPECT_VERSIONABLE));
                ExecuteAllRulesActionExecuterTest.assertTrue((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc2, ContentModel.ASPECT_CLASSIFIABLE));
                ExecuteAllRulesActionExecuterTest.assertFalse((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc2, ContentModel.ASPECT_TITLED));
                ExecuteAllRulesActionExecuterTest.assertTrue((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc3, ContentModel.ASPECT_VERSIONABLE));
                ExecuteAllRulesActionExecuterTest.assertTrue((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc3, ContentModel.ASPECT_CLASSIFIABLE));
                ExecuteAllRulesActionExecuterTest.assertTrue((boolean)ExecuteAllRulesActionExecuterTest.this.nodeService.hasAspect(doc3, ContentModel.ASPECT_TITLED));
                ExecuteAllRulesActionExecuterTest.this.clearAspects(doc1);
                ExecuteAllRulesActionExecuterTest.this.clearAspects(doc2);
                ExecuteAllRulesActionExecuterTest.this.clearAspects(doc3);
                return null;
            }
        });
    }

    public void testRulesFireOnNonInheritedFolderUsingLinkedRuleSetInstead() {
        NodeRef rootFolder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}rootFolderForTest"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef folderA = this.fileFolderService.create(rootFolder, "folderA", ContentModel.TYPE_FOLDER).getNodeRef();
        this.nodeService.addAspect(folderA, RuleModel.ASPECT_IGNORE_INHERITED_RULES, Collections.emptyMap());
        NodeRef fileA = this.createFile(folderA, "fileA.txt").getNodeRef();
        NodeRef folderB = this.fileFolderService.create(folderA, "folderB", ContentModel.TYPE_FOLDER).getNodeRef();
        NodeRef fileB = this.createFile(folderB, "fileB.txt").getNodeRef();
        Rule rule = new Rule();
        rule.setRuleType("inbound");
        Action action = this.actionService.createAction("add-features");
        action.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_CLASSIFIABLE);
        rule.setAction(action);
        rule.applyToChildren(false);
        rule.setExecuteAsynchronously(false);
        this.ruleService.enableRule(rule);
        this.ruleService.saveRule(rootFolder, rule);
        Action linkAction = this.actionService.createAction("link-rules");
        linkAction.setParameterValue("link_from_node", (Serializable)rootFolder);
        linkAction.setExecuteAsynchronously(false);
        this.actionService.executeAction(linkAction, folderA);
        TestTransaction.flagForCommit();
        TestTransaction.end();
        this.transactionHelper.doInTransaction(() -> {
            ExecuteAllRulesActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(folderA, ContentModel.ASPECT_CLASSIFIABLE));
            ExecuteAllRulesActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(fileA, ContentModel.ASPECT_CLASSIFIABLE));
            ExecuteAllRulesActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(folderB, ContentModel.ASPECT_CLASSIFIABLE));
            ExecuteAllRulesActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(fileB, ContentModel.ASPECT_CLASSIFIABLE));
            return null;
        });
        this.transactionHelper.doInTransaction(() -> {
            HashMap<String, Boolean> actionParams = new HashMap<String, Boolean>();
            actionParams.put("run-all-rules-on-children", true);
            actionParams.put("execute-inherited-rules", false);
            Action rulesAction = this.actionService.createAction("execute-all-rules", actionParams);
            this.executer.execute(rulesAction, folderA);
            return null;
        });
        this.transactionHelper.doInTransaction(() -> {
            ExecuteAllRulesActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(folderA, ContentModel.ASPECT_CLASSIFIABLE));
            ExecuteAllRulesActionExecuterTest.assertTrue((boolean)this.nodeService.hasAspect(fileA, ContentModel.ASPECT_CLASSIFIABLE));
            ExecuteAllRulesActionExecuterTest.assertTrue((boolean)this.nodeService.hasAspect(folderB, ContentModel.ASPECT_CLASSIFIABLE));
            ExecuteAllRulesActionExecuterTest.assertTrue((boolean)this.nodeService.hasAspect(fileB, ContentModel.ASPECT_CLASSIFIABLE));
            return null;
        });
    }

    private FileInfo createFile(NodeRef parent, String name) {
        FileInfo file = this.fileFolderService.create(parent, name, ContentModel.TYPE_CONTENT);
        ContentWriter writer = this.contentService.getWriter(file.getNodeRef(), ContentModel.PROP_CONTENT, true);
        writer.putContent(String.valueOf(file.getName()) + " contents");
        return file;
    }

    public void testRuleAppliesToSubfoldersSuccessfully() {
        NodeRef rootFolder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}rootFolderForTest"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef folderA = this.fileFolderService.create(rootFolder, "folderA", ContentModel.TYPE_FOLDER).getNodeRef();
        NodeRef fileA = this.createFile(folderA, "fileA.txt").getNodeRef();
        NodeRef folderB = this.fileFolderService.create(folderA, "folderB", ContentModel.TYPE_FOLDER).getNodeRef();
        NodeRef fileB = this.createFile(folderB, "fileB.txt").getNodeRef();
        TestTransaction.flagForCommit();
        TestTransaction.end();
        this.transactionHelper.doInTransaction(() -> {
            Rule rule1 = new Rule();
            rule1.setRuleType("inbound");
            Action action1 = this.actionService.createAction("add-features");
            action1.setParameterValue("aspect-name", (Serializable)ContentModel.ASPECT_CLASSIFIABLE);
            rule1.setAction(action1);
            rule1.applyToChildren(true);
            rule1.setExecuteAsynchronously(false);
            this.ruleService.enableRule(rule1);
            this.ruleService.saveRule(rootFolder, rule1);
            return null;
        });
        this.transactionHelper.doInTransaction(() -> {
            ExecuteAllRulesActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(folderA, ContentModel.ASPECT_CLASSIFIABLE));
            ExecuteAllRulesActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(folderB, ContentModel.ASPECT_CLASSIFIABLE));
            ExecuteAllRulesActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(fileA, ContentModel.ASPECT_CLASSIFIABLE));
            ExecuteAllRulesActionExecuterTest.assertFalse((boolean)this.nodeService.hasAspect(fileB, ContentModel.ASPECT_CLASSIFIABLE));
            return null;
        });
        this.transactionHelper.doInTransaction(() -> {
            HashMap<String, Boolean> actionParams = new HashMap<String, Boolean>();
            actionParams.put("run-all-rules-on-children", true);
            actionParams.put("execute-inherited-rules", true);
            Action action = this.actionService.createAction("execute-all-rules", actionParams);
            this.executer.execute(action, rootFolder);
            return null;
        });
        this.transactionHelper.doInTransaction(() -> {
            ExecuteAllRulesActionExecuterTest.assertTrue((boolean)this.nodeService.hasAspect(folderA, ContentModel.ASPECT_CLASSIFIABLE));
            ExecuteAllRulesActionExecuterTest.assertTrue((boolean)this.nodeService.hasAspect(folderB, ContentModel.ASPECT_CLASSIFIABLE));
            ExecuteAllRulesActionExecuterTest.assertTrue((boolean)this.nodeService.hasAspect(fileA, ContentModel.ASPECT_CLASSIFIABLE));
            ExecuteAllRulesActionExecuterTest.assertTrue((boolean)this.nodeService.hasAspect(fileB, ContentModel.ASPECT_CLASSIFIABLE));
            return null;
        });
    }

    private void clearAspects(NodeRef nodeRef) {
        this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE);
        this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_CLASSIFIABLE);
        this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_TITLED);
    }
}

